/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.hssf.util.HSSFCellRangeAddress;
import org.apache.poi.util.BitField;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.StringUtil;

public class DVRecord
extends Record {
    public static final short sid = 446;
    private int field_option_flags;
    private String field_title_prompt;
    private String field_title_error;
    private String field_text_prompt;
    private String field_text_error;
    private short field_size_first_formula;
    private short field_not_used_1 = (short)16352;
    private Stack field_rpn_token_1;
    private short field_size_sec_formula;
    private short field_not_used_2 = 0;
    private Stack field_rpn_token_2;
    private HSSFCellRangeAddress field_regions;
    public static final Integer STRING_PROMPT_TITLE = new Integer(0);
    public static final Integer STRING_ERROR_TITLE = new Integer(1);
    public static final Integer STRING_PROMPT_TEXT = new Integer(2);
    public static final Integer STRING_ERROR_TEXT = new Integer(3);
    private Hashtable _hash_strings;
    private BitField opt_data_type = new BitField(15);
    private BitField opt_error_style = new BitField(112);
    private BitField opt_string_list_formula = new BitField(128);
    private BitField opt_empty_cell_allowed = new BitField(256);
    private BitField opt_surppres_dropdown_arrow = new BitField(512);
    private BitField opt_show_prompt_on_cell_selected = new BitField(262144);
    private BitField opt_show_error_on_invalid_value = new BitField(524288);
    private BitField opt_condition_operator = new BitField(0xF00000);

    public DVRecord() {
    }

    public DVRecord(RecordInputStream in) {
        super(in);
    }

    protected void validateSid(short id) {
        if (id != 446) {
            throw new RecordFormatException("NOT a valid DV RECORD");
        }
    }

    protected void fillFields(RecordInputStream in) {
        Ptg ptg;
        this.field_rpn_token_1 = new Stack();
        this.field_rpn_token_2 = new Stack();
        this.field_option_flags = in.readInt();
        this._hash_strings = new Hashtable(4);
        StringHandler strHandler_prompt_title = new StringHandler(in);
        this.field_title_prompt = strHandler_prompt_title.getStringData();
        this._hash_strings.put(STRING_PROMPT_TITLE, strHandler_prompt_title);
        StringHandler strHandler_error_title = new StringHandler(in);
        this.field_title_error = strHandler_error_title.getStringData();
        this._hash_strings.put(STRING_ERROR_TITLE, strHandler_error_title);
        StringHandler strHandler_prompt_text = new StringHandler(in);
        this.field_text_prompt = strHandler_prompt_text.getStringData();
        this._hash_strings.put(STRING_PROMPT_TEXT, strHandler_prompt_text);
        StringHandler strHandler_error_text = new StringHandler(in);
        this.field_text_error = strHandler_error_text.getStringData();
        this._hash_strings.put(STRING_ERROR_TEXT, strHandler_error_text);
        this.field_size_first_formula = in.readShort();
        this.field_not_used_1 = in.readShort();
        int token_pos = 0;
        while (token_pos < this.field_size_first_formula) {
            ptg = Ptg.createPtg(in);
            token_pos += ptg.getSize();
            this.field_rpn_token_1.push(ptg);
        }
        this.field_size_sec_formula = in.readShort();
        this.field_not_used_2 = in.readShort();
        try {
            in.skip(this.field_size_sec_formula);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IllegalStateException(e.getMessage());
        }
        token_pos = 0;
        while (token_pos < this.field_size_sec_formula) {
            ptg = Ptg.createPtg(in);
            token_pos += ptg.getSize();
            this.field_rpn_token_2.push(ptg);
        }
        this.field_regions = new HSSFCellRangeAddress(in);
    }

    public void setDataType(int type) {
        this.field_option_flags = this.opt_data_type.setValue(this.field_option_flags, type);
    }

    public int getDataType() {
        return this.opt_data_type.getValue(this.field_option_flags);
    }

    public void setErrorStyle(int style) {
        this.field_option_flags = this.opt_error_style.setValue(this.field_option_flags, style);
    }

    public int getErrorStyle() {
        return this.opt_error_style.getValue(this.field_option_flags);
    }

    public void setListExplicitFormula(boolean explicit) {
        this.field_option_flags = this.opt_string_list_formula.setBoolean(this.field_option_flags, explicit);
    }

    public boolean getListExplicitFormula() {
        return this.opt_string_list_formula.isSet(this.field_option_flags);
    }

    public void setEmptyCellAllowed(boolean allowed) {
        this.field_option_flags = this.opt_empty_cell_allowed.setBoolean(this.field_option_flags, allowed);
    }

    public boolean getEmptyCellAllowed() {
        return this.opt_empty_cell_allowed.isSet(this.field_option_flags);
    }

    public void setSurppresDropdownArrow(boolean surppress) {
        this.field_option_flags = this.opt_surppres_dropdown_arrow.setBoolean(this.field_option_flags, surppress);
    }

    public boolean getSurppresDropdownArrow() {
        return this.opt_surppres_dropdown_arrow.isSet(this.field_option_flags);
    }

    public void setShowPromptOnCellSelected(boolean show) {
        this.field_option_flags = this.opt_show_prompt_on_cell_selected.setBoolean(this.field_option_flags, show);
    }

    public boolean getShowPromptOnCellSelected() {
        return this.opt_show_prompt_on_cell_selected.isSet(this.field_option_flags);
    }

    public void setShowErrorOnInvalidValue(boolean show) {
        this.field_option_flags = this.opt_show_error_on_invalid_value.setBoolean(this.field_option_flags, show);
    }

    public boolean getShowErrorOnInvalidValue() {
        return this.opt_show_error_on_invalid_value.isSet(this.field_option_flags);
    }

    public void setConditionOperator(int operator) {
        this.field_option_flags = this.opt_condition_operator.setValue(this.field_option_flags, operator);
    }

    public int getConditionOperator() {
        return this.opt_condition_operator.getValue(this.field_option_flags);
    }

    public void setFirstFormulaRPN(Stack rpn) {
        this.field_rpn_token_1 = rpn;
    }

    public void setFirstFormulaSize(short size) {
        this.field_size_first_formula = size;
    }

    public void setSecFormulaRPN(Stack rpn) {
        this.field_rpn_token_2 = rpn;
    }

    public void setSecFormulaSize(short size) {
        this.field_size_sec_formula = size;
    }

    public void setStringField(Integer type, String str_data) {
        if (this._hash_strings == null) {
            this._hash_strings = new Hashtable();
        }
        StringHandler strHandler = new StringHandler();
        if (str_data == null) {
            str_data = "";
        } else {
            strHandler.setStringLength(str_data.length());
        }
        strHandler.setStringData(str_data);
        strHandler.setUnicodeFlag((byte)0);
        this._hash_strings.put(type, strHandler);
    }

    public String getStringField(Integer type) {
        return ((StringHandler)this._hash_strings.get(type)).getStringData();
    }

    public void setCellRangeAddress(HSSFCellRangeAddress range) {
        this.field_regions = range;
    }

    public HSSFCellRangeAddress getCellRangeAddress() {
        return this.field_regions;
    }

    public int getOptionFlags() {
        return this.field_option_flags;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        Ptg ptg;
        int size = this.getRecordSize();
        LittleEndian.putShort(data, 0 + offset, (short)446);
        LittleEndian.putShort(data, 2 + offset, (short)(size - 4));
        int pos = 4;
        LittleEndian.putInt(data, pos + offset, this.getOptionFlags());
        pos += 4;
        pos += ((StringHandler)this._hash_strings.get(STRING_PROMPT_TITLE)).serialize(pos + offset, data);
        pos += ((StringHandler)this._hash_strings.get(STRING_ERROR_TITLE)).serialize(pos + offset, data);
        pos += ((StringHandler)this._hash_strings.get(STRING_PROMPT_TEXT)).serialize(pos + offset, data);
        pos += ((StringHandler)this._hash_strings.get(STRING_ERROR_TEXT)).serialize(pos + offset, data);
        LittleEndian.putShort(data, offset + pos, this.field_size_first_formula);
        LittleEndian.putShort(data, offset + (pos += 2), this.field_not_used_1);
        pos += 2;
        int k = 0;
        while (k < this.field_rpn_token_1.size()) {
            ptg = (Ptg)this.field_rpn_token_1.get(k);
            ptg.writeBytes(data, pos + offset);
            pos += ptg.getSize();
            ++k;
        }
        LittleEndian.putShort(data, offset + pos, this.field_size_sec_formula);
        LittleEndian.putShort(data, offset + (pos += 2), this.field_not_used_2);
        pos += 2;
        if (this.field_size_sec_formula > 0) {
            k = 0;
            while (k < this.field_rpn_token_2.size()) {
                ptg = (Ptg)this.field_rpn_token_2.get(k);
                ptg.writeBytes(data, pos + offset);
                pos += ptg.getSize();
                ++k;
            }
        }
        this.field_regions.serialize(pos + offset, data);
        return size;
    }

    public int getRecordSize() {
        int size = 16;
        if (this._hash_strings != null) {
            Enumeration enum_keys = this._hash_strings.keys();
            while (enum_keys.hasMoreElements()) {
                size += ((StringHandler)this._hash_strings.get((Integer)enum_keys.nextElement())).getSize();
            }
        }
        size += this.field_size_first_formula + this.field_size_sec_formula;
        return size += this.field_regions.getSize();
    }

    public short getSid() {
        return 446;
    }

    public Object clone() {
        return this.cloneViaReserialise();
    }

    private class StringHandler {
        private int _string_length = 1;
        private byte _string_unicode_flag = 0;
        private String _string_data = "0x00";
        private int _start_offset;
        private int _end_offset;

        StringHandler() {
        }

        StringHandler(RecordInputStream in) {
            this.fillFields(in);
        }

        protected void fillFields(RecordInputStream in) {
            this._string_length = in.readUShort();
            this._string_unicode_flag = in.readByte();
            this._string_data = this._string_unicode_flag == 1 ? in.readUnicodeLEString(this._string_length) : in.readCompressedUnicode(this._string_length);
        }

        private void setStringData(String string_data) {
            this._string_data = string_data;
        }

        private String getStringData() {
            return this._string_data;
        }

        private int getEndOffset() {
            return this._end_offset;
        }

        public int serialize(int offset, byte[] data) {
            LittleEndian.putUShort(data, offset, this._string_length);
            data[2 + offset] = this._string_unicode_flag;
            if (this._string_unicode_flag == 1) {
                StringUtil.putUnicodeLE(this._string_data, data, 3 + offset);
            } else {
                StringUtil.putCompressedUnicode(this._string_data, data, 3 + offset);
            }
            return this.getSize();
        }

        private void setUnicodeFlag(byte flag) {
            this._string_unicode_flag = flag;
        }

        private void setStringLength(int len) {
            this._string_length = len;
        }

        private int getStringByteLength() {
            return this._string_unicode_flag == 1 ? this._string_length * 2 : this._string_length;
        }

        public int getSize() {
            return 3 + this.getStringByteLength();
        }
    }
}

