/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.util.LittleEndian;

public class UncalcedRecord
extends Record {
    public static final short sid = 94;

    public UncalcedRecord() {
    }

    public UncalcedRecord(RecordInputStream in) {
        super(in);
    }

    public short getSid() {
        return 94;
    }

    protected void validateSid(short id) {
        if (id != 94) {
            throw new RecordFormatException("NOT AN UNCALCED RECORD");
        }
    }

    protected void fillFields(RecordInputStream in) {
        in.readShort();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[UNCALCED]\n");
        buffer.append("[/UNCALCED]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)94);
        LittleEndian.putShort(data, 2 + offset, (short)2);
        LittleEndian.putShort(data, 4 + offset, (short)0);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return UncalcedRecord.getStaticRecordSize();
    }

    public static int getStaticRecordSize() {
        return 6;
    }
}

