/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.util.BitField;
import org.apache.poi.util.BitFieldFactory;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndian;

public class UnicodeString
implements Comparable {
    public static final short sid = 4095;
    private short field_1_charCount;
    private byte field_2_optionflags;
    private String field_3_string;
    private List field_4_format_runs;
    private byte[] field_5_ext_rst;
    private static final BitField highByte = BitFieldFactory.getInstance(1);
    private static final BitField extBit = BitFieldFactory.getInstance(4);
    private static final BitField richText = BitFieldFactory.getInstance(8);

    private UnicodeString() {
    }

    public UnicodeString(String str) {
        this.setString(str);
    }

    public UnicodeString(RecordInputStream in) {
        this.validateSid(in.getSid());
        this.fillFields(in);
    }

    public int hashCode() {
        int stringHash = 0;
        if (this.field_3_string != null) {
            stringHash = this.field_3_string.hashCode();
        }
        return this.field_1_charCount + stringHash;
    }

    public boolean equals(Object o) {
        boolean eq;
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        UnicodeString other = (UnicodeString)o;
        boolean bl = eq = this.field_1_charCount == other.field_1_charCount && this.field_2_optionflags == other.field_2_optionflags && this.field_3_string.equals(other.field_3_string);
        if (!eq) {
            return false;
        }
        if (this.field_4_format_runs == null && other.field_4_format_runs == null) {
            return true;
        }
        if (this.field_4_format_runs == null && other.field_4_format_runs != null || this.field_4_format_runs != null && other.field_4_format_runs == null) {
            return false;
        }
        int size = this.field_4_format_runs.size();
        if (size != other.field_4_format_runs.size()) {
            return false;
        }
        int i = 0;
        while (i < size) {
            FormatRun run2;
            FormatRun run1 = (FormatRun)this.field_4_format_runs.get(i);
            if (!run1.equals(run2 = (FormatRun)other.field_4_format_runs.get(i))) {
                return false;
            }
            ++i;
        }
        if (this.field_5_ext_rst == null && other.field_5_ext_rst == null) {
            return true;
        }
        if (this.field_5_ext_rst == null && other.field_5_ext_rst != null || this.field_5_ext_rst != null && other.field_5_ext_rst == null) {
            return false;
        }
        size = this.field_5_ext_rst.length;
        if (size != this.field_5_ext_rst.length) {
            return false;
        }
        i = 0;
        while (i < size) {
            if (this.field_5_ext_rst[i] != other.field_5_ext_rst[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void validateSid(short id) {
    }

    protected void fillFields(RecordInputStream in) {
        int i;
        this.field_1_charCount = in.readShort();
        this.field_2_optionflags = in.readByte();
        int runCount = 0;
        int extensionLength = 0;
        if (this.isRichText()) {
            runCount = in.readShort();
        }
        if (this.isExtendedText()) {
            extensionLength = in.readInt();
        }
        in.setAutoContinue(false);
        StringBuffer tmpString = new StringBuffer(this.field_1_charCount);
        int stringCharCount = this.field_1_charCount;
        boolean isCompressed = (this.field_2_optionflags & 1) == 0;
        while (stringCharCount != 0) {
            char ch;
            if (in.remaining() == 0) {
                if (in.isContinueNext()) {
                    in.nextRecord();
                    byte optionflags = in.readByte();
                    isCompressed = (optionflags & 1) == 0;
                } else {
                    throw new RecordFormatException("Expected continue record.");
                }
            }
            if (isCompressed) {
                ch = (char)(0xFF & (short)in.readByte());
                tmpString.append(ch);
            } else {
                ch = (char)in.readShort();
                tmpString.append(ch);
            }
            --stringCharCount;
        }
        this.field_3_string = tmpString.toString();
        in.setAutoContinue(true);
        if (this.isRichText() && runCount > 0) {
            this.field_4_format_runs = new ArrayList(runCount);
            i = 0;
            while (i < runCount) {
                this.field_4_format_runs.add(new FormatRun(in.readShort(), in.readShort()));
                ++i;
            }
        }
        if (this.isExtendedText() && extensionLength > 0) {
            this.field_5_ext_rst = new byte[extensionLength];
            i = 0;
            while (i < extensionLength) {
                this.field_5_ext_rst[i] = in.readByte();
                ++i;
            }
        }
    }

    public short getCharCount() {
        return this.field_1_charCount;
    }

    public void setCharCount(short cc) {
        this.field_1_charCount = cc;
    }

    public byte getOptionFlags() {
        return this.field_2_optionflags;
    }

    public void setOptionFlags(byte of) {
        this.field_2_optionflags = of;
    }

    public String getString() {
        return this.field_3_string;
    }

    public void setString(String string) {
        this.field_3_string = string;
        this.setCharCount((short)this.field_3_string.length());
        boolean useUTF16 = false;
        int strlen = string.length();
        int j = 0;
        while (j < strlen) {
            if (string.charAt(j) > '\u00ff') {
                useUTF16 = true;
                break;
            }
            ++j;
        }
        this.field_2_optionflags = useUTF16 ? highByte.setByte(this.field_2_optionflags) : highByte.clearByte(this.field_2_optionflags);
    }

    public int getFormatRunCount() {
        if (this.field_4_format_runs == null) {
            return 0;
        }
        return this.field_4_format_runs.size();
    }

    public FormatRun getFormatRun(int index) {
        if (this.field_4_format_runs == null) {
            return null;
        }
        if (index < 0 || index >= this.field_4_format_runs.size()) {
            return null;
        }
        return (FormatRun)this.field_4_format_runs.get(index);
    }

    private int findFormatRunAt(int characterPos) {
        int size = this.field_4_format_runs.size();
        int i = 0;
        while (i < size) {
            FormatRun r = (FormatRun)this.field_4_format_runs.get(i);
            if (r.character == characterPos) {
                return i;
            }
            if (r.character > characterPos) {
                return -1;
            }
            ++i;
        }
        return -1;
    }

    public void addFormatRun(FormatRun r) {
        int index;
        if (this.field_4_format_runs == null) {
            this.field_4_format_runs = new ArrayList();
        }
        if ((index = this.findFormatRunAt(r.character)) != -1) {
            this.field_4_format_runs.remove(index);
        }
        this.field_4_format_runs.add(r);
        Collections.sort(this.field_4_format_runs);
        this.field_2_optionflags = richText.setByte(this.field_2_optionflags);
    }

    public Iterator formatIterator() {
        if (this.field_4_format_runs != null) {
            return this.field_4_format_runs.iterator();
        }
        return null;
    }

    public void removeFormatRun(FormatRun r) {
        this.field_4_format_runs.remove(r);
        if (this.field_4_format_runs.size() == 0) {
            this.field_4_format_runs = null;
            this.field_2_optionflags = richText.clearByte(this.field_2_optionflags);
        }
    }

    public void clearFormatting() {
        this.field_4_format_runs = null;
        this.field_2_optionflags = richText.clearByte(this.field_2_optionflags);
    }

    public byte[] getExtendedRst() {
        return this.field_5_ext_rst;
    }

    public void setExtendedRst(byte[] ext_rst) {
        this.field_2_optionflags = ext_rst != null ? extBit.setByte(this.field_2_optionflags) : extBit.clearByte(this.field_2_optionflags);
        this.field_5_ext_rst = ext_rst;
    }

    public String toString() {
        return this.getString();
    }

    public String getDebugInfo() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[UNICODESTRING]\n");
        buffer.append("    .charcount       = ").append(Integer.toHexString(this.getCharCount())).append("\n");
        buffer.append("    .optionflags     = ").append(Integer.toHexString(this.getOptionFlags())).append("\n");
        buffer.append("    .string          = ").append(this.getString()).append("\n");
        if (this.field_4_format_runs != null) {
            int i = 0;
            while (i < this.field_4_format_runs.size()) {
                FormatRun r = (FormatRun)this.field_4_format_runs.get(i);
                buffer.append("      .format_run" + i + "          = ").append(r.toString()).append("\n");
                ++i;
            }
        }
        if (this.field_5_ext_rst != null) {
            buffer.append("    .field_5_ext_rst          = ").append("\n").append(HexDump.toHex(this.field_5_ext_rst)).append("\n");
        }
        buffer.append("[/UNICODESTRING]\n");
        return buffer.toString();
    }

    private int writeContinueIfRequired(UnicodeRecordStats stats, int requiredSize, int offset, byte[] data) {
        if (stats.remainingSize < requiredSize) {
            if (stats.lastLengthPos != -1) {
                short lastRecordLength = (short)(offset - stats.lastLengthPos - 2);
                if (lastRecordLength > 8224) {
                    throw new InternalError();
                }
                LittleEndian.putShort(data, stats.lastLengthPos, lastRecordLength);
            }
            LittleEndian.putShort(data, offset, (short)60);
            stats.lastLengthPos = offset += 2;
            offset += 2;
            stats.recordSize += 4;
            stats.remainingSize = 8224;
        }
        return offset;
    }

    public int serialize(UnicodeRecordStats stats, int offset, byte[] data) {
        int pos = offset;
        pos = this.writeContinueIfRequired(stats, 3, pos, data);
        LittleEndian.putShort(data, pos, this.getCharCount());
        data[pos += 2] = this.getOptionFlags();
        ++pos;
        stats.recordSize += 3;
        stats.remainingSize -= 3;
        if (this.isRichText() && this.field_4_format_runs != null) {
            pos = this.writeContinueIfRequired(stats, 2, pos, data);
            LittleEndian.putShort(data, pos, (short)this.field_4_format_runs.size());
            pos += 2;
            stats.recordSize += 2;
            stats.remainingSize -= 2;
        }
        if (this.isExtendedText() && this.field_5_ext_rst != null) {
            pos = this.writeContinueIfRequired(stats, 4, pos, data);
            LittleEndian.putInt(data, pos, this.field_5_ext_rst.length);
            pos += 4;
            stats.recordSize += 4;
            stats.remainingSize -= 4;
        }
        int charsize = this.isUncompressedUnicode() ? 2 : 1;
        int strSize = this.getString().length() * charsize;
        byte[] strBytes = null;
        try {
            String unicodeString = this.getString();
            strBytes = !this.isUncompressedUnicode() ? unicodeString.getBytes("ISO-8859-1") : unicodeString.getBytes("UTF-16LE");
        }
        catch (Exception exception) {
            throw new InternalError();
        }
        if (strSize != strBytes.length) {
            throw new InternalError("That shouldnt have happened!");
        }
        if (strSize > stats.remainingSize) {
            int ammountThatCantFit = strSize;
            int strPos = 0;
            while (ammountThatCantFit > 0) {
                int ammountWritten = Math.min(stats.remainingSize, ammountThatCantFit);
                if (this.isUncompressedUnicode() && ammountWritten % 2 == 1) {
                    --ammountWritten;
                }
                System.arraycopy(strBytes, strPos, data, pos, ammountWritten);
                pos += ammountWritten;
                strPos += ammountWritten;
                stats.recordSize += ammountWritten;
                stats.remainingSize -= ammountWritten;
                if ((ammountThatCantFit -= ammountWritten) <= 0) continue;
                pos = this.writeContinueIfRequired(stats, ammountThatCantFit, pos, data);
                data[pos] = (byte)(this.isUncompressedUnicode() ? 1 : 0);
                ++pos;
                ++stats.recordSize;
                --stats.remainingSize;
            }
        } else {
            if (strSize > data.length - pos) {
                System.out.println("Hmm shouldnt happen");
            }
            System.arraycopy(strBytes, 0, data, pos, strSize);
            pos += strSize;
            stats.recordSize += strSize;
            stats.remainingSize -= strSize;
        }
        if (this.isRichText() && this.field_4_format_runs != null) {
            int count = this.field_4_format_runs.size();
            int i = 0;
            while (i < count) {
                pos = this.writeContinueIfRequired(stats, 4, pos, data);
                FormatRun r = (FormatRun)this.field_4_format_runs.get(i);
                LittleEndian.putShort(data, pos, r.character);
                LittleEndian.putShort(data, pos += 2, r.fontIndex);
                pos += 2;
                stats.recordSize += 4;
                stats.remainingSize -= 4;
                ++i;
            }
        }
        if (this.isExtendedText() && this.field_5_ext_rst != null) {
            int ammountThatCantFit = this.field_5_ext_rst.length - stats.remainingSize;
            int extPos = 0;
            if (ammountThatCantFit > 0) {
                while (ammountThatCantFit > 0) {
                    int ammountWritten = Math.min(stats.remainingSize, ammountThatCantFit);
                    System.arraycopy(this.field_5_ext_rst, extPos, data, pos, ammountWritten);
                    pos += ammountWritten;
                    extPos += ammountWritten;
                    stats.recordSize += ammountWritten;
                    stats.remainingSize -= ammountWritten;
                    if ((ammountThatCantFit -= ammountWritten) <= 0) continue;
                    pos = this.writeContinueIfRequired(stats, 1, pos, data);
                }
            } else {
                System.arraycopy(this.field_5_ext_rst, 0, data, pos, this.field_5_ext_rst.length);
                pos += this.field_5_ext_rst.length;
                stats.remainingSize -= this.field_5_ext_rst.length;
                stats.recordSize += this.field_5_ext_rst.length;
            }
        }
        return pos - offset;
    }

    public void setCompressedUnicode() {
        this.field_2_optionflags = highByte.setByte(this.field_2_optionflags);
    }

    public void setUncompressedUnicode() {
        this.field_2_optionflags = highByte.clearByte(this.field_2_optionflags);
    }

    private boolean isUncompressedUnicode() {
        return highByte.isSet(this.getOptionFlags());
    }

    public void getRecordSize(UnicodeRecordStats stats) {
        int ammountWritten;
        int ammountThatCantFit;
        if (stats.remainingSize < 3) {
            stats.recordSize += 4;
            stats.remainingSize = 8224;
        }
        stats.recordSize += 3;
        stats.remainingSize -= 3;
        if (this.isRichText()) {
            if (stats.remainingSize < 2) {
                stats.remainingSize = 8224;
                stats.recordSize += 4;
            }
            stats.recordSize += 2;
            stats.remainingSize -= 2;
        }
        if (this.isExtendedText()) {
            if (stats.remainingSize < 4) {
                stats.remainingSize = 8224;
                stats.recordSize += 4;
            }
            stats.recordSize += 4;
            stats.remainingSize -= 4;
        }
        int charsize = this.isUncompressedUnicode() ? 2 : 1;
        int strSize = this.getString().length() * charsize;
        if (strSize > stats.remainingSize) {
            ammountThatCantFit = strSize;
            while (ammountThatCantFit > 0) {
                ammountWritten = Math.min(stats.remainingSize, ammountThatCantFit);
                if (this.isUncompressedUnicode() && ammountWritten % 2 == 1) {
                    --ammountWritten;
                }
                stats.recordSize += ammountWritten;
                stats.remainingSize -= ammountWritten;
                if ((ammountThatCantFit -= ammountWritten) <= 0) continue;
                stats.remainingSize = 8224;
                stats.recordSize += 4;
                ++stats.recordSize;
                --stats.remainingSize;
            }
        } else {
            stats.recordSize += strSize;
            stats.remainingSize -= strSize;
        }
        if (this.isRichText() && this.field_4_format_runs != null) {
            int count = this.field_4_format_runs.size();
            int i = 0;
            while (i < count) {
                if (stats.remainingSize < 4) {
                    stats.remainingSize = 8224;
                    stats.recordSize += 4;
                }
                stats.recordSize += 4;
                stats.remainingSize -= 4;
                ++i;
            }
        }
        if (this.isExtendedText() && this.field_5_ext_rst != null) {
            ammountThatCantFit = this.field_5_ext_rst.length - stats.remainingSize;
            if (ammountThatCantFit > 0) {
                while (ammountThatCantFit > 0) {
                    ammountWritten = Math.min(stats.remainingSize, ammountThatCantFit);
                    stats.recordSize += ammountWritten;
                    stats.remainingSize -= ammountWritten;
                    if ((ammountThatCantFit -= ammountWritten) <= 0) continue;
                    stats.remainingSize = 8224;
                    stats.recordSize += 4;
                }
            } else {
                stats.remainingSize -= this.field_5_ext_rst.length;
                stats.recordSize += this.field_5_ext_rst.length;
            }
        }
    }

    public short getSid() {
        return 4095;
    }

    public int compareTo(Object obj) {
        UnicodeString str = (UnicodeString)obj;
        int result = this.getString().compareTo(str.getString());
        if (result != 0) {
            return result;
        }
        if (this.field_4_format_runs == null && str.field_4_format_runs == null) {
            return 0;
        }
        if (this.field_4_format_runs == null && str.field_4_format_runs != null) {
            return 1;
        }
        if (this.field_4_format_runs != null && str.field_4_format_runs == null) {
            return -1;
        }
        int size = this.field_4_format_runs.size();
        if (size != str.field_4_format_runs.size()) {
            return size - str.field_4_format_runs.size();
        }
        int i = 0;
        while (i < size) {
            FormatRun run2;
            FormatRun run1 = (FormatRun)this.field_4_format_runs.get(i);
            result = run1.compareTo(run2 = (FormatRun)str.field_4_format_runs.get(i));
            if (result != 0) {
                return result;
            }
            ++i;
        }
        if (this.field_5_ext_rst == null && str.field_5_ext_rst == null) {
            return 0;
        }
        if (this.field_5_ext_rst == null && str.field_5_ext_rst != null) {
            return 1;
        }
        if (this.field_5_ext_rst != null && str.field_5_ext_rst == null) {
            return -1;
        }
        size = this.field_5_ext_rst.length;
        if (size != this.field_5_ext_rst.length) {
            return size - this.field_5_ext_rst.length;
        }
        i = 0;
        while (i < size) {
            if (this.field_5_ext_rst[i] != str.field_5_ext_rst[i]) {
                return this.field_5_ext_rst[i] - str.field_5_ext_rst[i];
            }
            ++i;
        }
        return 0;
    }

    public boolean isRichText() {
        return richText.isSet(this.getOptionFlags());
    }

    public boolean isExtendedText() {
        return extBit.isSet(this.getOptionFlags());
    }

    public Object clone() {
        UnicodeString str = new UnicodeString();
        str.field_1_charCount = this.field_1_charCount;
        str.field_2_optionflags = this.field_2_optionflags;
        str.field_3_string = this.field_3_string;
        if (this.field_4_format_runs != null) {
            str.field_4_format_runs = new ArrayList();
            int size = this.field_4_format_runs.size();
            int i = 0;
            while (i < size) {
                FormatRun r = (FormatRun)this.field_4_format_runs.get(i);
                str.field_4_format_runs.add(new FormatRun(r.character, r.fontIndex));
                ++i;
            }
        }
        if (this.field_5_ext_rst != null) {
            str.field_5_ext_rst = new byte[this.field_5_ext_rst.length];
            System.arraycopy(this.field_5_ext_rst, 0, str.field_5_ext_rst, 0, this.field_5_ext_rst.length);
        }
        return str;
    }

    public static class FormatRun
    implements Comparable {
        private short character;
        private short fontIndex;

        public FormatRun(short character, short fontIndex) {
            this.character = character;
            this.fontIndex = fontIndex;
        }

        public short getCharacterPos() {
            return this.character;
        }

        public short getFontIndex() {
            return this.fontIndex;
        }

        public boolean equals(Object o) {
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            FormatRun other = (FormatRun)o;
            return this.character == other.character && this.fontIndex == other.fontIndex;
        }

        public int compareTo(Object obj) {
            FormatRun r = (FormatRun)obj;
            if (this.character == r.character && this.fontIndex == r.fontIndex) {
                return 0;
            }
            if (this.character == r.character) {
                return this.fontIndex - r.fontIndex;
            }
            return this.character - r.character;
        }

        public String toString() {
            return "character=" + this.character + ",fontIndex=" + this.fontIndex;
        }
    }

    public static class UnicodeRecordStats {
        public int recordSize;
        public int remainingSize = 8228;
        public int lastLengthPos = -1;
    }
}

