/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula;

import org.apache.poi.hssf.model.Workbook;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.UnicodeString;
import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.util.LittleEndian;

public class ArrayPtg
extends Ptg {
    public static final byte sid = 32;
    protected byte field_1_reserved;
    protected byte field_2_reserved;
    protected byte field_3_reserved;
    protected byte field_4_reserved;
    protected byte field_5_reserved;
    protected byte field_6_reserved;
    protected byte field_7_reserved;
    protected short token_1_columns;
    protected short token_2_rows;
    protected Object[][] token_3_arrayValues;

    protected ArrayPtg() {
    }

    public ArrayPtg(RecordInputStream in) {
        this.field_1_reserved = in.readByte();
        this.field_2_reserved = in.readByte();
        this.field_3_reserved = in.readByte();
        this.field_4_reserved = in.readByte();
        this.field_5_reserved = in.readByte();
        this.field_6_reserved = in.readByte();
        this.field_7_reserved = in.readByte();
    }

    public void readTokenValues(RecordInputStream in) {
        this.token_1_columns = (short)(0xFF & in.readByte());
        this.token_2_rows = in.readShort();
        this.token_1_columns = (short)(this.token_1_columns + 1);
        this.token_2_rows = (short)(this.token_2_rows + 1);
        this.token_3_arrayValues = new Object[this.token_1_columns][this.token_2_rows];
        int x = 0;
        while (x < this.token_1_columns) {
            int y = 0;
            while (y < this.token_2_rows) {
                byte grbit = in.readByte();
                if (grbit == 1) {
                    this.token_3_arrayValues[x][y] = new Double(in.readDouble());
                } else if (grbit == 2) {
                    this.token_3_arrayValues[x][y] = in.readUnicodeString();
                } else {
                    throw new RecordFormatException("Unknown grbit '" + grbit + "'");
                }
                ++y;
            }
            ++x;
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("[ArrayPtg]\n");
        buffer.append("columns = ").append(this.getColumnCount()).append("\n");
        buffer.append("rows = ").append(this.getRowCount()).append("\n");
        int x = 0;
        while (x < this.getColumnCount()) {
            int y = 0;
            while (y < this.getRowCount()) {
                Object o = this.token_3_arrayValues[x][y];
                buffer.append("[").append(x).append("][").append(y).append("] = ").append(o).append("\n");
                ++y;
            }
            ++x;
        }
        return buffer.toString();
    }

    public void writeBytes(byte[] array, int offset) {
        array[offset++] = (byte)(32 + this.ptgClass);
        array[offset++] = this.field_1_reserved;
        array[offset++] = this.field_2_reserved;
        array[offset++] = this.field_3_reserved;
        array[offset++] = this.field_4_reserved;
        array[offset++] = this.field_5_reserved;
        array[offset++] = this.field_6_reserved;
        array[offset++] = this.field_7_reserved;
    }

    public int writeTokenValueBytes(byte[] array, int offset) {
        int pos = 0;
        array[pos + offset] = (byte)(this.token_1_columns - 1);
        LittleEndian.putShort(array, ++pos + offset, (short)(this.token_2_rows - 1));
        pos += 2;
        int x = 0;
        while (x < this.getColumnCount()) {
            int y = 0;
            while (y < this.getRowCount()) {
                Object o = this.token_3_arrayValues[x][y];
                if (o instanceof Double) {
                    array[pos + offset] = 1;
                    LittleEndian.putDouble(array, ++pos + offset, (Double)o);
                    pos += 8;
                } else if (o instanceof UnicodeString) {
                    array[pos + offset] = 2;
                    UnicodeString s = (UnicodeString)o;
                    UnicodeString.UnicodeRecordStats stats = new UnicodeString.UnicodeRecordStats();
                    s.serialize(stats, ++pos + offset, array);
                    pos += stats.recordSize;
                } else {
                    throw new RuntimeException("Coding error");
                }
                ++y;
            }
            ++x;
        }
        return pos;
    }

    public void setRowCount(short row) {
        this.token_2_rows = row;
    }

    public short getRowCount() {
        return this.token_2_rows;
    }

    public void setColumnCount(short col) {
        this.token_1_columns = (byte)col;
    }

    public short getColumnCount() {
        return this.token_1_columns;
    }

    public int getSize() {
        int size = 11;
        int x = 0;
        while (x < this.getColumnCount()) {
            int y = 0;
            while (y < this.getRowCount()) {
                Object o = this.token_3_arrayValues[x][y];
                if (o instanceof UnicodeString) {
                    ++size;
                    UnicodeString.UnicodeRecordStats rs = new UnicodeString.UnicodeRecordStats();
                    ((UnicodeString)o).getRecordSize(rs);
                    size += rs.recordSize;
                } else if (o instanceof Double) {
                    size += 9;
                }
                ++y;
            }
            ++x;
        }
        return size;
    }

    public String toFormulaString(Workbook book) {
        StringBuffer b = new StringBuffer();
        b.append("{");
        int x = 0;
        while (x < this.getColumnCount()) {
            int y = 0;
            while (y < this.getRowCount()) {
                Object o = this.token_3_arrayValues[x][y];
                if (o instanceof String) {
                    b.append((String)o);
                } else if (o instanceof Double) {
                    b.append((Double)o);
                }
                if (y != this.getRowCount()) {
                    b.append(",");
                }
                ++y;
            }
            if (x != this.getColumnCount()) {
                b.append(";");
            }
            ++x;
        }
        b.append("}");
        return b.toString();
    }

    public byte getDefaultOperandClass() {
        return 64;
    }

    public Object clone() {
        ArrayPtg ptg = new ArrayPtg();
        ptg.field_1_reserved = this.field_1_reserved;
        ptg.field_2_reserved = this.field_2_reserved;
        ptg.field_3_reserved = this.field_3_reserved;
        ptg.field_4_reserved = this.field_4_reserved;
        ptg.field_5_reserved = this.field_5_reserved;
        ptg.field_6_reserved = this.field_6_reserved;
        ptg.field_7_reserved = this.field_7_reserved;
        ptg.token_1_columns = this.token_1_columns;
        ptg.token_2_rows = this.token_2_rows;
        ptg.token_3_arrayValues = new Object[this.getColumnCount()][this.getRowCount()];
        int x = 0;
        while (x < this.getColumnCount()) {
            int y = 0;
            while (y < this.getRowCount()) {
                ptg.token_3_arrayValues[x][y] = this.token_3_arrayValues[x][y];
                ++y;
            }
            ++x;
        }
        ptg.setClass(this.ptgClass);
        return ptg;
    }
}

