/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula;

import org.apache.poi.hssf.model.Workbook;
import org.apache.poi.hssf.record.NameRecord;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.util.LittleEndian;

public class NamePtg
extends Ptg {
    public static final short sid = 35;
    private static final int SIZE = 5;
    private short field_1_label_index;
    private short field_2_zero;
    boolean xtra = false;

    private NamePtg() {
    }

    public NamePtg(String name, Workbook book) {
        NameRecord rec;
        short n = (short)(book.getNumNames() + 1);
        short i = 1;
        while (i < n) {
            rec = book.getNameRecord(i - 1);
            if (name.equals(rec.getNameText())) {
                this.field_1_label_index = i;
                return;
            }
            i = (short)(i + 1);
        }
        rec = new NameRecord();
        rec.setNameText(name);
        rec.setNameTextLength((byte)name.length());
        book.addName(rec);
        this.field_1_label_index = n;
    }

    public NamePtg(RecordInputStream in) {
        this.field_1_label_index = in.readShort();
        this.field_2_zero = in.readShort();
    }

    public void writeBytes(byte[] array, int offset) {
        array[offset + 0] = (byte)(35 + this.ptgClass);
        LittleEndian.putShort(array, offset + 1, this.field_1_label_index);
        LittleEndian.putShort(array, offset + 3, this.field_2_zero);
    }

    public int getSize() {
        return 5;
    }

    public String toFormulaString(Workbook book) {
        NameRecord rec = book.getNameRecord(this.field_1_label_index - 1);
        return rec.getNameText();
    }

    public byte getDefaultOperandClass() {
        return 0;
    }

    public Object clone() {
        NamePtg ptg = new NamePtg();
        ptg.field_1_label_index = this.field_1_label_index;
        ptg.field_2_zero = this.field_2_zero;
        return ptg;
    }
}

