/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

import java.util.Iterator;
import org.apache.poi.hssf.model.Workbook;
import org.apache.poi.hssf.record.LabelSSTRecord;
import org.apache.poi.hssf.record.UnicodeString;
import org.apache.poi.hssf.usermodel.HSSFFont;

public class HSSFRichTextString
implements Comparable {
    public static final short NO_FONT = 0;
    private UnicodeString string;
    private Workbook book;
    private LabelSSTRecord record;

    public HSSFRichTextString() {
        this("");
    }

    public HSSFRichTextString(String string) {
        if (string == null) {
            string = "";
        }
        this.string = new UnicodeString(string);
    }

    HSSFRichTextString(Workbook book, LabelSSTRecord record) {
        this.setWorkbookReferences(book, record);
        this.string = book.getSSTString(record.getSSTIndex());
    }

    void setWorkbookReferences(Workbook book, LabelSSTRecord record) {
        this.book = book;
        this.record = record;
    }

    private UnicodeString cloneStringIfRequired() {
        if (this.book == null) {
            return this.string;
        }
        UnicodeString s = (UnicodeString)this.string.clone();
        return s;
    }

    private void addToSSTIfRequired() {
        if (this.book != null) {
            int index = this.book.addSSTString(this.string);
            this.record.setSSTIndex(index);
            this.string = this.book.getSSTString(index);
        }
    }

    public void applyFont(int startIndex, int endIndex, short fontIndex) {
        if (startIndex > endIndex) {
            throw new IllegalArgumentException("Start index must be less than end index.");
        }
        if (startIndex < 0 || endIndex > this.length()) {
            throw new IllegalArgumentException("Start and end index not in range.");
        }
        if (startIndex == endIndex) {
            return;
        }
        short currentFont = 0;
        if (endIndex != this.length()) {
            currentFont = this.getFontAtIndex(startIndex);
        }
        this.string = this.cloneStringIfRequired();
        Iterator formatting = this.string.formatIterator();
        if (formatting != null) {
            while (formatting.hasNext()) {
                UnicodeString.FormatRun r = (UnicodeString.FormatRun)formatting.next();
                if (r.getCharacterPos() < startIndex || r.getCharacterPos() >= endIndex) continue;
                formatting.remove();
            }
        }
        this.string.addFormatRun(new UnicodeString.FormatRun((short)startIndex, fontIndex));
        if (endIndex != this.length()) {
            this.string.addFormatRun(new UnicodeString.FormatRun((short)endIndex, currentFont));
        }
        this.addToSSTIfRequired();
    }

    public void applyFont(int startIndex, int endIndex, HSSFFont font) {
        this.applyFont(startIndex, endIndex, font.getIndex());
    }

    public void applyFont(HSSFFont font) {
        this.applyFont(0, (int)this.string.getCharCount(), font);
    }

    public void clearFormatting() {
        this.string = this.cloneStringIfRequired();
        this.string.clearFormatting();
        this.addToSSTIfRequired();
    }

    public String getString() {
        return this.string.getString();
    }

    UnicodeString getUnicodeString() {
        return this.cloneStringIfRequired();
    }

    void setUnicodeString(UnicodeString str) {
        this.string = str;
    }

    public int length() {
        return this.string.getCharCount();
    }

    public short getFontAtIndex(int index) {
        int size = this.string.getFormatRunCount();
        UnicodeString.FormatRun currentRun = null;
        int i = 0;
        while (i < size) {
            UnicodeString.FormatRun r = this.string.getFormatRun(i);
            if (r.getCharacterPos() > index) break;
            currentRun = r;
            ++i;
        }
        if (currentRun == null) {
            return 0;
        }
        return currentRun.getFontIndex();
    }

    public int numFormattingRuns() {
        return this.string.getFormatRunCount();
    }

    public int getIndexOfFormattingRun(int index) {
        UnicodeString.FormatRun r = this.string.getFormatRun(index);
        return r.getCharacterPos();
    }

    public short getFontOfFormattingRun(int index) {
        UnicodeString.FormatRun r = this.string.getFormatRun(index);
        return r.getFontIndex();
    }

    public int compareTo(Object o) {
        HSSFRichTextString r = (HSSFRichTextString)o;
        return this.string.compareTo(r.string);
    }

    public boolean equals(Object o) {
        if (o instanceof HSSFRichTextString) {
            return this.string.equals(((HSSFRichTextString)o).string);
        }
        return false;
    }

    public String toString() {
        return this.string.toString();
    }

    public void applyFont(short fontIndex) {
        this.applyFont(0, (int)this.string.getCharCount(), fontIndex);
    }
}

