/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.util;

import java.util.ArrayList;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.util.LittleEndian;

public class HSSFCellRangeAddress {
    private short field_addr_number;
    private ArrayList field_regions_list;

    public HSSFCellRangeAddress() {
    }

    public HSSFCellRangeAddress(RecordInputStream in) {
        this.fillFields(in);
    }

    public void fillFields(RecordInputStream in) {
        this.field_addr_number = in.readShort();
        this.field_regions_list = new ArrayList(this.field_addr_number);
        int k = 0;
        while (k < this.field_addr_number) {
            short first_row = in.readShort();
            short first_col = in.readShort();
            short last_row = in.readShort();
            short last_col = in.readShort();
            AddrStructure region = new AddrStructure(first_row, first_col, last_row, last_col);
            this.field_regions_list.add(region);
            ++k;
        }
    }

    public short getADDRStructureNumber() {
        return this.field_addr_number;
    }

    public int addADDRStructure(short first_row, short first_col, short last_row, short last_col) {
        if (this.field_regions_list == null) {
            this.field_addr_number = 0;
            this.field_regions_list = new ArrayList(10);
        }
        AddrStructure region = new AddrStructure(first_row, last_row, first_col, last_col);
        this.field_regions_list.add(region);
        this.field_addr_number = (short)(this.field_addr_number + 1);
        return this.field_addr_number;
    }

    public void removeADDRStructureAt(int index) {
        this.field_regions_list.remove(index);
        this.field_addr_number = (short)(this.field_addr_number - 1);
    }

    public AddrStructure getADDRStructureAt(int index) {
        return (AddrStructure)this.field_regions_list.get(index);
    }

    public int serialize(int offset, byte[] data) {
        int pos = 2;
        LittleEndian.putShort(data, offset, this.getADDRStructureNumber());
        int k = 0;
        while (k < this.getADDRStructureNumber()) {
            AddrStructure region = this.getADDRStructureAt(k);
            LittleEndian.putShort(data, offset + pos, region.getFirstRow());
            LittleEndian.putShort(data, offset + (pos += 2), region.getLastRow());
            LittleEndian.putShort(data, offset + (pos += 2), region.getFirstColumn());
            LittleEndian.putShort(data, offset + (pos += 2), region.getLastColumn());
            pos += 2;
            ++k;
        }
        return this.getSize();
    }

    public int getSize() {
        return 2 + this.field_addr_number * 8;
    }

    public class AddrStructure {
        private short _first_row;
        private short _first_col;
        private short _last_row;
        private short _last_col;

        public AddrStructure(short first_row, short last_row, short first_col, short last_col) {
            this._first_row = first_row;
            this._last_row = last_row;
            this._first_col = first_col;
            this._last_col = last_col;
        }

        public short getFirstColumn() {
            return this._first_col;
        }

        public short getFirstRow() {
            return this._first_row;
        }

        public short getLastColumn() {
            return this._last_col;
        }

        public short getLastRow() {
            return this._last_row;
        }

        public void setFirstColumn(short first_col) {
            this._first_col = first_col;
        }

        public void setFirstRow(short first_row) {
            this._first_row = first_row;
        }

        public void setLastColumn(short last_col) {
            this._last_col = last_col;
        }

        public void setLastRow(short last_row) {
            this._last_row = last_row;
        }
    }
}

