/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.DecimalFormat;

public class HexDump {
    public static final String EOL = System.getProperty("line.separator");
    private static final char[] _hexcodes = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final int[] _shifts;

    static {
        int[] nArray = new int[16];
        nArray[0] = 60;
        nArray[1] = 56;
        nArray[2] = 52;
        nArray[3] = 48;
        nArray[4] = 44;
        nArray[5] = 40;
        nArray[6] = 36;
        nArray[7] = 32;
        nArray[8] = 28;
        nArray[9] = 24;
        nArray[10] = 20;
        nArray[11] = 16;
        nArray[12] = 12;
        nArray[13] = 8;
        nArray[14] = 4;
        _shifts = nArray;
    }

    private HexDump() {
    }

    public static synchronized void dump(byte[] data, long offset, OutputStream stream, int index, int length) throws IOException, ArrayIndexOutOfBoundsException, IllegalArgumentException {
        if (data.length == 0) {
            stream.write(("No Data" + System.getProperty("line.separator")).getBytes());
            stream.flush();
            return;
        }
        if (index < 0 || index >= data.length) {
            throw new ArrayIndexOutOfBoundsException("illegal index: " + index + " into array of length " + data.length);
        }
        if (stream == null) {
            throw new IllegalArgumentException("cannot write to nullstream");
        }
        long display_offset = offset + (long)index;
        StringBuffer buffer = new StringBuffer(74);
        int data_length = Math.min(data.length, index + length);
        int j = index;
        while (j < data_length) {
            int chars_read = data_length - j;
            if (chars_read > 16) {
                chars_read = 16;
            }
            buffer.append(HexDump.dump(display_offset)).append(' ');
            int k = 0;
            while (k < 16) {
                if (k < chars_read) {
                    buffer.append(HexDump.dump(data[k + j]));
                } else {
                    buffer.append("  ");
                }
                buffer.append(' ');
                ++k;
            }
            k = 0;
            while (k < chars_read) {
                if (data[k + j] >= 32 && data[k + j] < 127) {
                    buffer.append((char)data[k + j]);
                } else {
                    buffer.append('.');
                }
                ++k;
            }
            buffer.append(EOL);
            stream.write(buffer.toString().getBytes());
            stream.flush();
            buffer.setLength(0);
            display_offset += (long)chars_read;
            j += 16;
        }
    }

    public static synchronized void dump(byte[] data, long offset, OutputStream stream, int index) throws IOException, ArrayIndexOutOfBoundsException, IllegalArgumentException {
        HexDump.dump(data, offset, stream, index, data.length - index);
    }

    public static String dump(byte[] data, long offset, int index) {
        if (index < 0 || index >= data.length) {
            throw new ArrayIndexOutOfBoundsException("illegal index: " + index + " into array of length " + data.length);
        }
        long display_offset = offset + (long)index;
        StringBuffer buffer = new StringBuffer(74);
        int j = index;
        while (j < data.length) {
            int chars_read = data.length - j;
            if (chars_read > 16) {
                chars_read = 16;
            }
            buffer.append(HexDump.dump(display_offset)).append(' ');
            int k = 0;
            while (k < 16) {
                if (k < chars_read) {
                    buffer.append(HexDump.dump(data[k + j]));
                } else {
                    buffer.append("  ");
                }
                buffer.append(' ');
                ++k;
            }
            k = 0;
            while (k < chars_read) {
                if (data[k + j] >= 32 && data[k + j] < 127) {
                    buffer.append((char)data[k + j]);
                } else {
                    buffer.append('.');
                }
                ++k;
            }
            buffer.append(EOL);
            display_offset += (long)chars_read;
            j += 16;
        }
        return buffer.toString();
    }

    private static String dump(long value) {
        StringBuffer buf = new StringBuffer();
        buf.setLength(0);
        int j = 0;
        while (j < 8) {
            buf.append(_hexcodes[(int)(value >> _shifts[j + _shifts.length - 8]) & 0xF]);
            ++j;
        }
        return buf.toString();
    }

    private static String dump(byte value) {
        StringBuffer buf = new StringBuffer();
        buf.setLength(0);
        int j = 0;
        while (j < 2) {
            buf.append(_hexcodes[value >> _shifts[j + 6] & 0xF]);
            ++j;
        }
        return buf.toString();
    }

    public static String toHex(byte[] value) {
        StringBuffer retVal = new StringBuffer();
        retVal.append('[');
        int x = 0;
        while (x < value.length) {
            retVal.append(HexDump.toHex(value[x]));
            retVal.append(", ");
            ++x;
        }
        retVal.append(']');
        return retVal.toString();
    }

    public static String toHex(short[] value) {
        StringBuffer retVal = new StringBuffer();
        retVal.append('[');
        int x = 0;
        while (x < value.length) {
            retVal.append(HexDump.toHex(value[x]));
            retVal.append(", ");
            ++x;
        }
        retVal.append(']');
        return retVal.toString();
    }

    public static String toHex(byte[] value, int bytesPerLine) {
        int digits = (int)Math.round(Math.log(value.length) / Math.log(10.0) + 0.5);
        StringBuffer formatString = new StringBuffer();
        int i = 0;
        while (i < digits) {
            formatString.append('0');
            ++i;
        }
        formatString.append(": ");
        DecimalFormat format = new DecimalFormat(formatString.toString());
        StringBuffer retVal = new StringBuffer();
        retVal.append(format.format(0L));
        int i2 = -1;
        int x = 0;
        while (x < value.length) {
            if (++i2 == bytesPerLine) {
                retVal.append('\n');
                retVal.append(format.format(x));
                i2 = 0;
            }
            retVal.append(HexDump.toHex(value[x]));
            retVal.append(", ");
            ++x;
        }
        return retVal.toString();
    }

    public static String toHex(short value) {
        return HexDump.toHex(value, 4);
    }

    public static String toHex(byte value) {
        return HexDump.toHex(value, 2);
    }

    public static String toHex(int value) {
        return HexDump.toHex(value, 8);
    }

    public static String toHex(long value) {
        return HexDump.toHex(value, 16);
    }

    private static String toHex(long value, int digits) {
        StringBuffer result = new StringBuffer(digits);
        int j = 0;
        while (j < digits) {
            result.append(_hexcodes[(int)(value >> _shifts[j + (16 - digits)] & 0xFL)]);
            ++j;
        }
        return result.toString();
    }

    public static void dump(InputStream in, PrintStream out, int start, int bytesToDump) throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        if (bytesToDump == -1) {
            int c = in.read();
            while (c != -1) {
                buf.write(c);
                c = in.read();
            }
        } else {
            int bytesRemaining = bytesToDump;
            while (bytesRemaining-- > 0) {
                int c = in.read();
                if (c != -1) {
                    buf.write(c);
                    continue;
                }
                break;
            }
        }
        byte[] data = buf.toByteArray();
        HexDump.dump(data, 0L, out, start, data.length);
    }

    public static void main(String[] args) throws Exception {
        File file = new File(args[0]);
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        byte[] b = new byte[(int)file.length()];
        ((InputStream)in).read(b);
        System.out.println(HexDump.dump(b, 0L, 0));
        ((InputStream)in).close();
    }
}

