/*
 * Decompiled with CFR 0.152.
 */
package com.bitmechanic.sql;

import com.bitmechanic.sql.PooledConnection;
import com.bitmechanic.util.JavaAlarm;
import com.bitmechanic.util.Queue;
import com.bitmechanic.util.TimeoutException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Vector;
import oracle.jdbc.driver.OracleConnection;

public class ConnectionPool {
    Vector connVector;
    Vector closeVector;
    String url;
    private Queue waitingThreads;
    private String username;
    private String password;
    private String alias;
    private int maxConn;
    private int timeoutSeconds;
    private int checkoutSeconds;
    private int numCheckoutTimeout;
    private int numRequests;
    private int numWaits;
    private int maxCheckout;
    private boolean cacheStatements;
    int numConnectionFaults = 0;
    private boolean trace;
    private int prefetchSize = -1;

    public void setCacheStatements(boolean bl) {
        this.cacheStatements = bl;
    }

    public boolean getCacheStatements() {
        return this.cacheStatements;
    }

    public void setTracing(boolean bl) {
        this.trace = bl;
    }

    public String getAlias() {
        return this.alias;
    }

    public int getNumRequests() {
        return this.numRequests;
    }

    public int getNumWaits() {
        return this.numWaits;
    }

    public int getNumCheckoutTimeouts() {
        return this.numCheckoutTimeout;
    }

    public int getMaxConn() {
        return this.maxConn;
    }

    public int size() {
        return this.connVector.size();
    }

    public void reapIdleConnections() {
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            if (this.trace) {
                System.err.println("ConnectionPool: " + this.alias + " reapIdleConnections() starting," + " size=" + this.size());
            }
            long l = System.currentTimeMillis();
            long l2 = l - (long)(this.timeoutSeconds * 1000);
            long l3 = l - (long)(this.checkoutSeconds * 1000);
            int n = 0;
            while (n < this.connVector.size()) {
                PooledConnection pooledConnection = (PooledConnection)this.connVector.elementAt(n);
                if (pooledConnection.isLocked() && pooledConnection.getLastAccess() < l3) {
                    ++this.numCheckoutTimeout;
                    System.err.println("ConnectionPool: Warning: found " + "timed-out connection\n" + pooledConnection.dumpInfo());
                    this.removeConnection(pooledConnection);
                    this.notifyAll();
                    continue;
                }
                if (pooledConnection.getLastAccess() < l2 && pooledConnection.getLock()) {
                    this.removeConnection(pooledConnection);
                    pooledConnection.releaseLock();
                    this.notifyAll();
                    continue;
                }
                ++n;
            }
        }
        this.closeConnections();
        if (this.trace) {
            System.err.println("ConnectionPool: " + this.alias + " reapIdleConnections() finished");
        }
    }

    public synchronized void removeAllConnections() {
        if (this.trace) {
            System.err.println("ConnectionPool: " + this.alias + " removeAllConnections() called");
        }
        while (!this.connVector.isEmpty()) {
            PooledConnection pooledConnection = (PooledConnection)this.connVector.firstElement();
            this.removeConnection(pooledConnection);
        }
    }

    private synchronized void removeConnection(PooledConnection pooledConnection) {
        this.removeConnection(pooledConnection, false);
    }

    private synchronized void removeConnection(PooledConnection pooledConnection, boolean bl) {
        this.connVector.removeElement(pooledConnection);
        if (bl) {
            this.closeConnection(pooledConnection);
        } else {
            this.closeVector.addElement(pooledConnection);
        }
    }

    private void closeConnections() {
        Vector vector = (Vector)this.closeVector.clone();
        int n = 0;
        while (n < vector.size()) {
            PooledConnection pooledConnection = (PooledConnection)vector.elementAt(n);
            this.closeConnection(pooledConnection);
            ++n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void closeConnection(PooledConnection pooledConnection) {
        try {
            this.closeVector.removeElement(pooledConnection);
            JavaAlarm javaAlarm = new JavaAlarm((Runnable)pooledConnection, 10000L);
            return;
        }
        catch (TimeoutException timeoutException) {
            if (this.trace) {
                timeoutException.printStackTrace();
            }
            System.err.println("ConnectionPool: " + timeoutException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Connection getConnection() throws SQLException {
        if (this.trace) {
            System.err.println("ConnectionPool: " + this.alias + " getConnection() called");
        }
        ++this.numRequests;
        while (true) {
            PooledConnection pooledConnection;
            int n = 0;
            while (n < this.connVector.size()) {
                pooledConnection = (PooledConnection)this.connVector.elementAt(n);
                if (pooledConnection.getLock()) {
                    return this.releaseConnection(pooledConnection);
                }
                ++n;
            }
            if (this.trace) {
                System.err.println("ConnectionPool: " + this.alias + " all connections locked.  calling" + " createConnection()");
            }
            if (this.connVector.size() < this.maxConn) {
                if (this.trace) {
                    System.err.println("ConnectionPool: " + this.alias + " opening new connection to database size=" + this.size());
                }
                Connection connection = this.createDriverConnection();
                if (this.trace) {
                    System.err.println("ConnectionPool: " + this.alias + " finished opening new connection");
                }
                if (this.prefetchSize != -1 && connection instanceof OracleConnection) {
                    ((OracleConnection)connection).setDefaultRowPrefetch(this.prefetchSize);
                }
                pooledConnection = new PooledConnection(connection, this);
                pooledConnection.getLock();
                this.connVector.addElement(pooledConnection);
                return this.releaseConnection(pooledConnection);
            }
            try {
                if (this.trace) {
                    System.err.println("ConnectionPool: " + this.alias + " pool is full.  calling wait()");
                }
                ++this.numWaits;
                this.wait();
            }
            catch (InterruptedException interruptedException) {
            }
            if (!this.trace) continue;
            System.err.println("ConnectionPool: " + this.alias + " awoken from wait().  trying to grab" + " an available connection");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized Connection releaseConnection(PooledConnection pooledConnection) {
        if (this.trace) {
            try {
                throw new RuntimeException();
            }
            catch (RuntimeException runtimeException) {
                pooledConnection.setTraceException(runtimeException);
            }
        }
        return pooledConnection;
    }

    Connection createDriverConnection() throws SQLException {
        return DriverManager.getConnection(this.url, this.username, this.password);
    }

    public synchronized void returnConnection(PooledConnection pooledConnection) {
        if (this.maxCheckout > 0 && pooledConnection.getCheckoutCount() >= this.maxCheckout) {
            if (this.trace) {
                System.err.println("ConnectionPool: " + this.alias + " connection checked out max # of times." + " closing it.");
            }
            this.removeConnection(pooledConnection, true);
        }
        if (this.trace) {
            System.err.println("ConnectionPool: " + this.alias + " releasing lock and calling notifyAll()");
        }
        pooledConnection.releaseLock();
        this.notifyAll();
    }

    public String dumpInfo() {
        String string = System.getProperty("line.separator");
        String string2 = "Pool: " + this.toString() + string;
        string2 = string2 + "\tAlias: " + this.getAlias() + string;
        string2 = string2 + "\tMax connections: " + this.getMaxConn() + string;
        string2 = string2 + "\tURL: " + this.url + string;
        string2 = string2 + "\tCheckouts: " + this.getNumRequests() + string;
        string2 = string2 + "\tThread waits: " + this.getNumWaits() + string;
        string2 = string2 + "\tConnections found closed: " + this.numConnectionFaults + string;
        string2 = string2 + "\tConnections reaped by timeout: " + this.getNumCheckoutTimeouts() + string;
        string2 = string2 + "\tConnections currently in pool: " + this.size() + string;
        Vector vector = this.connVector;
        int n = 0;
        while (n < vector.size()) {
            PooledConnection pooledConnection = (PooledConnection)vector.elementAt(n);
            if (pooledConnection != null) {
                string2 = string2 + pooledConnection.dumpInfo();
            }
            ++n;
        }
        return string2;
    }

    public void setPrefetchSize(int n) {
        this.prefetchSize = n;
    }

    public int getPrefetchSize() {
        return this.prefetchSize;
    }

    public ConnectionPool(String string, String string2, String string3, String string4, int n, int n2, int n3) {
        this(string, string2, string3, string4, n, n2, n3, 0);
    }

    public ConnectionPool(String string, String string2, String string3, String string4, int n, int n2, int n3, int n4) {
        this.timeoutSeconds = n2;
        this.checkoutSeconds = n3;
        this.alias = string;
        this.url = string2;
        this.username = string3;
        this.password = string4;
        this.maxConn = n;
        this.maxCheckout = n4;
        this.numRequests = 0;
        this.numWaits = 0;
        this.numCheckoutTimeout = 0;
        this.connVector = new Vector(n);
        this.closeVector = new Vector(n);
        this.waitingThreads = new Queue();
        this.trace = false;
        this.cacheStatements = true;
    }
}

