/*
 * Decompiled with CFR 0.152.
 */
package com.bitmechanic.sql;

import com.bitmechanic.sql.ConnectionPool;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class ConnectionPoolManager
implements Driver,
Runnable {
    public static final String URL_PREFIX = "jdbc:bitmechanic:pool:";
    private static final int MAJOR_VERSION = 0;
    private static final int MINOR_VERSION = 92;
    private Hashtable aliasHash = new Hashtable();
    private long sleepInterval;
    private boolean trace;

    public void addAlias(String string, String string2, String string3, String string4, String string5, int n, int n2, int n3) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.addAlias(string, string2, string3, string4, string5, n, n2, n3, 0);
    }

    public void addAlias(String string, String string2, String string3, String string4, String string5, int n, int n2, int n3, int n4) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.addAlias(string, string2, string3, string4, string5, n, n2, n3, n4, true);
    }

    public void addAlias(String string, String string2, String string3, String string4, String string5, int n, int n2, int n3, int n4, boolean bl) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class.forName(string2).newInstance();
        ConnectionPool connectionPool = new ConnectionPool(string, string3, string4, string5, n, n2, n3, n4);
        connectionPool.setCacheStatements(bl);
        this.addAlias(connectionPool);
    }

    public void addAlias(String string, String string2, String string3, String string4, String string5, int n, int n2, int n3, int n4, int n5) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.addAlias(string, string2, string3, string4, string5, n, n2, n3, n4, n5, true);
    }

    public void addAlias(String string, String string2, String string3, String string4, String string5, int n, int n2, int n3, int n4, int n5, boolean bl) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class.forName(string2).newInstance();
        ConnectionPool connectionPool = new ConnectionPool(string, string3, string4, string5, n, n2, n3, n4);
        connectionPool.setCacheStatements(bl);
        connectionPool.setPrefetchSize(n5);
        this.addAlias(connectionPool);
    }

    public synchronized void addAlias(ConnectionPool connectionPool) {
        this.aliasHash.put(connectionPool.getAlias(), connectionPool);
    }

    public synchronized void removeAlias(String string) throws SQLException {
        ConnectionPool connectionPool = this.getPool(string);
        this.aliasHash.remove(string);
        connectionPool.removeAllConnections();
    }

    public Enumeration getPools() {
        return this.aliasHash.elements();
    }

    public ConnectionPool getPool(String string) throws SQLException {
        ConnectionPool connectionPool = (ConnectionPool)this.aliasHash.get(string);
        if (connectionPool == null) {
            throw new SQLException("No connection pool created for alias: " + string);
        }
        return connectionPool;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block4: while (true) {
            try {
                Thread.currentThread();
                Thread.sleep(this.sleepInterval);
            }
            catch (InterruptedException interruptedException) {
            }
            Enumeration enumeration = this.aliasHash.elements();
            while (true) {
                if (!enumeration.hasMoreElements()) continue block4;
                ConnectionPool connectionPool = (ConnectionPool)enumeration.nextElement();
                try {
                    connectionPool.reapIdleConnections();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            break;
        }
    }

    public void setTracing(boolean bl) {
        if (bl != this.trace) {
            Object object = this.getPools();
            while (object.hasMoreElements()) {
                ConnectionPool connectionPool = (ConnectionPool)object.nextElement();
                connectionPool.setTracing(bl);
            }
            object = "off";
            if (bl) {
                object = "on";
            }
            System.err.println("ConnectionPoolManager: Tracing turned " + (String)object);
            this.trace = bl;
        }
    }

    public Connection connect(String string, Properties properties) throws SQLException {
        if (!string.startsWith(URL_PREFIX)) {
            return null;
        }
        if (string.length() <= URL_PREFIX.length()) {
            throw new SQLException("Invalid URL: " + string + " -- No alias given");
        }
        String string2 = string.substring(URL_PREFIX.length());
        if (this.trace) {
            System.err.println("ConnectionPoolManager: connect() called for " + string2 + ".  calling pool.getConnection()");
        }
        ConnectionPool connectionPool = this.getPool(string2);
        return connectionPool.getConnection();
    }

    public boolean acceptsURL(String string) {
        return string.startsWith(URL_PREFIX);
    }

    public int getMajorVersion() {
        return 0;
    }

    public int getMinorVersion() {
        return 92;
    }

    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) {
        return new DriverPropertyInfo[0];
    }

    public boolean jdbcCompliant() {
        return false;
    }

    public String dumpInfo() {
        String string = System.getProperty("line.separator");
        Enumeration enumeration = this.getPools();
        String string2 = "";
        while (enumeration.hasMoreElements()) {
            ConnectionPool connectionPool = (ConnectionPool)enumeration.nextElement();
            string2 = string2 + connectionPool.dumpInfo();
        }
        return string2;
    }

    public ConnectionPoolManager() throws SQLException {
        DriverManager.registerDriver(this);
        this.trace = false;
    }

    public ConnectionPoolManager(int n) throws SQLException {
        this();
        this.sleepInterval = n * 1000;
        Thread thread = new Thread(this);
        thread.setDaemon(true);
        thread.start();
    }
}

