/*
 * Decompiled with CFR 0.152.
 */
package com.bitmechanic.sql;

import com.bitmechanic.sql.ConnectionPool;
import com.bitmechanic.sql.PooledPreparedStatement;
import com.bitmechanic.sql.PooledStatement;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class PooledConnection
implements Connection,
Runnable {
    private static final int closedConnMaxRetry = 5;
    private static final int closedConnRetryWait = 1000;
    private ConnectionPool pool;
    private Connection conn;
    private boolean locked;
    private long lastAccess;
    private long lastCheckin;
    private int checkoutCount;
    private PooledStatement theStatement = null;
    int totalStatements;
    int preparedCalls;
    int preparedStatementHits;
    int preparedStatementMisses;
    int preparedStatements;
    private Exception traceException;
    private Map prepStmts;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            this.closeStatements();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        try {
            this.getConnection().close();
            return;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void closeStatements() throws SQLException {
        if (this.theStatement != null) {
            this.theStatement.getStatement().close();
        }
        Iterator iterator = this.prepStmts.values().iterator();
        while (iterator.hasNext()) {
            try {
                PooledPreparedStatement pooledPreparedStatement = (PooledPreparedStatement)iterator.next();
                pooledPreparedStatement.getStatement().close();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        }
    }

    public synchronized boolean getLock() {
        if (this.locked) {
            return false;
        }
        this.locked = true;
        ++this.checkoutCount;
        this.lastAccess = System.currentTimeMillis();
        return true;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public int getCheckoutCount() {
        return this.checkoutCount;
    }

    public long getLastAccess() {
        return this.lastAccess;
    }

    public long getLastCheckin() {
        return this.lastCheckin;
    }

    public void close() throws SQLException {
        this.lastAccess = System.currentTimeMillis();
        this.pool.returnConnection(this);
    }

    protected void releaseLock() {
        this.lastCheckin = System.currentTimeMillis();
        this.locked = false;
    }

    protected Connection getConnection() {
        return this.conn;
    }

    public Connection getNativeConnection() {
        return this.conn;
    }

    public String dumpInfo() {
        String string = System.getProperty("line.separator");
        String string2 = "\t\tConnection: " + this.toString() + string;
        string2 = string2 + "\t\t\tStatements Requested: " + this.totalStatements + string;
        string2 = string2 + "\t\t\tPrepared Calls: " + this.preparedCalls + string;
        if (this.pool.getCacheStatements()) {
            string2 = string2 + "\t\t\tPrepared Statements Hits: " + this.preparedStatementHits + string;
            string2 = string2 + "\t\t\tPrepared Statements Misses: " + this.preparedStatementMisses + string;
        } else {
            string2 = string2 + "\t\t\tPrepared Statements Requested: " + this.preparedStatements + string;
        }
        string2 = string2 + "\t\t\tCheckout count: " + this.getCheckoutCount() + string;
        string2 = string2 + "\t\t\tLast Checkout: " + this.getLastAccess() + ": " + new Date(this.getLastAccess()) + string;
        string2 = string2 + "\t\t\tLast Checkin : " + this.getLastCheckin() + ": " + new Date(this.getLastCheckin()) + string;
        string2 = string2 + "\t\t\t" + (this.isLocked() ? "Connection IS checked out." : "Connection is NOT checked out.") + string;
        string2 = string2 + "\t\t\tCheckout Stack Trace: ";
        if (this.traceException != null) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            this.traceException.printStackTrace(printWriter);
            string2 = string2 + stringWriter.toString();
        } else {
            string2 = string2 + "null";
        }
        string2 = string2 + string;
        if (this.theStatement != null) {
            string2 = string2 + this.theStatement.dumpInfo();
        }
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void guardConnection() {
        boolean bl;
        try {
            bl = this.conn.isClosed();
        }
        catch (SQLException sQLException) {
            bl = true;
        }
        if (bl) {
            ++this.pool.numConnectionFaults;
            System.err.println("PooledConnection.guardConnection(): " + "found closed Connection. " + "Statement information follows. Attempting to recover.");
            if (this.theStatement != null) {
                System.err.println("PooledConnection.guardConnection(): " + this.theStatement.dumpInfo());
            } else {
                System.err.println("PooledConnection.guardConnection: statement was null");
            }
            this.theStatement = null;
            int n = 0;
            n = 0;
            while (n < 5) {
                block10: {
                    try {
                        this.conn = this.pool.createDriverConnection();
                    }
                    catch (SQLException sQLException) {
                        System.err.println("PooledConnection.guardConnection(): " + "failed to create connection on try #" + n);
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            System.err.println("PooledConnection: " + interruptedException);
                        }
                        break block10;
                    }
                    System.err.println("PooledConnection.guardConnection(): " + "Recovered connection");
                    return;
                }
                ++n;
            }
        }
    }

    public Statement createStatement() throws SQLException {
        this.guardConnection();
        ++this.totalStatements;
        if (this.pool.getCacheStatements()) {
            if (this.theStatement == null) {
                this.theStatement = new PooledStatement(this.conn.createStatement());
            }
            return this.theStatement;
        }
        return this.conn.createStatement();
    }

    public Map getTypeMap() throws SQLException {
        return this.conn.getTypeMap();
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        if (this.pool.getCacheStatements()) {
            PreparedStatement preparedStatement = (PreparedStatement)this.prepStmts.get(string);
            if (preparedStatement == null) {
                preparedStatement = this.conn.prepareStatement(string);
                preparedStatement = new PooledPreparedStatement(preparedStatement);
                Map map = this.prepStmts;
                synchronized (map) {
                    this.prepStmts.put(string, preparedStatement);
                }
                ++this.preparedStatementMisses;
            } else {
                ++this.preparedStatementHits;
            }
            return preparedStatement;
        }
        ++this.preparedStatements;
        return this.conn.prepareStatement(string);
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        if (this.pool.getCacheStatements()) {
            ++this.preparedStatementMisses;
        } else {
            ++this.preparedStatements;
        }
        PreparedStatement preparedStatement = this.conn.prepareStatement(string, n, n2);
        return preparedStatement;
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        ++this.preparedCalls;
        CallableStatement callableStatement = this.conn.prepareCall(string);
        return callableStatement;
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        ++this.preparedCalls;
        CallableStatement callableStatement = this.conn.prepareCall(string, n, n2);
        return callableStatement;
    }

    public Statement createStatement(int n, int n2) throws SQLException {
        ++this.totalStatements;
        return this.conn.createStatement(n, n2);
    }

    public String nativeSQL(String string) throws SQLException {
        return this.conn.nativeSQL(string);
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        this.conn.setAutoCommit(bl);
    }

    public boolean getAutoCommit() throws SQLException {
        return this.conn.getAutoCommit();
    }

    public void commit() throws SQLException {
        this.conn.commit();
    }

    public void rollback() throws SQLException {
        this.conn.rollback();
    }

    public boolean isClosed() throws SQLException {
        return this.conn.isClosed();
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return this.conn.getMetaData();
    }

    public void setReadOnly(boolean bl) throws SQLException {
        this.conn.setReadOnly(bl);
    }

    public boolean isReadOnly() throws SQLException {
        return this.conn.isReadOnly();
    }

    public void setCatalog(String string) throws SQLException {
        this.conn.setCatalog(string);
    }

    public String getCatalog() throws SQLException {
        return this.conn.getCatalog();
    }

    public void setTypeMap(Map map) throws SQLException {
        this.conn.setTypeMap(map);
    }

    public void setTransactionIsolation(int n) throws SQLException {
        this.conn.setTransactionIsolation(n);
    }

    public int getTransactionIsolation() throws SQLException {
        return this.conn.getTransactionIsolation();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.conn.getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this.conn.clearWarnings();
    }

    protected void setTraceException(Exception exception) {
        this.traceException = exception;
    }

    public Exception getTraceException() {
        return this.traceException;
    }

    public PooledConnection(Connection connection, ConnectionPool connectionPool) {
        this.conn = connection;
        this.pool = connectionPool;
        this.locked = false;
        this.lastAccess = 0L;
        this.checkoutCount = 0;
        this.totalStatements = 0;
        this.prepStmts = new HashMap();
    }
}

