/*
 * Decompiled with CFR 0.152.
 */
package com.bitmechanic.sql;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;

public class SQLUtil {
    private static String emptyStr = "";
    private static SimpleDateFormat mysqlFormat = new SimpleDateFormat("yyyy-MM-dd");
    private static SimpleDateFormat mysqlFormatHiRes = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static String escapeString(String string) {
        return SQLUtil.escapeString(string, 999999);
    }

    public static String escapeString(String string, int n) {
        if (string == null) {
            return emptyStr;
        }
        if (string.length() > n) {
            string = string.substring(0, n);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "'");
        StringBuffer stringBuffer = null;
        while (stringTokenizer.hasMoreTokens()) {
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer(string.length() + 20);
            } else {
                stringBuffer.append("''");
            }
            stringBuffer.append(stringTokenizer.nextToken());
        }
        if (stringBuffer == null) {
            return string;
        }
        return stringBuffer.toString();
    }

    public static String notNull(String string) {
        if (string == null) {
            return emptyStr;
        }
        return string;
    }

    public static String formatMysqlDate(Date date) {
        if (date == null) {
            return "";
        }
        return mysqlFormat.format(date);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Date parseMysqlDate(String string) {
        if (string == null || string.equals("0000-00-00")) {
            return null;
        }
        try {
            return mysqlFormat.parse(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String formatHiResMysqlDate(Date date) {
        if (date == null) {
            return "";
        }
        return mysqlFormatHiRes.format(date);
    }

    public static String booleanToString(boolean bl) {
        if (bl) {
            return "y";
        }
        return "n";
    }

    public static boolean stringToBoolean(String string) {
        return string != null && string.equals("y");
    }
}

