/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.client;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import javax.servlet.http.Cookie;
import org.mortbay.io.Buffer;
import org.mortbay.io.ByteArrayBuffer;
import org.mortbay.jetty.client.Address;
import org.mortbay.jetty.client.HttpClient;
import org.mortbay.jetty.client.HttpConnection;
import org.mortbay.jetty.client.HttpEventListener;
import org.mortbay.jetty.client.HttpExchange;
import org.mortbay.jetty.client.security.Authorization;
import org.mortbay.jetty.client.security.SecurityListener;
import org.mortbay.jetty.servlet.PathMap;
import org.mortbay.log.Log;

public class HttpDestination {
    private ByteArrayBuffer _hostHeader;
    private final Address _address;
    private final LinkedList<HttpConnection> _connections = new LinkedList();
    private final ArrayList<HttpConnection> _idle = new ArrayList();
    private final HttpClient _client;
    private final boolean _ssl;
    private int _maxConnections;
    private int _pendingConnections = 0;
    private ArrayBlockingQueue<Object> _newQueue = new ArrayBlockingQueue(10, true);
    private int _newConnection = 0;
    private Address _proxy;
    private Authorization _proxyAuthentication;
    private PathMap _authorizations;
    private List<Cookie> _cookies;
    private LinkedList<HttpExchange> _queue = new LinkedList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump() throws IOException {
        HttpDestination httpDestination = this;
        synchronized (httpDestination) {
            System.err.println(this);
            System.err.println("connections=" + this._connections.size());
            System.err.println("idle=" + this._idle.size());
            System.err.println("pending=" + this._pendingConnections);
            for (HttpConnection c : this._connections) {
                if (c.isIdle()) continue;
                c.dump();
            }
        }
    }

    HttpDestination(HttpClient pool, Address address, boolean ssl, int maxConnections) {
        this._client = pool;
        this._address = address;
        this._ssl = ssl;
        this._maxConnections = maxConnections;
        String addressString = address.getHost();
        if (address.getPort() != (this._ssl ? 443 : 80)) {
            addressString = addressString + ":" + address.getPort();
        }
        this._hostHeader = new ByteArrayBuffer(addressString);
    }

    public Address getAddress() {
        return this._address;
    }

    public Buffer getHostHeader() {
        return this._hostHeader;
    }

    public HttpClient getHttpClient() {
        return this._client;
    }

    public boolean isSecure() {
        return this._ssl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getConnections() {
        HttpDestination httpDestination = this;
        synchronized (httpDestination) {
            return this._connections.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIdleConnections() {
        HttpDestination httpDestination = this;
        synchronized (httpDestination) {
            return this._idle.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAuthorization(String pathSpec, Authorization authorization) {
        HttpDestination httpDestination = this;
        synchronized (httpDestination) {
            if (this._authorizations == null) {
                this._authorizations = new PathMap();
            }
            this._authorizations.put((Object)pathSpec, (Object)authorization);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCookie(Cookie cookie) {
        HttpDestination httpDestination = this;
        synchronized (httpDestination) {
            if (this._cookies == null) {
                this._cookies = new ArrayList<Cookie>();
            }
            this._cookies.add(cookie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpConnection getConnection(long timeout) throws IOException {
        HttpConnection connection = null;
        while (connection == null && (connection = this.getIdleConnection()) == null && timeout > 0L) {
            int totalConnections = 0;
            boolean starting = false;
            HttpDestination httpDestination = this;
            synchronized (httpDestination) {
                totalConnections = this._connections.size() + this._pendingConnections;
                if (totalConnections < this._maxConnections) {
                    ++this._newConnection;
                    this.startNewConnection();
                    starting = true;
                }
            }
            if (!starting) {
                try {
                    Thread.currentThread();
                    Thread.sleep(200L);
                    timeout -= 200L;
                }
                catch (InterruptedException e) {
                    Log.ignore((Throwable)e);
                }
                continue;
            }
            try {
                Object o = this._newQueue.take();
                if (o instanceof HttpConnection) {
                    connection = (HttpConnection)o;
                    continue;
                }
                throw (IOException)o;
            }
            catch (InterruptedException e) {
                Log.ignore((Throwable)e);
            }
        }
        return connection;
    }

    public HttpConnection reserveConnection(long timeout) throws IOException {
        HttpConnection connection = this.getConnection(timeout);
        if (connection != null) {
            connection.setReserved(true);
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpConnection getIdleConnection() throws IOException {
        long now = this._client.getNow();
        long idleTimeout = this._client.getIdleTimeout();
        HttpConnection connection = null;
        do {
            HttpDestination httpDestination = this;
            synchronized (httpDestination) {
                if (connection != null) {
                    this._connections.remove(connection);
                    connection.close();
                    connection = null;
                }
                if (this._idle.size() > 0) {
                    connection = this._idle.remove(this._idle.size() - 1);
                }
            }
            if (connection != null) continue;
            return null;
        } while (!connection.cancelIdleTimeout());
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startNewConnection() {
        try {
            HttpDestination httpDestination = this;
            synchronized (httpDestination) {
                ++this._pendingConnections;
            }
            this._client._connector.startConnection(this);
        }
        catch (Exception e) {
            Log.debug((Throwable)e);
            this.onConnectionFailed(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onConnectionFailed(Throwable throwable) {
        Throwable connect_failure = null;
        HttpDestination httpDestination = this;
        synchronized (httpDestination) {
            --this._pendingConnections;
            if (this._newConnection > 0) {
                connect_failure = throwable;
                --this._newConnection;
            } else if (this._queue.size() > 0) {
                HttpExchange ex = this._queue.removeFirst();
                ex.setStatus(9);
                ex.getEventListener().onConnectionFailed(throwable);
            }
        }
        if (connect_failure != null) {
            try {
                this._newQueue.put(connect_failure);
            }
            catch (InterruptedException e) {
                Log.ignore((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onException(Throwable throwable) {
        HttpDestination httpDestination = this;
        synchronized (httpDestination) {
            --this._pendingConnections;
            if (this._queue.size() > 0) {
                HttpExchange ex = this._queue.removeFirst();
                ex.setStatus(9);
                ex.getEventListener().onException(throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNewConnection(HttpConnection connection) throws IOException {
        HttpConnection q_connection = null;
        HttpDestination httpDestination = this;
        synchronized (httpDestination) {
            --this._pendingConnections;
            this._connections.add(connection);
            if (this._newConnection > 0) {
                q_connection = connection;
                --this._newConnection;
            } else if (this._queue.size() == 0) {
                this._idle.add(connection);
            } else {
                HttpExchange ex = this._queue.removeFirst();
                connection.send(ex);
            }
        }
        if (q_connection != null) {
            try {
                this._newQueue.put(q_connection);
            }
            catch (InterruptedException e) {
                Log.ignore((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnConnection(HttpConnection connection, boolean close) throws IOException {
        if (connection.isReserved()) {
            connection.setReserved(false);
        }
        if (close) {
            try {
                connection.close();
            }
            catch (IOException e) {
                Log.ignore((Throwable)e);
            }
        }
        if (!this._client.isStarted()) {
            return;
        }
        if (!close && connection.getEndPoint().isOpen()) {
            HttpDestination httpDestination = this;
            synchronized (httpDestination) {
                if (this._queue.size() == 0) {
                    connection.setIdleTimeout(this._client.getNow() + this._client.getIdleTimeout());
                    this._idle.add(connection);
                } else {
                    HttpExchange ex = this._queue.removeFirst();
                    connection.send(ex);
                }
                this.notifyAll();
            }
        }
        HttpDestination httpDestination = this;
        synchronized (httpDestination) {
            this._connections.remove(connection);
            if (!this._queue.isEmpty()) {
                this.startNewConnection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnIdleConnection(HttpConnection connection) throws IOException {
        try {
            connection.close();
        }
        catch (IOException e) {
            Log.ignore((Throwable)e);
        }
        HttpDestination httpDestination = this;
        synchronized (httpDestination) {
            this._idle.remove(connection);
            this._connections.remove(connection);
            if (!this._queue.isEmpty() && this._client.isStarted()) {
                this.startNewConnection();
            }
        }
    }

    public void send(HttpExchange ex) throws IOException {
        LinkedList<String> listeners = this._client.getRegisteredListeners();
        if (listeners != null) {
            for (int i = listeners.size(); i > 0; --i) {
                String listenerClass = listeners.get(i - 1);
                try {
                    Class<?> listener = Class.forName(listenerClass);
                    Constructor<?> constructor = listener.getDeclaredConstructor(HttpDestination.class, HttpExchange.class);
                    HttpEventListener elistener = (HttpEventListener)constructor.newInstance(this, ex);
                    ex.setEventListener(elistener);
                    continue;
                }
                catch (Exception e) {
                    Log.debug((Throwable)e);
                    throw new IOException("Unable to instantiate registered listener for destination: " + listenerClass);
                }
            }
        }
        if (this._client.hasRealms()) {
            ex.setEventListener(new SecurityListener(this, ex));
        }
        this.doSend(ex);
    }

    public void resend(HttpExchange ex) throws IOException {
        ex.getEventListener().onRetry();
        ex.reset();
        this.doSend(ex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSend(HttpExchange ex) throws IOException {
        boolean sent;
        HttpConnection connection;
        Authorization auth;
        if (this._cookies != null) {
            StringBuilder buf = null;
            for (Cookie cookie : this._cookies) {
                if (buf == null) {
                    buf = new StringBuilder();
                } else {
                    buf.append("; ");
                }
                buf.append(cookie.getName());
                buf.append("=");
                buf.append(cookie.getValue());
            }
            if (buf != null) {
                ex.addRequestHeader("Cookie", buf.toString());
            }
        }
        if (this._authorizations != null && (auth = (Authorization)this._authorizations.match(ex.getURI())) != null) {
            auth.setCredentials(ex);
        }
        if ((connection = this.getIdleConnection()) != null && !(sent = connection.send(ex))) {
            connection = null;
        }
        if (connection == null) {
            HttpDestination httpDestination = this;
            synchronized (httpDestination) {
                this._queue.add(ex);
                if (this._connections.size() + this._pendingConnections < this._maxConnections) {
                    this.startNewConnection();
                }
            }
        }
    }

    public synchronized String toString() {
        return "HttpDestination@" + this.hashCode() + "//" + this._address.getHost() + ":" + this._address.getPort() + "(" + this._connections.size() + "," + this._idle.size() + "," + this._queue.size() + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String toDetailString() {
        StringBuilder b = new StringBuilder();
        b.append(this.toString());
        b.append('\n');
        HttpDestination httpDestination = this;
        synchronized (httpDestination) {
            for (HttpConnection connection : this._connections) {
                if (connection._exchange == null) continue;
                b.append(connection.toDetailString());
                if (this._idle.contains(connection)) {
                    b.append(" IDLE");
                }
                b.append('\n');
            }
        }
        b.append("--");
        b.append('\n');
        return b.toString();
    }

    public void setProxy(Address proxy) {
        this._proxy = proxy;
    }

    public Address getProxy() {
        return this._proxy;
    }

    public Authorization getProxyAuthentication() {
        return this._proxyAuthentication;
    }

    public void setProxyAuthentication(Authorization authentication) {
        this._proxyAuthentication = authentication;
    }

    public boolean isProxied() {
        return this._proxy != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        HttpDestination httpDestination = this;
        synchronized (httpDestination) {
            for (HttpConnection connection : this._connections) {
                connection.close();
            }
        }
    }
}

