/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.drda;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Properties;
import java.util.TimeZone;
import java.util.Vector;
import org.apache.derby.catalog.SystemProcedures;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.jdbc.AuthenticationService;
import org.apache.derby.iapi.jdbc.EngineLOB;
import org.apache.derby.iapi.jdbc.EnginePreparedStatement;
import org.apache.derby.iapi.jdbc.EngineResultSet;
import org.apache.derby.iapi.services.info.JVMInfo;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.stream.HeaderPrintWriter;
import org.apache.derby.iapi.tools.i18n.LocalizedResource;
import org.apache.derby.impl.drda.AppRequester;
import org.apache.derby.impl.drda.CcsidManager;
import org.apache.derby.impl.drda.CharacterEncodings;
import org.apache.derby.impl.drda.CodePoint;
import org.apache.derby.impl.drda.ConsistencyToken;
import org.apache.derby.impl.drda.DDMReader;
import org.apache.derby.impl.drda.DDMWriter;
import org.apache.derby.impl.drda.DRDAProtocolException;
import org.apache.derby.impl.drda.DRDAProtocolExceptionInfo;
import org.apache.derby.impl.drda.DRDAResultSet;
import org.apache.derby.impl.drda.DRDASocketTimeoutException;
import org.apache.derby.impl.drda.DRDAStatement;
import org.apache.derby.impl.drda.DRDAString;
import org.apache.derby.impl.drda.DRDAXAProtocol;
import org.apache.derby.impl.drda.Database;
import org.apache.derby.impl.drda.DecryptionManager;
import org.apache.derby.impl.drda.EXTDTAInputStream;
import org.apache.derby.impl.drda.EXTDTAReaderInputStream;
import org.apache.derby.impl.drda.FailingEXTDTAInputStream;
import org.apache.derby.impl.drda.FdocaConstants;
import org.apache.derby.impl.drda.NetworkServerControlImpl;
import org.apache.derby.impl.drda.PiggyBackedSessionData;
import org.apache.derby.impl.drda.Pkgnamcsn;
import org.apache.derby.impl.drda.SQLTypes;
import org.apache.derby.impl.drda.Session;
import org.apache.derby.impl.drda.SignedBinary;
import org.apache.derby.impl.drda.StandardEXTDTAReaderInputStream;
import org.apache.derby.impl.drda.XADatabase;
import org.apache.derby.impl.jdbc.EmbedSQLException;
import org.apache.derby.impl.jdbc.Util;
import org.apache.derby.jdbc.InternalDriver;

class DRDAConnThread
extends Thread {
    private static final String leftBrace = "{";
    private static final String rightBrace = "}";
    private static final byte NULL_VALUE = -1;
    private static final String SYNTAX_ERR = "42X01";
    private static final int MGRLVL_3 = 3;
    private static final int MGRLVL_4 = 4;
    private static final int MGRLVL_5 = 5;
    private static final int MGRLVL_6 = 6;
    private static final int MGRLVL_7 = 7;
    private static final int COMMIT = 1;
    private static final int ROLLBACK = 2;
    private int correlationID;
    private InputStream sockis;
    private OutputStream sockos;
    private DDMReader reader;
    private DDMWriter writer;
    private DRDAXAProtocol xaProto;
    private static int[] ACCRDB_REQUIRED = new int[]{8463, 8501, 4398, 47, 53};
    private static int MAX_REQUIRED_LEN = 5;
    private int currentRequiredLength = 0;
    private int[] required = new int[MAX_REQUIRED_LEN];
    private NetworkServerControlImpl server;
    private Session session;
    private long timeSlice;
    private Object timeSliceSync = new Object();
    private boolean logConnections;
    private boolean sendWarningsOnCNTQRY = false;
    private Object logConnectionsSync = new Object();
    private boolean close;
    private Object closeSync = new Object();
    private static HeaderPrintWriter logStream;
    private AppRequester appRequester;
    private Database database;
    private int sqlamLevel;
    private byte diagnosticLevel = (byte)-16;
    private Vector unknownManagers;
    private Vector knownManagers;
    private Vector errorManagers;
    private Vector errorManagersLevel;
    private SQLException databaseAccessException;
    private Pkgnamcsn prevPkgnamcsn = null;
    private DRDAString rdbnam = null;
    private DRDAString rdbcolid = null;
    private DRDAString pkgid = null;
    private DRDAString pkgcnstkn = null;
    private int pkgsn;
    private static final String TIMEOUT_STATEMENT = "SET STATEMENT_TIMEOUT ";
    private int pendingStatementTimeout;
    private static DecryptionManager decryptionManager;
    private byte[] myPublicKey;
    private byte[] myTargetSeed;
    private static final byte[] eod00000;
    private static final byte[] eod02000;
    private static final byte[] nullSQLState;
    private static final byte[] errD4_D6;
    private static final byte[] warn0_warnA;
    private static final String AUTHENTICATION_PROVIDER_BUILTIN_CLASS = "org.apache.derby.impl.jdbc.authentication.BasicAuthenticationServiceImpl";
    private static final String AUTHENTICATION_PROVIDER_NONE_CLASS = "org.apache.derby.impl.jdbc.authentication.NoneAuthenticationServiceImpl";
    private static final DRDAProtocolExceptionInfo dummy;
    private boolean deferredReset = false;
    private Calendar gmtCalendar;
    private static String SQLERRMC_TOKEN_DELIMITER;
    private static String SQLERRMC_PREFORMATTED_MESSAGE_DELIMITER;

    DRDAConnThread(Session session, NetworkServerControlImpl networkServerControlImpl, long l, boolean bl) {
        NetworkServerControlImpl.setUniqueThreadName(this, "DRDAConnThread");
        this.session = session;
        this.server = networkServerControlImpl;
        this.timeSlice = l;
        this.logConnections = bl;
        this.pendingStatementTimeout = -1;
        this.initialize();
    }

    public void run() {
        while (!this.closed()) {
            Session session = this.session;
            this.session = this.server.getNextSession(this.session);
            if (this.session == null) {
                this.close();
            }
            if (this.closed()) break;
            if (this.session != session) {
                this.initializeForSession();
            }
            try {
                long l = System.currentTimeMillis();
                switch (this.session.state) {
                    case 1: {
                        this.sessionInitialState();
                        if (this.session == null) break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        long l2;
                        do {
                            try {
                                this.processCommands();
                            }
                            catch (DRDASocketTimeoutException dRDASocketTimeoutException) {
                                // empty catch block
                            }
                        } while ((l2 = this.getTimeSlice()) <= 0L || System.currentTimeMillis() - l < l2);
                        break;
                    }
                    default: {
                        this.agentError("Session in invalid state:" + this.session.state);
                    }
                }
            }
            catch (Exception exception) {
                if (exception instanceof DRDAProtocolException && ((DRDAProtocolException)exception).isDisconnectException()) {
                    this.closeSession();
                    continue;
                }
                this.handleException(exception);
            }
        }
        this.server.removeThread(this);
    }

    protected InputStream getInputStream() {
        return this.sockis;
    }

    protected OutputStream getOutputStream() {
        return this.sockos;
    }

    protected DDMReader getReader() {
        return this.reader;
    }

    protected DDMWriter getWriter() {
        return this.writer;
    }

    protected int getCorrelationID() {
        return this.correlationID;
    }

    protected Session getSession() {
        return this.session;
    }

    protected Database getDatabase() {
        return this.database;
    }

    protected NetworkServerControlImpl getServer() {
        return this.server;
    }

    protected byte[] getCrrtkn() {
        if (this.database != null) {
            return this.database.crrtkn;
        }
        return null;
    }

    protected String getDbName() {
        if (this.database != null) {
            return this.database.getDatabaseName();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close() {
        Object object = this.closeSync;
        synchronized (object) {
            this.close = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setLogConnections(boolean bl) {
        Object object = this.logConnectionsSync;
        synchronized (object) {
            this.logConnections = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setTimeSlice(long l) {
        Object object = this.timeSliceSync;
        synchronized (object) {
            this.timeSlice = l;
        }
    }

    protected void markCommunicationsFailure(String string, String string2, String string3, String string4) throws DRDAProtocolException {
        this.markCommunicationsFailure(null, string, string2, string3, string4);
    }

    protected void markCommunicationsFailure(Exception exception, String string, String string2, String string3, String string4) throws DRDAProtocolException {
        String string5 = null;
        if (this.database != null) {
            string5 = this.database.getDatabaseName();
        }
        if (exception != null) {
            DRDAConnThread.println2Log(string5, this.session.drdaID, exception.getMessage());
            this.server.consoleExceptionPrintTrace(exception);
        }
        Object[] objectArray = new Object[]{string, string2, string3, string4};
        throw DRDAProtocolException.newDisconnectException(this, objectArray);
    }

    protected void throwSyntaxrm(int n, int n2) throws DRDAProtocolException {
        throw new DRDAProtocolException(DRDAProtocolException.DRDA_Proto_SYNTAXRM, this, n2, n);
    }

    protected void agentError(String string) throws DRDAProtocolException {
        String string2 = null;
        if (this.database != null) {
            string2 = this.database.getDatabaseName();
        }
        throw DRDAProtocolException.newAgentError(this, 64, string2, string);
    }

    protected void missingCodePoint(int n) throws DRDAProtocolException {
        this.throwSyntaxrm(14, n);
    }

    protected static void println2Log(String string, String string2, String string3) {
        int n;
        if (logStream == null) {
            logStream = Monitor.getStream();
        }
        if (string != null && (n = string.indexOf(59)) != -1) {
            string = string.substring(0, n);
        }
        logStream.printlnWithHeader("(DATABASE = " + string + "), (DRDAID = " + string2 + "), " + string3);
    }

    protected void writeRDBNAM(String string) throws DRDAProtocolException {
        CcsidManager ccsidManager = this.writer.getCurrentCcsidManager();
        int n = ccsidManager.getByteLength(string);
        if (n < 18) {
            n = 18;
        }
        this.writer.writeScalarPaddedString(8464, string, n);
    }

    private void initialize() {
        this.sockis = this.session.sessionInput;
        this.sockos = this.session.sessionOutput;
        this.reader = new DDMReader(this, this.session.dssTrace);
        this.writer = new DDMWriter(this, this.session.dssTrace);
        this.rdbnam = new DRDAString(this.writer);
        this.rdbcolid = new DRDAString(this.writer);
        this.pkgid = new DRDAString(this.writer);
        this.pkgcnstkn = new DRDAString(this.writer);
    }

    private void initializeForSession() {
        this.sockis = this.session.sessionInput;
        this.sockos = this.session.sessionOutput;
        this.reader.initialize(this, this.session.dssTrace);
        this.writer.reset(this.session.dssTrace);
        this.database = this.session.database;
        this.appRequester = this.session.appRequester;
        if (this.session.state == 2) {
            this.sqlamLevel = this.appRequester.getManagerLevel(9223);
        }
        this.reader.setEbcdicCcsid();
        this.writer.setEbcdicCcsid();
    }

    private void sessionInitialState() throws Exception {
        if (this.reader.isCmd()) {
            try {
                this.server.processCommands(this.reader, this.writer, this.session);
                this.reader.initialize(this, null);
                this.writer.reset(null);
                this.closeSession();
            }
            catch (Throwable throwable) {
                if (throwable instanceof InterruptedException) {
                    throw (InterruptedException)throwable;
                }
                this.server.consoleExceptionPrintTrace(throwable);
            }
        } else {
            this.exchangeServerAttributes();
        }
    }

    private void cleanUpAndCloseResultSet(DRDAStatement dRDAStatement, SQLException sQLException, int n) throws DRDAProtocolException {
        if (dRDAStatement != null) {
            this.writer.clearDSSesBackToMark(n);
            if (!dRDAStatement.rsIsClosed()) {
                try {
                    dRDAStatement.rsClose();
                }
                catch (SQLException sQLException2) {
                    // empty catch block
                }
                this.writeABNUOWRM();
                this.writeSQLCARD(sQLException, 8, 0, 0L);
            }
        } else {
            this.writeSQLCARDs(sQLException, 0);
        }
        this.errorInChain(sQLException);
    }

    private void processCommands() throws DRDAProtocolException {
        DRDAStatement dRDAStatement = null;
        int n = 0;
        boolean bl = false;
        boolean bl2 = this.session.requiresSecurityCodepoint();
        do {
            this.correlationID = this.reader.readDssHeader();
            int n2 = this.reader.readLengthAndCodePoint(false);
            int n3 = this.writer.markDSSClearPoint();
            if (bl2) {
                this.verifyInOrderACCSEC_SECCHK(n2, this.session.getRequiredSecurityCodepoint());
            }
            switch (n2) {
                case 8198: {
                    try {
                        dRDAStatement = this.parseCNTQRY();
                        if (dRDAStatement == null) break;
                        this.writeQRYDTA(dRDAStatement);
                        if (dRDAStatement.rsIsClosed()) {
                            this.writeENDQRYRM(4);
                            this.writeNullSQLCARDobject();
                        }
                        this.checkWarning(null, null, dRDAStatement.getResultSet(), 0, false, this.sendWarningsOnCNTQRY);
                        this.writePBSD();
                    }
                    catch (SQLException sQLException) {
                        this.cleanUpAndCloseResultSet(dRDAStatement, sQLException, n3);
                    }
                    break;
                }
                case 8202: {
                    try {
                        n = this.parseEXCSQLIMM();
                        if (!this.database.RDBUPDRM_sent) {
                            this.writeRDBUPDRM();
                        }
                        this.checkWarning(null, this.database.getDefaultStatement().getStatement(), null, n, true, true);
                        this.writePBSD();
                    }
                    catch (SQLException sQLException) {
                        this.writer.clearDSSesBackToMark(n3);
                        this.writeSQLCARDs(sQLException, 0);
                        this.errorInChain(sQLException);
                    }
                    break;
                }
                case 8212: {
                    try {
                        if (!this.parseEXCSQLSET()) break;
                        this.writeSQLCARDs(null, 0);
                    }
                    catch (SQLWarning sQLWarning) {
                        this.writeSQLCARD(sQLWarning, 4, 0, 0L);
                    }
                    catch (SQLException sQLException) {
                        this.writer.clearDSSesBackToMark(n3);
                        this.writeSQLCARDs(sQLException, 0);
                        this.errorInChain(sQLException);
                    }
                    break;
                }
                case 8205: {
                    bl = false;
                    try {
                        this.database.getConnection().clearWarnings();
                        int n4 = this.parsePRPSQLSTT();
                        if (n4 > 0) {
                            this.writeSQLDARD(this.database.getCurrentStatement(), n4 == 2, this.database.getConnection().getWarnings());
                            break;
                        }
                        this.checkWarning(this.database.getConnection(), null, null, 0, true, true);
                    }
                    catch (SQLException sQLException) {
                        this.writer.clearDSSesBackToMark(n3);
                        this.writeSQLCARDs(sQLException, 0, true);
                        bl = true;
                        this.errorInChain(sQLException);
                    }
                    break;
                }
                case 8204: {
                    PreparedStatement preparedStatement = null;
                    try {
                        if (bl) {
                            this.skipRemainder(true);
                            this.writeOPNQFLRM(null);
                            break;
                        }
                        Pkgnamcsn pkgnamcsn = this.parseOPNQRY();
                        if (pkgnamcsn != null) {
                            dRDAStatement = this.database.getDRDAStatement(pkgnamcsn);
                            preparedStatement = dRDAStatement.getPreparedStatement();
                            preparedStatement.clearWarnings();
                            if (this.pendingStatementTimeout >= 0) {
                                preparedStatement.setQueryTimeout(this.pendingStatementTimeout);
                                this.pendingStatementTimeout = -1;
                            }
                            dRDAStatement.execute();
                            this.writeOPNQRYRM(false, dRDAStatement);
                            this.checkWarning(null, preparedStatement, null, 0, false, true);
                            this.writeQRYDSC(dRDAStatement, false);
                            dRDAStatement.rsSuspend();
                            if (dRDAStatement.getQryprctyp() == 9239 && dRDAStatement.getQryrowset() != 0) {
                                DRDAResultSet dRDAResultSet = dRDAStatement.getCurrentDrdaResultSet();
                                try {
                                    if (dRDAResultSet != null && !dRDAResultSet.hasLobColumns()) {
                                        this.writeQRYDTA(dRDAStatement);
                                    }
                                }
                                catch (SQLException sQLException) {
                                    this.cleanUpAndCloseResultSet(dRDAStatement, sQLException, n3);
                                }
                            }
                        }
                        this.writePBSD();
                    }
                    catch (SQLException sQLException) {
                        this.writer.clearDSSesBackToMark(n3);
                        this.writeOPNQFLRM(sQLException);
                    }
                    break;
                }
                case 8206: {
                    try {
                        if (!this.database.getConnection().getAutoCommit()) {
                            this.database.getConnection().clearWarnings();
                            this.database.commit();
                            this.writeENDUOWRM(1);
                            this.checkWarning(this.database.getConnection(), null, null, 0, true, true);
                        }
                        this.database.RDBUPDRM_sent = false;
                    }
                    catch (SQLException sQLException) {
                        this.writer.clearDSSesBackToMark(n3);
                        this.writeENDUOWRM(1);
                        this.writeSQLCARDs(sQLException, 0);
                        this.errorInChain(sQLException);
                    }
                    break;
                }
                case 8207: {
                    try {
                        this.database.getConnection().clearWarnings();
                        this.database.rollback();
                        this.writeENDUOWRM(2);
                        this.checkWarning(this.database.getConnection(), null, null, 0, true, true);
                        this.database.RDBUPDRM_sent = false;
                    }
                    catch (SQLException sQLException) {
                        this.writer.clearDSSesBackToMark(n3);
                        this.writeENDUOWRM(2);
                        this.writeSQLCARDs(sQLException, 0);
                        this.errorInChain(sQLException);
                    }
                    break;
                }
                case 8197: {
                    try {
                        dRDAStatement = this.parseCLSQRY();
                        dRDAStatement.rsClose();
                        this.writeSQLCARDs(null, 0);
                    }
                    catch (SQLException sQLException) {
                        this.writer.clearDSSesBackToMark(n3);
                        this.writeSQLCARDs(sQLException, 0);
                        this.errorInChain(sQLException);
                    }
                    break;
                }
                case 4161: {
                    this.parseEXCSAT();
                    this.writeEXCSATRD();
                    break;
                }
                case 4205: {
                    int n5 = this.parseACCSEC();
                    this.writeACCSECRD(n5);
                    if (this.appRequester.supportsUtf8Ccsid()) {
                        this.switchToUtf8();
                    } else {
                        this.switchToEbcdic();
                    }
                    bl2 = true;
                    break;
                }
                case 4206: {
                    if (!this.parseDRDAConnection()) break;
                    bl2 = false;
                    break;
                }
                case 8194: {
                    this.reader.skipBytes();
                    this.writeSQLCARDs(null, 0);
                    break;
                }
                case 8196: {
                    this.reader.skipBytes();
                    this.parseSQLSTTDss();
                    this.writeSQLCARDs(null, 0);
                    break;
                }
                case 9241: {
                    this.reader.skipBytes();
                    break;
                }
                case 8201: {
                    this.reader.skipBytes();
                    this.writeSQLCARDs(null, 0);
                    break;
                }
                case 8200: {
                    if (bl) {
                        this.reader.skipBytes();
                        this.writeSQLCARDs(null, 0);
                        break;
                    }
                    try {
                        boolean bl3 = this.parseDSCSQLSTT();
                        this.writeSQLDARD(this.database.getCurrentStatement(), bl3, null);
                    }
                    catch (SQLException sQLException) {
                        this.writer.clearDSSesBackToMark(n3);
                        this.server.consoleExceptionPrint(sQLException);
                        try {
                            this.writeSQLDARD(this.database.getCurrentStatement(), true, sQLException);
                        }
                        catch (SQLException sQLException2) {
                            this.agentError("Why am I getting another SQLException?");
                        }
                        this.errorInChain(sQLException);
                    }
                    break;
                }
                case 8203: {
                    if (bl) {
                        this.skipRemainder(true);
                        this.writeSQLCARDs(null, 0);
                        break;
                    }
                    try {
                        this.parseEXCSQLSTT();
                        DRDAStatement dRDAStatement2 = this.database.getCurrentStatement();
                        if (dRDAStatement2 != null) {
                            dRDAStatement2.rsSuspend();
                        }
                        this.writePBSD();
                    }
                    catch (SQLException sQLException) {
                        this.skipRemainder(true);
                        this.writer.clearDSSesBackToMark(n3);
                        this.writeSQLCARDs(sQLException, 0);
                        this.errorInChain(sQLException);
                    }
                    break;
                }
                case 4181: {
                    if (this.xaProto == null) {
                        this.xaProto = new DRDAXAProtocol(this);
                    }
                    this.xaProto.parseSYNCCTL();
                    try {
                        this.writePBSD();
                    }
                    catch (SQLException sQLException) {
                        this.server.consoleExceptionPrint(sQLException);
                        this.errorInChain(sQLException);
                    }
                    break;
                }
                default: {
                    this.codePointNotSupported(n2);
                }
            }
            this.finalizeChain();
        } while (this.reader.isChainedWithSameID() || this.reader.isChainedWithDiffID());
    }

    private void errorInChain(SQLException sQLException) throws DRDAProtocolException {
        if (this.reader.terminateChainOnErr() && this.getExceptionSeverity(sQLException) > 8) {
            this.skipRemainder(false);
        }
    }

    private void exchangeServerAttributes() throws DRDAProtocolException {
        this.correlationID = this.reader.readDssHeader();
        int n = this.reader.readLengthAndCodePoint(false);
        if (n != 4161) {
            throw new DRDAProtocolException(DRDAProtocolException.DRDA_Proto_PRCCNVRM, this, n, 6);
        }
        this.parseEXCSAT();
        this.writeEXCSATRD();
        this.finalizeChain();
        this.session.setState(2);
    }

    private boolean parseDRDAConnection() throws DRDAProtocolException {
        boolean bl = true;
        int n = this.parseSECCHK();
        this.writeSECCHKRM(n);
        if (n != 0) {
            return false;
        }
        this.correlationID = this.reader.readDssHeader();
        int n2 = this.reader.readLengthAndCodePoint(false);
        this.verifyRequiredObject(n2, 8193);
        int n3 = this.parseACCRDB();
        if (this.database.getConnection() == null && this.databaseAccessException == null) {
            this.writeRDBfailure(8730);
            return false;
        }
        if (this.databaseAccessException != null) {
            int n4 = this.getRdbAccessErrorCodePoint();
            if (n4 == 8721 || n4 == 8907) {
                this.writeRDBfailure(n4);
            } else {
                this.writeRDBfailure(8730);
            }
            return false;
        }
        if (this.database.accessCount > 1) {
            this.writeRDBfailure(8711);
            return false;
        }
        this.writeACCRDBRM(n3);
        this.session.appRequester = this.server.getAppRequester(this.appRequester);
        return bl;
    }

    private void switchToUtf8() {
        this.writer.setUtf8Ccsid();
        this.reader.setUtf8Ccsid();
    }

    private void switchToEbcdic() {
        this.writer.setEbcdicCcsid();
        this.reader.setEbcdicCcsid();
    }

    private void writeRDBfailure(int n) throws DRDAProtocolException {
        this.writer.createDssReply();
        this.writer.startDdm(n);
        this.writer.writeScalar2Bytes(4425, 8);
        this.writeRDBNAM(this.database.getDatabaseName());
        this.writer.endDdmAndDss();
        switch (n) {
            case 8730: {
                this.writer.createDssObject();
                this.writer.writeScalarString(47, "QTDSQLASC");
                this.writeTYPDEFOVR();
                this.writer.endDss();
            }
            case 8721: 
            case 8907: {
                this.writeSQLCARD(this.databaseAccessException, 8, 0, 0L);
            }
            case 8711: {
                this.skipRemainder(false);
                this.finalizeChain();
            }
        }
    }

    private int getRdbAccessErrorCodePoint() {
        String string = this.databaseAccessException.getSQLState();
        if (string.regionMatches(0, "XJ004.C", 0, 5)) {
            return 8721;
        }
        if (this.isAuthenticationException(this.databaseAccessException) || string.regionMatches(0, "28502", 0, 5)) {
            return 8907;
        }
        return 8730;
    }

    private boolean isAuthenticationException(SQLException sQLException) {
        boolean bl = false;
        SQLException sQLException2 = Util.getExceptionFactory().getArgumentFerry(sQLException);
        if (sQLException2 instanceof EmbedSQLException) {
            String string = ((EmbedSQLException)sQLException2).getMessageId();
            if (string.equals("08004.C.1")) {
                bl = true;
            }
        } else {
            String string = sQLException2.getSQLState();
            if (string.regionMatches(0, "08004", 0, 5)) {
                bl = true;
            }
        }
        return bl;
    }

    private int verifyUserIdPassword() throws DRDAProtocolException {
        this.databaseAccessException = null;
        int n = 0;
        String string = this.database.getDatabaseName();
        int n2 = string.indexOf(59);
        if (n2 != -1) {
            string = string.substring(0, n2);
        }
        n = this.getConnFromDatabaseName();
        return n;
    }

    private int getConnFromDatabaseName() throws DRDAProtocolException {
        Properties properties = new Properties();
        this.databaseAccessException = null;
        if (this.session.drdaID == null) {
            this.session.drdaID = leftBrace + this.session.connNum + rightBrace;
        }
        properties.put("drdaID", this.session.drdaID);
        if (this.database.securityMechanism == 8 && this.database.getDatabaseName().indexOf("password") == -1) {
            properties.put("drdaSecMec", String.valueOf(this.database.securityMechanism));
            properties.put("drdaSecTokenIn", DecryptionManager.toHexString(this.database.secTokenIn, 0, this.database.secTokenIn.length));
            properties.put("drdaSecTokenOut", DecryptionManager.toHexString(this.database.secTokenOut, 0, this.database.secTokenOut.length));
        }
        try {
            this.database.makeConnection(properties);
        }
        catch (SQLException sQLException) {
            SQLException sQLException2;
            String string = sQLException.getSQLState();
            this.databaseAccessException = sQLException;
            while (sQLException2 != null) {
                DRDAConnThread.println2Log(this.database.getDatabaseName(), this.session.drdaID, sQLException2.getMessage());
                sQLException2 = sQLException2.getNextException();
            }
            if (this.isAuthenticationException(this.databaseAccessException)) {
                return 19;
            }
            return 0;
        }
        catch (Exception exception) {
            DRDAConnThread.println2Log(this.database.getDatabaseName(), this.session.drdaID, "Driver not loaded" + exception.getMessage());
            try {
                this.agentError("Driver not loaded");
            }
            catch (DRDAProtocolException dRDAProtocolException) {
                try {
                    this.server.startNetworkServer();
                }
                catch (Exception exception2) {
                    DRDAConnThread.println2Log(this.database.getDatabaseName(), this.session.drdaID, "Failed attempt to reload driver " + exception2.getMessage());
                }
                throw dRDAProtocolException;
            }
        }
        if (this.getLogConnections()) {
            DRDAConnThread.println2Log(this.database.getDatabaseName(), this.session.drdaID, "Apache Derby Network Server connected to database " + this.database.getDatabaseName());
        }
        return 0;
    }

    private void parseEXCSAT() throws DRDAProtocolException {
        this.deferredReset = false;
        if (this.appRequester != null) {
            if (!this.appRequester.isXARequester()) {
                this.deferredReset = true;
            }
            this.parseEXCSAT2();
            return;
        }
        this.appRequester = new AppRequester();
        this.reader.markCollection();
        int n = this.reader.getCodePoint();
        while (n != -1) {
            switch (n) {
                case 4446: {
                    this.appRequester.extnam = this.reader.readString();
                    if (this.appRequester.extnam.length() <= 255) break;
                    this.tooBig(4446);
                    break;
                }
                case 5124: {
                    this.parseMGRLVLLS(1);
                    break;
                }
                case 4445: {
                    this.appRequester.spvnam = this.reader.readString();
                    if (this.appRequester.spvnam == null) break;
                    this.badObjectLength(4445);
                    break;
                }
                case 4461: {
                    this.appRequester.srvnam = this.reader.readString();
                    if (this.appRequester.srvnam.length() <= 255) break;
                    this.tooBig(4461);
                    break;
                }
                case 4442: {
                    this.appRequester.srvrlslv = this.reader.readString();
                    if (this.appRequester.srvrlslv.length() <= 255) break;
                    this.tooBig(4442);
                    break;
                }
                case 4423: {
                    this.appRequester.srvclsnm = this.reader.readString();
                    if (this.appRequester.srvclsnm.length() <= 255) break;
                    this.tooBig(4423);
                    break;
                }
                default: {
                    this.invalidCodePoint(n);
                }
            }
            n = this.reader.getCodePoint();
        }
    }

    private void parseEXCSAT2() throws DRDAProtocolException {
        this.reader.markCollection();
        int n = this.reader.getCodePoint();
        while (n != -1) {
            switch (n) {
                case 4423: 
                case 4442: 
                case 4445: 
                case 4446: 
                case 4461: {
                    this.reader.skipBytes();
                    break;
                }
                case 5124: {
                    this.parseMGRLVLLS(2);
                    break;
                }
                default: {
                    this.invalidCodePoint(n);
                }
            }
            n = this.reader.getCodePoint();
        }
    }

    private void parseMGRLVLLS(int n) throws DRDAProtocolException {
        this.unknownManagers = new Vector();
        this.knownManagers = new Vector();
        this.errorManagers = new Vector();
        this.errorManagersLevel = new Vector();
        while (this.reader.moreDdmData()) {
            int n2 = this.reader.readNetworkShort();
            int n3 = this.reader.readNetworkShort();
            if (CodePoint.isKnownManager(n2)) {
                this.knownManagers.addElement(new Integer(n2));
                int n4 = this.appRequester.getManagerLevel(n2);
                if (n4 == -1) {
                    this.appRequester.setManagerLevel(n2, n3);
                    continue;
                }
                if (n4 == n3) continue;
                this.errorManagers.addElement(new Integer(n2));
                this.errorManagersLevel.addElement(new Integer(n3));
                continue;
            }
            this.unknownManagers.addElement(new Integer(n2));
        }
        this.sqlamLevel = this.appRequester.getManagerLevel(9223);
        if (this.errorManagers.size() > 0) {
            Object[] objectArray = new Object[this.errorManagers.size() * 2];
            int n5 = 0;
            for (int i = 0; i < this.errorManagers.size(); ++i) {
                objectArray[n5++] = this.errorManagers.elementAt(i);
                objectArray[n5++] = this.errorManagersLevel.elementAt(i);
            }
            throw new DRDAProtocolException(DRDAProtocolException.DRDA_Proto_MGRLVLRM, this, 0, 0, objectArray);
        }
    }

    private void writeEXCSATRD() throws DRDAProtocolException {
        this.writer.createDssReply();
        this.writer.startDdm(5187);
        this.writer.writeScalarString(4446, NetworkServerControlImpl.att_extnam);
        if (this.knownManagers != null && this.knownManagers.size() > 0) {
            this.writeMGRLEVELS();
        }
        this.writer.writeScalarString(4423, NetworkServerControlImpl.att_srvclsnm);
        this.writer.writeScalarString(4461, "NetworkServerControl");
        this.writer.writeScalarString(4442, NetworkServerControlImpl.att_srvrlslv);
        this.writer.endDdmAndDss();
    }

    private void writeMGRLEVELS() throws DRDAProtocolException {
        int n;
        int n2;
        this.writer.startDdm(5124);
        for (n2 = 0; n2 < this.knownManagers.size(); ++n2) {
            n = (Integer)this.knownManagers.elementAt(n2);
            int n3 = this.appRequester.getManagerLevel(n);
            int n4 = this.server.getManagerLevel(n);
            if (n4 >= n3) {
                this.writer.writeCodePoint4Bytes(n, n3);
                continue;
            }
            this.writer.writeCodePoint4Bytes(n, n4);
            this.appRequester.setManagerLevel(n, n4);
        }
        for (n2 = 0; n2 < this.unknownManagers.size(); ++n2) {
            n = (Integer)this.unknownManagers.elementAt(n2);
            this.writer.writeCodePoint4Bytes(n, 0);
        }
        this.writer.endDdm();
    }

    private int parseACCSEC() throws DRDAProtocolException {
        int n = 0;
        int n2 = 0;
        byte[] byArray = null;
        this.reader.markCollection();
        int n3 = this.reader.getCodePoint();
        while (n3 != -1) {
            switch (n3) {
                case 4502: {
                    if (this.reader.getDdmLength() == 0L) break;
                    this.badObjectLength(4502);
                    break;
                }
                case 4514: {
                    this.checkLength(4514, 2);
                    n2 = this.reader.readNetworkShort();
                    if (this.server.getSecurityMechanism() != -1 && n2 != this.server.getSecurityMechanism()) {
                        n = 1;
                        break;
                    }
                    if (n2 == 3 || n2 == 4) break;
                    if ((n2 != 9 || n2 == 9 && !this.server.supportsEUSRIDPWD()) && n2 != 8) {
                        n = 1;
                        break;
                    }
                    if (n2 == 8) break;
                    try {
                        if (decryptionManager == null) {
                            decryptionManager = new DecryptionManager();
                        }
                        this.myPublicKey = decryptionManager.obtainPublicKey();
                    }
                    catch (SQLException sQLException) {
                        DRDAConnThread.println2Log(null, this.session.drdaID, sQLException.getMessage());
                        n = 10;
                    }
                    break;
                }
                case 8464: {
                    String string = this.parseRDBNAM();
                    Database database = this.session.getDatabase(string);
                    if (database == null) {
                        this.initializeDatabase(string);
                        break;
                    }
                    if (!this.deferredReset) {
                        database.reset();
                    }
                    this.database = database;
                    break;
                }
                case 4572: {
                    byArray = this.reader.readBytes();
                    break;
                }
                default: {
                    this.invalidCodePoint(n3);
                }
            }
            n3 = this.reader.getCodePoint();
        }
        if (n2 == 0) {
            this.missingCodePoint(4514);
        }
        if (this.database == null) {
            this.initializeDatabase(null);
        }
        this.database.securityMechanism = n2;
        this.database.secTokenIn = byArray;
        if (n == 0 && this.database.securityMechanism == 8) {
            n = this.validateSecMecUSRSSBPWD();
        }
        if (n == 0 && (this.database.securityMechanism == 9 || this.database.securityMechanism == 8) && this.database.secTokenIn == null) {
            n = 14;
        }
        if (n == 0 && (this.database.securityMechanism == 3 || this.database.securityMechanism == 4) && this.database.secTokenIn != null) {
            n = 14;
        }
        if (n == 0) {
            this.session.setState(3);
        } else {
            this.session.setState(2);
        }
        return n;
    }

    private Pkgnamcsn parseOPNQRY() throws DRDAProtocolException, SQLException {
        DRDAStatement dRDAStatement;
        Pkgnamcsn pkgnamcsn = null;
        boolean bl = false;
        int n = 0;
        int n2 = 9239;
        int n3 = 0;
        int n4 = -1;
        int n5 = 2;
        int n6 = 1;
        this.reader.markCollection();
        int n7 = this.reader.getCodePoint();
        while (n7 != -1) {
            switch (n7) {
                case 8464: {
                    this.setDatabase(8204);
                    break;
                }
                case 8467: {
                    pkgnamcsn = this.parsePKGNAMCSN();
                    break;
                }
                case 8468: {
                    n = this.parseQRYBLKSZ();
                    bl = true;
                    break;
                }
                case 8498: {
                    n2 = this.reader.readNetworkShort();
                    if (n2 != 9232) {
                        this.invalidCodePoint(n2);
                    }
                    bl = true;
                    break;
                }
                case 8513: {
                    n3 = this.reader.readSignedNetworkShort();
                    break;
                }
                case 8519: {
                    n6 = this.parseOUTOVROPT();
                    break;
                }
                case 8534: {
                    n4 = this.parseQRYROWSET(0);
                    break;
                }
                case 8541: {
                    n5 = this.parseQRYCLSIMP();
                    break;
                }
                case 8542: {
                    this.parseQRYCLSRLS();
                    break;
                }
                case 6400: {
                    this.parseMONITOR();
                    break;
                }
                default: {
                    this.invalidCodePoint(n7);
                }
            }
            n7 = this.reader.getCodePoint();
        }
        if (pkgnamcsn == null) {
            this.missingCodePoint(8467);
        }
        if (!bl) {
            this.missingCodePoint(8468);
        }
        if ((dRDAStatement = this.database.getDRDAStatement(pkgnamcsn)) == null) {
            this.invalidValue(8467);
        }
        dRDAStatement.setOPNQRYOptions(n, n2, n3, n6, n4, n5);
        if (this.reader.isChainedWithSameID()) {
            this.parseOPNQRYobjects(dRDAStatement);
        }
        return pkgnamcsn;
    }

    private void parseOPNQRYobjects(DRDAStatement dRDAStatement) throws DRDAProtocolException, SQLException {
        do {
            this.correlationID = this.reader.readDssHeader();
            block7: while (this.reader.moreDssData()) {
                int n = this.reader.readLengthAndCodePoint(false);
                switch (n) {
                    case 47: {
                        this.setStmtOrDbByteOrder(false, dRDAStatement, this.parseTYPDEFNAM());
                        continue block7;
                    }
                    case 53: {
                        this.parseTYPDEFOVR(dRDAStatement);
                        continue block7;
                    }
                    case 9234: {
                        this.parseSQLDTA(dRDAStatement);
                        continue block7;
                    }
                    case 5228: {
                        this.readAndSetAllExtParams(dRDAStatement, false);
                        continue block7;
                    }
                }
                this.invalidCodePoint(n);
            }
        } while (this.reader.isChainedWithSameID());
    }

    private int parseOUTOVROPT() throws DRDAProtocolException {
        this.checkLength(8519, 1);
        int n = this.reader.readUnsignedByte();
        if (n != 1 && n != 2) {
            this.invalidValue(8519);
        }
        return n;
    }

    private int parseQRYBLKSZ() throws DRDAProtocolException {
        this.checkLength(8468, 4);
        int n = this.reader.readNetworkInt();
        if (n < 512 || n > 0xA00000) {
            this.invalidValue(8468);
        }
        return n;
    }

    private int parseQRYROWSET(int n) throws DRDAProtocolException {
        this.checkLength(8534, 4);
        int n2 = this.reader.readNetworkInt();
        if (n2 < n || n2 > Short.MAX_VALUE) {
            this.invalidValue(8534);
        }
        return n2;
    }

    private int parseQRYCLSIMP() throws DRDAProtocolException {
        this.checkLength(8541, 1);
        int n = this.reader.readUnsignedByte();
        if (n != 0 && n != 1 && n != 2) {
            this.invalidValue(8541);
        }
        return n;
    }

    private int parseQRYCLSRLS() throws DRDAProtocolException {
        this.reader.skipBytes();
        return 0;
    }

    private void writeQRYPOPRM() throws DRDAProtocolException {
        this.writer.createDssReply();
        this.writer.startDdm(8719);
        this.writer.writeScalar2Bytes(4425, 8);
        this.writeRDBNAM(this.database.getDatabaseName());
        this.writePKGNAMCSN();
        this.writer.endDdmAndDss();
    }

    private void writeQRYNOPRM(int n) throws DRDAProtocolException {
        this.writer.createDssReply();
        this.writer.startDdm(8706);
        this.writer.writeScalar2Bytes(4425, n);
        this.writeRDBNAM(this.database.getDatabaseName());
        this.writePKGNAMCSN();
        this.writer.endDdmAndDss();
    }

    private void writeOPNQFLRM(SQLException sQLException) throws DRDAProtocolException {
        this.writer.createDssReply();
        this.writer.startDdm(8722);
        this.writer.writeScalar2Bytes(4425, 8);
        this.writeRDBNAM(this.database.getDatabaseName());
        this.writer.endDdm();
        this.writer.startDdm(9224);
        this.writeSQLCAGRP(sQLException, this.getSqlCode(this.getExceptionSeverity(sQLException)), 0, 0L);
        this.writer.endDdmAndDss();
    }

    private void writePKGNAMCSN(byte[] byArray) throws DRDAProtocolException {
        this.writer.startDdm(8467);
        if (this.rdbnam.length() <= 18 && this.rdbcolid.length() <= 18 && this.pkgid.length() <= 18) {
            this.writer.writeScalarPaddedString(this.rdbnam, 18);
            this.writer.writeScalarPaddedString(this.rdbcolid, 18);
            this.writer.writeScalarPaddedString(this.pkgid, 18);
            this.writer.writeScalarPaddedBytes(byArray, 8, (byte)0);
            this.writer.writeShort(this.pkgsn);
        } else {
            int n = Math.max(18, this.rdbnam.length());
            this.writer.writeShort(n);
            this.writer.writeScalarPaddedString(this.rdbnam, n);
            n = Math.max(18, this.rdbcolid.length());
            this.writer.writeShort(n);
            this.writer.writeScalarPaddedString(this.rdbcolid, n);
            n = Math.max(18, this.pkgid.length());
            this.writer.writeShort(n);
            this.writer.writeScalarPaddedString(this.pkgid, n);
            this.writer.writeScalarPaddedBytes(byArray, 8, (byte)0);
            this.writer.writeShort(this.pkgsn);
        }
        this.writer.endDdm();
    }

    private void writePKGNAMCSN() throws DRDAProtocolException {
        this.writePKGNAMCSN(this.pkgcnstkn.getBytes());
    }

    private DRDAStatement parseCNTQRY() throws DRDAProtocolException, SQLException {
        DRDAStatement dRDAStatement;
        Pkgnamcsn pkgnamcsn = null;
        boolean bl = false;
        boolean bl2 = true;
        long l = 1L;
        boolean bl3 = false;
        int n = 1;
        int n2 = 0;
        int n3 = -1;
        boolean bl4 = false;
        int n4 = 1;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = true;
        int n5 = -1;
        int n6 = 1;
        this.reader.markCollection();
        int n7 = this.reader.getCodePoint();
        while (n7 != -1) {
            block0 : switch (n7) {
                case 8464: {
                    this.setDatabase(8198);
                    break;
                }
                case 8467: {
                    pkgnamcsn = this.parsePKGNAMCSN();
                    break;
                }
                case 8468: {
                    n2 = this.parseQRYBLKSZ();
                    bl = true;
                    break;
                }
                case 8508: {
                    bl2 = this.readBoolean(8508);
                    break;
                }
                case 8530: {
                    this.checkLength(8530, 1);
                    n4 = this.reader.readUnsignedByte();
                    switch (n4) {
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: {
                            break block0;
                        }
                    }
                    this.invalidValue(8530);
                    break;
                }
                case 8509: {
                    this.checkLength(8509, 8);
                    l = this.reader.readNetworkLong();
                    break;
                }
                case 8531: {
                    this.checkLength(8531, 1);
                    bl5 = this.readBoolean(8531);
                    bl6 = true;
                    break;
                }
                case 8532: {
                    this.checkLength(8532, 1);
                    bl7 = this.readBoolean(8532);
                    break;
                }
                case 8533: {
                    bl8 = this.readBoolean(8533);
                    break;
                }
                case 8534: {
                    n5 = this.parseQRYROWSET(1);
                    break;
                }
                case 8510: {
                    bl3 = this.readBoolean(8510);
                    break;
                }
                case 8506: {
                    this.checkLength(8506, 4);
                    n = this.reader.readNetworkInt();
                    break;
                }
                case 8513: {
                    this.checkLength(8513, 2);
                    n3 = this.reader.readSignedNetworkShort();
                    break;
                }
                case 8520: {
                    this.checkLength(8520, 1);
                    n6 = this.reader.readUnsignedByte();
                    if (n6 == 1 || n6 == 2) break;
                    this.invalidValue(8520);
                    break;
                }
                case 8539: {
                    this.checkLength(8539, 8);
                    long l2 = this.reader.readNetworkLong();
                    bl4 = true;
                    break;
                }
                case 6400: {
                    this.parseMONITOR();
                    break;
                }
                default: {
                    this.invalidCodePoint(n7);
                }
            }
            n7 = this.reader.getCodePoint();
        }
        if (pkgnamcsn == null) {
            this.missingCodePoint(8467);
        }
        if (!bl) {
            this.missingCodePoint(8468);
        }
        if (this.sqlamLevel >= 7 && !bl4) {
            this.missingCodePoint(8539);
        }
        if ((dRDAStatement = this.database.getDRDAStatement(pkgnamcsn)) == null) {
            this.invalidValue(8198);
        }
        if (dRDAStatement.rsIsClosed()) {
            this.writeQRYNOPRM(8);
            this.skipRemainder(true);
            return null;
        }
        dRDAStatement.setQueryOptions(n2, bl2, l, bl3, n, n3, n4, bl5, bl7, bl8, n5, n6);
        if (this.reader.isChainedWithSameID()) {
            this.parseCNTQRYobjects(dRDAStatement);
        }
        return dRDAStatement;
    }

    private void skipRemainder(boolean bl) throws DRDAProtocolException {
        this.reader.skipDss();
        while (this.reader.isChainedWithSameID() || !bl && this.reader.isChainedWithDiffID()) {
            this.reader.readDssHeader();
            this.reader.skipDss();
        }
    }

    private void parseCNTQRYobjects(DRDAStatement dRDAStatement) throws DRDAProtocolException, SQLException {
        do {
            this.correlationID = this.reader.readDssHeader();
            block4: while (this.reader.moreDssData()) {
                int n = this.reader.readLengthAndCodePoint(false);
                switch (n) {
                    case 9237: {
                        this.parseOUTOVR(dRDAStatement);
                        continue block4;
                    }
                }
                this.invalidCodePoint(n);
            }
        } while (this.reader.isChainedWithSameID());
    }

    private void parseOUTOVR(DRDAStatement dRDAStatement) throws DRDAProtocolException, SQLException {
        boolean bl = true;
        int n = 0;
        while (true) {
            int n2;
            int n3 = this.reader.readUnsignedByte();
            int n4 = this.reader.readUnsignedByte();
            int n5 = this.reader.readUnsignedByte();
            if (n4 == 113) break;
            int n6 = (n3 - 3) / 3;
            int[] nArray = null;
            if (bl) {
                nArray = new int[n6];
                bl = false;
            } else {
                int[] nArray2 = dRDAStatement.getOutovr_drdaType();
                n2 = nArray2.length;
                nArray = new int[n2 + n6];
                System.arraycopy(nArray2, 0, nArray, 0, n2);
                n = n2;
            }
            for (int i = n; i < n6 + n; ++i) {
                n2 = this.reader.readUnsignedByte();
                if (!this.database.supportsLocator() && n2 >= 24 && n2 <= 27) {
                    this.reader.readNetworkShort();
                    continue;
                }
                nArray[i] = n2;
                int n7 = this.reader.readNetworkShort();
                int n8 = i;
                nArray[n8] = nArray[n8] | n7 << 8;
            }
            dRDAStatement.setOutovr_drdaType(nArray);
        }
        this.reader.skipBytes();
    }

    private void writePBSD() throws SQLException, DRDAProtocolException {
        if (!this.appRequester.supportsSessionDataCaching()) {
            return;
        }
        PiggyBackedSessionData piggyBackedSessionData = this.database.getPiggyBackedSessionData(true);
        this.deferredReset = false;
        piggyBackedSessionData.refresh();
        if (piggyBackedSessionData.isModified()) {
            this.writer.createDssReply();
            this.writer.startDdm(49152);
            if (piggyBackedSessionData.isIsoModified()) {
                this.writer.writeScalar1Byte(49153, piggyBackedSessionData.getIso());
            }
            if (piggyBackedSessionData.isSchemaModified()) {
                this.writer.startDdm(49154);
                this.writer.writeString(piggyBackedSessionData.getSchema());
                this.writer.endDdm();
            }
            this.writer.endDdmAndDss();
        }
        piggyBackedSessionData.setUnmodified();
    }

    private void writeOPNQRYRM(boolean bl, DRDAStatement dRDAStatement) throws DRDAProtocolException, SQLException {
        if (bl) {
            this.writer.createDssObject();
        } else {
            this.writer.createDssReply();
        }
        this.writer.startDdm(8709);
        this.writer.writeScalar2Bytes(4425, 0);
        int n = dRDAStatement.getQryprctyp();
        this.writer.writeScalar2Bytes(8450, n);
        if (dRDAStatement.getCurrentDrdaResultSet().withHoldCursor == 1) {
            this.writer.writeScalar1Byte(8479, -15);
        }
        if (this.sqlamLevel >= 7) {
            this.writer.writeScalarHeader(8539, 8);
            this.writer.writeInt(0);
            this.writer.writeInt(this.session.qryinsid++);
            if (dRDAStatement.isScrollable()) {
                this.writer.writeScalar1Byte(8521, -15);
                if (dRDAStatement.getConcurType() == 1008 && dRDAStatement.getResultSet().getType() == 1004) {
                    this.writer.writeScalar1Byte(8535, 2);
                } else {
                    this.writer.writeScalar1Byte(8535, 1);
                }
            }
            if (dRDAStatement.getConcurType() == 1008) {
                if (dRDAStatement.getResultSet() != null) {
                    if (dRDAStatement.getResultSet().getConcurrency() == 1008) {
                        this.writer.writeScalar1Byte(8528, 4);
                    } else {
                        this.writer.writeScalar1Byte(8528, 1);
                    }
                } else {
                    this.writer.writeScalar1Byte(8528, 4);
                }
            } else {
                this.writer.writeScalar1Byte(8528, 1);
            }
        }
        this.writer.endDdmAndDss();
    }

    private void writeENDQRYRM(int n) throws DRDAProtocolException {
        this.writer.createDssReply();
        this.writer.startDdm(8715);
        this.writer.writeScalar2Bytes(4425, n);
        this.writer.endDdmAndDss();
    }

    private void writeABNUOWRM() throws DRDAProtocolException {
        this.writer.createDssReply();
        this.writer.startDdm(8717);
        this.writer.writeScalar2Bytes(4425, 8);
        this.writeRDBNAM(this.database.getDatabaseName());
        this.writer.endDdmAndDss();
    }

    private String parseRDBNAM() throws DRDAProtocolException {
        byte[] byArray = this.reader.readBytes();
        if (byArray.length == 0) {
            this.rdbNotFound(null);
        }
        if (byArray.length < 18 || byArray.length > 255) {
            this.badObjectLength(8464);
        }
        String string = this.reader.convertBytes(byArray);
        string = string.trim();
        return string;
    }

    private void writeACCSECRD(int n) throws DRDAProtocolException {
        this.writer.createDssReply();
        this.writer.startDdm(5292);
        if (n != 1) {
            this.writer.writeScalar2Bytes(4514, this.database.securityMechanism);
        } else if (this.server.getSecurityMechanism() != -1) {
            this.writer.writeScalar2Bytes(4514, this.server.getSecurityMechanism());
        } else {
            this.writer.writeScalar2Bytes(4514, 3);
            if (this.server.supportsEUSRIDPWD()) {
                this.writer.writeScalar2Bytes(4514, 9);
            }
            this.writer.writeScalar2Bytes(4514, 4);
            this.writer.writeScalar2Bytes(4514, 8);
        }
        if (n != 0) {
            this.writer.writeScalar1Byte(4516, n);
        } else if (this.database.securityMechanism == 9) {
            this.writer.writeScalarBytes(4572, this.myPublicKey);
        } else if (this.database.securityMechanism == 8) {
            this.writer.writeScalarBytes(4572, this.myTargetSeed);
        }
        this.writer.endDdmAndDss();
        if (n != 0) {
            this.skipRemainder(false);
        }
        this.finalizeChain();
    }

    /*
     * Unable to fully structure code
     */
    private int parseSECCHK() throws DRDAProtocolException {
        block43: {
            block42: {
                var2_1 = 0;
                var3_2 = 0;
                this.databaseAccessException = null;
                this.reader.markCollection();
                var1_3 = this.reader.getCodePoint();
                if (!this.deferredReset) break block42;
                while (var1_3 != -1) {
                    switch (var1_3) {
                        case 4502: 
                        case 4512: 
                        case 4513: 
                        case 4514: 
                        case 4572: 
                        case 4574: 
                        case 8464: {
                            this.reader.skipBytes();
                            break;
                        }
                        default: {
                            this.invalidCodePoint(var1_3);
                        }
                    }
                    var1_3 = this.reader.getCodePoint();
                }
                break block43;
            }
            while (var1_3 != -1) {
                switch (var1_3) {
                    case 4502: {
                        this.reader.skipBytes();
                        break;
                    }
                    case 4514: {
                        this.checkLength(4514, 2);
                        var3_2 = this.reader.readNetworkShort();
                        if (var3_2 == this.database.securityMechanism) break;
                        this.invalidValue(4514);
                        break;
                    }
                    case 4572: {
                        if (this.database.securityMechanism != 9 && this.database.securityMechanism != 8) {
                            var2_1 = 14;
                            this.reader.skipBytes();
                            break;
                        }
                        if (this.database.securityMechanism != 9) ** GOTO lbl55
                        if (this.database.decryptedUserId != null) ** GOTO lbl45
                        try {
                            this.database.decryptedUserId = this.reader.readEncryptedString(DRDAConnThread.decryptionManager, this.database.securityMechanism, this.myPublicKey, this.database.secTokenIn);
                        }
                        catch (SQLException var4_5) {
                            DRDAConnThread.println2Log(this.database.getDatabaseName(), this.session.drdaID, var4_5.getMessage());
                            if (var2_1 != 0) ** GOTO lbl43
                            var2_1 = 19;
                        }
lbl43:
                        // 3 sources

                        this.database.userId = this.database.decryptedUserId;
                        break;
lbl45:
                        // 1 sources

                        if (this.database.decryptedPassword != null) break;
                        try {
                            this.database.decryptedPassword = this.reader.readEncryptedString(DRDAConnThread.decryptionManager, this.database.securityMechanism, this.myPublicKey, this.database.secTokenIn);
                        }
                        catch (SQLException var4_6) {
                            DRDAConnThread.println2Log(this.database.getDatabaseName(), this.session.drdaID, var4_6.getMessage());
                            if (var2_1 != 0) ** GOTO lbl53
                            var2_1 = 15;
                        }
lbl53:
                        // 3 sources

                        this.database.password = this.database.decryptedPassword;
                        break;
lbl55:
                        // 1 sources

                        if (this.database.securityMechanism == 8) {
                            if (this.database.passwordSubstitute != null) break;
                            this.database.passwordSubstitute = this.reader.readBytes();
                            this.database.password = DecryptionManager.toHexString(this.database.passwordSubstitute, 0, this.database.passwordSubstitute.length);
                            break;
                        }
                        this.tooMany(4572);
                        break;
                    }
                    case 4513: {
                        this.database.password = this.reader.readString();
                        break;
                    }
                    case 4574: {
                        this.reader.skipBytes();
                        break;
                    }
                    case 4512: {
                        this.database.userId = this.reader.readString();
                        break;
                    }
                    case 8464: {
                        var4_4 = this.parseRDBNAM();
                        if (this.database != null) {
                            if (this.database.getDatabaseName() == null) {
                                this.database.setDatabaseName(var4_4);
                                this.session.addDatabase(this.database);
                                this.session.database = this.database;
                                break;
                            }
                            if (this.database.getDatabaseName().equals(var4_4)) break;
                            this.rdbnamMismatch(4206);
                            break;
                        }
                        this.initializeDatabase(var4_4);
                        break;
                    }
                    default: {
                        this.invalidCodePoint(var1_3);
                    }
                }
                var1_3 = this.reader.getCodePoint();
            }
            if (var3_2 == 0) {
                this.missingCodePoint(4514);
            }
            if (this.database == null || this.database.getDatabaseName() == null) {
                this.missingCodePoint(8464);
            }
            if (var2_1 == 0 && (this.database.securityMechanism == 3 || this.database.securityMechanism == 4)) {
                if (this.database.userId == null) {
                    var2_1 = 18;
                } else if (this.database.securityMechanism == 3 && this.database.password == null) {
                    var2_1 = 16;
                }
            }
            if (var2_1 == 0 && this.database.securityMechanism == 8) {
                if (this.database.userId == null) {
                    var2_1 = 18;
                } else if (this.database.passwordSubstitute == null) {
                    var2_1 = 16;
                }
            }
            if (var2_1 == 0 && this.database.securityMechanism == 9) {
                if (this.database.decryptedUserId == null) {
                    var2_1 = 18;
                } else if (this.database.decryptedPassword == null) {
                    var2_1 = 16;
                }
            }
        }
        if (var2_1 == 0 && this.databaseAccessException == null) {
            if (this.deferredReset) {
                try {
                    this.database.getConnection().resetFromPool();
                    this.database.getConnection().setHoldability(1);
                    this.database.getConnection().setTransactionIsolation(2);
                }
                catch (SQLException var4_7) {
                    this.handleException(var4_7);
                }
            } else {
                var2_1 = this.verifyUserIdPassword();
            }
        }
        if (var2_1 == 0) {
            this.session.setState(4);
        }
        return var2_1;
    }

    private void writeSECCHKRM(int n) throws DRDAProtocolException {
        this.writer.createDssReply();
        this.writer.startDdm(4633);
        this.writer.writeScalar2Bytes(4425, this.svrcodFromSecchkcd(n));
        this.writer.writeScalar1Byte(4516, n);
        this.writer.endDdmAndDss();
        if (n != 0) {
            this.skipRemainder(false);
        }
        this.finalizeChain();
    }

    private int svrcodFromSecchkcd(int n) {
        if (n == 0 || n == 2 || n == 5 || n == 8) {
            return 0;
        }
        return 8;
    }

    /*
     * Unable to fully structure code
     */
    private int parseACCRDB() throws DRDAProtocolException {
        var2_1 = 0;
        this.copyToRequired(DRDAConnThread.ACCRDB_REQUIRED);
        this.reader.markCollection();
        var1_2 = this.reader.getCodePoint();
        while (var1_2 != -1) {
            switch (var1_2) {
                case 8463: {
                    this.checkLength(8463, 2);
                    var3_3 = this.reader.readNetworkShort();
                    if (var3_3 != 9223) {
                        this.invalidValue(8463);
                    }
                    this.removeFromRequired(8463);
                    break;
                }
                case 8501: {
                    this.database.crrtkn = this.reader.readBytes();
                    this.removeFromRequired(8501);
                    var4_4 = this.database.crrtkn.length;
                    if (var4_4 > 255) {
                        this.tooBig(8501);
                    }
                    if (var4_4 < 9 || var4_4 > 23) {
                        this.invalidValue(8501);
                    }
                    var5_5 = new byte[var4_4 - 6];
                    for (var6_7 = 0; var6_7 < var5_5.length; ++var6_7) {
                        var5_5[var6_7] = this.database.crrtkn[var6_7];
                    }
                    var6_6 = SignedBinary.getLong(this.database.crrtkn, var4_4 - 8, 1);
                    this.session.drdaID = this.reader.convertBytes(var5_5) + var6_6 + "{" + this.session.connNum + "}";
                    this.database.setDrdaID(this.session.drdaID);
                    break;
                }
                case 8464: {
                    var8_8 = this.parseRDBNAM();
                    if (this.database != null) {
                        if (!this.database.getDatabaseName().equals(var8_8)) {
                            this.rdbnamMismatch(8193);
                        }
                    } else {
                        var9_9 = this.session.getDatabase(var8_8);
                        if (var9_9 == null) {
                            this.initializeDatabase(var8_8);
                        } else {
                            this.database = var9_9;
                            ++this.database.accessCount;
                        }
                    }
                    this.removeFromRequired(8464);
                    break;
                }
                case 4398: {
                    this.appRequester.setClientVersion(this.reader.readString());
                    if (this.appRequester.prdid.length() > 8) {
                        this.tooBig(4398);
                    }
                    if (this.appRequester.getClientType() == 1 && this.appRequester.greaterThanOrEqualTo(1, 5, 0)) ** GOTO lbl-1000
                    if (this.appRequester.getClientType() == 3) lbl-1000:
                    // 2 sources

                    {
                        this.sendWarningsOnCNTQRY = true;
                    } else {
                        this.sendWarningsOnCNTQRY = false;
                    }
                    if (this.appRequester.getClientType() == 3 && this.appRequester.greaterThanOrEqualTo(10, 2, 0)) {
                        this.diagnosticLevel = (byte)-15;
                    }
                    this.removeFromRequired(4398);
                    break;
                }
                case 47: {
                    this.setStmtOrDbByteOrder(true, null, this.parseTYPDEFNAM());
                    this.removeFromRequired(47);
                    break;
                }
                case 53: {
                    this.parseTYPDEFOVR(null);
                    this.removeFromRequired(53);
                    break;
                }
                case 8474: {
                    this.checkLength(8474, 1);
                    this.database.rdbAllowUpdates = this.readBoolean(8474);
                    break;
                }
                case 8452: {
                    if (this.reader.getDdmLength() > 255L) {
                        this.tooBig(8452);
                    }
                    this.reader.skipBytes();
                    break;
                }
                case 8507: {
                    var9_10 = this.reader.readByte();
                    if (var9_10 != 241) break;
                    this.database.sendTRGDFTRT = true;
                    break;
                }
                case 8480: 
                case 8481: {
                    this.codePointNotSupported(var1_2);
                    break;
                }
                default: {
                    this.invalidCodePoint(var1_2);
                }
            }
            var1_2 = this.reader.getCodePoint();
        }
        this.checkRequired(8193);
        if (this.database.ccsidDBC != 0 && !this.server.supportsCCSID(this.database.ccsidDBC) || this.database.ccsidMBC != 0 && !this.server.supportsCCSID(this.database.ccsidMBC)) {
            var2_1 = 4;
        }
        return var2_1;
    }

    private String parseTYPDEFNAM() throws DRDAProtocolException {
        String string = this.reader.readString();
        if (string.length() > 255) {
            this.tooBig(47);
        }
        this.checkValidTypDefNam(string);
        if (!(string.equals("QTDSQLASC") || string.equals("QTDSQLJVM") || string.equals("QTDSQLX86"))) {
            this.valueNotSupported(47);
        }
        return string;
    }

    private void setStmtOrDbByteOrder(boolean bl, DRDAStatement dRDAStatement, String string) {
        int n;
        int n2 = n = string.equals("QTDSQLX86") ? 2 : 1;
        if (bl) {
            this.database.typDefNam = string;
            this.database.byteOrder = n;
        } else {
            dRDAStatement.typDefNam = string;
            dRDAStatement.byteOrder = n;
        }
    }

    private void writeACCRDBRM(int n) throws DRDAProtocolException {
        this.writer.createDssReply();
        this.writer.startDdm(8705);
        this.writer.writeScalar2Bytes(4425, n);
        this.writer.writeScalarString(4398, NetworkServerControlImpl.prdId);
        this.writer.writeScalarString(47, "QTDSQLASC");
        this.writeTYPDEFOVR();
        this.writer.endDdmAndDss();
        if (this.appRequester.getClientType() == 3 && this.appRequester.greaterThanOrEqualTo(10, 7, 0)) {
            try {
                this.writePBSD();
            }
            catch (SQLException sQLException) {
                this.server.consoleExceptionPrint(sQLException);
                this.errorInChain(sQLException);
            }
        }
        this.finalizeChain();
    }

    private void writeTYPDEFOVR() throws DRDAProtocolException {
        this.writer.startDdm(53);
        this.writer.writeScalar2Bytes(4508, 1208);
        this.writer.writeScalar2Bytes(4510, 1208);
        if (this.database.sendTRGDFTRT) {
            this.writer.startDdm(8485);
            this.writer.writeShort(9269);
            this.writer.endDdm();
            this.writer.startDdm(4512);
            this.writer.writeString(this.database.userId);
            this.writer.endDdm();
        }
        this.writer.endDdm();
    }

    private void parseTYPDEFOVR(DRDAStatement dRDAStatement) throws DRDAProtocolException {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        String string = null;
        String string2 = null;
        String string3 = null;
        this.reader.markCollection();
        int n4 = this.reader.getCodePoint();
        if (n4 == -1 && dRDAStatement != null) {
            this.missingCodePoint(4508);
        }
        while (n4 != -1) {
            switch (n4) {
                case 4508: {
                    this.checkLength(4508, 2);
                    n = this.reader.readNetworkShort();
                    try {
                        string = CharacterEncodings.getJavaEncoding(n);
                    }
                    catch (Exception exception) {
                        this.valueNotSupported(4508);
                    }
                    break;
                }
                case 4509: {
                    this.checkLength(4509, 2);
                    n2 = this.reader.readNetworkShort();
                    try {
                        string2 = CharacterEncodings.getJavaEncoding(n2);
                    }
                    catch (Exception exception) {
                        string2 = null;
                        if (dRDAStatement == null) break;
                        this.valueNotSupported(4508);
                    }
                    break;
                }
                case 4510: {
                    this.checkLength(4510, 2);
                    n3 = this.reader.readNetworkShort();
                    try {
                        string3 = CharacterEncodings.getJavaEncoding(n3);
                    }
                    catch (Exception exception) {
                        string3 = null;
                        if (dRDAStatement == null) break;
                        this.valueNotSupported(4510);
                    }
                    break;
                }
                default: {
                    this.invalidCodePoint(n4);
                }
            }
            n4 = this.reader.getCodePoint();
        }
        if (dRDAStatement == null) {
            if (n != 0) {
                this.database.ccsidSBC = n;
                this.database.ccsidSBCEncoding = string;
            }
            if (n2 != 0) {
                this.database.ccsidDBC = n2;
                this.database.ccsidDBCEncoding = string2;
            }
            if (n3 != 0) {
                this.database.ccsidMBC = n3;
                this.database.ccsidMBCEncoding = string3;
            }
        } else {
            if (n != 0) {
                dRDAStatement.ccsidSBC = n;
                dRDAStatement.ccsidSBCEncoding = string;
            }
            if (n2 != 0) {
                dRDAStatement.ccsidDBC = n2;
                dRDAStatement.ccsidDBCEncoding = string2;
            }
            if (n3 != 0) {
                dRDAStatement.ccsidMBC = n3;
                dRDAStatement.ccsidMBCEncoding = string3;
            }
        }
    }

    private int parsePRPSQLSTT() throws DRDAProtocolException, SQLException {
        boolean bl = false;
        boolean bl2 = true;
        Pkgnamcsn pkgnamcsn = null;
        DRDAStatement dRDAStatement = null;
        Database database = null;
        this.reader.markCollection();
        int n = this.reader.getCodePoint();
        while (n != -1) {
            switch (n) {
                case 8464: {
                    this.setDatabase(8205);
                    database = this.database;
                    break;
                }
                case 8467: {
                    pkgnamcsn = this.parsePKGNAMCSN();
                    break;
                }
                case 8470: {
                    bl = this.readBoolean(8470);
                    break;
                }
                case 8518: {
                    bl2 = this.parseTYPSQLDA();
                    break;
                }
                case 6400: {
                    this.parseMONITOR();
                    break;
                }
                default: {
                    this.invalidCodePoint(n);
                }
            }
            n = this.reader.getCodePoint();
        }
        dRDAStatement = this.database.newDRDAStatement(pkgnamcsn);
        String string = this.parsePRPSQLSTTobjects(dRDAStatement);
        if (database != null) {
            dRDAStatement.setDatabase(this.database);
        }
        dRDAStatement.explicitPrepare(string);
        this.database.setCurrentStatement(dRDAStatement);
        if (!bl) {
            return 0;
        }
        if (bl2) {
            return 2;
        }
        return 1;
    }

    private String parsePRPSQLSTTobjects(DRDAStatement dRDAStatement) throws DRDAProtocolException, SQLException {
        String string = null;
        do {
            this.correlationID = this.reader.readDssHeader();
            block7: while (this.reader.moreDssData()) {
                int n = this.reader.readLengthAndCodePoint(false);
                switch (n) {
                    case 9236: {
                        string = this.parseEncodedString();
                        continue block7;
                    }
                    case 47: {
                        this.setStmtOrDbByteOrder(false, dRDAStatement, this.parseTYPDEFNAM());
                        continue block7;
                    }
                    case 53: {
                        this.parseTYPDEFOVR(dRDAStatement);
                        continue block7;
                    }
                    case 9296: {
                        this.parseSQLATTR(dRDAStatement);
                        continue block7;
                    }
                }
                this.invalidCodePoint(n);
            }
        } while (this.reader.isChainedWithSameID());
        if (string == null) {
            this.missingCodePoint(9236);
        }
        return string;
    }

    private boolean parseTYPSQLDA() throws DRDAProtocolException {
        this.checkLength(8518, 1);
        byte by = this.reader.readByte();
        if (by == 0 || by == 2 || by == 4) {
            return true;
        }
        if (by == 1 || by == 3 || by == 5) {
            return false;
        }
        this.invalidValue(8518);
        return false;
    }

    protected void parseSQLATTR(DRDAStatement dRDAStatement) throws DRDAProtocolException {
        String string = this.parseEncodedString();
        boolean bl = false;
        if (string.indexOf("INSENSITIVE SCROLL") != -1 || string.indexOf("SCROLL INSENSITIVE") != -1) {
            dRDAStatement.scrollType = 1004;
            dRDAStatement.concurType = 1007;
            bl = true;
        }
        if (string.indexOf("SENSITIVE DYNAMIC SCROLL") != -1 || string.indexOf("SENSITIVE STATIC SCROLL") != -1) {
            dRDAStatement.scrollType = 1005;
            bl = true;
        }
        if (string.indexOf("FOR UPDATE") != -1) {
            bl = true;
            dRDAStatement.concurType = 1008;
        }
        if (string.indexOf("WITH HOLD") != -1) {
            dRDAStatement.withHoldCursor = 1;
            bl = true;
        }
        if (!bl) {
            this.invalidValue(9296);
        }
    }

    private boolean parseDSCSQLSTT() throws DRDAProtocolException, SQLException {
        boolean bl = true;
        Pkgnamcsn pkgnamcsn = null;
        this.reader.markCollection();
        int n = this.reader.getCodePoint();
        while (n != -1) {
            switch (n) {
                case 8518: {
                    bl = this.parseTYPSQLDA();
                    break;
                }
                case 8464: {
                    this.setDatabase(8200);
                    break;
                }
                case 8467: {
                    pkgnamcsn = this.parsePKGNAMCSN();
                    DRDAStatement dRDAStatement = this.database.getDRDAStatement(pkgnamcsn);
                    if (dRDAStatement != null) break;
                    this.invalidValue(8467);
                    break;
                }
                case 6400: {
                    this.parseMONITOR();
                    break;
                }
                default: {
                    this.invalidCodePoint(n);
                }
            }
            n = this.reader.getCodePoint();
        }
        if (pkgnamcsn == null) {
            this.missingCodePoint(8467);
        }
        return bl;
    }

    private void parseEXCSQLSTT() throws DRDAProtocolException, SQLException {
        boolean bl;
        Object object;
        boolean bl2;
        boolean bl3;
        this.reader.markCollection();
        int n = this.reader.getCodePoint();
        boolean bl4 = false;
        Pkgnamcsn pkgnamcsn = null;
        int n2 = 1;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = -1;
        int n7 = 1;
        byte[] byArray = null;
        String string = null;
        while (n != -1) {
            switch (n) {
                case 8464: {
                    this.setDatabase(8203);
                    break;
                }
                case 8467: {
                    pkgnamcsn = this.parsePKGNAMCSN();
                    break;
                }
                case 8465: {
                    bl4 = this.readBoolean(8465);
                    break;
                }
                case 8506: {
                    this.checkLength(8506, 4);
                    n2 = this.reader.readNetworkInt();
                    break;
                }
                case 8504: {
                    string = this.reader.readString();
                    break;
                }
                case 8468: {
                    n3 = this.parseQRYBLKSZ();
                    break;
                }
                case 8512: {
                    this.checkLength(8512, 2);
                    n4 = this.reader.readNetworkShort();
                    break;
                }
                case 8513: {
                    this.checkLength(8513, 2);
                    n5 = this.reader.readNetworkShort();
                    break;
                }
                case 8514: {
                    byArray = this.reader.readBytes();
                    for (int i = 0; i < byArray.length; ++i) {
                    }
                    break;
                }
                case 8453: {
                    this.parseRDBCMTOK();
                    break;
                }
                case 8519: {
                    n7 = this.parseOUTOVROPT();
                    break;
                }
                case 8534: {
                    n6 = this.parseQRYROWSET(0);
                    break;
                }
                case 6400: {
                    this.parseMONITOR();
                    break;
                }
                default: {
                    this.invalidCodePoint(n);
                }
            }
            n = this.reader.getCodePoint();
        }
        if (pkgnamcsn == null) {
            this.missingCodePoint(8467);
        }
        boolean bl5 = false;
        DRDAStatement dRDAStatement = this.database.getDRDAStatement(pkgnamcsn);
        boolean bl6 = bl3 = string != null || dRDAStatement != null && dRDAStatement.wasExplicitlyPrepared() && dRDAStatement.isCall;
        if (bl3) {
            if (dRDAStatement == null || !dRDAStatement.wasExplicitlyPrepared()) {
                dRDAStatement = this.database.newDRDAStatement(pkgnamcsn);
                dRDAStatement.setQryprctyp(9239);
                bl5 = true;
            }
            dRDAStatement.procName = string;
            dRDAStatement.outputExpected = bl4;
        } else {
            if (dRDAStatement == null) {
                this.invalidValue(8467);
            }
            dRDAStatement.setQryprctyp(9239);
        }
        dRDAStatement.nbrrow = n2;
        dRDAStatement.qryrowset = n6;
        dRDAStatement.blksize = n3;
        dRDAStatement.maxblkext = n5;
        dRDAStatement.maxrslcnt = n4;
        dRDAStatement.outovropt = n7;
        dRDAStatement.rslsetflg = byArray;
        if (this.pendingStatementTimeout >= 0) {
            dRDAStatement.getPreparedStatement().setQueryTimeout(this.pendingStatementTimeout);
            this.pendingStatementTimeout = -1;
        }
        this.database.setCurrentStatement(dRDAStatement);
        if (this.reader.isChainedWithSameID()) {
            bl2 = this.parseEXCSQLSTTobjects(dRDAStatement);
        } else {
            if (bl3 && bl5) {
                object = "call " + dRDAStatement.procName + "()";
                this.database.getConnection().clearWarnings();
                CallableStatement callableStatement = (CallableStatement)dRDAStatement.prepare((String)object);
            }
            dRDAStatement.ps.clearWarnings();
            bl2 = dRDAStatement.execute();
        }
        object = null;
        if (bl2) {
            object = dRDAStatement.getResultSet();
        }
        bl2 = object != null;
        int n8 = 0;
        if (bl2) {
            n8 = dRDAStatement.getNumResultSets();
            this.writeRSLSETRM(dRDAStatement);
        }
        boolean bl7 = bl = dRDAStatement.hasOutputParams() && bl4;
        if (bl3) {
            if (bl) {
                this.writer.createDssObject();
                this.writer.startDdm(9235);
                this.writer.startDdm(16);
                this.writeQRYDSC(dRDAStatement, true);
                this.writer.endDdm();
                this.writer.startDdm(5242);
                this.writeFDODTA(dRDAStatement);
                this.writer.endDdm();
                this.writer.endDdmAndDss();
                if (dRDAStatement.getExtDtaObjects() != null) {
                    this.writeEXTDTA(dRDAStatement);
                }
            } else if (bl2) {
                this.writeNullSQLCARDobject();
            }
        }
        dRDAStatement.finishParams();
        PreparedStatement preparedStatement = dRDAStatement.getPreparedStatement();
        int n9 = 0;
        do {
            if (bl2) {
                dRDAStatement.setCurrentDrdaResultSet(n9);
                dRDAStatement.setQryrtndta(true);
                if (!bl3) {
                    this.checkWarning(null, preparedStatement, null, -1, true, true);
                }
                if (n9 == 0) {
                    this.writeSQLRSLRD(dRDAStatement);
                }
                this.writeOPNQRYRM(true, dRDAStatement);
                this.writeSQLCINRD(dRDAStatement);
                this.writeQRYDSC(dRDAStatement, false);
                dRDAStatement.rsSuspend();
                if (dRDAStatement.getQryprctyp() != 9239) continue;
                this.writeQRYDTA(dRDAStatement);
                continue;
            }
            if (bl) continue;
            int n10 = preparedStatement.getUpdateCount();
            this.checkWarning(this.database.getConnection(), dRDAStatement.ps, null, n10, true, true);
        } while (bl2 && ++n9 < n8);
    }

    private void parseRDBCMTOK() throws DRDAProtocolException {
        boolean bl = this.readBoolean(8453);
    }

    private boolean parseEXCSQLSTTobjects(DRDAStatement dRDAStatement) throws DRDAProtocolException, SQLException {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        do {
            this.correlationID = this.reader.readDssHeader();
            block8: while (this.reader.moreDssData()) {
                int n = this.reader.readLengthAndCodePoint(true);
                switch (n) {
                    case 47: {
                        this.setStmtOrDbByteOrder(false, dRDAStatement, this.parseTYPDEFNAM());
                        dRDAStatement.setTypDefValues();
                        continue block8;
                    }
                    case 53: {
                        this.parseTYPDEFOVR(dRDAStatement);
                        dRDAStatement.setTypDefValues();
                        continue block8;
                    }
                    case 9234: {
                        this.parseSQLDTA(dRDAStatement);
                        bl = true;
                        continue block8;
                    }
                    case 5228: {
                        this.readAndSetAllExtParams(dRDAStatement, true);
                        dRDAStatement.ps.clearWarnings();
                        bl3 = dRDAStatement.execute();
                        bl2 = true;
                        continue block8;
                    }
                    case 9237: {
                        this.parseOUTOVR(dRDAStatement);
                        continue block8;
                    }
                }
                this.invalidCodePoint(n);
            }
        } while (this.reader.isChainedWithSameID());
        if (!bl) {
            this.missingCodePoint(9234);
        }
        if (!bl2) {
            dRDAStatement.ps.clearWarnings();
            bl3 = dRDAStatement.execute();
        }
        return bl3;
    }

    private void writeSQLCINRD(DRDAStatement dRDAStatement) throws DRDAProtocolException, SQLException {
        ResultSet resultSet = dRDAStatement.getResultSet();
        this.writer.createDssObject();
        this.writer.startDdm(9227);
        if (this.sqlamLevel >= 7) {
            this.writeSQLDHROW(((EngineResultSet)resultSet).getHoldability());
        }
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        this.writer.writeShort(n);
        if (this.sqlamLevel >= 7) {
            for (int i = 0; i < n; ++i) {
                this.writeSQLDAGRP(resultSetMetaData, null, i, true);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                this.writeVCMorVCS(resultSetMetaData.getColumnName(i + 1));
                this.writeVCMorVCS(resultSetMetaData.getColumnLabel(i + 1));
                this.writeVCMorVCS(null);
            }
        }
        this.writer.endDdmAndDss();
    }

    private void writeSQLRSLRD(DRDAStatement dRDAStatement) throws DRDAProtocolException, SQLException {
        int n = dRDAStatement.getNumResultSets();
        this.writer.createDssObject();
        this.writer.startDdm(9230);
        this.writer.writeShort(n);
        for (int i = 0; i < n; ++i) {
            this.writer.writeInt(i);
            this.writeVCMorVCS(dRDAStatement.getResultSetCursorName(i));
            this.writer.writeInt(1);
        }
        this.writer.endDdmAndDss();
    }

    private void writeRSLSETRM(DRDAStatement dRDAStatement) throws DRDAProtocolException, SQLException {
        int n = dRDAStatement.getNumResultSets();
        this.writer.createDssReply();
        this.writer.startDdm(8729);
        this.writer.writeScalar2Bytes(4425, 0);
        this.writer.startDdm(8505);
        for (int i = 0; i < n; ++i) {
            this.writePKGNAMCSN(dRDAStatement.getResultSetPkgcnstkn(i).getBytes());
        }
        this.writer.endDdm();
        this.writer.endDdmAndDss();
    }

    private void parseSQLDTA(DRDAStatement dRDAStatement) throws DRDAProtocolException, SQLException {
        try {
            this.parseSQLDTA_work(dRDAStatement);
        }
        catch (SQLException sQLException) {
            this.skipRemainder(true);
            throw sQLException;
        }
    }

    private void parseSQLDTA_work(DRDAStatement dRDAStatement) throws DRDAProtocolException, SQLException {
        PreparedStatement preparedStatement = dRDAStatement.getPreparedStatement();
        ParameterMetaData parameterMetaData = null;
        dRDAStatement.clearDrdaParams();
        int n = 0;
        boolean bl = false;
        this.reader.markCollection();
        int n2 = this.reader.getCodePoint();
        while (n2 != -1) {
            switch (n2) {
                case 16: {
                    int n3;
                    int n4;
                    while (this.reader.getDdmLength() > 6L) {
                        n4 = this.reader.readUnsignedByte();
                        n3 = (n4 - 3) / 3;
                        this.reader.readByte();
                        this.reader.readByte();
                        for (int i = 0; i < n3; ++i) {
                            byte by = this.reader.readByte();
                            int n5 = this.reader.readNetworkShort();
                            dRDAStatement.addDrdaParam(by, n5);
                        }
                    }
                    n = dRDAStatement.getDrdaParamCount();
                    if (preparedStatement == null) {
                        String string = "(?";
                        for (n3 = 1; n3 < n; ++n3) {
                            string = string + ", ?";
                        }
                        String string2 = "call " + dRDAStatement.procName + string + ")";
                        CallableStatement callableStatement = null;
                        try {
                            callableStatement = (CallableStatement)dRDAStatement.prepare(string2);
                            dRDAStatement.registerAllOutParams();
                        }
                        catch (SQLException sQLException) {
                            if (!dRDAStatement.outputExpected || !sQLException.getSQLState().equals("42X50")) {
                                throw sQLException;
                            }
                            string2 = n == 1 ? "? = call " + dRDAStatement.procName + "()" : "? = call " + dRDAStatement.procName + "(" + string.substring(3) + ")";
                            try {
                                callableStatement = (CallableStatement)dRDAStatement.prepare(string2);
                            }
                            catch (SQLException sQLException2) {
                                throw sQLException;
                            }
                            bl = true;
                        }
                        dRDAStatement.ps = preparedStatement = callableStatement;
                    }
                    parameterMetaData = dRDAStatement.getParameterMetaData();
                    this.reader.readBytes(6);
                    break;
                }
                case 5242: {
                    int n3;
                    int n4;
                    this.reader.readByte();
                    for (n4 = 0; n4 < n; ++n4) {
                        if ((dRDAStatement.getParamDRDAType(n4 + 1) & 1) == 1 && ((n3 = this.reader.readUnsignedByte()) & 0xFF) == 255) {
                            if (parameterMetaData.getParameterMode(n4 + 1) != 4) {
                                preparedStatement.setNull(n4 + 1, parameterMetaData.getParameterType(n4 + 1));
                            }
                            if (!dRDAStatement.isOutputParam(n4 + 1)) continue;
                            dRDAStatement.registerOutParam(n4 + 1);
                            continue;
                        }
                        this.readAndSetParams(n4, dRDAStatement, parameterMetaData);
                    }
                    break;
                }
                case 5228: {
                    this.readAndSetAllExtParams(dRDAStatement, false);
                    break;
                }
                default: {
                    this.invalidCodePoint(n2);
                }
            }
            n2 = this.reader.getCodePoint();
        }
    }

    private int getByteOrder() {
        DRDAStatement dRDAStatement = this.database.getCurrentStatement();
        return dRDAStatement != null && dRDAStatement.typDefNam != null ? dRDAStatement.byteOrder : this.database.byteOrder;
    }

    private Calendar getGMTCalendar() {
        if (this.gmtCalendar == null) {
            TimeZone timeZone = TimeZone.getTimeZone("GMT");
            this.gmtCalendar = Calendar.getInstance(timeZone);
        }
        return this.gmtCalendar;
    }

    private void readAndSetParams(int n, DRDAStatement dRDAStatement, ParameterMetaData parameterMetaData) throws DRDAProtocolException, SQLException {
        Object object;
        PreparedStatement preparedStatement = dRDAStatement.getPreparedStatement();
        int n2 = (dRDAStatement.getParamDRDAType(n + 1) | 1) & 0xFF;
        int n3 = dRDAStatement.getParamLen(n + 1);
        if (preparedStatement instanceof CallableStatement && dRDAStatement.isOutputParam(n + 1)) {
            object = (CallableStatement)preparedStatement;
            object.registerOutParameter(n + 1, dRDAStatement.getOutputParamType(n + 1));
        }
        switch (n2) {
            case 5: {
                short s = this.reader.readShort(this.getByteOrder());
                preparedStatement.setShort(n + 1, s);
                break;
            }
            case 3: {
                int n4 = this.reader.readInt(this.getByteOrder());
                preparedStatement.setInt(n + 1, n4);
                break;
            }
            case 23: {
                long l = this.reader.readLong(this.getByteOrder());
                preparedStatement.setLong(n + 1, l);
                break;
            }
            case 13: {
                float f = this.reader.readFloat(this.getByteOrder());
                preparedStatement.setFloat(n + 1, f);
                break;
            }
            case 11: {
                double d = this.reader.readDouble(this.getByteOrder());
                preparedStatement.setDouble(n + 1, d);
                break;
            }
            case 15: {
                int n5 = n3 >> 8 & 0xFF;
                int n6 = n3 & 0xFF;
                BigDecimal bigDecimal = this.reader.readBigDecimal(n5, n6);
                preparedStatement.setBigDecimal(n + 1, bigDecimal);
                break;
            }
            case 33: {
                object = this.reader.readStringData(10).trim();
                try {
                    Calendar calendar = this.getGMTCalendar();
                    preparedStatement.setDate(n + 1, this.parseDate((String)object, calendar), calendar);
                    break;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new SQLException("22007.S.181", "22007.S.181".substring(0, 5));
                }
            }
            case 35: {
                object = this.reader.readStringData(8).trim();
                try {
                    Calendar calendar = this.getGMTCalendar();
                    preparedStatement.setTime(n + 1, this.parseTime((String)object, calendar), calendar);
                    break;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new SQLException("22007.S.181", "22007.S.181".substring(0, 5));
                }
            }
            case 37: {
                int n7 = this.appRequester.getTimestampLength();
                String string = this.reader.readStringData(n7).trim();
                try {
                    Calendar calendar = this.getGMTCalendar();
                    preparedStatement.setTimestamp(n + 1, this.parseTimestamp(string, calendar), calendar);
                    break;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new SQLException("22007.S.181", "22007.S.181".substring(0, 5));
                }
            }
            case 49: 
            case 51: 
            case 53: 
            case 63: 
            case 65: {
                object = this.reader.readLDStringData(dRDAStatement.ccsidMBCEncoding);
                preparedStatement.setString(n + 1, (String)object);
                break;
            }
            case 39: {
                object = this.reader.readBytes();
                preparedStatement.setBytes(n + 1, (byte[])object);
                break;
            }
            case 41: 
            case 43: {
                int n8 = this.reader.readNetworkShort();
                byte[] byArray = this.reader.readBytes(n8);
                preparedStatement.setBytes(n + 1, byArray);
                break;
            }
            case 81: {
                object = this.readUDT();
                preparedStatement.setObject(n + 1, object);
                break;
            }
            case 201: 
            case 203: 
            case 205: 
            case 207: {
                long l = this.readLobLength(n3);
                if (l != 0L) {
                    dRDAStatement.addExtPosition(n);
                    break;
                }
                if (n2 == 201) {
                    preparedStatement.setBytes(n + 1, new byte[0]);
                    break;
                }
                preparedStatement.setString(n + 1, "");
                break;
            }
            case 25: {
                int n9 = this.reader.readInt(this.getByteOrder());
                Blob blob = (Blob)this.database.getConnection().getLOBMapping(n9);
                preparedStatement.setBlob(n + 1, blob);
                break;
            }
            case 27: {
                int n10 = this.reader.readInt(this.getByteOrder());
                Clob clob = (Clob)this.database.getConnection().getLOBMapping(n10);
                preparedStatement.setClob(n + 1, clob);
                break;
            }
            default: {
                object = this.reader.readLDStringData(dRDAStatement.ccsidMBCEncoding);
                preparedStatement.setObject(n + 1, object);
            }
        }
    }

    private Object readUDT() throws DRDAProtocolException {
        int n = this.reader.readNetworkShort();
        byte[] byArray = this.reader.readBytes(n);
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            return objectInputStream.readObject();
        }
        catch (Exception exception) {
            this.markCommunicationsFailure(exception, "DRDAConnThread.readUDT()", "", exception.getMessage(), "*");
            return null;
        }
    }

    private long readLobLength(int n) throws DRDAProtocolException {
        switch (n) {
            case 32770: {
                return this.reader.readNetworkShort();
            }
            case 32772: {
                return this.reader.readNetworkInt();
            }
            case 32774: {
                return this.reader.readNetworkSixByteLong();
            }
            case 32776: {
                return this.reader.readNetworkLong();
            }
        }
        this.throwSyntaxrm(12, n);
        return 0L;
    }

    private Date parseDate(String string, Calendar calendar) {
        String[] stringArray = string.split("-");
        if (stringArray.length != 3) {
            throw new IllegalArgumentException();
        }
        calendar.clear();
        calendar.set(1, Integer.parseInt(stringArray[0]));
        calendar.set(2, Integer.parseInt(stringArray[1]) - 1);
        calendar.set(5, Integer.parseInt(stringArray[2]));
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return new Date(calendar.getTimeInMillis());
    }

    private Time parseTime(String string, Calendar calendar) {
        String[] stringArray = string.split(":");
        if (stringArray.length != 3) {
            throw new IllegalArgumentException();
        }
        calendar.clear();
        calendar.set(1, 1970);
        calendar.set(2, 0);
        calendar.set(5, 1);
        calendar.set(11, Integer.parseInt(stringArray[0]));
        calendar.set(12, Integer.parseInt(stringArray[1]));
        calendar.set(13, Integer.parseInt(stringArray[2]));
        calendar.set(14, 0);
        return new Time(calendar.getTimeInMillis());
    }

    private Timestamp parseTimestamp(String string, Calendar calendar) {
        String[] stringArray = string.split("[-.]");
        if (stringArray.length != 7) {
            throw new IllegalArgumentException();
        }
        calendar.clear();
        calendar.set(1, Integer.parseInt(stringArray[0]));
        calendar.set(2, Integer.parseInt(stringArray[1]) - 1);
        calendar.set(5, Integer.parseInt(stringArray[2]));
        calendar.set(11, Integer.parseInt(stringArray[3]));
        calendar.set(12, Integer.parseInt(stringArray[4]));
        calendar.set(13, Integer.parseInt(stringArray[5]));
        int n = 0;
        String string2 = stringArray[6];
        for (int i = 0; i < 9; ++i) {
            n *= 10;
            if (i >= string2.length()) continue;
            int n2 = Character.digit(string2.charAt(i), 10);
            if (n2 == -1) {
                throw new IllegalArgumentException();
            }
            n += n2;
        }
        Timestamp timestamp = new Timestamp(calendar.getTimeInMillis());
        timestamp.setNanos(n);
        return timestamp;
    }

    private void readAndSetAllExtParams(DRDAStatement dRDAStatement, boolean bl) throws SQLException, DRDAProtocolException {
        int n = dRDAStatement.getExtPositionCount();
        for (int i = 0; i < n; ++i) {
            int n2 = dRDAStatement.getExtPosition(i);
            boolean bl2 = bl && i == n - 1;
            this.readAndSetExtParam(n2, dRDAStatement, dRDAStatement.getParamDRDAType(n2 + 1), dRDAStatement.getParamLen(n2 + 1), bl2);
            if (i >= n - 1) continue;
            this.correlationID = this.reader.readDssHeader();
            int n3 = this.reader.readLengthAndCodePoint(true);
        }
    }

    private void readAndSetExtParam(int n, DRDAStatement dRDAStatement, int n2, int n3, boolean bl) throws DRDAProtocolException, SQLException {
        boolean bl2 = false;
        if (this.sqlamLevel >= 7 && FdocaConstants.isNullable(n2 &= 0xFF)) {
            bl2 = true;
        }
        EXTDTAReaderInputStream eXTDTAReaderInputStream = this.reader.getEXTDTAReaderInputStream(bl2);
        String string = "na";
        switch (n2) {
            case 202: 
            case 203: {
                string = dRDAStatement.ccsidSBCEncoding;
                break;
            }
            case 204: 
            case 205: {
                string = dRDAStatement.ccsidDBCEncoding;
                break;
            }
            case 206: 
            case 207: {
                string = dRDAStatement.ccsidMBCEncoding;
            }
        }
        this.traceEXTDTARead(n2, n + 1, eXTDTAReaderInputStream, bl, string);
        try {
            switch (n2) {
                case 200: 
                case 201: {
                    DRDAConnThread.setAsBinaryStream(dRDAStatement, n + 1, eXTDTAReaderInputStream, bl);
                    break;
                }
                case 202: 
                case 203: 
                case 204: 
                case 205: 
                case 206: 
                case 207: {
                    DRDAConnThread.setAsCharacterStream(dRDAStatement, n + 1, eXTDTAReaderInputStream, bl, string);
                    break;
                }
                default: {
                    this.invalidValue(n2);
                    break;
                }
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SQLException(unsupportedEncodingException.getMessage());
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.getMessage());
        }
    }

    private int parseEXCSQLIMM() throws DRDAProtocolException, SQLException {
        this.reader.markCollection();
        Pkgnamcsn pkgnamcsn = null;
        int n = this.reader.getCodePoint();
        while (n != -1) {
            switch (n) {
                case 8464: {
                    this.setDatabase(8202);
                    break;
                }
                case 8467: {
                    pkgnamcsn = this.parsePKGNAMCSN();
                    break;
                }
                case 8453: {
                    this.parseRDBCMTOK();
                    break;
                }
                case 6400: {
                    this.parseMONITOR();
                    break;
                }
                default: {
                    this.invalidCodePoint(n);
                }
            }
            n = this.reader.getCodePoint();
        }
        DRDAStatement dRDAStatement = this.database.getDefaultStatement(pkgnamcsn);
        dRDAStatement.initialize();
        String string = this.parseEXECSQLIMMobjects();
        Statement statement = dRDAStatement.getStatement();
        statement.clearWarnings();
        if (this.pendingStatementTimeout >= 0) {
            statement.setQueryTimeout(this.pendingStatementTimeout);
            this.pendingStatementTimeout = -1;
        }
        int n2 = statement.executeUpdate(string);
        return n2;
    }

    private boolean parseEXCSQLSET() throws DRDAProtocolException, SQLException {
        this.reader.markCollection();
        int n = this.reader.getCodePoint();
        while (n != -1) {
            switch (n) {
                case 8464: {
                    this.setDatabase(8212);
                    break;
                }
                case 8466: {
                    String string = this.parsePKGNAMCT();
                    break;
                }
                case 6400: {
                    this.parseMONITOR();
                    break;
                }
                case 8467: {
                    Pkgnamcsn pkgnamcsn = this.parsePKGNAMCSN();
                    break;
                }
                default: {
                    this.invalidCodePoint(n);
                }
            }
            n = this.reader.getCodePoint();
        }
        this.parseEXCSQLSETobjects();
        return true;
    }

    private String parseEXECSQLIMMobjects() throws DRDAProtocolException, SQLException {
        String string = null;
        DRDAStatement dRDAStatement = this.database.getDefaultStatement();
        do {
            this.correlationID = this.reader.readDssHeader();
            block6: while (this.reader.moreDssData()) {
                int n = this.reader.readLengthAndCodePoint(false);
                switch (n) {
                    case 47: {
                        this.setStmtOrDbByteOrder(false, dRDAStatement, this.parseTYPDEFNAM());
                        continue block6;
                    }
                    case 53: {
                        this.parseTYPDEFOVR(dRDAStatement);
                        continue block6;
                    }
                    case 9236: {
                        string = this.parseEncodedString();
                        continue block6;
                    }
                }
                this.invalidCodePoint(n);
            }
        } while (this.reader.isChainedWithSameID());
        if (string == null) {
            this.missingCodePoint(9236);
        }
        return string;
    }

    private void parseEXCSQLSETobjects() throws DRDAProtocolException, SQLException {
        Object object;
        boolean bl = false;
        boolean bl2 = false;
        String string = null;
        DRDAStatement dRDAStatement = this.database.getDefaultStatement();
        dRDAStatement.initialize();
        do {
            this.correlationID = this.reader.readDssHeader();
            block8: while (this.reader.moreDssData()) {
                int n = this.reader.readLengthAndCodePoint(false);
                switch (n) {
                    case 47: {
                        this.setStmtOrDbByteOrder(false, dRDAStatement, this.parseTYPDEFNAM());
                        continue block8;
                    }
                    case 53: {
                        this.parseTYPDEFOVR(dRDAStatement);
                        continue block8;
                    }
                    case 9236: {
                        string = this.parseEncodedString();
                        if (string != null) {
                            bl = true;
                        }
                        if (string.startsWith(TIMEOUT_STATEMENT)) {
                            object = string.substring(TIMEOUT_STATEMENT.length());
                            this.pendingStatementTimeout = Integer.valueOf((String)object);
                            continue block8;
                        }
                        if (this.canIgnoreStmt(string)) continue block8;
                        dRDAStatement.initialize();
                        dRDAStatement.getStatement().clearWarnings();
                        try {
                            dRDAStatement.getStatement().executeUpdate(string);
                            continue block8;
                        }
                        catch (SQLException sQLException) {
                            if (sQLException.getSQLState().equals(SYNTAX_ERR)) {
                                bl2 = true;
                                continue block8;
                            }
                            throw sQLException;
                        }
                    }
                }
                this.invalidCodePoint(n);
            }
        } while (this.reader.isChainedWithSameID());
        if (!bl) {
            this.missingCodePoint(9236);
        }
        if (bl2) {
            object = new SQLWarning("One or more SET statements not recognized.", "01000");
            throw object;
        }
    }

    private boolean canIgnoreStmt(String string) {
        return string.indexOf("SET CLIENT") != -1;
    }

    private void writeRDBUPDRM() throws DRDAProtocolException {
        this.database.RDBUPDRM_sent = true;
        this.writer.createDssReply();
        this.writer.startDdm(8728);
        this.writer.writeScalar2Bytes(4425, 0);
        this.writeRDBNAM(this.database.getDatabaseName());
        this.writer.endDdmAndDss();
    }

    private String parsePKGNAMCT() throws DRDAProtocolException {
        this.reader.skipBytes();
        return null;
    }

    private Pkgnamcsn parsePKGNAMCSN() throws DRDAProtocolException {
        if (this.reader.getDdmLength() == 64L) {
            this.reader.readString(this.rdbnam, 18, true);
            if ((this.appRequester.getClientType() != 3 || this.appRequester.greaterThanOrEqualTo(10, 3, 0)) && !this.rdbnam.toString().equals(this.database.getDatabaseName())) {
                this.rdbnamMismatch(8467);
            }
            this.reader.readString(this.rdbcolid, 18, true);
            this.reader.readString(this.pkgid, 18, true);
            this.reader.readString(this.pkgcnstkn, 8, false);
            this.pkgsn = this.reader.readNetworkShort();
        } else {
            int n = this.reader.readNetworkShort();
            if (n < 18 || n > 255) {
                this.badObjectLength(8464);
            }
            this.reader.readString(this.rdbnam, n, true);
            if ((this.appRequester.getClientType() != 3 || this.appRequester.greaterThanOrEqualTo(10, 3, 0)) && !this.rdbnam.toString().equals(this.database.getDatabaseName())) {
                this.rdbnamMismatch(8467);
            }
            n = this.reader.readNetworkShort();
            this.reader.readString(this.rdbcolid, n, true);
            n = this.reader.readNetworkShort();
            if (n != 18) {
                this.badObjectLength(8457);
            }
            this.reader.readString(this.pkgid, 18, true);
            this.reader.readString(this.pkgcnstkn, 8, false);
            this.pkgsn = this.reader.readNetworkShort();
        }
        if (this.prevPkgnamcsn == null || this.rdbnam.wasModified() || this.rdbcolid.wasModified() || this.pkgid.wasModified() || this.pkgcnstkn.wasModified() || this.prevPkgnamcsn.getPkgsn() != this.pkgsn) {
            byte[] byArray = new byte[this.pkgcnstkn.length()];
            System.arraycopy(this.pkgcnstkn.getBytes(), 0, byArray, 0, byArray.length);
            this.prevPkgnamcsn = new Pkgnamcsn(this.rdbnam.toString(), this.rdbcolid.toString(), this.pkgid.toString(), this.pkgsn, new ConsistencyToken(byArray));
        }
        return this.prevPkgnamcsn;
    }

    private String parseSQLSTTDss() throws DRDAProtocolException {
        this.correlationID = this.reader.readDssHeader();
        int n = this.reader.readLengthAndCodePoint(false);
        String string = this.parseEncodedString();
        return string;
    }

    private String parseEncodedString() throws DRDAProtocolException {
        if (this.sqlamLevel < 7) {
            return this.parseVCMorVCS();
        }
        return this.parseNOCMorNOCS();
    }

    private String parseVCMorVCS() throws DRDAProtocolException {
        int n;
        String string = null;
        int n2 = this.reader.readNetworkShort();
        if (n2 > 0) {
            string = this.parseCcsidMBC(n2);
        }
        if ((n = this.reader.readNetworkShort()) > 0) {
            if (string != null) {
                this.agentError("Both VCM and VCS have lengths > 0");
            }
            string = this.parseCcsidSBC(n);
        }
        return string;
    }

    private String parseNOCMorNOCS() throws DRDAProtocolException {
        byte by;
        int n;
        byte by2 = this.reader.readByte();
        String string = null;
        if (by2 != -1) {
            n = this.reader.readNetworkInt();
            string = this.parseCcsidMBC(n);
        }
        if ((by = this.reader.readByte()) != -1) {
            if (string != null) {
                this.agentError("Both CM and CS are non null");
            }
            n = this.reader.readNetworkInt();
            string = this.parseCcsidSBC(n);
        }
        return string;
    }

    private String parseCcsidMBC(int n) throws DRDAProtocolException {
        String string = null;
        DRDAStatement dRDAStatement = this.database.getCurrentStatement();
        if (dRDAStatement == null) {
            dRDAStatement = this.database.getDefaultStatement();
            dRDAStatement.initialize();
        }
        String string2 = dRDAStatement.ccsidMBCEncoding;
        if (n == 0) {
            return null;
        }
        byte[] byArray = this.reader.readBytes(n);
        if (string2 != null) {
            try {
                string = new String(byArray, 0, n, string2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                this.agentError("Unsupported encoding " + string2 + "in parseCcsidMBC");
            }
        } else {
            this.agentError("Attempt to decode mixed byte string without CCSID being set");
        }
        return string;
    }

    private String parseCcsidSBC(int n) throws DRDAProtocolException {
        String string = null;
        DRDAStatement dRDAStatement = this.database.getCurrentStatement();
        if (dRDAStatement == null) {
            dRDAStatement = this.database.getDefaultStatement();
            dRDAStatement.initialize();
        }
        String string2 = dRDAStatement.ccsidSBCEncoding;
        System.out.println("ccsidSBCEncoding - " + string2);
        if (n == 0) {
            return null;
        }
        byte[] byArray = this.reader.readBytes(n);
        if (string2 != null) {
            try {
                string = new String(byArray, 0, n, string2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                this.agentError("Unsupported encoding " + string2 + "in parseCcsidSBC");
            }
        } else {
            this.agentError("Attempt to decode single byte string without CCSID being set");
        }
        return string;
    }

    private DRDAStatement parseCLSQRY() throws DRDAProtocolException, SQLException {
        DRDAStatement dRDAStatement;
        Pkgnamcsn pkgnamcsn = null;
        this.reader.markCollection();
        long l = 0L;
        boolean bl = false;
        int n = this.reader.getCodePoint();
        while (n != -1) {
            switch (n) {
                case 8464: {
                    this.setDatabase(8197);
                    break;
                }
                case 8467: {
                    pkgnamcsn = this.parsePKGNAMCSN();
                    break;
                }
                case 8539: {
                    l = this.reader.readNetworkLong();
                    bl = true;
                    break;
                }
                case 6400: {
                    this.parseMONITOR();
                    break;
                }
                default: {
                    this.invalidCodePoint(n);
                }
            }
            n = this.reader.getCodePoint();
        }
        if (pkgnamcsn == null) {
            this.missingCodePoint(8467);
        }
        if (this.sqlamLevel >= 7 && !bl) {
            this.missingCodePoint(8539);
        }
        if ((dRDAStatement = this.database.getDRDAStatement(pkgnamcsn)) == null) {
            this.invalidValue(8467);
        }
        if (dRDAStatement.wasExplicitlyClosed()) {
            pkgnamcsn = null;
        }
        dRDAStatement.CLSQRY();
        return dRDAStatement;
    }

    private void parseMONITOR() throws DRDAProtocolException {
        this.reader.skipBytes();
    }

    private void writeSQLCARDs(SQLException sQLException, int n) throws DRDAProtocolException {
        this.writeSQLCARDs(sQLException, n, false);
    }

    private void writeSQLCARDs(SQLException sQLException, int n, boolean bl) throws DRDAProtocolException {
        int n2 = 0;
        if (sQLException == null) {
            this.writeSQLCARD(sQLException, n2, n, 0L);
            return;
        }
        n2 = this.getExceptionSeverity(sQLException);
        if (n2 > 8) {
            this.writeCMDCHKRM(n2);
        } else if (bl) {
            this.writeSQLERRRM(n2);
        }
        this.writeSQLCARD(sQLException, n2, n, 0L);
    }

    private int getSqlCode(int n) {
        if (n == 4) {
            return 100;
        }
        if (n == 0) {
            return 0;
        }
        return -1;
    }

    private void writeSQLCARD(SQLException sQLException, int n, int n2, long l) throws DRDAProtocolException {
        String string;
        this.writer.createDssObject();
        this.writer.startDdm(9224);
        this.writeSQLCAGRP(sQLException, this.getSqlCode(n), n2, l);
        this.writer.endDdmAndDss();
        if (sQLException != null && (string = sQLException.getSQLState()).regionMatches(0, "XJ015.M", 0, 5)) {
            try {
                this.server.startNetworkServer();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void writeNullSQLCARDobject() throws DRDAProtocolException {
        this.writer.createDssObject();
        this.writer.startDdm(9224);
        this.writeSQLCAGRP(nullSQLState, 0, 0, 0L);
        this.writer.endDdmAndDss();
    }

    private void writeSQLERRRM(int n) throws DRDAProtocolException {
        this.writer.createDssReply();
        this.writer.startDdm(8723);
        this.writer.writeScalar2Bytes(4425, n);
        this.writer.endDdmAndDss();
    }

    private void writeCMDCHKRM(int n) throws DRDAProtocolException {
        this.writer.createDssReply();
        this.writer.startDdm(4692);
        this.writer.writeScalar2Bytes(4425, n);
        this.writer.endDdmAndDss();
    }

    private int getExceptionSeverity(SQLException sQLException) {
        int n = 0;
        if (sQLException == null) {
            return n;
        }
        int n2 = sQLException.getErrorCode();
        switch (n2) {
            case 20000: 
            case 30000: {
                n = 8;
                break;
            }
            case 10000: {
                n = 4;
                break;
            }
            case 40000: 
            case 45000: 
            case 50000: {
                n = 128;
                break;
            }
            default: {
                String string = sQLException.getSQLState();
                n = string != null && string.startsWith("01") ? 4 : 8;
            }
        }
        return n;
    }

    private void writeSQLCAGRP(SQLException sQLException, int n, int n2, long l) throws DRDAProtocolException {
        if (sQLException == null) {
            this.writeSQLCAGRP(nullSQLState, n, n2, l);
            return;
        }
        if (l < 0L && n2 < 0) {
            this.writer.writeByte(255);
            return;
        }
        this.writer.writeByte(0);
        this.writer.writeInt(n);
        this.writer.writeString(sQLException.getSQLState());
        this.writer.writeBytes(NetworkServerControlImpl.prdIdBytes_);
        this.writeSQLCAXGRP(n2, l, this.buildSqlerrmc(sQLException), sQLException.getNextException());
    }

    private void writeSQLCAGRP(byte[] byArray, int n, int n2, long l) throws DRDAProtocolException {
        if (l < 0L && n2 < 0) {
            this.writer.writeByte(255);
            return;
        }
        this.writer.writeByte(0);
        this.writer.writeInt(n);
        this.writer.writeBytes(byArray);
        this.writer.writeBytes(NetworkServerControlImpl.prdIdBytes_);
        this.writeSQLCAXGRP(n2, l, null, null);
    }

    private String buildSqlerrmc(SQLException sQLException) {
        int n;
        boolean bl = sQLException.getErrorCode() >= 40000;
        String string = null;
        sQLException = Util.getExceptionFactory().getArgumentFerry(sQLException);
        string = sQLException instanceof EmbedSQLException && !bl ? this.buildTokenizedSqlerrmc(sQLException) : this.buildPreformattedSqlerrmc(sQLException);
        int n2 = n = string == null ? -1 : Math.min(string.length(), this.appRequester.supportedMessageParamLength());
        if (n >= 0 && string.length() > n) {
            string = string.substring(0, n);
        }
        return string;
    }

    private String buildPreformattedSqlerrmc(SQLException sQLException) {
        if (sQLException == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        do {
            stringBuffer.append(sQLException.getLocalizedMessage());
            sQLException = sQLException.getNextException();
            if (sQLException == null) continue;
            stringBuffer.append(SQLERRMC_PREFORMATTED_MESSAGE_DELIMITER + "SQLSTATE: " + sQLException.getSQLState());
        } while (sQLException != null);
        return stringBuffer.toString();
    }

    private String buildTokenizedSqlerrmc(SQLException sQLException) {
        String string = "";
        do {
            CharSequence charSequence;
            if (sQLException instanceof EmbedSQLException) {
                charSequence = ((EmbedSQLException)sQLException).getMessageId();
                Object[] objectArray = ((EmbedSQLException)sQLException).getArguments();
                for (int i = 0; objectArray != null && i < objectArray.length; ++i) {
                    string = string + objectArray[i] + SQLERRMC_TOKEN_DELIMITER;
                }
                string = string + (String)charSequence;
                sQLException = sQLException.getNextException();
            } else {
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append(sQLException.getLocalizedMessage());
                sQLException = sQLException.getNextException();
                if (sQLException != null) {
                    ((StringBuffer)charSequence).append(SQLERRMC_TOKEN_DELIMITER + "SQLSTATE: " + sQLException.getSQLState());
                }
                string = string + ((StringBuffer)charSequence).toString();
            }
            if (sQLException == null) continue;
            string = string + SystemProcedures.SQLERRMC_MESSAGE_DELIMITER + sQLException.getSQLState() + ":";
        } while (sQLException != null);
        return string;
    }

    private void writeSQLCAXGRP(int n, long l, String string, SQLException sQLException) throws DRDAProtocolException {
        this.writer.writeByte(0);
        if (this.sqlamLevel < 7) {
            this.writeRDBNAM(this.database.getDatabaseName());
            this.writeSQLCAERRWARN(n, l);
        } else {
            this.writeSQLCAERRWARN(n, l);
            this.writer.writeShort(0);
        }
        this.writeVCMorVCS(string);
        if (this.sqlamLevel >= 7) {
            this.writeSQLDIAGGRP(sQLException);
        }
    }

    private void writeSQLCAERRWARN(int n, long l) {
        this.writer.writeInt((int)(l >>> 32));
        this.writer.writeInt((int)(l & 0xFFFFFFFFL));
        this.writer.writeInt(n);
        this.writer.writeBytes(errD4_D6);
        this.writer.writeBytes(warn0_warnA);
    }

    private void writeSQLDIAGGRP(SQLException sQLException) throws DRDAProtocolException {
        while (sQLException != null && sQLException.getSQLState() != "rwupd" && sQLException.getSQLState() != "02502") {
            sQLException = sQLException.getNextException();
        }
        if (sQLException == null || this.diagnosticLevel == -16) {
            this.writer.writeByte(255);
            return;
        }
        this.writer.writeByte(0);
        this.writeSQLDIAGSTT();
        this.writeSQLDIAGCI(sQLException);
        this.writeSQLDIAGCN();
    }

    private void writeSQLDIAGSTT() throws DRDAProtocolException {
        this.writer.writeByte(255);
    }

    private void writeSQLDIAGCI(SQLException sQLException) throws DRDAProtocolException {
        SQLException sQLException2;
        long l = 1L;
        this.writeSQLNUMROW(sQLException2);
        for (sQLException2 = sQLException; sQLException2 != null; sQLException2 = sQLException2.getNextException()) {
            Object object;
            String string = sQLException2.getSQLState();
            int n = this.getExceptionSeverity(sQLException2);
            int n2 = -1;
            if (n == 4) {
                n2 = 1;
            } else if (n == 0) {
                n2 = 0;
            }
            String string2 = "";
            if (this.diagnosticLevel == -15) {
                string2 = sQLException2.getLocalizedMessage();
            }
            if (this.diagnosticLevel == -16 && sQLException2 instanceof EmbedSQLException) {
                object = ((EmbedSQLException)sQLException2).getArguments();
                for (int i = 0; object != null && i < ((Object[])object).length; ++i) {
                    string2 = string2 + object[i].toString() + SQLERRMC_TOKEN_DELIMITER;
                }
            }
            object = null;
            if (this.database != null) {
                object = this.database.getDatabaseName();
            }
            this.writeSQLDCROW(l++, n2, string, (String)object, string2);
        }
    }

    private void writeSQLNUMROW(SQLException sQLException) throws DRDAProtocolException {
        this.writeSQLNUMGRP(sQLException);
    }

    private void writeSQLNUMGRP(SQLException sQLException) throws DRDAProtocolException {
        int n = 0;
        for (SQLException sQLException2 = sQLException; sQLException2 != null; sQLException2 = sQLException2.getNextException()) {
            ++n;
        }
        this.writer.writeShort(n);
    }

    private void writeSQLDCROW(long l, int n, String string, String string2, String string3) throws DRDAProtocolException {
        this.writeSQLDCGRP(l, n, string, string2, string3);
    }

    private void writeSQLDCGRP(long l, int n, String string, String string2, String string3) throws DRDAProtocolException {
        this.writer.writeInt(n);
        this.writer.writeString(string);
        this.writer.writeInt(0);
        this.writer.writeInt(0);
        this.writer.writeLong(l);
        byte[] byArray = new byte[1];
        this.writer.writeScalarPaddedBytes(byArray, 47, (byte)0);
        this.writer.writeShort(0);
        this.writer.writeByte(255);
        this.writer.writeLDString(string3);
        this.writeVCMorVCS(null);
        this.writeVCMorVCS(null);
        this.writeVCMorVCS(null);
        this.writer.writeByte(255);
    }

    private void writeSQLDIAGCN() throws DRDAProtocolException {
        this.writer.writeByte(255);
    }

    private void writeSQLDARD(DRDAStatement dRDAStatement, boolean bl, SQLException sQLException) throws DRDAProtocolException, SQLException {
        PreparedStatement preparedStatement = dRDAStatement.getPreparedStatement();
        ResultSetMetaData resultSetMetaData = preparedStatement.getMetaData();
        ParameterMetaData parameterMetaData = dRDAStatement.getParameterMetaData();
        int n = 0;
        if (sQLException == null || sQLException instanceof SQLWarning) {
            if (bl && resultSetMetaData != null) {
                n = resultSetMetaData.getColumnCount();
            } else if (!bl && parameterMetaData != null) {
                n = parameterMetaData.getParameterCount();
            }
        }
        this.writer.createDssObject();
        this.writer.startDdm(9233);
        this.writeSQLCAGRP(sQLException, this.getSqlCode(this.getExceptionSeverity(sQLException)), 0, 0L);
        if (this.sqlamLevel >= 7) {
            this.writeSQLDHROW(preparedStatement.getResultSetHoldability());
        }
        this.writer.writeShort(n);
        for (int i = 0; i < n; ++i) {
            this.writeSQLDAGRP(resultSetMetaData, parameterMetaData, i, bl);
        }
        this.writer.endDdmAndDss();
    }

    private void writeQRYDSC(DRDAStatement dRDAStatement, boolean bl) throws DRDAProtocolException, SQLException {
        ResultSet resultSet = null;
        ResultSetMetaData resultSetMetaData = null;
        ParameterMetaData parameterMetaData = null;
        if (!dRDAStatement.needsToSendParamData) {
            resultSet = dRDAStatement.getResultSet();
        }
        if (resultSet == null) {
            parameterMetaData = dRDAStatement.getParameterMetaData();
        } else {
            resultSetMetaData = resultSet.getMetaData();
        }
        int n = resultSetMetaData != null ? resultSetMetaData.getColumnCount() : parameterMetaData.getParameterCount();
        int n2 = 1;
        int n3 = 1;
        int n4 = n;
        int n5 = dRDAStatement.getBlksize() > 0 ? dRDAStatement.getBlksize() : 0xA00000;
        int n6 = n5 - this.writer.getDSSLength() % n5 - (3 + FdocaConstants.SQLCADTA_SQLDTARD_RLO_SIZE);
        int n7 = n6 / 3;
        if (n7 < n || n > 84) {
            if (n7 > 84) {
                n2 = n / 84;
                if (84 * n2 < n) {
                    ++n2;
                }
                n4 = 84;
            } else {
                n4 = n7;
                if (84 * (n2 += (n - n7) / 84) < n) {
                    ++n2;
                }
            }
        }
        if (!bl) {
            this.writer.createDssObject();
            this.writer.startDdm(9242);
        }
        for (int i = 0; i < n2; ++i) {
            this.writeSQLDTAGRP(dRDAStatement, resultSetMetaData, parameterMetaData, n3, n4, i == 0);
            n3 = n4 + 1;
            if ((n4 += 84) <= n) continue;
            n4 = n;
        }
        this.writer.writeBytes(FdocaConstants.SQLCADTA_SQLDTARD_RLO);
        if (!bl) {
            this.writer.endDdmAndDss();
        }
    }

    private void writeSQLDTAGRP(DRDAStatement dRDAStatement, ResultSetMetaData resultSetMetaData, ParameterMetaData parameterMetaData, int n, int n2, boolean bl) throws DRDAProtocolException, SQLException {
        int n3 = 3 * (n2 + 1 - n) + 3;
        this.writer.writeByte(n3);
        if (bl) {
            this.writer.writeByte(118);
            this.writer.writeByte(208);
        } else {
            this.writer.writeByte(127);
            this.writer.writeByte(0);
        }
        boolean bl2 = resultSetMetaData != null;
        for (int i = n; i <= n2; ++i) {
            boolean bl3 = bl2 ? resultSetMetaData.isNullable(i) == 1 : parameterMetaData.isNullable(i) == 1;
            int n4 = bl2 ? resultSetMetaData.getColumnType(i) : parameterMetaData.getParameterType(i);
            int[] nArray = new int[]{-1};
            int n5 = FdocaConstants.mapJdbcTypeToDrdaType(n4, bl3, this.appRequester, nArray);
            boolean bl4 = (n5 | 1) == 15;
            int n6 = 0;
            int n7 = 0;
            if (bl2) {
                n6 = resultSetMetaData.getPrecision(i);
                n7 = resultSetMetaData.getScale(i);
                dRDAStatement.setRsDRDAType(i, n5);
                dRDAStatement.setRsPrecision(i, n6);
                dRDAStatement.setRsScale(i, n7);
            } else if (bl4 && dRDAStatement.isOutputParam(i)) {
                n6 = parameterMetaData.getPrecision(i);
                n7 = parameterMetaData.getScale(i);
                ((CallableStatement)dRDAStatement.ps).registerOutParameter(i, 3, n7);
            }
            this.writer.writeByte(n5);
            if (bl4) {
                this.writer.writeByte(n6);
                this.writer.writeByte(n7);
                continue;
            }
            if (nArray[0] != -1) {
                this.writer.writeShort(nArray[0]);
                continue;
            }
            if (bl2) {
                this.writer.writeShort(resultSetMetaData.getColumnDisplaySize(i));
                continue;
            }
            this.writer.writeShort(dRDAStatement.getParamLen(i));
        }
    }

    private void writeSQLDHROW(int n) throws DRDAProtocolException, SQLException {
        if (JVMInfo.JDK_ID < 2) {
            this.writer.writeByte(255);
            return;
        }
        this.writer.writeByte(0);
        this.writer.writeShort(n);
        this.writer.writeShort(0);
        this.writer.writeShort(0);
        this.writer.writeShort(0);
        this.writer.writeShort(0);
        this.writer.writeShort(0);
        this.writer.writeShort(0);
        this.writeVCMorVCS(null);
    }

    private void writeQRYDTA(DRDAStatement dRDAStatement) throws DRDAProtocolException, SQLException {
        int n;
        boolean bl = true;
        boolean bl2 = false;
        int n2 = 0;
        this.writer.createDssObject();
        this.writer.startDdm(9243);
        if (this.processLeftoverQRYDTA(dRDAStatement)) {
            if (dRDAStatement.getSplitQRYDTA() == null) {
                ++dRDAStatement.rowCount;
                if (dRDAStatement.getExtDtaObjects() != null) {
                    this.writeEXTDTA(dRDAStatement);
                }
            }
            return;
        }
        while (bl) {
            bl2 = false;
            bl = this.writeFDODTA(dRDAStatement);
            if (dRDAStatement.getExtDtaObjects() != null && dRDAStatement.getSplitQRYDTA() == null) {
                this.writer.endDdmAndDss();
                this.writeEXTDTA(dRDAStatement);
                bl = false;
                bl2 = true;
            }
            if (!bl) continue;
            n = this.writer.getDSSLength();
            int n3 = n - n2;
            if (dRDAStatement.getBlksize() - n < n3) {
                bl = false;
            }
            n2 = n;
        }
        if (!bl2) {
            this.writer.endDdmAndDss();
        }
        if (!dRDAStatement.hasdata() && dRDAStatement.isRSCloseImplicit((n = this.appRequester.supportsQryclsimpForLmtblkprc()) != 0)) {
            dRDAStatement.rsClose();
        }
    }

    private boolean writeFDODTA(DRDAStatement dRDAStatement) throws DRDAProtocolException, SQLException {
        int n;
        boolean bl;
        boolean bl2 = false;
        int n2 = dRDAStatement.getBlksize() > 0 ? dRDAStatement.getBlksize() : 0xA00000;
        long l = 0L;
        ResultSet resultSet = null;
        boolean bl3 = bl = dRDAStatement.getQryprctyp() == 9239;
        if (!dRDAStatement.needsToSendParamData) {
            resultSet = dRDAStatement.getResultSet();
        }
        if (resultSet != null) {
            n = dRDAStatement.getNumRsCols();
            bl2 = dRDAStatement.isScrollable() ? this.positionCursor(dRDAStatement, resultSet) : resultSet.next();
        } else {
            bl2 = dRDAStatement.hasOutputParams();
            n = dRDAStatement.getDrdaParamCount();
        }
        do {
            boolean bl4;
            SQLWarning sQLWarning;
            SQLWarning sQLWarning2;
            if (!bl2) {
                this.doneData(dRDAStatement, resultSet);
                bl = false;
                return bl;
            }
            SQLWarning sQLWarning3 = sQLWarning2 = resultSet != null ? resultSet.getWarnings() : null;
            if (resultSet != null) {
                resultSet.clearWarnings();
            }
            if (resultSet != null && resultSet.rowUpdated()) {
                sQLWarning = new SQLWarning("", "rwupd", 10000);
                if (sQLWarning2 != null) {
                    sQLWarning2.setNextWarning(sQLWarning);
                } else {
                    sQLWarning2 = sQLWarning;
                }
            }
            if (resultSet != null && resultSet.rowDeleted()) {
                sQLWarning = new SQLWarning("", "02502", 10000);
                if (sQLWarning2 != null) {
                    sQLWarning2.setNextWarning(sQLWarning);
                } else {
                    sQLWarning2 = sQLWarning;
                }
            }
            if (sQLWarning2 == null) {
                this.writeSQLCAGRP(nullSQLState, 0, -1, -1L);
            } else {
                this.writeSQLCAGRP(sQLWarning2, sQLWarning2.getErrorCode(), 1, -1L);
            }
            boolean bl5 = bl4 = resultSet != null && (!dRDAStatement.getQryrtndta() || resultSet.rowDeleted());
            if (bl4) {
                this.writer.writeByte(255);
            } else {
                this.writer.writeByte(0);
            }
            block10: for (int i = 1; i <= n && !bl4; ++i) {
                boolean bl6;
                Object object;
                int n3;
                int n4;
                int n5;
                Object object2 = null;
                if (resultSet != null) {
                    n5 = dRDAStatement.getRsDRDAType(i) & 0xFF;
                    n4 = dRDAStatement.getRsPrecision(i);
                    n3 = dRDAStatement.getRsScale(i);
                    int n6 = n5 | 1;
                    switch (n6) {
                        case 201: 
                        case 207: {
                            object = EXTDTAInputStream.getEXTDTAStream(resultSet, i, n5);
                            this.writeFdocaVal(i, object, n5, n4, n3, ((EXTDTAInputStream)object).isNull(), dRDAStatement);
                            break;
                        }
                        case 3: {
                            int n7 = resultSet.getInt(i);
                            bl6 = resultSet.wasNull();
                            this.writeNullability(n5, bl6);
                            if (bl6) continue block10;
                            this.writer.writeInt(n7);
                            break;
                        }
                        case 5: {
                            short s = resultSet.getShort(i);
                            bl6 = resultSet.wasNull();
                            this.writeNullability(n5, bl6);
                            if (bl6) continue block10;
                            this.writer.writeShort(s);
                            break;
                        }
                        case 23: {
                            long l2 = resultSet.getLong(i);
                            bl6 = resultSet.wasNull();
                            this.writeNullability(n5, bl6);
                            if (bl6) continue block10;
                            this.writer.writeLong(l2);
                            break;
                        }
                        case 13: {
                            float f = resultSet.getFloat(i);
                            bl6 = resultSet.wasNull();
                            this.writeNullability(n5, bl6);
                            if (bl6) continue block10;
                            this.writer.writeFloat(f);
                            break;
                        }
                        case 11: {
                            double d = resultSet.getDouble(i);
                            bl6 = resultSet.wasNull();
                            this.writeNullability(n5, bl6);
                            if (bl6) continue block10;
                            this.writer.writeDouble(d);
                            break;
                        }
                        case 49: 
                        case 51: 
                        case 53: 
                        case 63: 
                        case 65: {
                            String string = resultSet.getString(i);
                            this.writeFdocaVal(i, string, n5, n4, n3, resultSet.wasNull(), dRDAStatement);
                            break;
                        }
                        default: {
                            object2 = this.getObjectForWriteFdoca(resultSet, i, n5);
                            this.writeFdocaVal(i, object2, n5, n4, n3, resultSet.wasNull(), dRDAStatement);
                            break;
                        }
                    }
                    continue;
                }
                n5 = dRDAStatement.getParamDRDAType(i) & 0xFF;
                n4 = dRDAStatement.getParamPrecision(i);
                n3 = dRDAStatement.getParamScale(i);
                if (dRDAStatement.isOutputParam(i)) {
                    object = new int[1];
                    n5 = FdocaConstants.mapJdbcTypeToDrdaType(dRDAStatement.getOutputParamType(i), true, this.appRequester, (int[])object);
                    n4 = dRDAStatement.getOutputParamPrecision(i);
                    n3 = dRDAStatement.getOutputParamScale(i);
                    object2 = this.getObjectForWriteFdoca((CallableStatement)dRDAStatement.ps, i, n5);
                    bl6 = object2 == null;
                    this.writeFdocaVal(i, object2, n5, n4, n3, bl6, dRDAStatement);
                    continue;
                }
                this.writeFdocaVal(i, null, n5, n4, n3, true, dRDAStatement);
            }
            if (this.writer.getDSSLength() > n2) {
                this.splitQRYDTA(dRDAStatement, n2);
                return false;
            }
            if (resultSet == null) {
                return bl;
            }
            if (++l < (long)dRDAStatement.getQryrowset()) {
                bl2 = resultSet.next();
                continue;
            }
            if (!dRDAStatement.isScrollable() && !bl4) continue;
            bl = false;
        } while (bl2 && l < (long)dRDAStatement.getQryrowset());
        if (!dRDAStatement.isScrollable()) {
            dRDAStatement.rowCount += l;
        }
        if (!bl2) {
            this.doneData(dRDAStatement, resultSet);
            bl = false;
        }
        if (!dRDAStatement.isScrollable()) {
            dRDAStatement.setHasdata(bl2);
        }
        return bl;
    }

    private Object getObjectForWriteFdoca(ResultSet resultSet, int n, int n2) throws SQLException {
        int n3 = n2 | 1;
        switch (n3) {
            case 33: {
                return resultSet.getDate(n, this.getGMTCalendar());
            }
            case 35: {
                return resultSet.getTime(n, this.getGMTCalendar());
            }
            case 37: {
                return resultSet.getTimestamp(n, this.getGMTCalendar());
            }
        }
        return resultSet.getObject(n);
    }

    private Object getObjectForWriteFdoca(CallableStatement callableStatement, int n, int n2) throws SQLException {
        int n3 = n2 | 1;
        switch (n3) {
            case 33: {
                return callableStatement.getDate(n, this.getGMTCalendar());
            }
            case 35: {
                return callableStatement.getTime(n, this.getGMTCalendar());
            }
            case 37: {
                return callableStatement.getTimestamp(n, this.getGMTCalendar());
            }
            case 201: 
            case 207: {
                return EXTDTAInputStream.getEXTDTAStream(callableStatement, n, n2);
            }
        }
        return callableStatement.getObject(n);
    }

    private void splitQRYDTA(DRDAStatement dRDAStatement, int n) throws SQLException, DRDAProtocolException {
        byte[] byArray = this.writer.copyDSSDataToEnd(n);
        this.writer.truncateDSS(n);
        if (byArray.length == 0) {
            this.agentError("LMTBLKPRC violation: splitQRYDTA was called to split a QRYDTA block, but the entire row fit successfully into the current block. Server rowsize computation was probably incorrect (perhaps an off-by-one bug?). QRYDTA blocksize: " + n);
        }
        dRDAStatement.setSplitQRYDTA(byArray);
    }

    private boolean processLeftoverQRYDTA(DRDAStatement dRDAStatement) throws SQLException, DRDAProtocolException {
        int n;
        byte[] byArray = dRDAStatement.getSplitQRYDTA();
        if (byArray == null) {
            return false;
        }
        int n2 = n = dRDAStatement.getBlksize() > 0 ? dRDAStatement.getBlksize() : 0xA00000;
        if (byArray.length < (n -= 10)) {
            this.writer.writeBytes(byArray, 0, byArray.length);
            dRDAStatement.setSplitQRYDTA(null);
        } else {
            this.writer.writeBytes(byArray, 0, n);
            byte[] byArray2 = new byte[byArray.length - n];
            for (int i = 0; i < byArray2.length; ++i) {
                byArray2[i] = byArray[n + i];
            }
            dRDAStatement.setSplitQRYDTA(byArray2);
        }
        this.writer.endDdmAndDss();
        return true;
    }

    private void doneData(DRDAStatement dRDAStatement, ResultSet resultSet) throws DRDAProtocolException, SQLException {
        boolean bl;
        int n;
        int n2 = n = dRDAStatement.getBlksize() > 0 ? dRDAStatement.getBlksize() : 0xA00000;
        if (resultSet != null) {
            if (dRDAStatement.isScrollable()) {
                bl = resultSet.isAfterLast();
                boolean bl2 = resultSet.isBeforeFirst();
                resultSet.last();
                dRDAStatement.rowCount = resultSet.getRow();
                if (bl) {
                    resultSet.afterLast();
                }
                if (bl2) {
                    resultSet.beforeFirst();
                }
            } else {
                bl = this.appRequester.supportsQryclsimpForLmtblkprc();
                if (dRDAStatement.isRSCloseImplicit(bl)) {
                    dRDAStatement.rsClose();
                    dRDAStatement.rsSuspend();
                }
            }
        }
        bl = dRDAStatement.getQryscrorn() == 3;
        this.writeSQLCAGRP(bl ? eod00000 : eod02000, bl ? 0 : 100, 0, dRDAStatement.rowCount);
        this.writer.writeByte(255);
        if (this.writer.getDSSLength() > n) {
            this.splitQRYDTA(dRDAStatement, n);
        }
    }

    private boolean positionCursor(DRDAStatement dRDAStatement, ResultSet resultSet) throws SQLException, DRDAProtocolException {
        boolean bl = false;
        switch (dRDAStatement.getQryscrorn()) {
            case 1: {
                int n = (int)dRDAStatement.getQryrownbr();
                if (resultSet.isAfterLast() && n > 0 || resultSet.isBeforeFirst() && n < 0) {
                    bl = false;
                    break;
                }
                bl = resultSet.relative(n);
                break;
            }
            case 2: {
                if (dRDAStatement.getQryrownbr() == 0L) {
                    resultSet.beforeFirst();
                    bl = false;
                    break;
                }
                bl = resultSet.absolute((int)dRDAStatement.getQryrownbr());
                break;
            }
            case 3: {
                resultSet.afterLast();
                bl = false;
                break;
            }
            case 4: {
                resultSet.beforeFirst();
                bl = false;
                break;
            }
            default: {
                this.agentError("Invalid value for cursor orientation " + dRDAStatement.getQryscrorn());
            }
        }
        return bl;
    }

    private void writeSQLDAGRP(ResultSetMetaData resultSetMetaData, ParameterMetaData parameterMetaData, int n, boolean bl) throws DRDAProtocolException, SQLException {
        int n2;
        int n3 = n + 1;
        int[] nArray = new int[]{-1};
        int n4 = bl ? resultSetMetaData.getColumnType(n3) : parameterMetaData.getParameterType(n3);
        int n5 = n2 = bl ? resultSetMetaData.getPrecision(n3) : parameterMetaData.getPrecision(n3);
        if (n2 > FdocaConstants.NUMERIC_MAX_PRECISION) {
            n2 = FdocaConstants.NUMERIC_MAX_PRECISION;
        }
        this.writer.writeShort(n2);
        int n6 = bl ? resultSetMetaData.getScale(n3) : parameterMetaData.getScale(n3);
        this.writer.writeShort(n6);
        boolean bl2 = bl ? resultSetMetaData.isNullable(n3) == 1 : parameterMetaData.isNullable(n3) == 1;
        int n7 = SQLTypes.mapJdbcTypeToDB2SqlType(n4, bl2, this.appRequester, nArray);
        if (nArray[0] == -1) {
            switch (n4) {
                case 2: 
                case 3: {
                    n6 = bl ? resultSetMetaData.getScale(n3) : parameterMetaData.getScale(n3);
                    nArray[0] = n2 << 8 | n6 << 0;
                    break;
                }
                default: {
                    nArray[0] = Math.min(FdocaConstants.LONGVARCHAR_MAX_LEN, bl ? resultSetMetaData.getColumnDisplaySize(n3) : parameterMetaData.getPrecision(n3));
                }
            }
        }
        switch (n4) {
            case -4: 
            case -3: 
            case -2: 
            case 2004: 
            case 2005: {
                int n8 = nArray[0] = bl ? resultSetMetaData.getPrecision(n3) : parameterMetaData.getPrecision(n3);
            }
        }
        if (this.sqlamLevel >= 6) {
            this.writer.writeLong(nArray[0]);
        } else {
            this.writer.writeInt(nArray[0]);
        }
        String string = bl ? resultSetMetaData.getColumnTypeName(n3) : parameterMetaData.getParameterTypeName(n3);
        this.writer.writeShort(n7);
        if (n4 == 1 || n4 == 12 || n4 == -1 || n4 == 2005) {
            this.writer.writeScalar2Bytes(1208);
        } else {
            this.writer.writeScalar2Bytes(0);
        }
        if (this.sqlamLevel < 7) {
            this.writeVCMorVCS(bl ? resultSetMetaData.getColumnName(n3) : null);
            this.writeVCMorVCS(null);
            this.writeVCMorVCS(null);
            if (this.sqlamLevel == 6) {
                this.writeSQLUDTGRP(resultSetMetaData, parameterMetaData, n3, bl);
            }
        } else {
            this.writeSQLDOPTGRP(resultSetMetaData, parameterMetaData, n3, bl);
        }
    }

    private void writeVCMorVCS(String string) throws DRDAProtocolException {
        if (string == null) {
            this.writer.writeShort(0);
            this.writer.writeShort(0);
            return;
        }
        this.writer.writeLDString(string);
        this.writer.writeShort(0);
    }

    private void writeSQLUDTGRP(ResultSetMetaData resultSetMetaData, ParameterMetaData parameterMetaData, int n, boolean bl) throws DRDAProtocolException, SQLException {
        int n2;
        int n3 = n2 = bl ? resultSetMetaData.getColumnType(n) : parameterMetaData.getParameterType(n);
        if (n2 != 2000 || !this.appRequester.supportsUDTs()) {
            this.writer.writeByte(255);
            return;
        }
        String string = bl ? resultSetMetaData.getColumnTypeName(n) : parameterMetaData.getParameterTypeName(n);
        String string2 = bl ? resultSetMetaData.getColumnClassName(n) : parameterMetaData.getParameterClassName(n);
        this.writeVCMorVCS(string);
        this.writeVCMorVCS(string2);
    }

    private void writeSQLDOPTGRP(ResultSetMetaData resultSetMetaData, ParameterMetaData parameterMetaData, int n, boolean bl) throws DRDAProtocolException, SQLException {
        this.writer.writeByte(0);
        this.writer.writeShort(0);
        this.writeVCMorVCS(bl ? resultSetMetaData.getColumnName(n) : null);
        this.writeVCMorVCS(null);
        this.writeVCMorVCS(null);
        this.writeSQLUDTGRP(resultSetMetaData, parameterMetaData, n, bl);
        this.writeSQLDXGRP(resultSetMetaData, parameterMetaData, n, bl);
    }

    private void writeSQLDXGRP(ResultSetMetaData resultSetMetaData, ParameterMetaData parameterMetaData, int n, boolean bl) throws DRDAProtocolException, SQLException {
        this.writer.writeByte(0);
        this.writer.writeShort(0);
        this.writer.writeShort(bl ? resultSetMetaData.isWritable(n) : false);
        if (bl && resultSetMetaData.isAutoIncrement(n)) {
            this.writer.writeShort(2);
        } else {
            this.writer.writeShort(0);
        }
        if (parameterMetaData != null && !bl) {
            int n2;
            int n3 = parameterMetaData.getParameterMode(n);
            if (n3 == 0 && (n2 = DRDAStatement.getOutputParameterTypeFromClassName(parameterMetaData.getParameterClassName(n))) != DRDAStatement.NOT_OUTPUT_PARAM) {
                n3 = 2;
            }
            this.writer.writeShort(n3);
        } else {
            this.writer.writeShort(0);
        }
        this.writer.writeShort(0);
        this.writeVCMorVCS(null);
        this.writeVCMorVCS(bl ? resultSetMetaData.getTableName(n) : null);
        this.writeVCMorVCS(bl ? resultSetMetaData.getSchemaName(n) : null);
        this.writeVCMorVCS(bl ? resultSetMetaData.getColumnName(n) : null);
    }

    protected void writeFdocaVal(int n, Object object, int n2, int n3, int n4, boolean bl, DRDAStatement dRDAStatement) throws DRDAProtocolException, SQLException {
        this.writeNullability(n2, bl);
        if (!bl) {
            int n5 = n2 | 1;
            long l = 0L;
            switch (n5) {
                case 191: {
                    this.writer.writeBoolean((Boolean)object);
                    break;
                }
                case 5: {
                    if (object instanceof Boolean) {
                        this.writer.writeShort((Boolean)object);
                        break;
                    }
                    if (object instanceof Short) {
                        this.writer.writeShort(((Short)object).shortValue());
                        break;
                    }
                    if (object instanceof Byte) {
                        this.writer.writeShort(((Byte)object).byteValue());
                        break;
                    }
                    this.writer.writeShort(((Integer)object).shortValue());
                    break;
                }
                case 3: {
                    this.writer.writeInt((Integer)object);
                    break;
                }
                case 23: {
                    this.writer.writeLong((Long)object);
                    break;
                }
                case 13: {
                    this.writer.writeFloat(((Float)object).floatValue());
                    break;
                }
                case 11: {
                    this.writer.writeDouble((Double)object);
                    break;
                }
                case 15: {
                    if (n3 == 0) {
                        n3 = FdocaConstants.NUMERIC_DEFAULT_PRECISION;
                    }
                    BigDecimal bigDecimal = (BigDecimal)object;
                    this.writer.writeBigDecimal(bigDecimal, n3, n4);
                    break;
                }
                case 33: {
                    this.writer.writeString(this.formatDate((Date)object));
                    break;
                }
                case 35: {
                    this.writer.writeString(this.formatTime((Time)object));
                    break;
                }
                case 37: {
                    this.writer.writeString(this.formatTimestamp((Timestamp)object));
                    break;
                }
                case 49: {
                    this.writer.writeString(((String)object).toString());
                    break;
                }
                case 51: 
                case 53: 
                case 63: 
                case 65: {
                    this.writer.writeLDString(object.toString(), n);
                    break;
                }
                case 201: 
                case 207: {
                    if (!((EXTDTAInputStream)object).isEmptyStream()) {
                        dRDAStatement.addExtDtaObject(object, n);
                        this.writer.writeExtendedLength(32768L);
                        break;
                    }
                    this.writer.writeExtendedLength(0L);
                    break;
                }
                case 39: {
                    this.writer.writeBytes((byte[])object);
                    break;
                }
                case 41: 
                case 43: {
                    this.writer.writeLDBytes((byte[])object, n);
                    break;
                }
                case 25: 
                case 27: {
                    this.writer.writeInt(((EngineLOB)object).getLocator());
                    break;
                }
                case 81: {
                    this.writer.writeUDT(object, n);
                    break;
                }
                default: {
                    this.writer.writeLDString(object.toString(), n);
                }
            }
        }
    }

    private void writeNullability(int n, boolean bl) {
        if (FdocaConstants.isNullable(n)) {
            if (bl) {
                this.writer.writeByte(255);
            } else {
                this.writer.writeByte(0);
            }
        }
    }

    private String formatDate(Date date) {
        Calendar calendar = this.getGMTCalendar();
        calendar.clear();
        calendar.setTime(date);
        char[] cArray = "YYYY-MM-DD".toCharArray();
        this.padInt(cArray, 0, 4, calendar.get(1));
        this.padInt(cArray, 5, 2, calendar.get(2) + 1);
        this.padInt(cArray, 8, 2, calendar.get(5));
        return new String(cArray);
    }

    private String formatTime(Time time) {
        Calendar calendar = this.getGMTCalendar();
        calendar.clear();
        calendar.setTime(time);
        char[] cArray = "HH:MM:SS".toCharArray();
        this.padInt(cArray, 0, 2, calendar.get(11));
        this.padInt(cArray, 3, 2, calendar.get(12));
        this.padInt(cArray, 6, 2, calendar.get(13));
        return new String(cArray);
    }

    private String formatTimestamp(Timestamp timestamp) {
        Calendar calendar = this.getGMTCalendar();
        calendar.clear();
        calendar.setTime(timestamp);
        char[] cArray = new char[this.appRequester.getTimestampLength()];
        this.padInt(cArray, 0, 4, calendar.get(1));
        cArray[4] = 45;
        this.padInt(cArray, 5, 2, calendar.get(2) + 1);
        cArray[7] = 45;
        this.padInt(cArray, 8, 2, calendar.get(5));
        cArray[10] = 45;
        this.padInt(cArray, 11, 2, calendar.get(11));
        cArray[13] = 46;
        this.padInt(cArray, 14, 2, calendar.get(12));
        cArray[16] = 46;
        this.padInt(cArray, 17, 2, calendar.get(13));
        cArray[19] = 46;
        int n = timestamp.getNanos();
        if (this.appRequester.supportsTimestampNanoseconds()) {
            this.padInt(cArray, 20, 9, n);
        } else {
            this.padInt(cArray, 20, 6, n / 1000);
        }
        return new String(cArray);
    }

    private void padInt(char[] cArray, int n, int n2, int n3) {
        for (int i = n + n2 - 1; i >= n; --i) {
            cArray[i] = Character.forDigit(n3 % 10, 10);
            n3 /= 10;
        }
    }

    private void copyToRequired(int[] nArray) {
        this.currentRequiredLength = nArray.length;
        if (this.currentRequiredLength > this.required.length) {
            this.required = new int[this.currentRequiredLength];
        }
        for (int i = 0; i < nArray.length; ++i) {
            this.required[i] = nArray[i];
        }
    }

    private void removeFromRequired(int n) {
        for (int i = 0; i < this.currentRequiredLength; ++i) {
            if (this.required[i] != n) continue;
            this.required[i] = 0;
        }
    }

    private void checkRequired(int n) throws DRDAProtocolException {
        int n2 = 0;
        for (int i = 0; i < this.currentRequiredLength; ++i) {
            if (this.required[i] == 0) continue;
            n2 = this.required[i];
            break;
        }
        if (n2 != 0) {
            this.missingCodePoint(n2);
        }
    }

    private void tooMany(int n) throws DRDAProtocolException {
        this.throwSyntaxrm(15, n);
    }

    private void tooBig(int n) throws DRDAProtocolException {
        this.throwSyntaxrm(9, n);
    }

    private void badObjectLength(int n) throws DRDAProtocolException {
        this.throwSyntaxrm(11, n);
    }

    private void rdbNotFound(String string) throws DRDAProtocolException {
        Object[] objectArray = new Object[]{string};
        throw new DRDAProtocolException(DRDAProtocolException.DRDA_Proto_RDBNFNRM, this, 0, 0, objectArray);
    }

    private void invalidValue(int n) throws DRDAProtocolException {
        this.throwSyntaxrm(20, n);
    }

    protected void invalidCodePoint(int n) throws DRDAProtocolException {
        this.throwSyntaxrm(29, n);
    }

    protected void codePointNotSupported(int n) throws DRDAProtocolException {
        throw new DRDAProtocolException(DRDAProtocolException.DRDA_Proto_CMDNSPRM, this, n, 0);
    }

    private void valueNotSupported(int n) throws DRDAProtocolException {
        throw new DRDAProtocolException(DRDAProtocolException.DRDA_Proto_VALNSPRM, this, n, 0);
    }

    private void verifyRequiredObject(int n, int n2) throws DRDAProtocolException {
        if (n != n2) {
            this.throwSyntaxrm(14, n);
        }
    }

    private void verifyInOrderACCSEC_SECCHK(int n, int n2) throws DRDAProtocolException {
        if (n != n2) {
            throw new DRDAProtocolException(DRDAProtocolException.DRDA_Proto_PRCCNVRM, this, n, 17);
        }
    }

    private void rdbnamMismatch(int n) throws DRDAProtocolException {
        throw new DRDAProtocolException(DRDAProtocolException.DRDA_Proto_PRCCNVRM, this, n, 18);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeSession() {
        if (this.session == null) {
            return;
        }
        if (this.xaProto != null) {
            this.xaProto.rollbackCurrentTransaction();
        }
        this.server.removeFromSessionTable(this.session.connNum);
        try {
            this.session.close();
        }
        catch (SQLException sQLException) {
            this.sendUnexpectedException(sQLException);
            this.close();
        }
        finally {
            this.session = null;
            this.database = null;
            this.appRequester = null;
            this.sockis = null;
            this.sockos = null;
            this.databaseAccessException = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleException(Exception exception) {
        try {
            if (exception instanceof DRDAProtocolException) {
                this.sendProtocolException((DRDAProtocolException)exception);
            } else {
                this.sendUnexpectedException(exception);
                this.server.consoleExceptionPrintTrace(exception);
            }
        }
        finally {
            this.closeSession();
            this.close();
        }
    }

    private void sendProtocolException(DRDAProtocolException dRDAProtocolException) {
        String string = null;
        if (this.database != null) {
            string = this.database.getDatabaseName();
        }
        try {
            DRDAConnThread.println2Log(string, this.session.drdaID, dRDAProtocolException.getMessage());
            this.server.consoleExceptionPrintTrace(dRDAProtocolException);
            this.reader.clearBuffer();
            dRDAProtocolException.write(this.writer);
            this.finalizeChain();
        }
        catch (DRDAProtocolException dRDAProtocolException2) {
            DRDAConnThread.println2Log(string, this.session.drdaID, dRDAProtocolException.getMessage());
            this.server.consoleExceptionPrintTrace(dRDAProtocolException2);
        }
    }

    private void sendUnexpectedException(Exception exception) {
        String string = null;
        try {
            if (this.database != null) {
                string = this.database.getDatabaseName();
            }
            DRDAConnThread.println2Log(string, this.session.drdaID, exception.getMessage());
            this.server.consoleExceptionPrintTrace(exception);
            DRDAProtocolException dRDAProtocolException = DRDAProtocolException.newAgentError(this, 64, string, exception.getMessage());
            this.reader.clearBuffer();
            dRDAProtocolException.write(this.writer);
            this.finalizeChain();
        }
        catch (DRDAProtocolException dRDAProtocolException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean closed() {
        Object object = this.closeSync;
        synchronized (object) {
            return this.close;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getLogConnections() {
        Object object = this.logConnectionsSync;
        synchronized (object) {
            return this.logConnections;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getTimeSlice() {
        Object object = this.timeSliceSync;
        synchronized (object) {
            return this.timeSlice;
        }
    }

    protected void trace(String string) {
    }

    private void traceEXTDTARead(int n, int n2, EXTDTAReaderInputStream eXTDTAReaderInputStream, boolean bl, String string) {
    }

    public static void showmem() {
        Runtime runtime = null;
        java.util.Date date = null;
        runtime = Runtime.getRuntime();
        runtime.gc();
        date = new java.util.Date();
        System.out.println("total memory: " + runtime.totalMemory() + " free: " + runtime.freeMemory() + " " + date.toString());
    }

    private String convertToHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("0x");
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i] & 0xFF;
            String string = Integer.toHexString(n);
            if (string.length() < 2) {
                stringBuffer.append("0");
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    private void checkValidTypDefNam(String string) throws DRDAProtocolException {
        if (string.equals("QTDSQL370")) {
            return;
        }
        if (string.equals("QTDSQL400")) {
            return;
        }
        if (string.equals("QTDSQLX86")) {
            return;
        }
        if (string.equals("QTDSQLASC")) {
            return;
        }
        if (string.equals("QTDSQLVAX")) {
            return;
        }
        if (string.equals("QTDSQLJVM")) {
            return;
        }
        this.invalidValue(47);
    }

    private void checkLength(int n, int n2) throws DRDAProtocolException {
        long l = this.reader.getDdmLength();
        if (l < (long)n2) {
            this.badObjectLength(n);
        } else if (l > (long)n2) {
            this.tooBig(n);
        }
    }

    private boolean readBoolean(int n) throws DRDAProtocolException {
        this.checkLength(n, 1);
        byte by = this.reader.readByte();
        if (by == -15) {
            return true;
        }
        if (by == -16) {
            return false;
        }
        this.invalidValue(n);
        return false;
    }

    private void initializeDatabase(String string) {
        Database database = this.appRequester.isXARequester() ? new XADatabase(string) : new Database(string);
        if (string != null) {
            this.session.addDatabase(database);
            this.session.database = database;
        }
        this.database = database;
    }

    private void setDatabase(int n) throws DRDAProtocolException {
        String string = this.parseRDBNAM();
        if (this.database != null && this.database.getDatabaseName().equals(string)) {
            return;
        }
        Database database = this.session.getDatabase(string);
        if (database == null) {
            this.rdbnamMismatch(n);
        } else {
            this.database = database;
        }
        this.session.database = database;
    }

    private void writeENDUOWRM(int n) {
        this.writer.createDssReply();
        this.writer.startDdm(8716);
        this.writer.writeScalar2Bytes(4425, 4);
        this.writer.writeScalar1Byte(8469, n);
        this.writer.endDdmAndDss();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeEXTDTA(DRDAStatement dRDAStatement) throws SQLException, DRDAProtocolException {
        ArrayList arrayList = dRDAStatement.getExtDtaObjects();
        if (arrayList == null) {
            return;
        }
        boolean bl = false;
        for (int i = 0; i < arrayList.size(); ++i) {
            Object e;
            boolean bl2;
            boolean bl3;
            if (i != arrayList.size() - 1) {
                bl3 = true;
                bl2 = true;
            } else {
                bl3 = false;
                bl2 = false;
            }
            if (this.sqlamLevel >= 7 && dRDAStatement.isExtDtaValueNullable(i)) {
                bl = true;
            }
            if (!((e = arrayList.get(i)) instanceof EXTDTAInputStream)) continue;
            EXTDTAInputStream eXTDTAInputStream = (EXTDTAInputStream)e;
            try {
                eXTDTAInputStream.initInputStream();
                this.writer.writeScalarStream(bl2, 5228, eXTDTAInputStream, bl);
                continue;
            }
            finally {
                DRDAConnThread.closeStream(eXTDTAInputStream);
            }
        }
        dRDAStatement.clearExtDtaObjects();
    }

    private void checkWarning(Connection connection, Statement statement, ResultSet resultSet, int n, boolean bl, boolean bl2) throws DRDAProtocolException, SQLException {
        SQLWarning sQLWarning = null;
        SQLWarning sQLWarning2 = null;
        try {
            if (statement != null && (sQLWarning = statement.getWarnings()) != null) {
                statement.clearWarnings();
                sQLWarning2 = sQLWarning;
            }
            if (resultSet != null && (sQLWarning = resultSet.getWarnings()) != null) {
                resultSet.clearWarnings();
                if (sQLWarning2 == null) {
                    sQLWarning2 = sQLWarning;
                }
            }
            if (connection != null && (sQLWarning = connection.getWarnings()) != null) {
                connection.clearWarnings();
                if (sQLWarning2 == null) {
                    sQLWarning2 = sQLWarning;
                }
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if ((bl || sQLWarning2 != null) && bl2) {
            this.writeSQLCARDs(sQLWarning2, n);
        }
    }

    boolean hasSession() {
        return this.session != null;
    }

    long getBytesRead() {
        return this.reader.totalByteCount;
    }

    long getBytesWritten() {
        return this.writer.totalByteCount;
    }

    protected String buildRuntimeInfo(String string, LocalizedResource localizedResource) {
        String string2 = "";
        if (!this.hasSession()) {
            return string2;
        }
        string2 = string2 + this.session.buildRuntimeInfo("", localizedResource);
        string2 = string2 + "\n";
        return string2;
    }

    private void finalizeChain() throws DRDAProtocolException {
        this.writer.finalizeChain(this.reader.getCurrChainState(), this.getOutputStream());
    }

    private int validateSecMecUSRSSBPWD() throws DRDAProtocolException {
        String string;
        String string2 = null;
        AuthenticationService authenticationService = null;
        org.apache.derby.iapi.db.Database database = null;
        String string3 = this.appRequester.srvrlslv;
        if (string3 == null || string3.length() == 0 || string3.length() < 8 || string3.indexOf("DNC") == -1) {
            return 1;
        }
        this.appRequester.setClientVersion(string3.substring(0, 8));
        if (!this.appRequester.supportsSecMecUSRSSBPWD()) {
            return 1;
        }
        string2 = this.database.getShortDbName();
        if (string2 == null || string2.length() == 0) {
            authenticationService = ((InternalDriver)((Object)NetworkServerControlImpl.getDriver())).getAuthenticationService();
        } else {
            if (Monitor.getMonitor() != null) {
                database = (org.apache.derby.iapi.db.Database)Monitor.findService("org.apache.derby.database.Database", string2);
            }
            if (database == null) {
                this.database.makeDummyConnection();
                database = (org.apache.derby.iapi.db.Database)Monitor.findService("org.apache.derby.database.Database", string2);
            }
            try {
                if (database != null) {
                    authenticationService = database.getAuthenticationService();
                }
            }
            catch (StandardException standardException) {
                DRDAConnThread.println2Log(null, this.session.drdaID, standardException.getMessage());
                return 10;
            }
        }
        if (authenticationService != null && !(string = authenticationService.getClass().getName()).equals(AUTHENTICATION_PROVIDER_BUILTIN_CLASS) && !string.equals(AUTHENTICATION_PROVIDER_NONE_CLASS)) {
            return 1;
        }
        try {
            this.myTargetSeed = decryptionManager.generateSeed();
            this.database.secTokenOut = this.myTargetSeed;
        }
        catch (SQLException sQLException) {
            DRDAConnThread.println2Log(null, this.session.drdaID, sQLException.getMessage());
            return 10;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int peekStream(EXTDTAInputStream eXTDTAInputStream) throws IOException {
        eXTDTAInputStream.mark(1);
        try {
            int n = eXTDTAInputStream.read();
            return n;
        }
        finally {
            eXTDTAInputStream.reset();
        }
    }

    private static void closeStream(InputStream inputStream) {
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            Util.javaException(iOException);
        }
    }

    private static InputStream convertAsByteArrayInputStream(EXTDTAReaderInputStream eXTDTAReaderInputStream) throws IOException {
        eXTDTAReaderInputStream.setSuppressException(true);
        int n = eXTDTAReaderInputStream instanceof StandardEXTDTAReaderInputStream ? (int)((StandardEXTDTAReaderInputStream)eXTDTAReaderInputStream).getLength() : 1 + eXTDTAReaderInputStream.available();
        PublicBufferOutputStream publicBufferOutputStream = new PublicBufferOutputStream(n);
        byte[] byArray = new byte[Math.min(n, 32768)];
        int n2 = 0;
        while ((n2 = eXTDTAReaderInputStream.read(byArray, 0, byArray.length)) > -1) {
            publicBufferOutputStream.write(byArray, 0, n2);
        }
        if (eXTDTAReaderInputStream.isStatusSet() && eXTDTAReaderInputStream.getStatus() != 127) {
            return new FailingEXTDTAInputStream(eXTDTAReaderInputStream.getStatus());
        }
        return new ByteArrayInputStream(publicBufferOutputStream.getBuffer(), 0, publicBufferOutputStream.getCount());
    }

    private static void setAsCharacterStream(DRDAStatement dRDAStatement, int n, EXTDTAReaderInputStream eXTDTAReaderInputStream, boolean bl, String string) throws IOException, SQLException {
        PreparedStatement preparedStatement = dRDAStatement.getPreparedStatement();
        EnginePreparedStatement enginePreparedStatement = (EnginePreparedStatement)preparedStatement;
        if (bl) {
            dRDAStatement.setStreamedParameter(eXTDTAReaderInputStream);
        }
        InputStream inputStream = bl ? eXTDTAReaderInputStream : DRDAConnThread.convertAsByteArrayInputStream(eXTDTAReaderInputStream);
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, string);
        enginePreparedStatement.setCharacterStream(n, inputStreamReader);
    }

    private static void setAsBinaryStream(DRDAStatement dRDAStatement, int n, EXTDTAReaderInputStream eXTDTAReaderInputStream, boolean bl) throws IOException, SQLException {
        int n2 = dRDAStatement.getParameterMetaData().getParameterType(n);
        boolean bl2 = n2 == 2004;
        PreparedStatement preparedStatement = dRDAStatement.getPreparedStatement();
        if (bl && bl2) {
            dRDAStatement.setStreamedParameter(eXTDTAReaderInputStream);
            if (eXTDTAReaderInputStream == null) {
                preparedStatement.setBytes(n, null);
            } else if (!eXTDTAReaderInputStream.isLayerBStream()) {
                int n3 = (int)((StandardEXTDTAReaderInputStream)eXTDTAReaderInputStream).getLength();
                preparedStatement.setBinaryStream(n, (InputStream)eXTDTAReaderInputStream, n3);
            } else {
                ((EnginePreparedStatement)preparedStatement).setBinaryStream(n, eXTDTAReaderInputStream);
            }
        } else if (eXTDTAReaderInputStream == null) {
            preparedStatement.setBytes(n, null);
        } else {
            InputStream inputStream = DRDAConnThread.convertAsByteArrayInputStream(eXTDTAReaderInputStream);
            preparedStatement.setBinaryStream(n, inputStream, inputStream.available());
        }
    }

    static {
        eod00000 = new byte[]{48, 48, 48, 48, 48};
        eod02000 = new byte[]{48, 50, 48, 48, 48};
        nullSQLState = new byte[]{32, 32, 32, 32, 32};
        errD4_D6 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        warn0_warnA = new byte[]{32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32};
        dummy = new DRDAProtocolExceptionInfo(0, 0, 0, false);
        SQLERRMC_TOKEN_DELIMITER = new String(new char[]{'\u0014'});
        SQLERRMC_PREFORMATTED_MESSAGE_DELIMITER = new String("::");
    }

    private static class PublicBufferOutputStream
    extends ByteArrayOutputStream {
        PublicBufferOutputStream(int n) {
            super(n);
        }

        public byte[] getBuffer() {
            return this.buf;
        }

        public int getCount() {
            return this.count;
        }
    }
}

