/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.connectors.webcrawler;

import java.util.HashMap;
import java.util.Map;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.crawler.system.Logging;

public class BasicParseState {
    protected static final int BASICPARSESTATE_NORMAL = 0;
    protected static final int BASICPARSESTATE_SAWLEFTBRACKET = 1;
    protected static final int BASICPARSESTATE_SAWEXCLAMATION = 2;
    protected static final int BASICPARSESTATE_SAWDASH = 3;
    protected static final int BASICPARSESTATE_IN_COMMENT = 4;
    protected static final int BASICPARSESTATE_SAWCOMMENTDASH = 5;
    protected static final int BASICPARSESTATE_SAWSECONDCOMMENTDASH = 6;
    protected static final int BASICPARSESTATE_IN_TAG_NAME = 7;
    protected static final int BASICPARSESTATE_IN_ATTR_NAME = 8;
    protected static final int BASICPARSESTATE_IN_ATTR_VALUE = 9;
    protected static final int BASICPARSESTATE_IN_TAG_SAW_SLASH = 10;
    protected static final int BASICPARSESTATE_IN_END_TAG_NAME = 11;
    protected static final int BASICPARSESTATE_IN_ATTR_LOOKING_FOR_VALUE = 12;
    protected static final int BASICPARSESTATE_IN_SINGLE_QUOTES_ATTR_VALUE = 13;
    protected static final int BASICPARSESTATE_IN_DOUBLE_QUOTES_ATTR_VALUE = 14;
    protected static final int BASICPARSESTATE_IN_UNQUOTED_ATTR_VALUE = 15;
    protected int currentState = 0;
    protected StringBuffer currentTagNameBuffer = null;
    protected StringBuffer currentAttrNameBuffer = null;
    protected StringBuffer currentValueBuffer = null;
    protected String currentTagName = null;
    protected String currentAttrName = null;
    protected Map currentAttrMap = null;
    protected static final Map mapLookup = new HashMap();

    public void dealWithCharacter(char thisChar) throws ManifoldCFException {
        char thisCharLower = Character.toLowerCase(thisChar);
        switch (this.currentState) {
            case 0: {
                if (thisChar != '<') break;
                this.currentState = 1;
                break;
            }
            case 1: {
                if (thisChar == '!') {
                    this.currentState = 2;
                    break;
                }
                if (thisChar == '/') {
                    this.currentState = 11;
                    this.currentTagNameBuffer = new StringBuffer();
                    break;
                }
                this.currentState = 7;
                this.currentTagNameBuffer = new StringBuffer();
                if (BasicParseState.isHTMLWhitespace(thisChar)) break;
                this.currentTagNameBuffer.append(thisCharLower);
                break;
            }
            case 2: {
                if (thisChar == '-') {
                    this.currentState = 3;
                    break;
                }
                this.currentState = 0;
                break;
            }
            case 3: {
                if (thisChar == '-') {
                    this.currentState = 4;
                    break;
                }
                this.currentState = 0;
                break;
            }
            case 4: {
                if (thisChar != '-') break;
                this.currentState = 5;
                break;
            }
            case 5: {
                if (thisChar == '-') {
                    this.currentState = 6;
                    break;
                }
                this.currentState = 4;
                break;
            }
            case 6: {
                if (thisChar == '>') {
                    this.currentState = 0;
                    break;
                }
                if (thisChar == '-') break;
                this.currentState = 4;
                break;
            }
            case 7: {
                if (BasicParseState.isHTMLWhitespace(thisChar)) {
                    if (this.currentTagNameBuffer.length() <= 0) break;
                    this.currentTagName = this.currentTagNameBuffer.toString();
                    this.currentTagNameBuffer = null;
                    this.currentAttrMap = new HashMap();
                    this.currentState = 8;
                    this.currentAttrNameBuffer = new StringBuffer();
                    break;
                }
                if (thisChar == '/') {
                    if (this.currentTagNameBuffer.length() > 0) {
                        this.currentTagName = this.currentTagNameBuffer.toString();
                        this.currentTagNameBuffer = null;
                        this.currentAttrMap = new HashMap();
                        this.currentState = 10;
                        this.noteTag(this.currentTagName, this.currentAttrMap);
                        break;
                    }
                    this.currentState = 0;
                    this.currentTagNameBuffer = null;
                    break;
                }
                if (thisChar == '>') {
                    if (this.currentTagNameBuffer.length() > 0) {
                        this.currentTagName = this.currentTagNameBuffer.toString();
                        this.currentTagNameBuffer = null;
                        this.currentAttrMap = new HashMap();
                    }
                    if (this.currentTagName != null) {
                        this.noteTag(this.currentTagName, this.currentAttrMap);
                    }
                    this.currentState = 0;
                    this.currentTagName = null;
                    this.currentAttrMap = null;
                    break;
                }
                this.currentTagNameBuffer.append(thisCharLower);
                break;
            }
            case 8: {
                if (BasicParseState.isHTMLWhitespace(thisChar)) {
                    if (this.currentAttrNameBuffer.length() <= 0) break;
                    this.currentAttrName = this.currentAttrNameBuffer.toString();
                    this.currentAttrNameBuffer = null;
                    this.currentState = 12;
                    break;
                }
                if (thisChar == '=') {
                    if (this.currentAttrNameBuffer.length() <= 0) break;
                    this.currentAttrName = this.currentAttrNameBuffer.toString();
                    this.currentAttrNameBuffer = null;
                    this.currentState = 9;
                    this.currentValueBuffer = new StringBuffer();
                    break;
                }
                if (thisChar == '/') {
                    if (this.currentAttrNameBuffer.length() > 0) {
                        this.currentAttrName = this.currentAttrNameBuffer.toString();
                        this.currentAttrNameBuffer = null;
                    }
                    if (this.currentAttrName != null) {
                        this.currentAttrMap.put(this.currentAttrName, "");
                        this.currentAttrName = null;
                    }
                    this.noteTag(this.currentTagName, this.currentAttrMap);
                    this.currentState = 10;
                    break;
                }
                if (thisChar == '>') {
                    if (this.currentAttrNameBuffer.length() > 0) {
                        this.currentAttrName = this.currentAttrNameBuffer.toString();
                        this.currentAttrNameBuffer = null;
                    }
                    if (this.currentAttrName != null) {
                        this.currentAttrMap.put(this.currentAttrName, "");
                        this.currentAttrName = null;
                    }
                    this.currentState = 0;
                    this.noteTag(this.currentTagName, this.currentAttrMap);
                    this.currentTagName = null;
                    this.currentAttrMap = null;
                    break;
                }
                this.currentAttrNameBuffer.append(thisCharLower);
                break;
            }
            case 12: {
                if (thisChar == '=') {
                    this.currentState = 9;
                    this.currentValueBuffer = new StringBuffer();
                    break;
                }
                if (thisChar == '>') {
                    this.currentState = 0;
                    this.noteTag(this.currentTagName, this.currentAttrMap);
                    this.currentTagName = null;
                    this.currentAttrMap = null;
                    break;
                }
                if (thisChar == '/') {
                    this.currentState = 10;
                    this.currentAttrMap.put(this.currentAttrName, "");
                    this.currentAttrName = null;
                    this.noteTag(this.currentTagName, this.currentAttrMap);
                    break;
                }
                if (BasicParseState.isHTMLWhitespace(thisChar)) break;
                this.currentAttrMap.put(this.currentAttrName, "");
                this.currentState = 8;
                this.currentAttrNameBuffer = new StringBuffer();
                this.currentAttrNameBuffer.append(thisCharLower);
                this.currentAttrName = null;
                break;
            }
            case 9: {
                if (thisChar == '\'') {
                    this.currentState = 13;
                    break;
                }
                if (thisChar == '\"') {
                    this.currentState = 14;
                    break;
                }
                if (BasicParseState.isHTMLWhitespace(thisChar)) break;
                this.currentState = 15;
                this.currentValueBuffer.append(thisChar);
                break;
            }
            case 10: {
                if (thisChar != '>') break;
                this.noteEndTag(this.currentTagName);
                this.currentState = 0;
                this.currentTagName = null;
                this.currentAttrMap = null;
                break;
            }
            case 11: {
                if (BasicParseState.isHTMLWhitespace(thisChar)) {
                    if (this.currentTagNameBuffer == null || this.currentTagNameBuffer.length() <= 0) break;
                    this.currentTagName = this.currentTagNameBuffer.toString();
                    this.currentTagNameBuffer = null;
                    break;
                }
                if (thisChar == '>') {
                    if (this.currentTagNameBuffer != null && this.currentTagNameBuffer.length() > 0) {
                        this.currentTagName = this.currentTagNameBuffer.toString();
                        this.currentTagNameBuffer = null;
                    }
                    if (this.currentTagName != null) {
                        this.noteEndTag(this.currentTagName);
                    }
                    this.currentTagName = null;
                    this.currentState = 0;
                    break;
                }
                if (this.currentTagNameBuffer == null) break;
                this.currentTagNameBuffer.append(thisCharLower);
                break;
            }
            case 13: {
                if (thisChar == '\'' || thisChar == '\n' || thisChar == '\r') {
                    this.currentAttrMap.put(this.currentAttrName, BasicParseState.htmlAttributeDecode(this.currentValueBuffer.toString()));
                    this.currentAttrName = null;
                    this.currentValueBuffer = null;
                    this.currentState = 8;
                    this.currentAttrNameBuffer = new StringBuffer();
                    break;
                }
                this.currentValueBuffer.append(thisChar);
                break;
            }
            case 14: {
                if (thisChar == '\"' || thisChar == '\n' || thisChar == '\r') {
                    this.currentAttrMap.put(this.currentAttrName, BasicParseState.htmlAttributeDecode(this.currentValueBuffer.toString()));
                    this.currentAttrName = null;
                    this.currentValueBuffer = null;
                    this.currentState = 8;
                    this.currentAttrNameBuffer = new StringBuffer();
                    break;
                }
                this.currentValueBuffer.append(thisChar);
                break;
            }
            case 15: {
                if (BasicParseState.isHTMLWhitespace(thisChar)) {
                    this.currentAttrMap.put(this.currentAttrName, BasicParseState.htmlAttributeDecode(this.currentValueBuffer.toString()));
                    this.currentAttrName = null;
                    this.currentValueBuffer = null;
                    this.currentState = 8;
                    this.currentAttrNameBuffer = new StringBuffer();
                    break;
                }
                if (thisChar == '/') {
                    this.currentAttrMap.put(this.currentAttrName, BasicParseState.htmlAttributeDecode(this.currentValueBuffer.toString()));
                    this.noteTag(this.currentTagName, this.currentAttrMap);
                    this.currentState = 10;
                    break;
                }
                if (thisChar == '>') {
                    this.currentAttrMap.put(this.currentAttrName, BasicParseState.htmlAttributeDecode(this.currentValueBuffer.toString()));
                    this.currentAttrName = null;
                    this.currentValueBuffer = null;
                    this.currentState = 0;
                    this.noteTag(this.currentTagName, this.currentAttrMap);
                    this.currentTagName = null;
                    this.currentAttrMap = null;
                    break;
                }
                this.currentValueBuffer.append(thisChar);
                break;
            }
            default: {
                throw new ManifoldCFException("Invalid state: " + Integer.toString(this.currentState));
            }
        }
    }

    protected void noteTag(String tagName, Map attributes) throws ManifoldCFException {
        Logging.connectors.debug((Object)(" Saw tag '" + tagName + "'"));
    }

    protected void noteEndTag(String tagName) throws ManifoldCFException {
        Logging.connectors.debug((Object)(" Saw end tag '" + tagName + "'"));
    }

    public void finishUp() throws ManifoldCFException {
    }

    protected static String htmlAttributeDecode(String input) {
        StringBuffer output = new StringBuffer();
        int i = 0;
        while (i < input.length()) {
            String chunk;
            String replacement;
            int index;
            char x;
            if ((x = input.charAt(i++)) == '&' && (index = input.indexOf(";", i)) != -1 && (replacement = BasicParseState.mapChunk(chunk = input.substring(i, index))) != null) {
                output.append(replacement);
                i = index + 1;
                continue;
            }
            output.append(x);
        }
        return output.toString();
    }

    protected static String mapChunk(String input) {
        if (input.startsWith("#")) {
            try {
                int value = Integer.parseInt(input.substring(1));
                StringBuffer sb = new StringBuffer();
                sb.append((char)value);
                return sb.toString();
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return (String)mapLookup.get(input);
    }

    protected static boolean isHTMLWhitespace(char x) {
        return x <= ' ';
    }

    static {
        mapLookup.put("amp", "&");
        mapLookup.put("lt", "<");
        mapLookup.put("gt", ">");
        mapLookup.put("quot", "\"");
    }
}

