/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.connectors.webcrawler;

import java.util.HashMap;
import java.util.Map;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.crawler.connectors.webcrawler.IHTMLHandler;
import org.apache.manifoldcf.crawler.connectors.webcrawler.LinkParseState;

public class FormParseState
extends LinkParseState {
    protected static final int FORMPARSESTATE_NORMAL = 0;
    protected static final int FORMPARSESTATE_IN_FORM = 1;
    protected static final int FORMPARSESTATE_IN_SELECT = 2;
    protected static final int FORMPARSESTATE_IN_TEXTAREA = 3;
    protected int formParseState = 0;
    protected String selectName = null;
    protected String selectMultiple = null;

    public FormParseState(IHTMLHandler handler) {
        super(handler);
    }

    protected void noteNonscriptTag(String tagName, Map attributes) throws ManifoldCFException {
        super.noteNonscriptTag(tagName, attributes);
        switch (this.formParseState) {
            case 0: {
                if (!tagName.equals("form")) break;
                this.formParseState = 1;
                this.handler.noteFormStart(attributes);
                break;
            }
            case 1: {
                if (tagName.equals("input")) {
                    String type = (String)attributes.get("type");
                    if (type == null || type.toLowerCase().equals("button") || type.toLowerCase().equals("reset") || type.toLowerCase().equals("image")) break;
                    this.handler.noteFormInput(attributes);
                    break;
                }
                if (tagName.equals("select")) {
                    this.selectName = (String)attributes.get("name");
                    this.selectMultiple = (String)attributes.get("multiple");
                    this.formParseState = 2;
                    break;
                }
                if (tagName.equals("textarea")) {
                    this.formParseState = 3;
                    HashMap<String, String> textareaMap = new HashMap<String, String>();
                    textareaMap.put("type", "textarea");
                    textareaMap.put("value", "");
                    this.handler.noteFormInput(textareaMap);
                    break;
                }
                if (tagName.equals("button")) {
                    String type = (String)attributes.get("type");
                    if (type != null && !type.toLowerCase().equals("submit")) break;
                    this.handler.noteFormInput(attributes);
                    break;
                }
                if (!tagName.equals("isindex")) break;
                HashMap<String, String> indexMap = new HashMap<String, String>();
                indexMap.put("type", "text");
                break;
            }
            case 2: {
                if (!tagName.equals("option")) break;
                String optionValue = (String)attributes.get("value");
                String optionSelected = (String)attributes.get("selected");
                HashMap<String, String> optionMap = new HashMap<String, String>();
                optionMap.put("type", "select");
                optionMap.put("name", this.selectName);
                optionMap.put("multiple", this.selectMultiple);
                optionMap.put("value", optionValue);
                optionMap.put("selected", optionSelected);
                this.handler.noteFormInput(optionMap);
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new ManifoldCFException("Unknown form parse state: " + Integer.toString(this.formParseState));
            }
        }
    }

    protected void noteNonscriptEndTag(String tagName) throws ManifoldCFException {
        super.noteNonscriptEndTag(tagName);
        switch (this.formParseState) {
            case 0: {
                break;
            }
            case 1: {
                if (!tagName.equals("form")) break;
                this.handler.noteFormEnd();
                this.formParseState = 0;
                break;
            }
            case 2: {
                this.formParseState = 1;
                this.selectName = null;
                this.selectMultiple = null;
                break;
            }
            case 3: {
                this.formParseState = 1;
                break;
            }
            default: {
                throw new ManifoldCFException("Unknown form parse state: " + Integer.toString(this.formParseState));
            }
        }
    }
}

