/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.connectors.webcrawler;

import java.util.Map;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.crawler.connectors.webcrawler.IHTMLHandler;
import org.apache.manifoldcf.crawler.connectors.webcrawler.MetaParseState;

public class LinkParseState
extends MetaParseState {
    protected IHTMLHandler handler;

    public LinkParseState(IHTMLHandler handler) {
        super(handler);
        this.handler = handler;
    }

    protected void noteNonscriptTag(String tagName, Map attributes) throws ManifoldCFException {
        String srcValue;
        super.noteNonscriptTag(tagName, attributes);
        if (tagName.equals("a")) {
            String hrefValue = (String)attributes.get("href");
            if (hrefValue != null && hrefValue.length() > 0) {
                this.handler.noteAHREF(hrefValue);
            }
        } else if (tagName.equals("link")) {
            String hrefValue = (String)attributes.get("href");
            if (hrefValue != null && hrefValue.length() > 0) {
                this.handler.noteLINKHREF(hrefValue);
            }
        } else if (tagName.equals("img")) {
            String srcValue2 = (String)attributes.get("src");
            if (srcValue2 != null && srcValue2.length() > 0) {
                this.handler.noteIMGSRC(srcValue2);
            }
        } else if (tagName.equals("frame") && (srcValue = (String)attributes.get("src")) != null && srcValue.length() > 0) {
            this.handler.noteFRAMESRC(srcValue);
        }
    }
}

