/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.connectors.webcrawler;

import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.manifoldcf.core.interfaces.ConfigNode;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;

public class ThrottleDescription {
    public static final String _rcsid = "@(#)$Id: ThrottleDescription.java 988245 2010-08-23 18:39:35Z kwright $";
    protected HashMap patternHash = new HashMap();

    public ThrottleDescription(ConfigParams configData) throws ManifoldCFException {
        int i = 0;
        while (i < configData.getChildCount()) {
            ConfigNode node;
            if (!(node = configData.getChild(i++)).getType().equals("bindesc")) continue;
            String binDescription = node.getAttributeValue("binregexp");
            String caseSensitive = node.getAttributeValue("caseinsensitive");
            boolean isInsensitive = false;
            if (caseSensitive != null && caseSensitive.equalsIgnoreCase("true")) {
                isInsensitive = true;
            }
            Integer maxConnectionCount = null;
            Double minMillisecondsPerByte = null;
            Long minMillisecondsPerFetch = null;
            int j = 0;
            while (j < node.getChildCount()) {
                String value;
                ConfigNode childNode;
                if ((childNode = node.getChild(j++)).getType().equals("maxconnections")) {
                    value = childNode.getAttributeValue("value");
                    if (value == null) continue;
                    try {
                        maxConnectionCount = new Integer(value);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        throw new ManifoldCFException("Bad number", (Throwable)e);
                    }
                }
                if (childNode.getType().equals("maxkbpersecond")) {
                    value = childNode.getAttributeValue("value");
                    if (value == null) continue;
                    try {
                        double kbPerSecond = new Double(value);
                        if (!(kbPerSecond > 0.0)) continue;
                        minMillisecondsPerByte = new Double(1.0 / kbPerSecond);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        throw new ManifoldCFException("Bad number", (Throwable)e);
                    }
                }
                if (!childNode.getType().equals("maxfetchesperminute") || (value = childNode.getAttributeValue("value")) == null) continue;
                try {
                    double fetchesPerMinute = new Double(value);
                    if (!(fetchesPerMinute > 0.0)) continue;
                    minMillisecondsPerFetch = new Long((long)(60000.0 / fetchesPerMinute));
                }
                catch (NumberFormatException e) {
                    throw new ManifoldCFException("Bad number: " + e.getMessage(), (Throwable)e);
                }
            }
            try {
                Pattern p;
                int flags = 64;
                if (isInsensitive) {
                    flags |= 2;
                }
                try {
                    p = Pattern.compile(binDescription, flags);
                }
                catch (PatternSyntaxException e) {
                    throw new ManifoldCFException("Bin regular expression '" + binDescription + "' is illegal: " + e.getMessage(), (Throwable)e);
                }
                ThrottleItem ti = new ThrottleItem(p);
                ti.setMaxOpenConnections(maxConnectionCount);
                ti.setMinimumMillisecondsPerByte(minMillisecondsPerByte);
                ti.setMinimumMillisecondsPerFetch(minMillisecondsPerFetch);
                this.patternHash.put(binDescription, ti);
            }
            catch (PatternSyntaxException e) {
                throw new ManifoldCFException("Bad pattern syntax in '" + binDescription + "'", (Throwable)e);
            }
        }
    }

    public int getMaxOpenConnections(String binName) {
        int maxCount = -1;
        for (String binDescription : this.patternHash.keySet()) {
            Pattern p;
            Matcher m;
            ThrottleItem ti = (ThrottleItem)this.patternHash.get(binDescription);
            Integer limit = ti.getMaxOpenConnections();
            if (limit == null || !(m = (p = ti.getPattern()).matcher(binName)).find() || maxCount != -1 && limit <= maxCount) continue;
            maxCount = limit;
        }
        return maxCount;
    }

    public double getMinimumMillisecondsPerByte(String binName) {
        double minMilliseconds = 0.0;
        boolean seenSomething = false;
        for (String binDescription : this.patternHash.keySet()) {
            Pattern p;
            Matcher m;
            ThrottleItem ti = (ThrottleItem)this.patternHash.get(binDescription);
            Double limit = ti.getMinimumMillisecondsPerByte();
            if (limit == null || !(m = (p = ti.getPattern()).matcher(binName)).find() || seenSomething && !(limit < minMilliseconds)) continue;
            seenSomething = true;
            minMilliseconds = limit;
        }
        return minMilliseconds;
    }

    public long getMinimumMillisecondsPerFetch(String binName) {
        long minMilliseconds = 0L;
        boolean seenSomething = false;
        for (String binDescription : this.patternHash.keySet()) {
            Pattern p;
            Matcher m;
            ThrottleItem ti = (ThrottleItem)this.patternHash.get(binDescription);
            Long limit = ti.getMinimumMillisecondsPerFetch();
            if (limit == null || !(m = (p = ti.getPattern()).matcher(binName)).find() || seenSomething && limit >= minMilliseconds) continue;
            seenSomething = true;
            minMilliseconds = limit;
        }
        return minMilliseconds;
    }

    protected static class ThrottleItem {
        protected Pattern pattern;
        protected Double minimumMillisecondsPerByte = null;
        protected Long minimumMillisecondsPerFetch = null;
        protected Integer maxOpenConnections = null;

        public ThrottleItem(Pattern p) {
            this.pattern = p;
        }

        public Pattern getPattern() {
            return this.pattern;
        }

        public void setMinimumMillisecondsPerByte(Double value) {
            this.minimumMillisecondsPerByte = value;
        }

        public Double getMinimumMillisecondsPerByte() {
            return this.minimumMillisecondsPerByte;
        }

        public void setMinimumMillisecondsPerFetch(Long value) {
            this.minimumMillisecondsPerFetch = value;
        }

        public Long getMinimumMillisecondsPerFetch() {
            return this.minimumMillisecondsPerFetch;
        }

        public void setMaxOpenConnections(Integer value) {
            this.maxOpenConnections = value;
        }

        public Integer getMaxOpenConnections() {
            return this.maxOpenConnections;
        }
    }
}

