/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.connectors.webcrawler;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NoHttpResponseException;
import org.apache.commons.httpclient.RedirectException;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.params.HostParams;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolFactory;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.core.interfaces.IKeystoreManager;
import org.apache.manifoldcf.core.interfaces.KeystoreManagerFactory;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.crawler.connectors.webcrawler.CookieSet;
import org.apache.manifoldcf.crawler.connectors.webcrawler.FormData;
import org.apache.manifoldcf.crawler.connectors.webcrawler.FormDataElement;
import org.apache.manifoldcf.crawler.connectors.webcrawler.IThrottledConnection;
import org.apache.manifoldcf.crawler.connectors.webcrawler.LoginCookies;
import org.apache.manifoldcf.crawler.connectors.webcrawler.PageCredentials;
import org.apache.manifoldcf.crawler.connectors.webcrawler.ThrottleDescription;
import org.apache.manifoldcf.crawler.interfaces.IVersionActivity;
import org.apache.manifoldcf.crawler.system.Logging;
import org.apache.manifoldcf.crawler.system.ManifoldCF;

public class ThrottledFetcher {
    public static final String _rcsid = "@(#)$Id: ThrottledFetcher.java 989847 2010-08-26 17:52:30Z kwright $";
    protected static final boolean recordEverything = false;
    protected static final long TIME_2HRS = 0x6DDD00L;
    protected static final long TIME_5MIN = 300000L;
    protected static final long TIME_15MIN = 1500000L;
    protected static final long TIME_6HRS = 21600000L;
    protected static final long TIME_1DAY = 86400000L;
    protected static HashMap connectionBins = new HashMap();
    protected static HashMap throttleBins = new HashMap();
    protected static Integer poolLock = new Integer(0);
    protected static final int READ_CHUNK_LENGTH = 4096;
    protected static final String resultLogFile = "/common/web/resultlog";
    protected static final String dataFileFolder = "/common/web/data/";
    protected static DataRecorder dataRecorder = new DataRecorder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IThrottledConnection getConnection(String protocol, String server, int port, PageCredentials authentication, IKeystoreManager trustStore, ThrottleDescription throttleDescription, String[] binNames, int connectionLimit) throws ManifoldCFException {
        int i;
        String trustStoreString;
        WebSecureSocketFactory secureSocketFactory;
        ProtocolFactory myFactory = new ProtocolFactory();
        if (trustStore != null) {
            secureSocketFactory = new WebSecureSocketFactory(trustStore.getSecureSocketFactory());
            trustStoreString = trustStore.getString();
        } else {
            trustStoreString = null;
            secureSocketFactory = new WebSecureSocketFactory(KeystoreManagerFactory.getTrustingSecureSocketFactory());
        }
        Protocol myHttpsProtocol = new Protocol("https", (ProtocolSocketFactory)secureSocketFactory, 443);
        myFactory.registerProtocol("https", myHttpsProtocol);
        ConnectionBin[] bins = new ConnectionBin[binNames.length];
        for (i = 0; i < binNames.length; ++i) {
            ConnectionBin cb;
            String binName = binNames[i];
            HashMap hashMap = connectionBins;
            synchronized (hashMap) {
                cb = (ConnectionBin)connectionBins.get(binName);
                if (cb == null) {
                    cb = new ConnectionBin(binName);
                    connectionBins.put(binName, cb);
                }
            }
            bins[i] = cb;
        }
        long startTime = 0L;
        if (Logging.connectors.isDebugEnabled()) {
            startTime = System.currentTimeMillis();
            Logging.connectors.debug((Object)("WEB: Waiting to start getting a connection to " + protocol + "://" + server + ":" + port));
        }
        Integer n = poolLock;
        synchronized (n) {
            ConnectionBin cb;
            long idleTimeout = 64000L;
            while (true) {
                int openCount = 0;
                HashMap hashMap = connectionBins;
                synchronized (hashMap) {
                    for (String binName : connectionBins.keySet()) {
                        cb = (ConnectionBin)connectionBins.get(binName);
                        openCount += cb.countConnections();
                    }
                }
                if (openCount < connectionLimit || idleTimeout == 0L) break;
                idleTimeout /= 4L;
                hashMap = connectionBins;
                synchronized (hashMap) {
                    for (String binName : connectionBins.keySet()) {
                        cb = (ConnectionBin)connectionBins.get(binName);
                        cb.flushIdleConnections(idleTimeout);
                    }
                }
            }
            try {
                ThrottledConnection connectionToReuse;
                while (true) {
                    ConnectionBin cb2;
                    if (Logging.connectors.isDebugEnabled()) {
                        Logging.connectors.debug((Object)("WEB: Attempting to get connection to " + protocol + "://" + server + ":" + port + " (" + new Long(System.currentTimeMillis() - startTime).toString() + " ms)"));
                    }
                    connectionToReuse = null;
                    try {
                        for (i = 0; i < binNames.length; ++i) {
                            String binName = binNames[i];
                            ConnectionBin cb3 = bins[i];
                            int maxConnections = throttleDescription.getMaxOpenConnections(binName);
                            if (maxConnections == -1) {
                                maxConnections = Integer.MAX_VALUE;
                            } else if (maxConnections == 0) {
                                maxConnections = 1;
                            }
                            if (connectionToReuse != null) {
                                cb3.insureWithinLimits(maxConnections, connectionToReuse);
                                continue;
                            }
                            connectionToReuse = cb3.findConnection(maxConnections, bins, protocol, server, port, authentication, trustStoreString);
                        }
                        long currentTime = System.currentTimeMillis();
                        HashMap maxConnections = connectionBins;
                        synchronized (maxConnections) {
                            for (i = 0; i < binNames.length; ++i) {
                                String binName;
                                binName = binNames[i];
                                cb = bins[i];
                                long minMillisecondsPerFetch = throttleDescription.getMinimumMillisecondsPerFetch(binName);
                                if (cb.getLastFetchTime() + minMillisecondsPerFetch <= currentTime) continue;
                                throw new WaitException(cb.getLastFetchTime() + minMillisecondsPerFetch - currentTime);
                            }
                            i = 0;
                            while (i < binNames.length) {
                                cb2 = bins[i++];
                                cb2.setLastFetchTime(currentTime);
                            }
                        }
                    }
                    catch (Throwable e) {
                        if (connectionToReuse != null) {
                            int k = 0;
                            while (k < binNames.length) {
                                String binName = binNames[k++];
                                HashMap hashMap = connectionBins;
                                synchronized (hashMap) {
                                    cb2 = (ConnectionBin)connectionBins.get(binName);
                                    if (cb2 == null) {
                                        cb2 = new ConnectionBin(binName);
                                        connectionBins.put(binName, cb2);
                                    }
                                }
                                cb2.addToPool(connectionToReuse);
                            }
                            connectionToReuse = null;
                        }
                        if (e instanceof Error) {
                            throw (Error)e;
                        }
                        if (e instanceof ManifoldCFException) {
                            throw (ManifoldCFException)e;
                        }
                        if (e instanceof WaitException) {
                            WaitException we = (WaitException)e;
                            long waitAmount = we.getWaitAmount();
                            if (Logging.connectors.isDebugEnabled()) {
                                Logging.connectors.debug((Object)("WEB: Waiting " + new Long(waitAmount).toString() + " ms before starting fetch on " + protocol + "://" + server + ":" + port));
                            }
                            poolLock.wait(waitAmount);
                            continue;
                        }
                        if (e instanceof PoolException) {
                            if (Logging.connectors.isDebugEnabled()) {
                                Logging.connectors.debug((Object)("WEB: Going into wait for connection to " + protocol + "://" + server + ":" + port + " (" + new Long(System.currentTimeMillis() - startTime).toString() + " ms)"));
                            }
                            poolLock.wait();
                            continue;
                        }
                        throw new ManifoldCFException("Unexpected exception encountered: " + e.getMessage(), e);
                    }
                    break;
                }
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("WEB: Successfully got connection to " + protocol + "://" + server + ":" + port + " (" + new Long(System.currentTimeMillis() - startTime).toString() + " ms)"));
                }
                if (connectionToReuse == null) {
                    connectionToReuse = new ThrottledConnection(protocol, server, port, authentication, myFactory, trustStoreString, bins);
                }
                connectionToReuse.setup(throttleDescription);
                return connectionToReuse;
            }
            catch (InterruptedException e) {
                throw new ManifoldCFException(e.getMessage(), 2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flushIdleConnections() throws ManifoldCFException {
        Integer n = poolLock;
        synchronized (n) {
            HashMap hashMap = connectionBins;
            synchronized (hashMap) {
                for (String binName : connectionBins.keySet()) {
                    ConnectionBin cb = (ConnectionBin)connectionBins.get(binName);
                    if (!cb.flushIdleConnections(60000L)) continue;
                }
            }
        }
    }

    protected static class SocketCreateThread
    extends Thread {
        protected SSLSocketFactory socketFactory;
        protected String host;
        protected int port;
        protected InetAddress clientHost;
        protected int clientPort;
        protected Socket rval = null;
        protected Throwable throwable = null;

        public SocketCreateThread(SSLSocketFactory socketFactory, String host, int port, InetAddress clientHost, int clientPort) {
            this.socketFactory = socketFactory;
            this.host = host;
            this.port = port;
            this.clientHost = clientHost;
            this.clientPort = clientPort;
            this.setDaemon(true);
        }

        public void run() {
            try {
                this.rval = this.socketFactory.createSocket(this.host, this.port, this.clientHost, this.clientPort);
            }
            catch (Throwable e) {
                this.throwable = e;
            }
        }

        public Throwable getException() {
            return this.throwable;
        }

        public Socket getResult() {
            return this.rval;
        }
    }

    protected static class WebSecureSocketFactory
    implements SecureProtocolSocketFactory {
        protected SSLSocketFactory socketFactory;

        public WebSecureSocketFactory(SSLSocketFactory socketFactory) {
            this.socketFactory = socketFactory;
        }

        public Socket createSocket(String host, int port, InetAddress clientHost, int clientPort) throws IOException, UnknownHostException {
            return this.socketFactory.createSocket(host, port, clientHost, clientPort);
        }

        public Socket createSocket(String host, int port, InetAddress localAddress, int localPort, HttpConnectionParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
            if (params == null) {
                throw new IllegalArgumentException("Parameters may not be null");
            }
            int timeout = params.getConnectionTimeout();
            if (timeout == 0) {
                return this.createSocket(host, port, localAddress, localPort);
            }
            SocketCreateThread thread = new SocketCreateThread(this.socketFactory, host, port, localAddress, localPort);
            thread.start();
            try {
                thread.join(timeout);
                if (thread.isAlive()) {
                    thread.interrupt();
                    throw new ConnectTimeoutException("Secure connection timed out");
                }
                Throwable t = thread.getException();
                if (t != null) {
                    if (t instanceof SocketTimeoutException) {
                        throw (SocketTimeoutException)t;
                    }
                    if (t instanceof ConnectTimeoutException) {
                        throw (ConnectTimeoutException)t;
                    }
                    if (t instanceof InterruptedIOException) {
                        throw (InterruptedIOException)t;
                    }
                    if (t instanceof IOException) {
                        throw (IOException)t;
                    }
                    if (t instanceof UnknownHostException) {
                        throw (UnknownHostException)t;
                    }
                    if (t instanceof Error) {
                        throw (Error)t;
                    }
                    if (t instanceof RuntimeException) {
                        throw (RuntimeException)t;
                    }
                    throw new Error("Received an unexpected exception: " + t.getMessage(), t);
                }
                return thread.getResult();
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException("Interrupted: " + e.getMessage());
            }
        }

        public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
            return this.socketFactory.createSocket(host, port);
        }

        public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
            return this.socketFactory.createSocket(socket, host, port, autoClose);
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof WebSecureSocketFactory)) {
                return false;
            }
            return super.equals(obj);
        }

        public int hashCode() {
            return super.hashCode();
        }
    }

    protected static class WaitException
    extends Exception {
        protected long amt;

        public WaitException(long amt) {
            super("Wait needed");
            this.amt = amt;
        }

        public long getWaitAmount() {
            return this.amt;
        }
    }

    protected static class PoolException
    extends Exception {
        public PoolException(String message) {
            super(message);
        }
    }

    protected static class ThrottledInputstream
    extends InputStream {
        protected double minimumMillisecondsPerBytePerServer;
        protected ThrottledConnection throttledConnection;
        protected InputStream inputStream;
        protected DataSession dataSession;

        public ThrottledInputstream(ThrottledConnection connection, InputStream is, DataSession dataSession) {
            this.throttledConnection = connection;
            this.inputStream = is;
            this.dataSession = dataSession;
        }

        public int read() throws IOException {
            byte[] byteArray = new byte[1];
            int count = this.read(byteArray, 0, 1);
            if (count == -1) {
                return count;
            }
            return byteArray[0];
        }

        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int amt;
            int totalCount = 0;
            while (len > 4096) {
                amt = this.basicRead(b, off, 4096, totalCount);
                if (amt == -1) {
                    if (totalCount == 0) {
                        return amt;
                    }
                    return totalCount;
                }
                totalCount += amt;
                off += amt;
                len -= amt;
            }
            if (len > 0) {
                amt = this.basicRead(b, off, len, totalCount);
                if (amt == -1) {
                    if (totalCount == 0) {
                        return amt;
                    }
                    return totalCount;
                }
                return totalCount + amt;
            }
            return totalCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected int basicRead(byte[] b, int off, int len, int totalSoFar) throws IOException {
            this.throttledConnection.beginRead(len);
            int amt = 0;
            try {
                int n = amt = this.inputStream.read(b, off, len);
                if (amt == -1) {
                    this.throttledConnection.endRead(len, 0);
                } else {
                    this.throttledConnection.endRead(len, amt);
                    this.throttledConnection.logFetchCount(amt);
                }
                return n;
            }
            catch (Throwable throwable) {
                try {
                    if (amt == -1) {
                        this.throttledConnection.endRead(len, 0);
                    } else {
                        this.throttledConnection.endRead(len, amt);
                        this.throttledConnection.logFetchCount(amt);
                    }
                    throw throwable;
                }
                catch (InterruptedException e) {
                    InterruptedIOException e2 = new InterruptedIOException("Interrupted");
                    e2.bytesTransferred = totalSoFar;
                    throw e2;
                }
            }
        }

        public long skip(long n) throws IOException {
            return this.inputStream.skip(n);
        }

        public int available() throws IOException {
            return this.inputStream.available();
        }

        public void mark(int readLimit) {
            this.inputStream.mark(readLimit);
        }

        public void reset() throws IOException {
            this.inputStream.reset();
        }

        public boolean markSupported() {
            return this.inputStream.markSupported();
        }

        public void close() throws IOException {
            try {
                this.inputStream.close();
            }
            catch (SocketTimeoutException e) {
                Logging.connectors.debug((Object)("Socket timeout exception trying to close connection: " + e.getMessage()), (Throwable)e);
            }
            catch (ConnectTimeoutException e) {
                Logging.connectors.debug((Object)("Socket connection timeout exception trying to close connection: " + e.getMessage()), (Throwable)e);
            }
            catch (InterruptedIOException e) {
                throw e;
            }
            catch (SocketException e) {
                Logging.connectors.debug((Object)("Connection reset while I was closing it: " + e.getMessage()), (Throwable)e);
            }
            catch (IOException e) {
                Logging.connectors.debug((Object)("IO Exception trying to close connection: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    protected static class ThrottledConnection
    implements IThrottledConnection {
        protected ConnectionBin[] connectionBinArray;
        protected ThrottleBin[] throttleBinArray;
        protected double[] minMillisecondsPerByte;
        protected boolean isActive;
        protected long inactiveTime = 0L;
        protected String protocol;
        protected String server;
        protected int port;
        protected PageCredentials authentication;
        protected IKeystoreManager trustStore;
        protected String trustStoreString;
        protected MultiThreadedHttpConnectionManager connManager = null;
        protected HttpMethodBase fetchMethod = null;
        protected Throwable throwable = null;
        protected String myUrl = null;
        protected int statusCode = -1;
        protected String fetchType = null;
        protected long fetchCounter = 0L;
        protected long startFetchTime = -1L;
        protected LoginCookies lastFetchCookies = null;
        protected ProtocolSocketFactory secureSocketFactory = null;
        protected ProtocolFactory myFactory = null;
        protected DataSession dataSession = null;

        public ThrottledConnection(String protocol, String server, int port, PageCredentials authentication, ProtocolFactory myFactory, String trustStoreString, ConnectionBin[] connectionBins) {
            this.protocol = protocol;
            this.server = server;
            this.port = port;
            this.authentication = authentication;
            this.myFactory = myFactory;
            this.trustStoreString = trustStoreString;
            this.connectionBinArray = connectionBins;
            this.throttleBinArray = new ThrottleBin[connectionBins.length];
            this.minMillisecondsPerByte = new double[connectionBins.length];
            this.isActive = true;
            for (int i = 0; i < connectionBins.length; ++i) {
                connectionBins[i].noteConnectionCreation();
                this.throttleBinArray[i] = null;
                this.minMillisecondsPerByte[i] = 0.0;
            }
        }

        public void mustHaveReference(ConnectionBin cb) {
            for (int i = 0; i < this.connectionBinArray.length; ++i) {
                if (cb != this.connectionBinArray[i]) continue;
                return;
            }
            String msg = "Connection bin " + cb.toString() + " owns connection " + this.toString() + " for " + this.protocol + this.server + ":" + this.port + " but there is no back reference!";
            Logging.connectors.error((Object)msg);
            System.out.println(msg);
            new Exception(msg).printStackTrace();
            System.exit(3);
        }

        public boolean matches(ConnectionBin[] bins, String protocol, String server, int port, PageCredentials authentication, String trustStoreString) {
            if (this.trustStoreString == null && trustStoreString != null) {
                return false;
            }
            if (this.trustStoreString != null && trustStoreString == null) {
                return false;
            }
            if (this.trustStoreString != null && !this.trustStoreString.equals(trustStoreString)) {
                return false;
            }
            if (this.authentication == null && authentication != null) {
                return false;
            }
            if (this.authentication != null && authentication == null) {
                return false;
            }
            if (this.authentication != null && !this.authentication.equals(authentication)) {
                return false;
            }
            if (this.connectionBinArray.length != bins.length || !this.protocol.equals(protocol) || !this.server.equals(server) || this.port != port) {
                return false;
            }
            for (int i = 0; i < bins.length; ++i) {
                if (this.connectionBinArray[i] == bins[i]) continue;
                return false;
            }
            return true;
        }

        public void activate() {
            this.isActive = true;
            int i = 0;
            while (i < this.connectionBinArray.length) {
                this.connectionBinArray[i++].takeFromPool(this);
            }
        }

        public void setup(ThrottleDescription description) {
            for (int i = 0; i < this.connectionBinArray.length; ++i) {
                String binName = this.connectionBinArray[i].getBinName();
                this.minMillisecondsPerByte[i] = description.getMinimumMillisecondsPerByte(binName);
            }
        }

        public boolean flushIdleConnections(long idleTimeout) {
            if (this.isActive) {
                return false;
            }
            if (this.connManager != null) {
                this.connManager.closeIdleConnections(idleTimeout);
                this.connManager.deleteClosedConnections();
                return this.connManager.getConnectionsInPool() == 0;
            }
            return true;
        }

        public void logFetchCount(int count) {
            this.fetchCounter += (long)count;
        }

        public void beginRead(int len) throws InterruptedException {
            for (int i = 0; i < this.throttleBinArray.length; ++i) {
                this.throttleBinArray[i].beginRead(len, this.minMillisecondsPerByte[i]);
            }
        }

        public void endRead(int origLen, int actualAmt) {
            for (int i = 0; i < this.throttleBinArray.length; ++i) {
                this.throttleBinArray[i].endRead(origLen, actualAmt);
            }
        }

        protected void destroy() {
            if (!this.isActive) {
                throw new RuntimeException("Trying to destroy an inactive connection");
            }
            if (this.connManager != null) {
                this.connManager.shutdown();
                this.connManager = null;
            }
            int i = 0;
            while (i < this.connectionBinArray.length) {
                ConnectionBin cb = this.connectionBinArray[i++];
                cb.noteConnectionDestruction();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void beginFetch(String fetchType) throws ManifoldCFException {
            try {
                this.fetchType = fetchType;
                this.fetchCounter = 0L;
                for (int i = 0; i < this.throttleBinArray.length; ++i) {
                    ThrottleBin tb;
                    String binName = this.connectionBinArray[i].getBinName();
                    HashMap hashMap = throttleBins;
                    synchronized (hashMap) {
                        tb = (ThrottleBin)throttleBins.get(binName);
                        if (tb == null) {
                            tb = new ThrottleBin(binName);
                            throttleBins.put(binName, tb);
                        }
                        tb.beginFetch();
                    }
                    this.throttleBinArray[i] = tb;
                }
            }
            catch (InterruptedException e) {
                throw new ManifoldCFException("Interrupted", 2);
            }
        }

        public void executeFetch(String urlPath, String userAgent, String from, int connectionTimeoutMilliseconds, int socketTimeoutMilliseconds, boolean redirectOK, String host, FormData formData, LoginCookies loginCookies) throws ManifoldCFException, ServiceInterruption {
            StringBuffer sb = new StringBuffer(this.protocol);
            sb.append("://").append(this.server);
            if (!(this.port == -1 || this.protocol.equals("http") && this.port == 80 || this.protocol.equals("https") && this.port == 443)) {
                sb.append(":").append(Integer.toString(this.port));
            }
            sb.append(urlPath);
            String fetchUrl = sb.toString();
            if (host != null) {
                sb.setLength(0);
                sb.append(this.protocol).append("://").append(host);
                if (!(this.port == -1 || this.protocol.equals("http") && this.port == 80 || this.protocol.equals("https") && this.port == 443)) {
                    sb.append(":").append(Integer.toString(this.port));
                }
                sb.append(urlPath);
                this.myUrl = sb.toString();
            } else {
                this.myUrl = fetchUrl;
            }
            try {
                if (this.connManager == null) {
                    this.connManager = new MultiThreadedHttpConnectionManager();
                }
                HttpConnectionManagerParams httpConParam = this.connManager.getParams();
                httpConParam.setDefaultMaxConnectionsPerHost(1);
                httpConParam.setMaxTotalConnections(1);
                httpConParam.setConnectionTimeout(connectionTimeoutMilliseconds);
                httpConParam.setSoTimeout(socketTimeoutMilliseconds);
                this.connManager.setParams(httpConParam);
                long startTime = 0L;
                if (Logging.connectors.isDebugEnabled()) {
                    startTime = System.currentTimeMillis();
                    Logging.connectors.debug((Object)"WEB: Waiting for an HttpClient object");
                }
                HttpClient client = new HttpClient((HttpConnectionManager)this.connManager);
                client.getParams().setParameter("http.protocol.allow-circular-redirects", (Object)new Boolean(true));
                client.getParams().setParameter("http.protocol.factory", (Object)this.myFactory);
                HostConfiguration clientConf = new HostConfiguration();
                clientConf.setParams(new HostParams());
                clientConf.setHost(this.server, this.port, this.myFactory.getProtocol(this.protocol));
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("WEB: Got an HttpClient object after " + new Long(System.currentTimeMillis() - startTime).toString() + " ms."));
                }
                this.startFetchTime = System.currentTimeMillis();
                int pageFetchMethod = 0;
                if (formData != null) {
                    pageFetchMethod = formData.getSubmitMethod();
                }
                switch (pageFetchMethod) {
                    case 0: {
                        String fullUrlPath;
                        Iterator iter;
                        if (formData != null) {
                            StringBuffer psb = new StringBuffer(urlPath);
                            iter = formData.getElementIterator();
                            int appendChar = urlPath.indexOf("?") == -1 ? 63 : 38;
                            while (iter.hasNext()) {
                                FormDataElement e = (FormDataElement)iter.next();
                                psb.append((char)appendChar);
                                appendChar = 38;
                                String param = e.getElementName();
                                String value = e.getElementValue();
                                psb.append(URLEncoder.encode(param, "utf-8"));
                                if (value == null) continue;
                                psb.append('=').append(URLEncoder.encode(value, "utf-8"));
                            }
                            fullUrlPath = psb.toString();
                        } else {
                            fullUrlPath = urlPath;
                        }
                        while (fullUrlPath.startsWith("//")) {
                            fullUrlPath = fullUrlPath.substring(1);
                        }
                        if (Logging.connectors.isDebugEnabled()) {
                            Logging.connectors.debug((Object)("WEB: Get method for '" + fullUrlPath + "'"));
                        }
                        this.fetchMethod = new GetMethod(fullUrlPath);
                        break;
                    }
                    case 1: {
                        Iterator iter;
                        if (Logging.connectors.isDebugEnabled()) {
                            Logging.connectors.debug((Object)("WEB: Post method for '" + urlPath + "'"));
                        }
                        PostMethod postMethod = new PostMethod(urlPath);
                        if (formData != null) {
                            iter = formData.getElementIterator();
                            while (iter.hasNext()) {
                                FormDataElement e = (FormDataElement)iter.next();
                                String param = e.getElementName();
                                String value = e.getElementValue();
                                if (Logging.connectors.isDebugEnabled()) {
                                    Logging.connectors.debug((Object)("WEB: Post parameter name '" + param + "' value '" + value + "' for '" + urlPath + "'"));
                                }
                                postMethod.addParameter(param, value);
                            }
                        }
                        this.fetchMethod = postMethod;
                        break;
                    }
                    default: {
                        throw new ManifoldCFException("Illegal method type: " + Integer.toString(pageFetchMethod));
                    }
                }
                this.fetchMethod.setRequestHeader("User-Agent", userAgent);
                this.fetchMethod.setRequestHeader("From", from);
                HttpMethodParams params = this.fetchMethod.getParams();
                if (host != null) {
                    if (Logging.connectors.isDebugEnabled()) {
                        Logging.connectors.debug((Object)("WEB: For " + this.myUrl + ", setting virtual host to " + host));
                    }
                    params.setVirtualHost(host);
                }
                params.setSoTimeout(socketTimeoutMilliseconds);
                params.setCookiePolicy("compatibilitymediumsecurity");
                params.setParameter("http.protocol.single-cookie-header", (Object)new Boolean(true));
                this.fetchMethod.setParams(params);
                this.fetchMethod.setFollowRedirects(redirectOK);
                HttpState state = client.getState();
                state.clearCookies();
                if (loginCookies != null) {
                    if (Logging.connectors.isDebugEnabled()) {
                        Logging.connectors.debug((Object)("WEB: Adding " + Integer.toString(loginCookies.getCookieCount()) + " cookies for '" + urlPath + "'"));
                    }
                    int h = 0;
                    while (h < loginCookies.getCookieCount()) {
                        state.addCookie(loginCookies.getCookie(h++));
                    }
                }
                this.lastFetchCookies = loginCookies;
                if (this.authentication != null) {
                    if (Logging.connectors.isDebugEnabled()) {
                        Logging.connectors.debug((Object)("WEB: For " + this.myUrl + ", discovered matching authentication credentials"));
                    }
                    state.setCredentials(AuthScope.ANY, this.authentication.makeCredentialsObject(host));
                }
                client.setState(state);
                try {
                    ExecuteMethodThread t = new ExecuteMethodThread(client, clientConf, this.fetchMethod);
                    try {
                        t.start();
                        t.join();
                        Throwable thr = t.getException();
                        if (thr != null) {
                            throw thr;
                        }
                        this.statusCode = t.getResponse();
                    }
                    catch (InterruptedException e) {
                        t.interrupt();
                        throw e;
                    }
                    this.lastFetchCookies = new CookieSet(client.getState().getCookies());
                    switch (this.statusCode) {
                        case 408: 
                        case 503: 
                        case 504: {
                            long currentTime = System.currentTimeMillis();
                            throw new ServiceInterruption("Http response temporary error on '" + this.myUrl + "': " + Integer.toString(this.statusCode), (Throwable)new ManifoldCFException("Service unavailable (code " + Integer.toString(this.statusCode) + ")"), currentTime + 0x6DDD00L, currentTime + 86400000L, -1, false);
                        }
                    }
                    return;
                }
                catch (SocketTimeoutException e) {
                    this.throwable = e;
                    long currentTime = System.currentTimeMillis();
                    throw new ServiceInterruption("Timed out waiting for IO for '" + this.myUrl + "': " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 0x6DDD00L, -1, false);
                }
                catch (ConnectTimeoutException e) {
                    this.throwable = e;
                    long currentTime = System.currentTimeMillis();
                    throw new ServiceInterruption("Timed out waiting for connection for '" + this.myUrl + "': " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 0x6DDD00L, -1, false);
                }
                catch (InterruptedIOException e) {
                    this.throwable = new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e);
                    this.statusCode = -104;
                    throw new ManifoldCFException("Interrupted", 2);
                }
                catch (RedirectException e) {
                    this.throwable = e;
                    this.statusCode = -100;
                    return;
                }
                catch (NoHttpResponseException e) {
                    this.throwable = e;
                    long currentTime = System.currentTimeMillis();
                    throw new ServiceInterruption("Timed out waiting for response for '" + this.myUrl + "': " + e.getMessage(), (Throwable)e, currentTime + 1500000L, currentTime + 0x6DDD00L, -1, false);
                }
                catch (ConnectException e) {
                    this.throwable = e;
                    long currentTime = System.currentTimeMillis();
                    throw new ServiceInterruption("Timed out waiting for a connection for '" + this.myUrl + "': " + e.getMessage(), (Throwable)e, currentTime + 0x6DDD00L, currentTime + 21600000L, -1, false);
                }
                catch (IOException e) {
                    this.throwable = e;
                    this.statusCode = -103;
                    return;
                }
            }
            catch (InterruptedException e) {
                this.fetchMethod = null;
                this.connManager = null;
                this.throwable = new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e);
                this.statusCode = -104;
                throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
            }
            catch (IllegalArgumentException e) {
                this.throwable = new ManifoldCFException("Illegal URI: '" + this.myUrl + "'", (Throwable)e);
                this.statusCode = -101;
                return;
            }
            catch (IllegalStateException e) {
                this.throwable = new ManifoldCFException("Illegal state while fetching URI: '" + this.myUrl + "'", (Throwable)e);
                this.statusCode = -102;
                return;
            }
            catch (ServiceInterruption e) {
                throw e;
            }
            catch (ManifoldCFException e) {
                throw e;
            }
            catch (Throwable e) {
                Logging.connectors.debug((Object)("WEB: Caught an unexpected exception: " + e.getMessage()), e);
                this.throwable = e;
                this.statusCode = -999;
                return;
            }
        }

        public int getResponseCode() throws ManifoldCFException, ServiceInterruption {
            return this.statusCode;
        }

        public LoginCookies getLastFetchCookies() throws ManifoldCFException, ServiceInterruption {
            return this.lastFetchCookies;
        }

        public String getResponseHeader(String headerName) throws ManifoldCFException, ServiceInterruption {
            Header h = this.fetchMethod.getResponseHeader(headerName);
            if (h == null) {
                return null;
            }
            return h.getValue();
        }

        public InputStream getResponseBodyStream() throws ManifoldCFException, ServiceInterruption {
            if (this.fetchMethod == null) {
                throw new ManifoldCFException("Attempt to get a response when there is no method");
            }
            try {
                InputStream bodyStream = this.fetchMethod.getResponseBodyAsStream();
                if (bodyStream == null) {
                    Logging.connectors.debug((Object)("Web: Couldn't set up response stream for '" + this.myUrl + "', retrying"));
                    throw new ServiceInterruption("Failed to set up body response stream for " + this.myUrl, null, 300000L, -1L, 2, false);
                }
                return new ThrottledInputstream(this, bodyStream, this.dataSession);
            }
            catch (SocketTimeoutException e) {
                Logging.connectors.debug((Object)("Web: Socket timeout exception setting up response stream for '" + this.myUrl + "', retrying"));
                throw new ServiceInterruption("Socket timeout exception setting up response stream: " + e.getMessage(), (Throwable)e, System.currentTimeMillis() + 300000L, -1L, 2, false);
            }
            catch (ConnectTimeoutException e) {
                Logging.connectors.debug((Object)("Web: Connect timeout exception setting up response stream for '" + this.myUrl + "', retrying"));
                throw new ServiceInterruption("Connect timeout exception setting up response stream: " + e.getMessage(), (Throwable)e, System.currentTimeMillis() + 300000L, -1L, 2, false);
            }
            catch (InterruptedIOException e) {
                throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
            }
            catch (IOException e) {
                Logging.connectors.debug((Object)("Web: IO exception setting up response stream for '" + this.myUrl + "', retrying"));
                throw new ServiceInterruption("IO exception setting up response stream: " + e.getMessage(), (Throwable)e, System.currentTimeMillis() + 300000L, -1L, 2, false);
            }
            catch (IllegalStateException e) {
                Logging.connectors.debug((Object)("Web: State error getting response body for '" + this.myUrl + "', retrying"));
                throw new ServiceInterruption("State error getting response body: " + e.getMessage(), (Throwable)e, 300000L, -1L, 2, false);
            }
        }

        public void noteInterrupted(Throwable e) {
            if (this.statusCode > 0) {
                this.throwable = new ManifoldCFException("Interrupted: " + e.getMessage(), e);
                this.statusCode = -104;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doneFetch(IVersionActivity activities) throws ManifoldCFException {
            if (this.fetchType != null) {
                long endTime = System.currentTimeMillis();
                for (int i = 0; i < this.throttleBinArray.length; ++i) {
                    HashMap hashMap = throttleBins;
                    synchronized (hashMap) {
                        if (this.throttleBinArray[i].endFetch()) {
                            throttleBins.remove(this.throttleBinArray[i].getBinName());
                        }
                    }
                    this.throttleBinArray[i] = null;
                }
                activities.recordActivity(new Long(this.startFetchTime), "fetch", new Long(this.fetchCounter), this.myUrl, Integer.toString(this.statusCode), this.throwable == null ? null : this.throwable.getMessage(), null);
                Logging.connectors.info((Object)("WEB: FETCH " + this.fetchType + "|" + this.myUrl + "|" + new Long(this.startFetchTime).toString() + "+" + new Long(endTime - this.startFetchTime).toString() + "|" + Integer.toString(this.statusCode) + "|" + new Long(this.fetchCounter).toString() + "|" + (this.throwable == null ? "" : this.throwable.getClass().getName() + "| " + this.throwable.getMessage())));
                if (this.throwable != null && Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("WEB: Fetch exception for '" + this.myUrl + "'"), this.throwable);
                }
                if (this.fetchMethod != null) {
                    try {
                        this.fetchMethod.releaseConnection();
                    }
                    catch (IllegalStateException e) {
                        // empty catch block
                    }
                    this.fetchMethod = null;
                }
                this.throwable = null;
                this.startFetchTime = -1L;
                this.myUrl = null;
                this.statusCode = -1;
                this.lastFetchCookies = null;
                this.fetchType = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws ManifoldCFException {
            Integer n = poolLock;
            synchronized (n) {
                HashMap hashMap = connectionBins;
                synchronized (hashMap) {
                    for (String connectionName : connectionBins.keySet()) {
                        ConnectionBin cb = (ConnectionBin)connectionBins.get(connectionName);
                    }
                }
                this.isActive = false;
                this.inactiveTime = System.currentTimeMillis();
                int i = 0;
                while (i < this.connectionBinArray.length) {
                    this.connectionBinArray[i++].addToPool(this);
                }
                HashMap hashMap2 = connectionBins;
                synchronized (hashMap2) {
                    for (String connectionName : connectionBins.keySet()) {
                        ConnectionBin cb = (ConnectionBin)connectionBins.get(connectionName);
                    }
                }
                poolLock.notifyAll();
            }
        }

        protected static class ExecuteMethodThread
        extends Thread {
            protected HttpClient client;
            protected HostConfiguration hostConfiguration;
            protected HttpMethodBase executeMethod;
            protected Throwable exception = null;
            protected int rval = 0;

            public ExecuteMethodThread(HttpClient client, HostConfiguration hostConfiguration, HttpMethodBase executeMethod) {
                this.setDaemon(true);
                this.client = client;
                this.hostConfiguration = hostConfiguration;
                this.executeMethod = executeMethod;
            }

            public void run() {
                try {
                    this.rval = this.client.executeMethod(this.hostConfiguration, (HttpMethod)this.executeMethod, null);
                }
                catch (Throwable e) {
                    this.exception = e;
                }
            }

            public Throwable getException() {
                return this.exception;
            }

            public int getResponse() {
                return this.rval;
            }
        }
    }

    protected static class DataSession {
        protected DataRecorder dr;
        protected String url;
        protected int responseCode = 0;
        protected ArrayList headerNames = new ArrayList();
        protected ArrayList headerValues = new ArrayList();
        protected String documentName = null;

        public DataSession(DataRecorder dr, String url) {
            this.dr = dr;
            this.url = url;
        }

        public void setResponseCode(int responseCode) {
            this.responseCode = responseCode;
        }

        public void addHeader(String headerName, String headerValue) {
            this.headerNames.add(headerName);
            this.headerValues.add(headerValue);
        }

        public void endHeader() throws ManifoldCFException {
            this.documentName = this.dr.writeResponseRecord(this.url, this.responseCode, this.headerNames, this.headerValues);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(byte[] theBytes, int off, int length) throws IOException {
            if (this.documentName == null) {
                throw new IOException("Must end header before reading data!");
            }
            FileOutputStream os = new FileOutputStream(ThrottledFetcher.dataFileFolder + this.documentName, true);
            try {
                ((OutputStream)os).write(theBytes, off, length);
            }
            finally {
                ((OutputStream)os).close();
            }
        }
    }

    protected static class DataRecorder {
        protected int documentNumber = 0;

        public DataSession getSession(String url) throws ManifoldCFException {
            return new DataSession(this, url);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive exception aggregation
         */
        public synchronized String writeResponseRecord(String url, int responseCode, ArrayList headerNames, ArrayList headerValues) throws ManifoldCFException {
            try {
                FileOutputStream os = new FileOutputStream(ThrottledFetcher.resultLogFile, true);
                try {
                    String string;
                    OutputStreamWriter writer = new OutputStreamWriter((OutputStream)os, "utf-8");
                    try {
                        String documentName = Integer.toString(this.documentNumber++);
                        writer.write("URI: " + url + "\n");
                        writer.write("File: " + documentName + "\n");
                        writer.write("Code: " + Integer.toString(responseCode) + "\n");
                        for (int i = 0; i < headerNames.size(); ++i) {
                            writer.write("Header: " + (String)headerNames.get(i) + ":" + (String)headerValues.get(i) + "\n");
                        }
                        string = documentName;
                    }
                    catch (Throwable throwable) {
                        writer.close();
                        throw throwable;
                    }
                    writer.close();
                    return string;
                }
                finally {
                    ((OutputStream)os).close();
                }
            }
            catch (IOException e) {
                throw new ManifoldCFException("Error recording file info: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    protected static class ThrottleBin {
        protected String binName;
        protected int refCount = 0;
        protected double rateEstimate = 0.0;
        protected boolean estimateValid = false;
        protected boolean estimateInProgress = false;
        protected long seriesStartTime = -1L;
        protected long totalBytesRead = -1L;
        protected Integer firstChunkLock = new Integer(0);

        public ThrottleBin(String binName) {
            this.binName = binName;
        }

        public String getBinName() {
            return this.binName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void beginFetch() throws InterruptedException {
            ThrottleBin throttleBin = this;
            synchronized (throttleBin) {
                if (this.refCount == 0) {
                    this.estimateValid = false;
                    this.rateEstimate = 0.0;
                    this.totalBytesRead = 0L;
                    this.estimateInProgress = false;
                    this.seriesStartTime = -1L;
                }
                ++this.refCount;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void beginRead(int byteCount, double minimumMillisecondsPerBytePerServer) throws InterruptedException {
            long currentTime = System.currentTimeMillis();
            Integer n = this.firstChunkLock;
            synchronized (n) {
                while (this.estimateInProgress) {
                    this.firstChunkLock.wait();
                }
                if (!this.estimateValid) {
                    this.seriesStartTime = currentTime;
                    this.estimateInProgress = true;
                    ThrottleBin throttleBin = this;
                    synchronized (throttleBin) {
                        this.totalBytesRead += (long)byteCount;
                    }
                    return;
                }
            }
            long waitTime = 0L;
            ThrottleBin throttleBin = this;
            synchronized (throttleBin) {
                this.totalBytesRead += (long)byteCount;
                long estimatedTime = (long)(this.rateEstimate * (double)byteCount);
                long desiredEndTime = this.seriesStartTime + (long)((double)this.totalBytesRead * minimumMillisecondsPerBytePerServer);
                waitTime = desiredEndTime - estimatedTime - currentTime;
            }
            if (waitTime > 0L) {
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("WEB: Performing a read wait on bin '" + this.binName + "' of " + new Long(waitTime).toString() + " ms."));
                }
                ManifoldCF.sleep((long)waitTime);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void endRead(int originalCount, int actualCount) {
            long currentTime = System.currentTimeMillis();
            Object object = this;
            synchronized (object) {
                this.totalBytesRead = this.totalBytesRead + (long)actualCount - (long)originalCount;
            }
            object = this.firstChunkLock;
            synchronized (object) {
                if (this.estimateInProgress) {
                    this.rateEstimate = actualCount == 0 ? 0.0 : (double)(currentTime - this.seriesStartTime) / (double)actualCount;
                    this.estimateValid = true;
                    this.estimateInProgress = false;
                    this.firstChunkLock.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean endFetch() {
            ThrottleBin throttleBin = this;
            synchronized (throttleBin) {
                --this.refCount;
                return this.refCount == 0;
            }
        }
    }

    protected static class ConnectionBin {
        protected String binName;
        protected int inUseConnections = 0;
        protected long lastFetchTime = 0L;
        protected Integer connectionWait = new Integer(0);
        protected HashMap freePool = new HashMap();

        public ConnectionBin(String binName) {
            this.binName = binName;
        }

        public String getBinName() {
            return this.binName;
        }

        public synchronized void noteConnectionCreation() {
            ++this.inUseConnections;
        }

        public synchronized void noteConnectionDestruction() {
            --this.inUseConnections;
        }

        public synchronized void takeFromPool(ThrottledConnection tc) {
            this.freePool.remove(tc);
            ++this.inUseConnections;
        }

        public synchronized void addToPool(ThrottledConnection tc) {
            this.freePool.put(tc, tc);
            --this.inUseConnections;
        }

        public synchronized void insureWithinLimits(int maxConnections, ThrottledConnection existingConnection) throws PoolException {
            if (this.existsInPool(existingConnection)) {
                return;
            }
            while (maxConnections > 0 && this.inUseConnections + this.freePool.size() > maxConnections) {
                ThrottledConnection freeMe = this.getPoolConnection();
                if (freeMe != null) {
                    freeMe.activate();
                    freeMe.destroy();
                    continue;
                }
                throw new PoolException("Waiting for a connection");
            }
        }

        public synchronized ThrottledConnection findConnection(int maxConnections, ConnectionBin[] binNames, String protocol, String server, int port, PageCredentials authentication, String trustStoreString) throws PoolException {
            while (maxConnections > 0 && this.inUseConnections + this.freePool.size() > maxConnections) {
                ThrottledConnection freeMe = this.getPoolConnection();
                if (freeMe != null) {
                    freeMe.activate();
                    freeMe.destroy();
                    continue;
                }
                throw new PoolException("Waiting for a connection");
            }
            if (maxConnections > 0 && this.inUseConnections > maxConnections - 1) {
                throw new PoolException("Waiting for a connection");
            }
            ThrottledConnection rval = this.getPoolConnection();
            if (rval == null) {
                return null;
            }
            rval.activate();
            if (!rval.matches(binNames, protocol, server, port, authentication, trustStoreString)) {
                rval.destroy();
                return null;
            }
            return rval;
        }

        public synchronized void setLastFetchTime(long currentTime) {
            if (currentTime > this.lastFetchTime) {
                this.lastFetchTime = currentTime;
            }
        }

        public synchronized long getLastFetchTime() {
            return this.lastFetchTime;
        }

        public synchronized int countConnections() {
            return this.freePool.size() + this.inUseConnections;
        }

        public synchronized boolean flushIdleConnections(long idleTimeout) {
            Iterator iter = this.freePool.keySet().iterator();
            while (iter.hasNext()) {
                ThrottledConnection tc = (ThrottledConnection)iter.next();
                if (!tc.flushIdleConnections(idleTimeout)) continue;
                tc.activate();
                tc.destroy();
                iter = this.freePool.keySet().iterator();
            }
            return this.freePool.size() == 0 && this.inUseConnections == 0;
        }

        protected ThrottledConnection getPoolConnection() {
            if (this.freePool.size() == 0) {
                return null;
            }
            Iterator iter = this.freePool.keySet().iterator();
            ThrottledConnection rval = (ThrottledConnection)iter.next();
            return rval;
        }

        protected boolean existsInPool(ThrottledConnection tc) {
            return this.freePool.get(tc) != null;
        }

        public synchronized void sanityCheck() {
            for (ThrottledConnection tc : this.freePool.keySet()) {
                tc.mustHaveReference(this);
            }
        }
    }
}

