/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.connectors.webcrawler;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.manifoldcf.agents.common.XMLContext;
import org.apache.manifoldcf.agents.common.XMLStream;
import org.apache.manifoldcf.agents.common.XMLStringContext;
import org.apache.manifoldcf.agents.interfaces.RepositoryDocument;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.core.interfaces.ConfigNode;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.ConfigurationNode;
import org.apache.manifoldcf.core.interfaces.DBInterfaceFactory;
import org.apache.manifoldcf.core.interfaces.IDBInterface;
import org.apache.manifoldcf.core.interfaces.IHTTPOutput;
import org.apache.manifoldcf.core.interfaces.IKeystoreManager;
import org.apache.manifoldcf.core.interfaces.IPostParameters;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.KeystoreManagerFactory;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.SpecificationNode;
import org.apache.manifoldcf.crawler.connectors.BaseRepositoryConnector;
import org.apache.manifoldcf.crawler.connectors.webcrawler.CookieManager;
import org.apache.manifoldcf.crawler.connectors.webcrawler.CredentialsDescription;
import org.apache.manifoldcf.crawler.connectors.webcrawler.DNSManager;
import org.apache.manifoldcf.crawler.connectors.webcrawler.DataCache;
import org.apache.manifoldcf.crawler.connectors.webcrawler.FormData;
import org.apache.manifoldcf.crawler.connectors.webcrawler.FormDataAccumulator;
import org.apache.manifoldcf.crawler.connectors.webcrawler.FormParseState;
import org.apache.manifoldcf.crawler.connectors.webcrawler.IDiscoveredLinkHandler;
import org.apache.manifoldcf.crawler.connectors.webcrawler.IHTMLHandler;
import org.apache.manifoldcf.crawler.connectors.webcrawler.IRedirectionHandler;
import org.apache.manifoldcf.crawler.connectors.webcrawler.IXMLHandler;
import org.apache.manifoldcf.crawler.connectors.webcrawler.LoginParameters;
import org.apache.manifoldcf.crawler.connectors.webcrawler.PageCredentials;
import org.apache.manifoldcf.crawler.connectors.webcrawler.RobotsManager;
import org.apache.manifoldcf.crawler.connectors.webcrawler.SequenceCredentials;
import org.apache.manifoldcf.crawler.connectors.webcrawler.ThrottleDescription;
import org.apache.manifoldcf.crawler.connectors.webcrawler.ThrottledFetcher;
import org.apache.manifoldcf.crawler.connectors.webcrawler.TrustsDescription;
import org.apache.manifoldcf.crawler.interfaces.DocumentSpecification;
import org.apache.manifoldcf.crawler.interfaces.IFingerprintActivity;
import org.apache.manifoldcf.crawler.interfaces.INamingActivity;
import org.apache.manifoldcf.crawler.interfaces.IProcessActivity;
import org.apache.manifoldcf.crawler.interfaces.ISeedingActivity;
import org.apache.manifoldcf.crawler.interfaces.IVersionActivity;
import org.apache.manifoldcf.crawler.system.Logging;
import org.apache.manifoldcf.crawler.system.ManifoldCF;
import org.apache.manifoldcf.ui.util.Encoder;
import org.xml.sax.Attributes;

public class WebcrawlerConnector
extends BaseRepositoryConnector {
    public static final String _rcsid = "@(#)$Id: WebcrawlerConnector.java 995042 2010-09-08 13:10:06Z kwright $";
    protected static final int RESULTSTATUS_FALSE = 0;
    protected static final int RESULTSTATUS_TRUE = 1;
    protected static final int RESULTSTATUS_NOTYETDETERMINED = 2;
    protected static final String[] interestingMimeTypeArray = new String[]{"application/rtf", "application/xls", "text/html", "text/rtf", "application/x-excel", "application/x-msexcel", "application/x-mspowerpoint", "application/x-msword-doc", "application/x-msword", "application/x-word", "text/xml", "no-type", "text/plain", "application/x-rtf", "application/x-pdf", "text/richtext", "Text", "Text/html"};
    protected static final Map interestingMimeTypeMap = new HashMap();
    protected static final Map understoodProtocols;
    protected static final int ROBOTS_NONE = 0;
    protected static final int ROBOTS_DATA = 1;
    protected static final int ROBOTS_ALL = 2;
    public static final String REL_LINK = "link";
    public static final String REL_REDIRECT = "redirect";
    public static final String ACTIVITY_FETCH = "fetch";
    public static final String ACTIVITY_ROBOTSPARSE = "robots parse";
    public static final String ACTIVITY_LOGON_START = "begin logon";
    public static final String ACTIVITY_LOGON_END = "end logon";
    protected static final String FETCH_ROBOTS = "ROBOTS";
    protected static final String FETCH_STANDARD = "URL";
    protected static final String FETCH_LOGIN = "LOGIN";
    protected int robotsUsage = 2;
    protected String userAgent = null;
    protected String from = null;
    protected int connectionTimeoutMilliseconds = 60000;
    protected int socketTimeoutMilliseconds = 300000;
    protected ThrottleDescription throttleDescription = null;
    protected CredentialsDescription credentialsDescription = null;
    protected TrustsDescription trustsDescription = null;
    protected RobotsManager robotsManager = null;
    protected DNSManager dnsManager = null;
    protected CookieManager cookieManager = null;
    protected boolean isInitialized = false;
    protected static DataCache cache;
    private static final String defaultAuthorityDenyToken = "DEAD_AUTHORITY";
    protected static final int SESSIONSTATE_NORMAL = 0;
    protected static final int SESSIONSTATE_LOGIN = 1;
    protected static final int RESULT_NO_DOCUMENT = 0;
    protected static final int RESULT_NO_VERSION = 1;
    protected static final int RESULT_VERSION_NEEDED = 2;
    protected static final int RESULT_RETRY_DOCUMENT = 3;

    public int getConnectorModel() {
        return 0;
    }

    public String getJSPFolder() {
        return "webcrawler";
    }

    public void install(IThreadContext threadContext) throws ManifoldCFException {
        IDBInterface mainDatabase = DBInterfaceFactory.make((IThreadContext)threadContext, (String)ManifoldCF.getMasterDatabaseName(), (String)ManifoldCF.getMasterDatabaseUsername(), (String)ManifoldCF.getMasterDatabasePassword());
        RobotsManager rm = new RobotsManager(threadContext, mainDatabase);
        DNSManager dns = new DNSManager(threadContext, mainDatabase);
        CookieManager cm = new CookieManager(threadContext, mainDatabase);
        mainDatabase.beginTransaction();
        try {
            rm.install();
            dns.install();
            cm.install();
        }
        catch (ManifoldCFException e) {
            mainDatabase.signalRollback();
            throw e;
        }
        catch (Error e) {
            mainDatabase.signalRollback();
            throw e;
        }
        finally {
            mainDatabase.endTransaction();
        }
    }

    public void deinstall(IThreadContext threadContext) throws ManifoldCFException {
        IDBInterface mainDatabase = DBInterfaceFactory.make((IThreadContext)threadContext, (String)ManifoldCF.getMasterDatabaseName(), (String)ManifoldCF.getMasterDatabaseUsername(), (String)ManifoldCF.getMasterDatabasePassword());
        RobotsManager rm = new RobotsManager(threadContext, mainDatabase);
        DNSManager dns = new DNSManager(threadContext, mainDatabase);
        CookieManager cm = new CookieManager(threadContext, mainDatabase);
        mainDatabase.beginTransaction();
        try {
            cm.deinstall();
            rm.deinstall();
            dns.deinstall();
        }
        catch (ManifoldCFException e) {
            mainDatabase.signalRollback();
            throw e;
        }
        catch (Error e) {
            mainDatabase.signalRollback();
            throw e;
        }
        finally {
            mainDatabase.endTransaction();
        }
    }

    public String[] getActivitiesList() {
        return new String[]{ACTIVITY_FETCH, ACTIVITY_ROBOTSPARSE, ACTIVITY_LOGON_START, ACTIVITY_LOGON_END};
    }

    public String[] getRelationshipTypes() {
        return new String[]{REL_LINK, REL_REDIRECT};
    }

    public void clearThreadContext() {
        super.clearThreadContext();
        this.robotsManager = null;
        this.dnsManager = null;
        this.cookieManager = null;
    }

    protected void getSession() throws ManifoldCFException {
        if (this.robotsManager == null || this.dnsManager == null || this.cookieManager == null) {
            IDBInterface databaseHandle = DBInterfaceFactory.make((IThreadContext)this.currentContext, (String)ManifoldCF.getMasterDatabaseName(), (String)ManifoldCF.getMasterDatabaseUsername(), (String)ManifoldCF.getMasterDatabasePassword());
            this.robotsManager = new RobotsManager(this.currentContext, databaseHandle);
            this.dnsManager = new DNSManager(this.currentContext, databaseHandle);
            this.cookieManager = new CookieManager(this.currentContext, databaseHandle);
        }
        if (!this.isInitialized) {
            String emailAddress = this.params.getParameter("Email address");
            if (emailAddress == null) {
                throw new ManifoldCFException("Missing email address");
            }
            this.userAgent = "ApacheManifoldCFWebCrawler; " + emailAddress + ")";
            this.from = emailAddress;
            String x = this.params.getParameter("Robots usage");
            this.robotsUsage = 2;
            if (x == null || x.length() == 0 || x.equals("all")) {
                this.robotsUsage = 2;
            } else if (x.equals("none")) {
                this.robotsUsage = 0;
            } else if (x.equals("data")) {
                this.robotsUsage = 1;
            }
            this.throttleDescription = new ThrottleDescription(this.params);
            this.credentialsDescription = new CredentialsDescription(this.params);
            this.trustsDescription = new TrustsDescription(this.params);
            this.isInitialized = true;
        }
    }

    public void poll() throws ManifoldCFException {
        ThrottledFetcher.flushIdleConnections();
    }

    public String check() throws ManifoldCFException {
        this.getSession();
        return super.check();
    }

    public void disconnect() throws ManifoldCFException {
        this.throttleDescription = null;
        this.credentialsDescription = null;
        this.trustsDescription = null;
        this.userAgent = null;
        this.from = null;
        this.isInitialized = false;
        super.disconnect();
    }

    public String[] getBinNames(String documentIdentifier) {
        try {
            URI uri = new URI(documentIdentifier);
            return new String[]{uri.getHost()};
        }
        catch (URISyntaxException e) {
            return new String[]{""};
        }
    }

    public void addSeedDocuments(ISeedingActivity activities, DocumentSpecification spec, long startTime, long endTime) throws ManifoldCFException, ServiceInterruption {
        this.getSession();
        DocumentURLFilter filter = new DocumentURLFilter(spec);
        String seeds = "";
        int i = 0;
        while (i < spec.getChildCount()) {
            SpecificationNode sn;
            if (!(sn = spec.getChild(i++)).getType().equals("seeds")) continue;
            seeds = sn.getValue();
        }
        ArrayList list = WebcrawlerConnector.stringToArray(seeds);
        int index = 0;
        while (index < list.size()) {
            String urlCandidate;
            String documentIdentifier;
            if ((documentIdentifier = this.makeDocumentIdentifier(null, urlCandidate = (String)list.get(index++), filter)) == null) {
                Logging.connectors.warn((Object)("WEB: Illegal seed URL '" + urlCandidate + "'"));
                continue;
            }
            activities.addSeedDocument(documentIdentifier, this.calculateDocumentEvents((INamingActivity)activities, documentIdentifier));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public String[] getDocumentVersions(String[] documentIdentifiers, String[] oldVersions, IVersionActivity activities, DocumentSpecification spec, int jobMode, boolean usesDefaultAuthority) throws ManifoldCFException, ServiceInterruption {
        this.getSession();
        connectionLimit = 200;
        acls = WebcrawlerConnector.getAcls(spec);
        Arrays.sort(acls);
        namesAndValues = WebcrawlerConnector.findMetadata(spec);
        metadata = new String[namesAndValues.size()];
        k = 0;
        fixedListStrings = new String[2];
        while (k < metadata.length) {
            nv = (NameValue)namesAndValues.get(k);
            name = nv.getName();
            value = nv.getValue();
            fixedListStrings[0] = name;
            fixedListStrings[1] = value;
            newsb = new StringBuffer();
            WebcrawlerConnector.packFixedList(newsb, fixedListStrings, '=');
            metadata[k++] = newsb.toString();
        }
        Arrays.sort(metadata);
        filter = new DocumentURLFilter(spec);
        rval = new String[documentIdentifiers.length];
        currentTime = System.currentTimeMillis();
        block21: for (i = 0; i < documentIdentifiers.length; ++i) {
            documentIdentifier = documentIdentifiers[i];
            if (filter.isDocumentAndHostLegal(documentIdentifier)) {
                sessionCredential = this.getSequenceCredential(documentIdentifier);
                sessionState = false;
                currentURI = documentIdentifier;
                formData = null;
                if (sessionCredential != null) {
                    sequenceKey = sessionCredential.getSequenceKey();
                    globalSequenceEvent = this.makeSessionLoginEventName((INamingActivity)activities, sequenceKey);
                } else {
                    globalSequenceEvent = null;
                }
                try {
                    block80: {
                        resultSignal = 0;
                        activityResultCode = null;
                        contextMessage = null;
                        contextException = null;
                        checkSum = null;
                        try {
                            while ((ipAddressStatus = this.lookupIPAddress(currentURI, activities, hostName = (url = new URL(currentURI)).getHost(), currentTime, ipAddressBuffer = new StringBuffer())) == 1) {
                                ipAddress = ipAddressBuffer.toString();
                                protocol = url.getProtocol();
                                port = url.getPort();
                                if (port == -1) {
                                    port = url.getDefaultPort();
                                }
                                binNames = this.getBinNames(currentURI);
                                credential = this.getPageCredential(currentURI);
                                trustStore = protocol.equalsIgnoreCase("https") != false ? this.getTrustStore(currentURI) : KeystoreManagerFactory.make((String)"");
                                robotsStatus = 1;
                                if (!documentIdentifier.equals(currentURI) || this.robotsUsage < 1 || (robotsStatus = this.checkFetchAllowed(documentIdentifier, protocol, ipAddress, port, credential, trustStore, hostName, binNames, currentTime, url.getFile(), activities, connectionLimit)) == 1) {
                                    lc = null;
                                    if (sessionCredential != null) {
                                        lc = this.cookieManager.readCookies(sessionCredential.getSequenceKey());
                                    }
                                    connection = ThrottledFetcher.getConnection(protocol, ipAddress, port, credential, trustStore, this.throttleDescription, binNames, connectionLimit);
                                    try {
                                        connection.beginFetch(sessionState == true ? "LOGIN" : "URL");
                                        try {
                                            connection.executeFetch(url.getFile(), this.userAgent, this.from, this.connectionTimeoutMilliseconds, this.socketTimeoutMilliseconds, false, hostName, formData, lc);
                                            response = connection.getResponseCode();
                                            if (response == 200 || response == 302 || response == 301) {
                                                if (sessionState) {
                                                    lastFetchCookies = connection.getLastFetchCookies();
                                                    this.cookieManager.updateCookies(sessionCredential.getSequenceKey(), lastFetchCookies);
                                                }
                                                if ((contentType = connection.getResponseHeader("Content-Type")) != null) {
                                                    contentTypes = contentType.split(",");
                                                    contentType = contentTypes.length > 0 ? contentTypes[contentTypes.length - 1].trim() : null;
                                                }
                                                if (this.isContentInteresting((IFingerprintActivity)activities, currentURI, response, contentType)) {
                                                    checkSum = WebcrawlerConnector.cache.addData(activities, currentURI, connection);
                                                    resultSignal = 2;
                                                    activityResultCode = null;
                                                } else {
                                                    contextMessage = "it had the wrong content type";
                                                    resultSignal = 0;
                                                    activityResultCode = null;
                                                }
                                            } else {
                                                contextMessage = "it failed to fetch (status=" + Integer.toString(response) + ")";
                                                resultSignal = 1;
                                                activityResultCode = null;
                                            }
                                        }
                                        catch (ManifoldCFException e) {
                                            connection.noteInterrupted(e);
                                            throw e;
                                        }
                                        catch (ServiceInterruption e) {
                                            connection.noteInterrupted(e);
                                            throw e;
                                        }
                                        finally {
                                            connection.doneFetch(activities);
                                        }
                                    }
                                    finally {
                                        connection.close();
                                    }
                                    preferredLink = null;
                                    preferredRedirection = null;
                                    formData = null;
                                    if (resultSignal == 2) {
                                        isLoginPage = false;
                                        if (sessionCredential != null) {
                                            iterMatches = sessionCredential.findLoginParameters(currentURI);
                                            seenAnything = false;
                                            seenFormError = false;
                                            seenLinkError = false;
                                            seenRedirectionError = false;
                                            while (iterMatches.hasNext()) {
                                                seenAnything = true;
                                                lp = (LoginParameters)iterMatches.next();
                                                newFormData = this.findHTMLForm(currentURI, lp);
                                                if (newFormData != null) {
                                                    if (formData != null) {
                                                        seenFormError = true;
                                                        formData = null;
                                                        continue;
                                                    }
                                                    if (seenFormError) continue;
                                                    formData = newFormData;
                                                    preferredLink = null;
                                                    preferredRedirection = null;
                                                    continue;
                                                }
                                                newPreferredLink = this.findHTMLLinkURI(currentURI, lp);
                                                if (newPreferredLink != null) {
                                                    if (preferredLink != null) {
                                                        seenLinkError = true;
                                                        preferredLink = null;
                                                        continue;
                                                    }
                                                    if (seenLinkError || seenFormError || formData != null) continue;
                                                    preferredLink = newPreferredLink;
                                                    preferredRedirection = null;
                                                    continue;
                                                }
                                                newPreferredRedirection = this.findPreferredRedirectionURI(currentURI, lp);
                                                if (newPreferredRedirection == null) continue;
                                                if (preferredRedirection != null) {
                                                    seenRedirectionError = true;
                                                    preferredRedirection = null;
                                                    continue;
                                                }
                                                if (seenRedirectionError || seenLinkError || seenFormError || formData != null || preferredLink != null) continue;
                                                preferredRedirection = newPreferredRedirection;
                                            }
                                            if (formData != null) {
                                                if (Logging.connectors.isDebugEnabled()) {
                                                    Logging.connectors.debug((Object)("WEB: Document '" + currentURI + "' matches form, so determined to be login page for sequence '" + sessionCredential.getSequenceKey() + "'"));
                                                }
                                                isLoginPage = true;
                                            } else if (preferredLink != null) {
                                                if (Logging.connectors.isDebugEnabled()) {
                                                    Logging.connectors.debug((Object)("WEB: Document '" + currentURI + "' matches preferred link, so determined to be login page for sequence '" + sessionCredential.getSequenceKey() + "'"));
                                                }
                                                isLoginPage = true;
                                            } else if (preferredRedirection != null) {
                                                if (Logging.connectors.isDebugEnabled()) {
                                                    Logging.connectors.debug((Object)("WEB: Document '" + currentURI + "' matches preferred redirection, so determined to be login page for sequence '" + sessionCredential.getSequenceKey() + "'"));
                                                }
                                                isLoginPage = true;
                                            } else if (seenAnything && Logging.connectors.isDebugEnabled()) {
                                                Logging.connectors.debug((Object)("WEB: Document '" + currentURI + "' did not match expected form, link, or redirection content for sequence '" + sessionCredential.getSequenceKey() + "'"));
                                            }
                                        }
                                        if (!sessionState && isLoginPage) {
                                            if (activities.beginEventSequence(globalSequenceEvent)) {
                                                if (Logging.connectors.isDebugEnabled()) {
                                                    Logging.connectors.debug((Object)("WEB: For document '" + documentIdentifier + "', beginning login sequence '" + sessionCredential.getSequenceKey() + "'"));
                                                }
                                                activities.recordActivity(null, "begin logon", null, sessionCredential.getSequenceKey(), "OK", null, null);
                                                sessionState = true;
                                            } else {
                                                if (Logging.connectors.isDebugEnabled()) {
                                                    Logging.connectors.debug((Object)("WEB: For document '" + documentIdentifier + "', login sequence '" + sessionCredential.getSequenceKey() + "' was already in progress."));
                                                }
                                                WebcrawlerConnector.cache.deleteData(currentURI);
                                                contextMessage = "login sequence already in progress";
                                                resultSignal = 3;
                                                activityResultCode = null;
                                            }
                                        } else if (sessionState && !isLoginPage) {
                                            activities.completeEventSequence(globalSequenceEvent);
                                            activities.recordActivity(null, "end logon", null, sessionCredential.getSequenceKey(), "OK", null, null);
                                            sessionState = false;
                                            if (!currentURI.equals(documentIdentifier)) {
                                                WebcrawlerConnector.cache.deleteData(currentURI);
                                                currentURI = documentIdentifier;
                                                continue;
                                            }
                                        }
                                        if (resultSignal == 2 && sessionState) {
                                            targetURI = formData != null ? formData.getActionURI() : (preferredLink != null ? preferredLink : preferredRedirection);
                                            WebcrawlerConnector.cache.deleteData(currentURI);
                                            if (targetURI == null) {
                                                activities.completeEventSequence(globalSequenceEvent);
                                                activities.recordActivity(null, "end logon", null, sessionCredential.getSequenceKey(), "NEXT LINK NOT FOUND", null, null);
                                                sessionState = false;
                                                currentURI = documentIdentifier;
                                                continue;
                                            }
                                            currentURI = targetURI;
                                            continue;
                                        }
                                        if (resultSignal != 2 && sessionState) {
                                            activities.completeEventSequence(globalSequenceEvent);
                                            activities.recordActivity(null, "end logon", null, sessionCredential.getSequenceKey(), "LINK TARGET UNSUITABLE", null, null);
                                            sessionState = false;
                                        }
                                    }
                                    break block80;
                                }
                                if (robotsStatus == 0) {
                                    activityResultCode = "-11";
                                    contextMessage = "robots.txt says so";
                                    resultSignal = 0;
                                } else {
                                    activityResultCode = null;
                                    resultSignal = 3;
                                    contextMessage = "robots prerequisite already in progress";
                                }
                                break block80;
                            }
                            if (ipAddressStatus == 0) {
                                activityResultCode = "-10";
                                contextMessage = "ip address not found";
                                resultSignal = 0;
                            } else {
                                activityResultCode = null;
                                contextMessage = "dns prerequisite already in progress";
                                resultSignal = 3;
                            }
                        }
                        catch (MalformedURLException e) {
                            contextMessage = "was not a valid URL: " + e.getMessage();
                            contextException = e;
                            activityResultCode = "-12";
                            resultSignal = 0;
                        }
                    }
                    if (!currentURI.equals(documentIdentifier)) {
                        activityResultCode = null;
                        if (contextMessage != null) {
                            contextMessage = "for login sequence url '" + currentURI + "': " + contextMessage;
                        }
                        if (resultSignal != 2) {
                            resultSignal = 3;
                        }
                    }
                    if (activityResultCode != null) {
                        activities.recordActivity(null, "fetch", null, documentIdentifier, activityResultCode, contextMessage != null ? contextMessage : "", null);
                    }
                    switch (resultSignal) {
                        case 0: {
                            if (Logging.connectors.isDebugEnabled()) {
                                Logging.connectors.debug((Object)("WEB: Removing url '" + documentIdentifier + "'" + (contextMessage != null ? " because " + contextMessage : "")), (Throwable)contextException);
                            }
                            rval[i] = null;
                            ** break;
lbl232:
                            // 1 sources

                            continue block21;
                        }
                        case 1: {
                            if (Logging.connectors.isDebugEnabled()) {
                                Logging.connectors.debug((Object)("WEB: Ignoring url '" + documentIdentifier + "'" + (contextMessage != null ? " because " + contextMessage : "")), (Throwable)contextException);
                            }
                            rval[i] = "";
                            ** break;
lbl238:
                            // 1 sources

                            continue block21;
                        }
                        case 2: {
                            sb = new StringBuffer();
                            WebcrawlerConnector.packList(sb, (String[])acls, '+');
                            if (acls.length > 0) {
                                sb.append('+');
                                WebcrawlerConnector.pack(sb, "DEAD_AUTHORITY", '+');
                            } else {
                                sb.append('-');
                            }
                            WebcrawlerConnector.packList(sb, (String[])metadata, '+');
                            sb.append(checkSum);
                            rval[i] = sb.toString();
                            ** break;
lbl254:
                            // 1 sources

                            continue block21;
                        }
                        case 3: {
                            if (Logging.connectors.isDebugEnabled()) {
                                Logging.connectors.debug((Object)("WEB: Retrying url '" + documentIdentifier + "' later" + (contextMessage != null ? " because " + contextMessage : "")), (Throwable)contextException);
                            }
                            activities.retryDocumentProcessing(documentIdentifier);
                            rval[i] = null;
                            ** break;
lbl261:
                            // 1 sources

                            continue block21;
                        }
                        default: {
                            throw new ManifoldCFException("Unexpected value for result signal: " + Integer.toString(resultSignal));
                        }
                    }
                }
                finally {
                    if (sessionState && globalSequenceEvent != null) {
                        activities.completeEventSequence(globalSequenceEvent);
                    }
                }
            }
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("WEB: Removing url '" + documentIdentifier + "' because it's not in the set of allowed ones"));
            }
            rval[i] = null;
        }
        return rval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processDocuments(String[] documentIdentifiers, String[] versions, IProcessActivity activities, DocumentSpecification spec, boolean[] scanOnly) throws ManifoldCFException, ServiceInterruption {
        this.getSession();
        DocumentURLFilter filter = new DocumentURLFilter(spec);
        String[] fixedList = new String[2];
        int i = 0;
        while (i < documentIdentifiers.length) {
            String documentIdentifier = documentIdentifiers[i];
            String version = versions[i];
            boolean doScanOnly = scanOnly[i];
            if (version.length() == 0) {
                ++i;
                activities.deleteDocument(documentIdentifier);
                continue;
            }
            boolean indexDocument = this.extractLinks(documentIdentifier, activities, filter);
            if (!doScanOnly) {
                if (indexDocument) {
                    indexDocument = this.isDataIngestable((IFingerprintActivity)activities, documentIdentifier);
                }
                if (indexDocument) {
                    if (Logging.connectors.isDebugEnabled()) {
                        Logging.connectors.debug((Object)("WEB: Decided to ingest '" + documentIdentifier + "'"));
                    }
                    ArrayList acls = new ArrayList();
                    StringBuffer denyAclBuffer = new StringBuffer();
                    ArrayList metadata = new ArrayList();
                    int index = WebcrawlerConnector.unpackList(acls, version, 0, '+');
                    if (index < version.length() && version.charAt(index++) == '+') {
                        index = WebcrawlerConnector.unpack(denyAclBuffer, version, index, '+');
                    }
                    index = WebcrawlerConnector.unpackList(metadata, version, index, '+');
                    RepositoryDocument rd = new RepositoryDocument();
                    String[] aclArray = new String[acls.size()];
                    for (int j = 0; j < aclArray.length; ++j) {
                        aclArray[j] = (String)acls.get(j);
                    }
                    rd.setACL(aclArray);
                    if (denyAclBuffer.length() > 0) {
                        String[] denyAclArray = new String[]{denyAclBuffer.toString()};
                        rd.setDenyACL(denyAclArray);
                    }
                    HashMap<String, HashMap<String, String>> metaHash = new HashMap<String, HashMap<String, String>>();
                    int k = 0;
                    while (k < metadata.size()) {
                        String metadataItem = (String)metadata.get(k++);
                        WebcrawlerConnector.unpackFixedList(fixedList, metadataItem, 0, '=');
                        HashMap<String, String> hashValue = (HashMap<String, String>)metaHash.get(fixedList[0]);
                        if (hashValue == null) {
                            hashValue = new HashMap<String, String>();
                            metaHash.put(fixedList[0], hashValue);
                        }
                        hashValue.put(fixedList[1], fixedList[1]);
                    }
                    for (String key : metaHash.keySet()) {
                        HashMap metaList = (HashMap)metaHash.get(key);
                        String[] values = new String[metaList.size()];
                        Iterator iter = metaList.keySet().iterator();
                        k = 0;
                        while (iter.hasNext()) {
                            values[k] = (String)iter.next();
                            ++k;
                        }
                        rd.addField(key, values);
                    }
                    long length = cache.getDataLength(documentIdentifier);
                    InputStream is = cache.getData(documentIdentifier);
                    if (is != null) {
                        try {
                            rd.setBinary(is, length);
                            activities.ingestDocument(documentIdentifier, version, documentIdentifier, rd);
                        }
                        finally {
                            try {
                                is.close();
                            }
                            catch (SocketException e) {
                                throw new ManifoldCFException("Socket timeout error closing stream: " + e.getMessage(), (Throwable)e);
                            }
                            catch (ConnectTimeoutException e) {
                                throw new ManifoldCFException("Socket connect timeout error closing stream: " + e.getMessage(), (Throwable)e);
                            }
                            catch (InterruptedIOException e) {
                                throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
                            }
                            catch (IOException e) {
                                throw new ManifoldCFException("IO error closing stream: " + e.getMessage(), (Throwable)e);
                            }
                        }
                    }
                    Logging.connectors.error((Object)("WEB: Expected a cached document for '" + documentIdentifier + "', but none present!"));
                } else {
                    activities.ingestDocument(documentIdentifier, version, null, null);
                    if (Logging.connectors.isDebugEnabled()) {
                        Logging.connectors.debug((Object)("WEB: Decided not to ingest '" + documentIdentifier + "' because it did not match ingestability criteria"));
                    }
                }
            }
            ++i;
        }
    }

    public void releaseDocumentVersions(String[] documentIdentifiers, String[] versions) throws ManifoldCFException {
        for (int i = 0; i < documentIdentifiers.length; ++i) {
            String version = versions[i];
            if (version == null) continue;
            String urlValue = documentIdentifiers[i];
            cache.deleteData(urlValue);
        }
    }

    public int getMaxDocumentRequest() {
        return 1;
    }

    public void outputConfigurationHeader(IThreadContext threadContext, IHTTPOutput out, ConfigParams parameters, ArrayList tabsArray) throws ManifoldCFException, IOException {
        tabsArray.add("Email");
        tabsArray.add("Robots");
        tabsArray.add("Bandwidth");
        tabsArray.add("Access Credentials");
        tabsArray.add("Certificates");
        out.print("<script type=\"text/javascript\">\n<!--\nfunction checkConfig()\n{\n  if (editconnection.email.value != \"\" && editconnection.email.value.indexOf(\"@\") == -1)\n  {\n    alert(\"Need a valid email address\");\n    editconnection.email.focus();\n    return false;\n  }\n\n  // If the Bandwidth tab is up, check to be sure we have valid numbers and regexps everywhere.\n  var i = 0;\n  var count = editconnection.bandwidth_count.value;\n  while (i < count)\n  {\n    var connections = eval(\"editconnection.connections_bandwidth_\"+i+\".value\");\n    if (connections != \"\" && !isInteger(connections))\n    {\n      alert(\"Maximum connections must be an integer\");\n      eval(\"editconnection.connections_bandwidth_\"+i+\".focus()\");\n      return false;\n    }\n    var rate = eval(\"editconnection.rate_bandwidth_\"+i+\".value\");\n    if (rate != \"\" && !isInteger(rate))\n    {\n      alert(\"Maximum Kbytes per second must be an integer\");\n      eval(\"editconnection.rate_bandwidth_\"+i+\".focus()\");\n      return false;\n    }\n    var fetches = eval(\"editconnection.fetches_bandwidth_\"+i+\".value\");\n    if (fetches != \"\" && !isInteger(fetches))\n    {\n      alert(\"Maximum fetches per minute must be an integer\");\n      eval(\"editconnection.fetches_bandwidth_\"+i+\".focus()\");\n      return false;\n    }\n\n    i = i + 1;\n  }\n    \n  // Make sure access credentials are all legal\n  i = 0;\n  count = editconnection.acredential_count.value;\n  while (i < count)\n  {\n    var username = eval(\"editconnection.username_acredential_\"+i+\".value\");\n    if (username == \"\")\n    {\n      alert(\"Credential must have non-null user name\");\n      eval(\"editconnection.username_acredential_\"+i+\".focus()\");\n      return false;\n    }\n    i = i + 1;\n  }\n\n  // Make sure session credentials are all legal\n  i = 0;\n  count = editconnection.scredential_count.value;\n  while (i < count)\n  {\n    var loginpagecount = eval(\"editconnection.scredential_\"+i+\"_loginpagecount.value\");\n    var j = 0;\n    while (j < loginpagecount)\n    {\n      var matchregexp = eval(\"editconnection.scredential_\"+i+\"_\"+j+\"_matchregexp.value\");\n      if (!isRegularExpression(matchregexp))\n      {\n        alert(\"Match expression must be a valid regular expression\");\n        eval(\"editconnection.scredential_\"+i+\"_\"+j+\"_matchregexp.focus()\");\n        return false;\n      }\n      if (eval(\"editconnection.scredential_\"+i+\"_\"+j+\"_type.value\") == \"form\")\n      {\n        var paramcount = eval(\"editconnection.scredential_\"+i+\"_\"+j+\"_loginparamcount.value\");\n        var k = 0;\n        while (k < paramcount)\n        {\n          var paramname = eval(\"editconnection.scredential_\"+i+\"_\"+j+\"_\"+k+\"_param.value\");\n          if (paramname == \"\")\n          {\n            alert(\"Parameter must have non-empty name\");\n            eval(\"editconnection.scredential_\"+i+\"_\"+j+\"_\"+k+\"_param.focus()\");\n            return false;\n          }\n          var paramvalue = eval(\"editconnection.scredential_\"+i+\"_\"+j+\"_\"+k+\"_value.value\");\n          var parampassword = eval(\"editconnection.scredential_\"+i+\"_\"+j+\"_\"+k+\"_password.value\");\n          if (paramvalue != \"\" && parampassword != \"\")\n          {\n            alert(\"Parameter can either be hidden or not, but can't be both\");\n            eval(\"editconnection.scredential_\"+i+\"_\"+j+\"_\"+k+\"_value.focus()\");\n            return false;\n          }\n          k = k + 1;\n        }\n      }\n      j = j + 1;\n    }\n    i = i + 1;\n  }\n  return true;\n}\n\nfunction checkConfigForSave()\n{\n  if (editconnection.email.value == \"\")\n  {\n    alert(\"Email address required, to be included in all request headers\");\n    SelectTab(\"Email\");\n    editconnection.email.focus();\n    return false;\n  }\n  return true;\n}\n\nfunction deleteRegexp(i)\n{\n  // Set the operation\n  eval(\"editconnection.op_bandwidth_\"+i+\".value=\\\"Delete\\\"\");\n  // Submit\n  if (editconnection.bandwidth_count.value==i)\n    postFormSetAnchor(\"bandwidth\");\n  else\n    postFormSetAnchor(\"bandwidth_\"+i)\n  // Undo, so we won't get two deletes next time\n  eval(\"editconnection.op_bandwidth_\"+i+\".value=\\\"Continue\\\"\");\n}\n\nfunction addRegexp()\n{\n  if (editconnection.connections_bandwidth.value != \"\" && !isInteger(editconnection.connections_bandwidth.value))\n  {\n    alert(\"Maximum connections must be an integer\");\n    editconnection.connections_bandwidth.focus();\n    return;\n  }\n  if (editconnection.rate_bandwidth.value != \"\" && !isInteger(editconnection.rate_bandwidth.value))\n  {\n    alert(\"Maximum Kbytes per second must be an integer\");\n    editconnection.rate_bandwidth.focus();\n    return;\n  }\n  if (editconnection.fetches_bandwidth.value != \"\" && !isInteger(editconnection.fetches_bandwidth.value))\n  {\n    alert(\"Maximum fetches per minute must be an integer\");\n    editconnection.fetches_bandwidth.focus();\n    return;\n  }\n  if (!isRegularExpression(editconnection.regexp_bandwidth.value))\n  {\n    alert(\"A valid regular expression is required\");\n    editconnection.regexp_bandwidth.focus();\n    return;\n  }\n  editconnection.bandwidth_op.value=\"Add\";\n  postFormSetAnchor(\"bandwidth\");\n}\n\nfunction deleteARegexp(i)\n{\n  // Set the operation\n  eval(\"editconnection.op_acredential_\"+i+\".value=\\\"Delete\\\"\");\n  // Submit\n  if (editconnection.acredential_count.value==i)\n    postFormSetAnchor(\"acredential\");\n  else\n    postFormSetAnchor(\"acredential_\"+i)\n  // Undo, so we won't get two deletes next time\n  eval(\"editconnection.op_acredential_\"+i+\".value=\\\"Continue\\\"\");\n}\n\nfunction addARegexp()\n{\n  if (editconnection.username_acredential.value == \"\")\n  {\n    alert(\"Credential must include a non-null user name\");\n    editconnection.username_acredential.focus();\n    return;\n  }\n  if (!isRegularExpression(editconnection.regexp_acredential.value))\n  {\n    alert(\"A valid regular expression is required\");\n    editconnection.regexp_acredential.focus();\n    return;\n  }\n  editconnection.acredential_op.value=\"Add\";\n  postFormSetAnchor(\"acredential\");\n}\n\nfunction deleteSRegexp(i)\n{\n  // Set the operation\n  eval(\"editconnection.scredential_\"+i+\"_op.value=\\\"Delete\\\"\");\n  // Submit\n  if (editconnection.scredential_count.value==i)\n    postFormSetAnchor(\"scredential\");\n  else\n    postFormSetAnchor(\"scredential_\"+i)\n  // Undo, so we won't get two deletes next time\n  eval(\"editconnection.scredential_\"+i+\"_op.value=\\\"Continue\\\"\");\n}\n\nfunction addSRegexp()\n{\n  if (!isRegularExpression(editconnection.scredential_regexp.value))\n  {\n    alert(\"A valid regular expression is required\");\n    editconnection.scredential_regexp.focus();\n    return;\n  }\n  editconnection.scredential_op.value=\"Add\";\n  postFormSetAnchor(\"scredential\");\n}\n\nfunction deleteLoginPage(credential,loginpage)\n{\n  // Set the operation\n  eval(\"editconnection.scredential_\"+credential+\"_\"+loginpage+\"_op.value=\\\"Delete\\\"\");\n  // Submit\n  if (eval(\"editconnection.scredential_\"+credential+\"_loginpagecount.value\")==credential)\n    postFormSetAnchor(\"scredential_loginpage\");\n  else\n    postFormSetAnchor(\"scredential_\"+credential+\"_\"+loginpage)\n  // Undo, so we won't get two deletes next time\n  eval(\"editconnection.scredential_\"+credential+\"_\"+loginpage+\"_op.value=\\\"Continue\\\"\");\n\n}\n  \nfunction addLoginPage(credential)\n{\n  if (!isRegularExpression(eval(\"editconnection.scredential_\"+credential+\"_loginpageregexp.value\")))\n  {\n    alert(\"A valid regular expression is required\");\n    eval(\"editconnection.scredential_\"+credential+\"_loginpageregexp.focus()\");\n    return;\n  }\n  if (!isRegularExpression(eval(\"editconnection.scredential_\"+credential+\"_loginpagematchregexp.value\")))\n  {\n    alert(\"A valid regular expression is required\");\n    eval(\"editconnection.scredential_\"+credential+\"_loginpagematchregexp.focus()\");\n    return;\n  }\n  eval(\"editconnection.scredential_\"+credential+\"_loginpageop.value=\\\"Add\\\"\");\n  postFormSetAnchor(\"scredential_\"+credential);\n}\n  \nfunction deleteLoginPageParameter(credential,loginpage,parameter)\n{\n  // Set the operation\n  eval(\"editconnection.scredential_\"+credential+\"_\"+loginpage+\"_\"+parameter+\"_op.value=\\\"Delete\\\"\");\n  // Submit\n  if (eval(\"editconnection.scredential_\"+credential+\"_\"+loginpage+\"_loginparamcount.value\")==credential)\n    postFormSetAnchor(\"scredential_\"+credential+\"_loginparam\");\n  else\n    postFormSetAnchor(\"scredential_\"+credential+\"_\"+loginpage+\"_\"+parameter)\n  // Undo, so we won't get two deletes next time\n  eval(\"editconnection.scredential_\"+credential+\"_\"+loginpage+\"_\"+parameter+\"_op.value=\\\"Continue\\\"\");\n}\n  \nfunction addLoginPageParameter(credential,loginpage)\n{\n  if (!isRegularExpression(eval(\"editconnection.scredential_\"+credential+\"_\"+loginpage+\"_loginparamname.value\")))\n  {\n    alert(\"Parameter name must be a regular expression\");\n    eval(\"editconnection.scredential_\"+credential+\"_\"+loginpage+\"_loginparamname.focus()\");\n    return;\n  }\n  if (eval(\"editconnection.scredential_\"+credential+\"_\"+loginpage+\"_loginparamvalue.value\") != \"\" && eval(\"editconnection.scredential_\"+credential+\"_\"+loginpage+\"_loginparampassword.value\") != \"\")\n  {\n    alert(\"Parameter can either be hidden or not but can't be both\");\n    eval(\"editconnection.scredential_\"+credential+\"_\"+loginpage+\"_loginparamvalue.focus()\");\n    return;\n  }\n  eval(\"editconnection.scredential_\"+credential+\"_\"+loginpage+\"_loginparamop.value=\\\"Add\\\"\");\n  postFormSetAnchor(\"scredential_\"+credential+\"_\"+loginpage);\n}\n  \nfunction deleteTRegexp(i)\n{\n  // Set the operation\n  eval(\"editconnection.op_trust_\"+i+\".value=\\\"Delete\\\"\");\n  // Submit\n  if (editconnection.trust_count.value==i)\n    postFormSetAnchor(\"trust\");\n  else\n    postFormSetAnchor(\"trust_\"+i)\n  // Undo, so we won't get two deletes next time\n  eval(\"editconnection.op_trust_\"+i+\".value=\\\"Continue\\\"\");\n}\n\nfunction addTRegexp()\n{\n  if (editconnection.certificate_trust.value == \"\" && editconnection.all_trust.checked == false)\n  {\n    alert(\"Specify a trust certificate file to upload first, or check 'Trust everything'\");\n    editconnection.certificate_trust.focus();\n    return;\n  }\n  if (!isRegularExpression(editconnection.regexp_trust.value))\n  {\n    alert(\"A valid regular expression is required\");\n    editconnection.regexp_trust.focus();\n    return;\n  }\n  editconnection.trust_op.value=\"Add\";\n  postFormSetAnchor(\"trust\");\n}\n  \n//-->\n</script>\n");
    }

    public void outputConfigurationBody(IThreadContext threadContext, IHTTPOutput out, ConfigParams parameters, String tabName) throws ManifoldCFException, IOException {
        String trustEverything;
        String prefix;
        int trustsCounter;
        String authParamPrefix;
        String password;
        String value;
        String param;
        ConfigNode paramNode;
        int paramCounter;
        int z;
        String authpagePrefix;
        String matchRegexp;
        String pageType;
        String pageRegexp;
        String prefix2;
        String password2;
        String userName;
        String domain;
        String regexp;
        String type;
        int accessCounter;
        String prefix3;
        String prefix4;
        ConfigNode childNode;
        int j;
        String maxFetchesPerMinute;
        String maxKBPerSecond;
        String maxConnections;
        String isCaseInsensitive;
        String regexp2;
        ConfigNode cn;
        int binCounter;
        int i;
        String robotsUsage;
        String email = parameters.getParameter("Email address");
        if (email == null) {
            email = "";
        }
        if ((robotsUsage = parameters.getParameter("Robots usage")) == null) {
            robotsUsage = "all";
        }
        if (tabName.equals("Email")) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>Email address to contact:</nobr></td>\n    <td class=\"value\">\n      <input type=\"text\" size=\"32\" name=\"email\" value=\"" + Encoder.attributeEscape((String)email) + "\"/>\n" + "    </td>\n" + "  </tr>\n" + "</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"email\" value=\"" + Encoder.attributeEscape((String)email) + "\"/>\n");
        }
        if (tabName.equals("Robots")) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>Robots.txt usage:</nobr></td>\n    <td class=\"value\">\n      <select name=\"robotsusage\" size=\"3\">\n        <option value=\"none\" " + (robotsUsage.equals("none") ? "selected=\"selected\"" : "") + ">Don't look at robots.txt</option>\n" + "        <option value=\"data\" " + (robotsUsage.equals("data") ? "selected=\"selected\"" : "") + ">Obey robots.txt for data fetches only</option>\n" + "        <option value=\"all\" " + (robotsUsage.equals("all") ? "selected=\"selected\"" : "") + ">Obey robots.txt for all fetches</option>\n" + "      </select>\n" + "    </td>\n" + "  </tr>\n" + "</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"robotsusage\" value=\"" + robotsUsage + "\"/>\n");
        }
        if (tabName.equals("Bandwidth")) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>Throttles:</nobr></td>\n    <td class=\"boxcell\">\n      <table class=\"formtable\">\n        <tr class=\"formheaderrow\">\n          <td class=\"formcolumnheader\"></td>\n          <td class=\"formcolumnheader\"><nobr>Bin regular expression</nobr></td>\n          <td class=\"formcolumnheader\"><nobr>Case insensitive?</nobr></td>\n          <td class=\"formcolumnheader\"><nobr>Max connections</nobr></td>\n          <td class=\"formcolumnheader\"><nobr>Max Kbytes/sec</nobr></td>\n          <td class=\"formcolumnheader\"><nobr>Max fetches/min</nobr></td>\n        </tr>\n");
            i = 0;
            binCounter = 0;
            while (i < parameters.getChildCount()) {
                if (!(cn = parameters.getChild(i++)).getType().equals("bindesc")) continue;
                regexp2 = cn.getAttributeValue("binregexp");
                isCaseInsensitive = cn.getAttributeValue("caseinsensitive");
                maxConnections = null;
                maxKBPerSecond = null;
                maxFetchesPerMinute = null;
                j = 0;
                while (j < cn.getChildCount()) {
                    if ((childNode = cn.getChild(j++)).getType().equals("maxconnections")) {
                        maxConnections = childNode.getAttributeValue("value");
                        continue;
                    }
                    if (childNode.getType().equals("maxkbpersecond")) {
                        maxKBPerSecond = childNode.getAttributeValue("value");
                        continue;
                    }
                    if (!childNode.getType().equals("maxfetchesperminute")) continue;
                    maxFetchesPerMinute = childNode.getAttributeValue("value");
                }
                if (maxConnections == null) {
                    maxConnections = "";
                }
                if (maxKBPerSecond == null) {
                    maxKBPerSecond = "";
                }
                if (maxFetchesPerMinute == null) {
                    maxFetchesPerMinute = "";
                }
                if (isCaseInsensitive == null || isCaseInsensitive.length() == 0) {
                    isCaseInsensitive = "false";
                }
                prefix4 = "bandwidth_" + Integer.toString(binCounter);
                out.print("        <tr class=\"" + (binCounter % 2 == 0 ? "evenformrow" : "oddformrow") + "\">\n" + "          <td class=\"formcolumncell\">\n" + "            <a name=\"" + prefix4 + "\">\n" + "              <input type=\"button\" value=\"Delete\" alt=\"" + "Delete bin regular expression #" + Integer.toString(binCounter + 1) + "\" onclick='javascript:deleteRegexp(" + Integer.toString(binCounter) + ");'/>\n" + "              <input type=\"hidden\" name=\"" + "op_" + prefix4 + "\" value=\"Continue\"/>\n" + "              <input type=\"hidden\" name=\"" + "regexp_" + prefix4 + "\" value=\"" + Encoder.attributeEscape((String)regexp2) + "\"/>\n" + "            </a>\n" + "          </td>\n" + "          <td class=\"formcolumncell\">\n" + "            <nobr>" + Encoder.bodyEscape((String)regexp2) + "</nobr>\n" + "          </td>\n" + "          <td class=\"formcolumncell\">\n" + "            <nobr><input type=\"checkbox\" name=\"insensitive_" + prefix4 + "\" value=\"true\" " + (isCaseInsensitive.equals("true") ? "checked=\"\"" : "") + " /></nobr>\n" + "          </td>\n" + "          <td class=\"formcolumncell\">\n" + "            <nobr><input type=\"text\" size=\"5\" name=\"connections_" + prefix4 + "\" value=\"" + maxConnections + "\"/></nobr>\n" + "          </td>\n" + "          <td class=\"formcolumncell\">\n" + "            <nobr><input type=\"text\" size=\"5\" name=\"rate_" + prefix4 + "\" value=\"" + maxKBPerSecond + "\"/></nobr>\n" + "          </td>\n" + "          <td class=\"formcolumncell\">\n" + "            <nobr><input type=\"text\" size=\"5\" name=\"fetches_" + prefix4 + "\" value=\"" + maxFetchesPerMinute + "\"/></nobr>\n" + "          </td>\n" + "        </tr>\n");
                ++binCounter;
            }
            if (parameters.getChildCount() == 0) {
                prefix3 = "bandwidth_" + Integer.toString(binCounter);
                out.print("        <tr class=\"" + (binCounter % 2 == 0 ? "evenformrow" : "oddformrow") + "\">\n" + "          <td class=\"formcolumncell\">\n" + "            <a name=\"" + prefix3 + "\">\n" + "              <input type=\"button\" value=\"Delete\" alt=\"" + "Delete bin regular expression #" + Integer.toString(binCounter + 1) + "\" onclick='javascript:deleteRegexp(" + Integer.toString(binCounter) + ");'/>\n" + "              <input type=\"hidden\" name=\"" + "op_" + prefix3 + "\" value=\"Continue\"/>\n" + "              <input type=\"hidden\" name=\"" + "regexp_" + prefix3 + "\" value=\"\"/>\n" + "            </a>\n" + "          </td>\n" + "          <td class=\"formcolumncell\">\n" + "            <nobr></nobr>\n" + "          </td>\n" + "          <td class=\"formcolumncell\">\n" + "            <nobr><input type=\"checkbox\" name=\"insensitive_" + prefix3 + "\" value=\"false\"/></nobr>\n" + "          </td>\n" + "          <td class=\"formcolumncell\">\n" + "            <nobr><input type=\"text\" size=\"5\" name=\"connections_" + prefix3 + "\" value=\"2\"/></nobr>\n" + "          </td>\n" + "          <td class=\"formcolumncell\">\n" + "            <nobr><input type=\"text\" size=\"5\" name=\"rate_" + prefix3 + "\" value=\"64\"/></nobr>\n" + "          </td>\n" + "          <td class=\"formcolumncell\">\n" + "            <nobr><input type=\"text\" size=\"5\" name=\"fetches_" + prefix3 + "\" value=\"12\"/></nobr>\n" + "          </td>\n" + "        </tr>\n");
                ++binCounter;
            }
            if (binCounter == 0) {
                out.print("        <tr class=\"formrow\"><td class=\"formmessage\" colspan=\"6\">No bandwidth or connection throttling specified</td></tr>\n");
            }
            out.print("        <tr class=\"formrow\"><td class=\"formseparator\" colspan=\"6\"><hr/></td></tr>\n        <tr class=\"formrow\">\n          <td class=\"formcolumncell\">\n            <a name=\"bandwidth\">\n              <input type=\"button\" value=\"Add\" alt=\"Add bin regular expression\" onclick=\"javascript:addRegexp();\"/>\n            </a>\n            <input type=\"hidden\" name=\"bandwidth_count\" value=\"" + binCounter + "\"/>\n" + "            <input type=\"hidden\" name=\"bandwidth_op\" value=\"Continue\"/>\n" + "          </td>\n" + "          <td class=\"formcolumncell\">\n" + "            <nobr><input type=\"text\" size=\"30\" name=\"regexp_bandwidth\" value=\"\"/></nobr>\n" + "          </td>\n" + "          <td class=\"formcolumncell\">\n" + "            <nobr><input type=\"checkbox\" name=\"insensitive_bandwidth\" value=\"true\"/></nobr>\n" + "          </td>\n" + "          <td class=\"formcolumncell\">\n" + "            <nobr><input type=\"text\" size=\"5\" name=\"connections_bandwidth\" value=\"\"/></nobr>\n" + "          </td>\n" + "          <td class=\"formcolumncell\">\n" + "            <nobr><input type=\"text\" size=\"5\" name=\"rate_bandwidth\" value=\"\"/></nobr>\n" + "          </td>\n" + "          <td class=\"formcolumncell\">\n" + "            <nobr><input type=\"text\" size=\"5\" name=\"fetches_bandwidth\" value=\"\"/></nobr>\n" + "          </td>\n" + "        </tr>\n" + "      </table>\n" + "    </td>\n" + "  </tr>\n" + "</table>\n");
        } else {
            i = 0;
            binCounter = 0;
            while (i < parameters.getChildCount()) {
                if (!(cn = parameters.getChild(i++)).getType().equals("bindesc")) continue;
                regexp2 = cn.getAttributeValue("binregexp");
                isCaseInsensitive = cn.getAttributeValue("caseinsensitive");
                maxConnections = null;
                maxKBPerSecond = null;
                maxFetchesPerMinute = null;
                j = 0;
                while (j < cn.getChildCount()) {
                    if ((childNode = cn.getChild(j++)).getType().equals("maxconnections")) {
                        maxConnections = childNode.getAttributeValue("value");
                        continue;
                    }
                    if (childNode.getType().equals("maxkbpersecond")) {
                        maxKBPerSecond = childNode.getAttributeValue("value");
                        continue;
                    }
                    if (!childNode.getType().equals("maxfetchesperminute")) continue;
                    maxFetchesPerMinute = childNode.getAttributeValue("value");
                }
                if (maxConnections == null) {
                    maxConnections = "";
                }
                if (maxKBPerSecond == null) {
                    maxKBPerSecond = "";
                }
                if (maxFetchesPerMinute == null) {
                    maxFetchesPerMinute = "";
                }
                if (isCaseInsensitive == null || isCaseInsensitive.length() == 0) {
                    isCaseInsensitive = "false";
                }
                prefix4 = "bandwidth_" + Integer.toString(binCounter);
                out.print("<input type=\"hidden\" name=\"regexp_" + prefix4 + "\" value=\"" + Encoder.attributeEscape((String)regexp2) + "\"/>\n" + "<input type=\"hidden\" name=\"" + "insensitive_" + prefix4 + "\" value=\"" + isCaseInsensitive + "\"/>\n" + "<input type=\"hidden\" name=\"" + "connections_" + prefix4 + "\" value=\"" + maxConnections + "\"/>\n" + "<input type=\"hidden\" name=\"" + "rate_" + prefix4 + "\" value=\"" + maxKBPerSecond + "\"/>\n" + "<input type=\"hidden\" name=\"" + "fetches_" + prefix4 + "\" value=\"" + maxFetchesPerMinute + "\"/>\n");
                ++binCounter;
            }
            if (parameters.getChildCount() == 0) {
                prefix3 = "bandwidth_" + Integer.toString(binCounter);
                out.print("<input type=\"hidden\" name=\"regexp_" + prefix3 + "\" value=\"\"/>\n" + "<input type=\"hidden\" name=\"" + "insensitive_" + prefix3 + "\" value=\"false\"/>\n" + "<input type=\"hidden\" name=\"" + "connections_" + prefix3 + "\" value=\"2\"/>\n" + "<input type=\"hidden\" name=\"" + "rate_" + prefix3 + "\" value=\"64\"/>\n" + "<input type=\"hidden\" name=\"" + "fetches_" + prefix3 + "\" value=\"12\"/>\n");
                ++binCounter;
            }
            out.print("<input type=\"hidden\" name=\"bandwidth_count\" value=\"" + binCounter + "\"/>\n");
        }
        if (tabName.equals("Access Credentials")) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>Page access credentials:</nobr></td>\n    <td class=\"boxcell\">\n      <table class=\"formtable\">\n        <tr class=\"formheaderrow\">\n          <td class=\"formcolumnheader\"></td>\n          <td class=\"formcolumnheader\"><nobr>URL regular expression</nobr></td>\n          <td class=\"formcolumnheader\"><nobr>Authentication type</nobr></td>\n          <td class=\"formcolumnheader\"><nobr>Domain</nobr></td>\n          <td class=\"formcolumnheader\"><nobr>User name</nobr></td>\n          <td class=\"formcolumnheader\"><nobr>Password</nobr></td>\n        </tr>\n");
            i = 0;
            accessCounter = 0;
            while (i < parameters.getChildCount()) {
                if (!(cn = parameters.getChild(i++)).getType().equals("accesscredential") || (type = cn.getAttributeValue("type")).equals("session")) continue;
                regexp = cn.getAttributeValue("urlregexp");
                domain = cn.getAttributeValue("domain");
                if (domain == null) {
                    domain = "";
                }
                userName = cn.getAttributeValue("username");
                password2 = ManifoldCF.deobfuscate((String)cn.getAttributeValue("password"));
                String prefix5 = "acredential_" + Integer.toString(accessCounter);
                out.print("        <tr class=\"" + (accessCounter % 2 == 0 ? "evenformrow" : "oddformrow") + "\">\n" + "          <td class=\"formcolumncell\">\n" + "            <a name=\"" + prefix5 + "\">\n" + "              <input type=\"button\" value=\"Delete\" alt=\"" + "Delete page authentication url regular expression #" + Integer.toString(accessCounter + 1) + "\" onclick='javascript:deleteARegexp(" + Integer.toString(accessCounter) + ");'/>\n" + "              <input type=\"hidden\" name=\"op_" + prefix5 + "\" value=\"Continue\"/>\n" + "              <input type=\"hidden\" name=\"regexp_" + prefix5 + "\" value=\"" + Encoder.attributeEscape((String)regexp) + "\"/>\n" + "            </a>\n" + "          </td>\n" + "          <td class=\"formcolumncell\">\n" + "            <nobr>" + Encoder.bodyEscape((String)regexp) + "</nobr>\n" + "          </td>\n" + "          <td class=\"formcolumncell\">\n" + "            <nobr><input type=\"radio\" name=\"type_" + prefix5 + "\" value=\"basic\" " + (type.equals("basic") ? "checked=\"\"" : "") + " />&nbsp;Basic authentication</nobr><br/>\n" + "            <nobr><input type=\"radio\" name=\"type_" + prefix5 + "\" value=\"ntlm\" " + (type.equals("ntlm") ? "checked=\"\"" : "") + " />&nbsp;NTLM authentication</nobr>\n" + "          </td>\n" + "          <td class=\"formcolumncell\">\n" + "            <nobr><input type=\"text\" size=\"16\" name=\"" + "domain_" + prefix5 + "\" value=\"" + Encoder.attributeEscape((String)domain) + "\"/></nobr>\n" + "          </td>\n" + "          <td class=\"formcolumncell\">\n" + "            <nobr><input type=\"text\" size=\"16\" name=\"" + "username_" + prefix5 + "\" value=\"" + Encoder.attributeEscape((String)userName) + "\"/></nobr>\n" + "          </td>\n" + "          <td class=\"formcolumncell\">\n" + "            <nobr><input type=\"password\" size=\"16\" name=\"" + "password_" + prefix5 + "\" value=\"" + Encoder.attributeEscape((String)password2) + "\"/></nobr>\n" + "          </td>\n" + "        </tr>\n");
                ++accessCounter;
            }
            if (accessCounter == 0) {
                out.print("        <tr class=\"formrow\"><td class=\"formmessage\" colspan=\"6\">No page access credentials specified</td></tr>\n");
            }
            out.print("        <tr class=\"formrow\"><td class=\"formseparator\" colspan=\"6\"><hr/></td></tr>\n        <tr class=\"formrow\">\n          <td class=\"formcolumncell\">\n            <a name=\"acredential\">\n              <input type=\"button\" value=\"Add\" alt=\"Add page authentication url regular expression\" onclick=\"javascript:addARegexp();\"/>\n            </a>\n            <input type=\"hidden\" name=\"acredential_count\" value=\"" + accessCounter + "\"/>\n" + "            <input type=\"hidden\" name=\"acredential_op\" value=\"Continue\"/>\n" + "          </td>\n" + "          <td class=\"formcolumncell\">\n" + "            <nobr><input type=\"text\" size=\"30\" name=\"regexp_acredential\" value=\"\"/></nobr>\n" + "          </td>\n" + "          <td class=\"formcolumncell\">\n" + "            <nobr><input type=\"radio\" name=\"type_acredential\" value=\"basic\" checked=\"\" />&nbsp;Basic authentication</nobr><br/>\n" + "            <nobr><input type=\"radio\" name=\"type_acredential\" value=\"ntlm\" />&nbsp;NTLM authentication</nobr>\n" + "          </td>\n" + "          <td class=\"formcolumncell\">\n" + "            <nobr><input type=\"text\" size=\"16\" name=\"domain_acredential\" value=\"\"/></nobr>\n" + "          </td>\n" + "          <td class=\"formcolumncell\">\n" + "            <nobr><input type=\"text\" size=\"16\" name=\"username_acredential\" value=\"\"/></nobr>\n" + "          </td>\n" + "          <td class=\"formcolumncell\">\n" + "            <nobr><input type=\"password\" size=\"16\" name=\"password_acredential\" value=\"\"/></nobr>\n" + "          </td>\n" + "        </tr>\n" + "      </table>\n" + "    </td>\n" + "  </tr>\n" + "        \n" + "  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n" + "\n" + "  <tr>\n" + "    <td class=\"description\"><nobr>Session-based access credentials:</nobr></td>\n" + "    <td class=\"boxcell\">\n" + "      <table class=\"formtable\">\n" + "        <tr class=\"formheaderrow\">\n" + "          <td class=\"formcolumnheader\"></td>\n" + "          <td class=\"formcolumnheader\"><nobr>URL regular expression</nobr></td>\n" + "          <td class=\"formcolumnheader\"><nobr>Login pages</nobr></td>\n" + "        </tr>\n");
            i = 0;
            accessCounter = 0;
            while (i < parameters.getChildCount()) {
                if (!(cn = parameters.getChild(i++)).getType().equals("accesscredential") || !(type = cn.getAttributeValue("type")).equals("session")) continue;
                regexp = cn.getAttributeValue("urlregexp");
                prefix2 = "scredential_" + Integer.toString(accessCounter);
                out.print("        <tr class=\"" + (accessCounter % 2 == 0 ? "evenformrow" : "oddformrow") + "\">\n" + "          <td class=\"formcolumncell\">\n" + "            <a name=\"" + prefix2 + "\">\n" + "              <input type=\"button\" value=\"Delete\" alt=\"" + "Delete session authentication url regular expression #" + Integer.toString(accessCounter + 1) + "\" onclick='javascript:deleteSRegexp(" + Integer.toString(accessCounter) + ");'/>\n" + "              <input type=\"hidden\" name=\"" + prefix2 + "_op" + "\" value=\"Continue\"/>\n" + "              <input type=\"hidden\" name=\"" + prefix2 + "_regexp" + "\" value=\"" + Encoder.attributeEscape((String)regexp) + "\"/>\n" + "            </a>\n" + "          </td>\n" + "          <td class=\"formcolumncell\">\n" + "            <nobr>" + Encoder.bodyEscape((String)regexp) + "</nobr>\n" + "          </td>\n" + "          <td class=\"boxcell\">\n" + "            <table class=\"formtable\">\n" + "              <tr class=\"formheaderrow\">\n" + "                <td class=\"formcolumnheader\"></td>\n" + "                <td class=\"formcolumnheader\"><nobr>Login URL regular expression</nobr></td>\n" + "                <td class=\"formcolumnheader\"><nobr>Page type</nobr></td>\n" + "                <td class=\"formcolumnheader\"><nobr>Form name/link target regular expression</nobr></td>\n" + "                <td class=\"formcolumnheader\"><nobr>Override form parameters</nobr></td>\n" + "              </tr>\n");
                int q = 0;
                int authPageCounter = 0;
                while (q < cn.getChildCount()) {
                    ConfigNode authPageNode;
                    if (!(authPageNode = cn.getChild(q++)).getType().equals("authpage")) continue;
                    pageRegexp = authPageNode.getAttributeValue("urlregexp");
                    pageType = authPageNode.getAttributeValue("type");
                    matchRegexp = authPageNode.getAttributeValue("match");
                    if (matchRegexp == null) {
                        matchRegexp = "";
                    }
                    authpagePrefix = prefix2 + "_" + authPageCounter;
                    out.print("              <tr class=\"" + (authPageCounter % 2 == 0 ? "evenformrow" : "oddformrow") + "\">\n" + "                <td class=\"formcolumncell\">\n" + "                  <a name=\"" + authpagePrefix + "\">\n" + "                    <input type=\"button\" value=\"Delete\" alt=\"" + "Delete login page #" + (authPageCounter + 1) + " for url regular expression #" + Integer.toString(accessCounter + 1) + "\" onclick='javascript:deleteLoginPage(" + Integer.toString(accessCounter) + "," + Integer.toString(authPageCounter) + ");'/>\n" + "                    <input type=\"hidden\" name=\"" + authpagePrefix + "_op" + "\" value=\"Continue\"/>\n" + "                    <input type=\"hidden\" name=\"" + authpagePrefix + "_regexp" + "\" value=\"" + Encoder.attributeEscape((String)pageRegexp) + "\"/>\n" + "                    <input type=\"hidden\" name=\"" + authpagePrefix + "_type" + "\" value=\"" + pageType + "\"/>\n" + "                  </a>\n" + "                </td>\n" + "\n" + "                <td class=\"formcolumncell\"><nobr>" + Encoder.bodyEscape((String)pageRegexp) + "</nobr></td>\n" + "                <td class=\"formcolumncell\"><nobr>" + pageType + "</nobr></td>\n" + "                <td class=\"formcolumncell\"><nobr><input type=\"text\" size=\"30\" name=\"" + authpagePrefix + "_matchregexp" + "\" value=\"" + Encoder.attributeEscape((String)matchRegexp) + "\"/></nobr></td>\n");
                    if (pageType.equals("form")) {
                        out.print("                <td class=\"boxcell\">\n                  <table class=\"formtable\">\n                    <tr class=\"formheaderrow\">\n                      <td class=\"formcolumnheader\"></td>\n                      <td class=\"formcolumnheader\"><nobr>Parameter regular expression</nobr></td>\n                      <td class=\"formcolumnheader\"><nobr>Value</nobr></td>\n                      <td class=\"formcolumnheader\"><nobr>Password</nobr></td>\n                    </tr>\n");
                        z = 0;
                        paramCounter = 0;
                        while (z < authPageNode.getChildCount()) {
                            if (!(paramNode = authPageNode.getChild(z++)).getType().equals("authparameter")) continue;
                            param = paramNode.getAttributeValue("name");
                            if (param == null) {
                                param = "";
                            }
                            if ((value = paramNode.getAttributeValue("value")) == null) {
                                value = "";
                            }
                            if ((password = paramNode.getAttributeValue("password")) == null) {
                                password = "";
                            }
                            authParamPrefix = authpagePrefix + "_" + paramCounter;
                            out.print("                    <tr class=\"" + (paramCounter % 2 == 0 ? "evenformrow" : "oddformrow") + "\">\n" + "                      <td class=\"formcolumncell\">\n" + "                        <a name=\"" + authParamPrefix + "\">\n" + "                          <input type=\"button\" value=\"Delete\" alt=\"" + "Delete parameter #" + (paramCounter + 1) + " for login page #" + (authPageCounter + 1) + " for credential #" + (accessCounter + 1) + "\" onclick='javascript:deleteLoginPageParameter(" + accessCounter + "," + authPageCounter + "," + paramCounter + ");'/>\n" + "                          <input type=\"hidden\" name=\"" + authParamPrefix + "_op" + "\" value=\"Continue\"/>\n" + "                        </a>\n" + "                      </td>\n" + "                      <td class=\"formcolumncell\">\n" + "                        <nobr><input type=\"text\" size=\"30\" name=\"" + authParamPrefix + "_param" + "\" value=\"" + Encoder.attributeEscape((String)param) + "\"/></nobr>\n" + "                      </td>\n" + "                      <td class=\"formcolumncell\">\n" + "                        <nobr><input type=\"text\" size=\"15\" name=\"" + authParamPrefix + "_value" + "\" value=\"" + Encoder.attributeEscape((String)value) + "\"/></nobr>\n" + "                      </td>\n" + "                      <td class=\"formcolumncell\">\n" + "                        <nobr><input type=\"password\" size=\"15\" name=\"" + authParamPrefix + "_password" + "\" value=\"" + Encoder.attributeEscape((String)ManifoldCF.deobfuscate((String)password)) + "\"/></nobr>\n" + "                      </td>\n" + "                    </tr>\n");
                            ++paramCounter;
                        }
                        out.print("                    <tr class=\"formrow\"><td class=\"formseparator\" colspan=\"4\"><hr/></td></tr>\n                    <tr class=\"formrow\">\n                      <td class=\"formcolumncell\">\n                        <a name=\"" + authpagePrefix + "_loginparam" + "\">\n" + "                          <input type=\"button\" value=\"Add\" alt=\"" + "Add parameter to login page #" + (authPageCounter + 1) + " for credential #" + (accessCounter + 1) + "\" onclick='javascript:addLoginPageParameter(" + accessCounter + "," + authPageCounter + ");'/>\n" + "                        </a>\n" + "                        <input type=\"hidden\" name=\"" + authpagePrefix + "_loginparamcount" + "\" value=\"" + paramCounter + "\"/>\n" + "                        <input type=\"hidden\" name=\"" + authpagePrefix + "_loginparamop" + "\" value=\"Continue\"/>\n" + "                      </td>\n" + "                      <td class=\"formcolumncell\">\n" + "                        <nobr><input type=\"text\" size=\"30\" name=\"" + authpagePrefix + "_loginparamname" + "\" value=\"\"/></nobr>\n" + "                      </td>\n" + "                      <td class=\"formcolumncell\">\n" + "                        <nobr><input type=\"text\" size=\"15\" name=\"" + authpagePrefix + "_loginparamvalue" + "\" value=\"\"/></nobr>\n" + "                      </td>\n" + "                      <td class=\"formcolumncell\">\n" + "                        <nobr><input type=\"password\" size=\"15\" name=\"" + authpagePrefix + "_loginparampassword" + "\" value=\"\"/></nobr>\n" + "                      </td>\n" + "                    </tr>\n" + "                  </table>\n" + "                </td>\n");
                    } else {
                        out.print("                <td class=\"formcolumncell\"></td>\n");
                    }
                    out.print("              </tr>\n");
                    ++authPageCounter;
                }
                out.print("              <tr class=\"formrow\"><td class=\"formseparator\" colspan=\"5\"><hr/></td></tr>\n              <tr class=\"formrow\">\n                <td class=\"formcolumncell\">\n                  <a name=\"" + prefix2 + "_loginpage" + "\">\n" + "                    <input type=\"button\" value=\"Add\" alt=\"" + "Add login page to credential #" + (accessCounter + 1) + "\" onclick='javascript:addLoginPage(" + accessCounter + ");'/>\n" + "                  </a>\n" + "                  <input type=\"hidden\" name=\"" + prefix2 + "_loginpagecount" + "\" value=\"" + authPageCounter + "\"/>\n" + "                  <input type=\"hidden\" name=\"" + prefix2 + "_loginpageop" + "\" value=\"Continue\"/>\n" + "                </td>\n" + "                <td class=\"formcolumncell\">\n" + "                  <nobr><input type=\"text\" size=\"30\" name=\"" + prefix2 + "_loginpageregexp" + "\" value=\"\"/></nobr>\n" + "                </td>\n" + "                <td class=\"formcolumncell\">\n" + "                  <nobr><input type=\"radio\" name=\"" + prefix2 + "_loginpagetype" + "\" value=\"" + "form" + "\" checked=\"\"/>&nbsp;Form name</nobr><br/>\n" + "                  <nobr><input type=\"radio\" name=\"" + prefix2 + "_loginpagetype" + "\" value=\"" + REL_LINK + "\"/>&nbsp;Link target</nobr>\n" + "                  <nobr><input type=\"radio\" name=\"" + prefix2 + "_loginpagetype" + "\" value=\"" + "redirection" + "\"/>&nbsp;Redirection</nobr>\n" + "                </td>\n" + "                <td class=\"formcolumncell\">\n" + "                  <nobr><input type=\"text\" size=\"30\" name=\"" + prefix2 + "_loginpagematchregexp" + "\" value=\"\"/></nobr>\n" + "                </td>\n" + "                <td class=\"formcolumncell\">\n" + "                </td>\n" + "              </tr>\n" + "\n" + "            </table>\n" + "          </td>\n" + "        </tr>\n");
                ++accessCounter;
            }
            if (accessCounter == 0) {
                out.print("        <tr class=\"formrow\"><td class=\"formmessage\" colspan=\"3\">No session-based access credentials specified</td></tr>\n");
            }
            out.print("        <tr class=\"formrow\"><td class=\"formseparator\" colspan=\"3\"><hr/></td></tr>\n        <tr class=\"formrow\">\n          <td class=\"formcolumncell\">\n            <a name=\"scredential\">\n              <input type=\"button\" value=\"Add\" alt=\"Add session authentication url regular expression\" onclick=\"javascript:addSRegexp();\"/>\n            </a>\n            <input type=\"hidden\" name=\"scredential_count\" value=\"" + accessCounter + "\"/>\n" + "            <input type=\"hidden\" name=\"scredential_op\" value=\"Continue\"/>\n" + "          </td>\n" + "          <td class=\"formcolumncell\">\n" + "            <nobr><input type=\"text\" size=\"30\" name=\"scredential_regexp\" value=\"\"/></nobr>\n" + "          </td>\n" + "          <td class=\"formcolumncell\">\n" + "          </td>\n" + "        </tr>\n" + "      </table>\n" + "    </td>\n" + "  </tr>\n" + "\n" + "</table>\n");
        } else {
            i = 0;
            accessCounter = 0;
            while (i < parameters.getChildCount()) {
                if (!(cn = parameters.getChild(i++)).getType().equals("accesscredential") || (type = cn.getAttributeValue("type")).equals("session")) continue;
                regexp = cn.getAttributeValue("urlregexp");
                domain = cn.getAttributeValue("domain");
                if (domain == null) {
                    domain = "";
                }
                userName = cn.getAttributeValue("username");
                password2 = ManifoldCF.deobfuscate((String)cn.getAttributeValue("password"));
                String prefix6 = "acredential_" + Integer.toString(accessCounter);
                out.print("<input type=\"hidden\" name=\"regexp_" + prefix6 + "\" value=\"" + Encoder.attributeEscape((String)regexp) + "\"/>\n" + "<input type=\"hidden\" name=\"" + "type_" + prefix6 + "\" value=\"" + type + "\"/>\n" + "<input type=\"hidden\" name=\"" + "domain_" + prefix6 + "\" value=\"" + Encoder.attributeEscape((String)domain) + "\"/>\n" + "<input type=\"hidden\" name=\"" + "username_" + prefix6 + "\" value=\"" + Encoder.attributeEscape((String)userName) + "\"/>\n" + "<input type=\"hidden\" name=\"" + "password_" + prefix6 + "\" value=\"" + Encoder.attributeEscape((String)password2) + "\"/>\n");
                ++accessCounter;
            }
            out.print("<input type=\"hidden\" name=\"acredential_count\" value=\"" + accessCounter + "\"/>\n");
            i = 0;
            accessCounter = 0;
            while (i < parameters.getChildCount()) {
                if (!(cn = parameters.getChild(i++)).getType().equals("accesscredential") || !(type = cn.getAttributeValue("type")).equals("session")) continue;
                regexp = cn.getAttributeValue("urlregexp");
                prefix2 = "scredential_" + Integer.toString(accessCounter);
                out.print("<input type=\"hidden\" name=\"" + prefix2 + "_regexp" + "\" value=\"" + Encoder.attributeEscape((String)regexp) + "\"/>\n");
                int q = 0;
                int authPageCounter = 0;
                while (q < cn.getChildCount()) {
                    ConfigNode authPageNode;
                    if (!(authPageNode = cn.getChild(q++)).getType().equals("authpage")) continue;
                    pageRegexp = authPageNode.getAttributeValue("urlregexp");
                    pageType = authPageNode.getAttributeValue("type");
                    matchRegexp = authPageNode.getAttributeValue("match");
                    if (matchRegexp == null) {
                        matchRegexp = "";
                    }
                    authpagePrefix = prefix2 + "_" + authPageCounter;
                    out.print("<input type=\"hidden\" name=\"" + authpagePrefix + "_regexp" + "\" value=\"" + Encoder.attributeEscape((String)pageRegexp) + "\"/>\n" + "<input type=\"hidden\" name=\"" + authpagePrefix + "_type" + "\" value=\"" + pageType + "\"/>\n" + "<input type=\"hidden\" name=\"" + authpagePrefix + "_matchregexp" + "\" value=\"" + Encoder.attributeEscape((String)matchRegexp) + "\"/>\n");
                    if (pageType.equals("form")) {
                        z = 0;
                        paramCounter = 0;
                        while (z < authPageNode.getChildCount()) {
                            if (!(paramNode = authPageNode.getChild(z++)).getType().equals("authparameter")) continue;
                            param = paramNode.getAttributeValue("name");
                            if (param == null) {
                                param = "";
                            }
                            if ((value = paramNode.getAttributeValue("value")) == null) {
                                value = "";
                            }
                            if ((password = paramNode.getAttributeValue("password")) == null) {
                                password = "";
                            }
                            authParamPrefix = authpagePrefix + "_" + paramCounter;
                            out.print("<input type=\"hidden\" name=\"" + authParamPrefix + "_param" + "\" value=\"" + Encoder.attributeEscape((String)param) + "\"/>\n" + "<input type=\"hidden\" name=\"" + authParamPrefix + "_value" + "\" value=\"" + Encoder.attributeEscape((String)value) + "\"/>\n" + "<input type=\"hidden\" name=\"" + authParamPrefix + "_password" + "\" value=\"" + Encoder.attributeEscape((String)ManifoldCF.deobfuscate((String)password)) + "\"/>\n");
                            ++paramCounter;
                        }
                        out.print("<input type=\"hidden\" name=\"" + authpagePrefix + "_loginparamcount" + "\" value=\"" + paramCounter + "\"/>\n");
                    }
                    ++authPageCounter;
                }
                out.print("<input type=\"hidden\" name=\"" + prefix2 + "_loginpagecount" + "\" value=\"" + authPageCounter + "\"/>\n");
                ++accessCounter;
            }
            out.print("<input type=\"hidden\" name=\"scredential_count\" value=\"" + accessCounter + "\"/>\n");
        }
        if (tabName.equals("Certificates")) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>Trust certificates:</nobr></td>\n    <td class=\"boxcell\">\n      <table class=\"formtable\">\n        <tr class=\"formheaderrow\">\n          <td class=\"formcolumnheader\"></td>\n          <td class=\"formcolumnheader\"><nobr>URL regular expression</nobr></td>\n          <td class=\"formcolumnheader\"><nobr>Certificate</nobr></td>\n        </tr>\n");
            i = 0;
            trustsCounter = 0;
            while (i < parameters.getChildCount()) {
                if (!(cn = parameters.getChild(i++)).getType().equals("trust")) continue;
                prefix = "trust_" + Integer.toString(trustsCounter);
                regexp = cn.getAttributeValue("urlregexp");
                trustEverything = cn.getAttributeValue("trusteverything");
                if (trustEverything != null && trustEverything.equals("true")) {
                    out.print("        <tr class=\"" + (trustsCounter % 2 == 0 ? "evenformrow" : "oddformrow") + "\">\n" + "          <td class=\"formcolumncell\">\n" + "            <a name=\"" + prefix + "\"><input type=\"button\" value=\"Delete\" alt=\"" + "Delete trust url regular expression #" + Integer.toString(trustsCounter + 1) + "\" onclick='javascript:deleteTRegexp(" + Integer.toString(trustsCounter) + ");'/>\n" + "            <input type=\"hidden\" name=\"" + "op_" + prefix + "\" value=\"Continue\"/>\n" + "            <input type=\"hidden\" name=\"" + "regexp_" + prefix + "\" value=\"" + Encoder.attributeEscape((String)regexp) + "\"/>\n" + "            <input type=\"hidden\" name=\"" + "trustall_" + prefix + "\" value=\"true\"/>\n" + "            <input type=\"hidden\" name=\"" + "truststore_" + prefix + "\" value=\"\"/>\n" + "            </a>\n" + "          </td>\n" + "          <td class=\"formcolumncell\">\n" + "            <nobr>" + Encoder.bodyEscape((String)regexp) + "</nobr>\n" + "          </td>\n" + "          <td class=\"formcolumncell\">\n" + "            <nobr><i>Trust everything</i></nobr>\n" + "          </td>\n" + "        </tr>\n");
                    ++trustsCounter;
                    continue;
                }
                String trustStore = cn.getAttributeValue("truststore");
                IKeystoreManager localTruststore = KeystoreManagerFactory.make((String)"", (String)trustStore);
                String[] truststoreContents = localTruststore.getContents();
                if (truststoreContents.length != 1) continue;
                String alias = truststoreContents[0];
                String description = localTruststore.getDescription(alias);
                String shortenedDescription = description;
                if (shortenedDescription.length() > 100) {
                    shortenedDescription = shortenedDescription.substring(0, 100) + "...";
                }
                out.print("        <tr class=\"" + (trustsCounter % 2 == 0 ? "evenformrow" : "oddformrow") + "\">\n" + "          <td class=\"formcolumncell\">\n" + "            <a name=\"" + prefix + "\">\n" + "              <input type=\"button\" value=\"Delete\" alt=\"" + "Delete trust url regular expression #" + Integer.toString(trustsCounter + 1) + "\" onclick='javascript:deleteTRegexp(" + Integer.toString(trustsCounter) + ");'/>\n" + "              <input type=\"hidden\" name=\"" + "op_" + prefix + "\" value=\"Continue\"/>\n" + "              <input type=\"hidden\" name=\"" + "regexp_" + prefix + "\" value=\"" + Encoder.attributeEscape((String)regexp) + "\"/>\n" + "              <input type=\"hidden\" name=\"" + "trustall_" + prefix + "\" value=\"false\"/>\n" + "              <input type=\"hidden\" name=\"" + "truststore_" + prefix + "\" value=\"" + Encoder.attributeEscape((String)trustStore) + "\"/>\n" + "            </a>\n" + "          </td>\n" + "          <td class=\"formcolumncell\">\n" + "            <nobr>" + Encoder.bodyEscape((String)regexp) + "</nobr>\n" + "          </td>\n" + "          <td class=\"formcolumncell\">\n" + "            <nobr>" + Encoder.bodyEscape((String)shortenedDescription) + "</nobr>\n" + "          </td>\n" + "        </tr>\n");
                ++trustsCounter;
            }
            if (trustsCounter == 0) {
                out.print("        <tr class=\"formrow\"><td class=\"formmessage\" colspan=\"3\">No trust certificates specified</td></tr>\n");
            }
            out.print("        <tr class=\"formrow\"><td class=\"formseparator\" colspan=\"3\"><hr/></td></tr>\n        <tr class=\"formrow\">\n          <td class=\"formcolumncell\">\n            <a name=\"trust\"><input type=\"button\" value=\"Add\" alt=\"Add url regular expression for truststore\" onclick=\"javascript:addTRegexp();\"/></a>\n            <input type=\"hidden\" name=\"trust_count\" value=\"" + trustsCounter + "\"/>\n" + "            <input type=\"hidden\" name=\"trust_op\" value=\"Continue\"/>\n" + "          </td>\n" + "          <td class=\"formcolumncell\">\n" + "            <nobr><input type=\"text\" size=\"30\" name=\"regexp_trust\" value=\"\"/></nobr>\n" + "          </td>\n" + "          <td class=\"formcolumncell\">\n" + "            <nobr>Upload certificate: <input name=\"certificate_trust\" size=\"50\" type=\"file\"/>&nbsp;<input name=\"all_trust\" type=\"checkbox\" value=\"true\">Trust everything</input></nobr>\n" + "          </td>\n" + "        </tr>\n" + "      </table>\n" + "    </td>\n" + "  </tr>\n" + "</table>\n");
        } else {
            i = 0;
            trustsCounter = 0;
            while (i < parameters.getChildCount()) {
                if (!(cn = parameters.getChild(i++)).getType().equals("trust")) continue;
                prefix = "trust_" + Integer.toString(trustsCounter);
                regexp = cn.getAttributeValue("urlregexp");
                trustEverything = cn.getAttributeValue("trusteverything");
                if (trustEverything != null && trustEverything.equals("true")) {
                    out.print("<input type=\"hidden\" name=\"regexp_" + prefix + "\" value=\"" + Encoder.attributeEscape((String)regexp) + "\"/>\n" + "<input type=\"hidden\" name=\"" + "truststore_" + prefix + "\" value=\"\"/>\n" + "<input type=\"hidden\" name=\"" + "trustall_" + prefix + "\" value=\"true\"/>\n");
                    ++trustsCounter;
                    continue;
                }
                String trustStore = cn.getAttributeValue("truststore");
                out.print("<input type=\"hidden\" name=\"regexp_" + prefix + "\" value=\"" + Encoder.attributeEscape((String)regexp) + "\"/>\n" + "<input type=\"hidden\" name=\"" + "truststore_" + prefix + "\" value=\"" + Encoder.attributeEscape((String)trustStore) + "\"/>\n" + "<input type=\"hidden\" name=\"" + "trustall_" + prefix + "\" value=\"false\"/>\n");
                ++trustsCounter;
            }
            out.print("<input type=\"hidden\" name=\"trust_count\" value=\"" + trustsCounter + "\"/>\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String processConfigurationPost(IThreadContext threadContext, IPostParameters variableContext, ConfigParams parameters) throws ManifoldCFException {
        ConfigNode node;
        ConfigNode node2;
        String regexp;
        String addop;
        ConfigNode node3;
        String regexp2;
        String op;
        String prefix;
        int count;
        int i;
        String x;
        String robotsUsage;
        String email = variableContext.getParameter("email");
        if (email != null) {
            parameters.setParameter("Email address", email);
        }
        if ((robotsUsage = variableContext.getParameter("robotsusage")) != null) {
            parameters.setParameter("Robots usage", robotsUsage);
        }
        if ((x = variableContext.getParameter("bandwidth_count")) != null && x.length() > 0) {
            i = 0;
            while (i < parameters.getChildCount()) {
                ConfigNode node4 = parameters.getChild(i);
                if (node4.getType().equals("bindesc")) {
                    parameters.removeChild(i);
                    continue;
                }
                ++i;
            }
            count = Integer.parseInt(x);
            for (i = 0; i < count; ++i) {
                ConfigNode child;
                prefix = "bandwidth_" + Integer.toString(i);
                op = variableContext.getParameter("op_" + prefix);
                if (op != null && op.equals("Delete")) continue;
                regexp2 = variableContext.getParameter("regexp_" + prefix);
                String isCaseInsensitive = variableContext.getParameter("insensitive_" + prefix);
                String maxConnections = variableContext.getParameter("connections_" + prefix);
                String rate = variableContext.getParameter("rate_" + prefix);
                String fetches = variableContext.getParameter("fetches_" + prefix);
                node3 = new ConfigNode("bindesc");
                node3.setAttribute("binregexp", regexp2);
                if (isCaseInsensitive != null && isCaseInsensitive.length() > 0) {
                    node3.setAttribute("caseinsensitive", isCaseInsensitive);
                }
                if (maxConnections != null && maxConnections.length() > 0) {
                    child = new ConfigNode("maxconnections");
                    child.setAttribute("value", maxConnections);
                    node3.addChild(node3.getChildCount(), (ConfigurationNode)child);
                }
                if (rate != null && rate.length() > 0) {
                    child = new ConfigNode("maxkbpersecond");
                    child.setAttribute("value", rate);
                    node3.addChild(node3.getChildCount(), (ConfigurationNode)child);
                }
                if (fetches != null && fetches.length() > 0) {
                    child = new ConfigNode("maxfetchesperminute");
                    child.setAttribute("value", fetches);
                    node3.addChild(node3.getChildCount(), (ConfigurationNode)child);
                }
                parameters.addChild(parameters.getChildCount(), (ConfigurationNode)node3);
            }
            addop = variableContext.getParameter("bandwidth_op");
            if (addop != null && addop.equals("Add")) {
                ConfigNode child;
                regexp = variableContext.getParameter("regexp_bandwidth");
                String isCaseInsensitive = variableContext.getParameter("insensitive_bandwidth");
                String maxConnections = variableContext.getParameter("connections_bandwidth");
                String rate = variableContext.getParameter("rate_bandwidth");
                String fetches = variableContext.getParameter("fetches_bandwidth");
                node2 = new ConfigNode("bindesc");
                node2.setAttribute("binregexp", regexp);
                if (isCaseInsensitive != null && isCaseInsensitive.length() > 0) {
                    node2.setAttribute("caseinsensitive", isCaseInsensitive);
                }
                if (maxConnections != null && maxConnections.length() > 0) {
                    child = new ConfigNode("maxconnections");
                    child.setAttribute("value", maxConnections);
                    node2.addChild(node2.getChildCount(), (ConfigurationNode)child);
                }
                if (rate != null && rate.length() > 0) {
                    child = new ConfigNode("maxkbpersecond");
                    child.setAttribute("value", rate);
                    node2.addChild(node2.getChildCount(), (ConfigurationNode)child);
                }
                if (fetches != null && fetches.length() > 0) {
                    child = new ConfigNode("maxfetchesperminute");
                    child.setAttribute("value", fetches);
                    node2.addChild(node2.getChildCount(), (ConfigurationNode)child);
                }
                parameters.addChild(parameters.getChildCount(), (ConfigurationNode)node2);
            }
        }
        if ((x = variableContext.getParameter("acredential_count")) != null && x.length() > 0) {
            i = 0;
            while (i < parameters.getChildCount()) {
                ConfigNode node5 = parameters.getChild(i);
                if (node5.getType().equals("accesscredential") && !node5.getAttributeValue("type").equals("session")) {
                    parameters.removeChild(i);
                    continue;
                }
                ++i;
            }
            count = Integer.parseInt(x);
            for (i = 0; i < count; ++i) {
                prefix = "acredential_" + Integer.toString(i);
                op = variableContext.getParameter("op_" + prefix);
                if (op != null && op.equals("Delete")) continue;
                regexp2 = variableContext.getParameter("regexp_" + prefix);
                String type = variableContext.getParameter("type_" + prefix);
                String domain = variableContext.getParameter("domain_" + prefix);
                if (domain == null) {
                    domain = "";
                }
                String userName = variableContext.getParameter("username_" + prefix);
                String password = variableContext.getParameter("password_" + prefix);
                node3 = new ConfigNode("accesscredential");
                node3.setAttribute("urlregexp", regexp2);
                node3.setAttribute("type", type);
                node3.setAttribute("domain", domain);
                node3.setAttribute("username", userName);
                node3.setAttribute("password", ManifoldCF.obfuscate((String)password));
                parameters.addChild(parameters.getChildCount(), (ConfigurationNode)node3);
            }
            addop = variableContext.getParameter("acredential_op");
            if (addop != null && addop.equals("Add")) {
                regexp = variableContext.getParameter("regexp_acredential");
                String type = variableContext.getParameter("type_acredential");
                String domain = variableContext.getParameter("domain_acredential");
                String userName = variableContext.getParameter("username_acredential");
                String password = variableContext.getParameter("password_acredential");
                node2 = new ConfigNode("accesscredential");
                node2.setAttribute("urlregexp", regexp);
                node2.setAttribute("type", type);
                node2.setAttribute("domain", domain);
                node2.setAttribute("username", userName);
                node2.setAttribute("password", ManifoldCF.obfuscate((String)password));
                parameters.addChild(parameters.getChildCount(), (ConfigurationNode)node2);
            }
        }
        if ((x = variableContext.getParameter("scredential_count")) != null && x.length() > 0) {
            i = 0;
            while (i < parameters.getChildCount()) {
                ConfigNode node6 = parameters.getChild(i);
                if (node6.getType().equals("accesscredential") && node6.getAttributeValue("type").equals("session")) {
                    parameters.removeChild(i);
                    continue;
                }
                ++i;
            }
            count = Integer.parseInt(x);
            for (i = 0; i < count; ++i) {
                prefix = "scredential_" + Integer.toString(i);
                op = variableContext.getParameter(prefix + "_op");
                if (op != null && op.equals("Delete")) continue;
                regexp2 = variableContext.getParameter(prefix + "_regexp");
                node = new ConfigNode("accesscredential");
                node.setAttribute("urlregexp", regexp2);
                node.setAttribute("type", "session");
                int loginPageCount = Integer.parseInt(variableContext.getParameter(prefix + "_loginpagecount"));
                for (int q = 0; q < loginPageCount; ++q) {
                    String authpagePrefix = prefix + "_" + Integer.toString(q);
                    String authpageOp = variableContext.getParameter(authpagePrefix + "_op");
                    if (authpageOp != null && authpageOp.equals("Delete")) continue;
                    String pageRegexp = variableContext.getParameter(authpagePrefix + "_regexp");
                    String pageType = variableContext.getParameter(authpagePrefix + "_type");
                    String matchRegexp = variableContext.getParameter(authpagePrefix + "_matchregexp");
                    if (matchRegexp == null) {
                        matchRegexp = "";
                    }
                    ConfigNode authPageNode = new ConfigNode("authpage");
                    authPageNode.setAttribute("urlregexp", pageRegexp);
                    authPageNode.setAttribute("type", pageType);
                    authPageNode.setAttribute("match", matchRegexp);
                    if (pageType.equals("form")) {
                        int paramCount = Integer.parseInt(variableContext.getParameter(authpagePrefix + "_loginparamcount"));
                        for (int z = 0; z < paramCount; ++z) {
                            String paramPrefix = authpagePrefix + "_" + Integer.toString(z);
                            String paramOp = variableContext.getParameter(paramPrefix + "_op");
                            if (paramOp != null && paramOp.equals("Delete")) continue;
                            String name = variableContext.getParameter(paramPrefix + "_param");
                            String value = variableContext.getParameter(paramPrefix + "_value");
                            String password = variableContext.getParameter(paramPrefix + "_password");
                            ConfigNode paramNode = new ConfigNode("authparameter");
                            paramNode.setAttribute("name", name);
                            if (value != null && value.length() > 0) {
                                paramNode.setAttribute("value", value);
                            }
                            if (password != null && password.length() > 0) {
                                paramNode.setAttribute("password", ManifoldCF.obfuscate((String)password));
                            }
                            authPageNode.addChild(authPageNode.getChildCount(), (ConfigurationNode)paramNode);
                        }
                        String paramAddOp = variableContext.getParameter(authpagePrefix + "_loginparamop");
                        if (paramAddOp != null && paramAddOp.equals("Add")) {
                            String name = variableContext.getParameter(authpagePrefix + "_loginparamname");
                            String value = variableContext.getParameter(authpagePrefix + "_loginparamvalue");
                            String password = variableContext.getParameter(authpagePrefix + "_loginparampassword");
                            ConfigNode paramNode = new ConfigNode("authparameter");
                            paramNode.setAttribute("name", name);
                            if (value != null && value.length() > 0) {
                                paramNode.setAttribute("value", value);
                            }
                            if (password != null && password.length() > 0) {
                                paramNode.setAttribute("password", ManifoldCF.obfuscate((String)password));
                            }
                            authPageNode.addChild(authPageNode.getChildCount(), (ConfigurationNode)paramNode);
                        }
                    }
                    node.addChild(node.getChildCount(), (ConfigurationNode)authPageNode);
                }
                String authpageAddop = variableContext.getParameter(prefix + "_loginpageop");
                if (authpageAddop != null && authpageAddop.equals("Add")) {
                    String pageRegexp = variableContext.getParameter(prefix + "_loginpageregexp");
                    String pageType = variableContext.getParameter(prefix + "_loginpagetype");
                    String matchRegexp = variableContext.getParameter(prefix + "_loginpagematchregexp");
                    if (matchRegexp == null) {
                        matchRegexp = "";
                    }
                    ConfigNode authPageNode = new ConfigNode("authpage");
                    authPageNode.setAttribute("urlregexp", pageRegexp);
                    authPageNode.setAttribute("type", pageType);
                    authPageNode.setAttribute("match", matchRegexp);
                    node.addChild(node.getChildCount(), (ConfigurationNode)authPageNode);
                }
                parameters.addChild(parameters.getChildCount(), (ConfigurationNode)node);
            }
            addop = variableContext.getParameter("scredential_op");
            if (addop != null && addop.equals("Add")) {
                regexp = variableContext.getParameter("scredential_regexp");
                ConfigNode node7 = new ConfigNode("accesscredential");
                node7.setAttribute("urlregexp", regexp);
                node7.setAttribute("type", "session");
                parameters.addChild(parameters.getChildCount(), (ConfigurationNode)node7);
            }
        }
        if ((x = variableContext.getParameter("trust_count")) != null && x.length() > 0) {
            i = 0;
            while (i < parameters.getChildCount()) {
                ConfigNode node8 = parameters.getChild(i);
                if (node8.getType().equals("trust")) {
                    parameters.removeChild(i);
                    continue;
                }
                ++i;
            }
            int count2 = Integer.parseInt(x);
            for (i = 0; i < count2; ++i) {
                prefix = "trust_" + Integer.toString(i);
                op = variableContext.getParameter("op_" + prefix);
                if (op != null && op.equals("Delete")) continue;
                regexp2 = variableContext.getParameter("regexp_" + prefix);
                String trustall = variableContext.getParameter("trustall_" + prefix);
                String truststore = variableContext.getParameter("truststore_" + prefix);
                ConfigNode node9 = new ConfigNode("trust");
                node9.setAttribute("urlregexp", regexp2);
                if (trustall != null && trustall.equals("true")) {
                    node9.setAttribute("trusteverything", "true");
                } else {
                    node9.setAttribute("truststore", truststore);
                }
                parameters.addChild(parameters.getChildCount(), (ConfigurationNode)node9);
            }
            addop = variableContext.getParameter("trust_op");
            if (addop != null && addop.equals("Add")) {
                regexp = variableContext.getParameter("regexp_trust");
                String trustall = variableContext.getParameter("all_trust");
                if (trustall != null && trustall.equals("true")) {
                    node = new ConfigNode("trust");
                    node.setAttribute("urlregexp", regexp);
                    node.setAttribute("trusteverything", "true");
                    parameters.addChild(parameters.getChildCount(), (ConfigurationNode)node);
                } else {
                    byte[] certificateValue = variableContext.getBinaryBytes("certificate_trust");
                    IKeystoreManager mgr = KeystoreManagerFactory.make((String)"");
                    ByteArrayInputStream is = new ByteArrayInputStream(certificateValue);
                    String certError = null;
                    try {
                        mgr.importCertificate("Certificate", (InputStream)is);
                    }
                    catch (Throwable e) {
                        certError = e.getMessage();
                    }
                    finally {
                        try {
                            ((InputStream)is).close();
                        }
                        catch (IOException e) {}
                    }
                    if (certError != null) {
                        return "Illegal certificate: " + certError;
                    }
                    node3 = new ConfigNode("trust");
                    node3.setAttribute("urlregexp", regexp);
                    node3.setAttribute("truststore", mgr.getString());
                    parameters.addChild(parameters.getChildCount(), (ConfigurationNode)node3);
                }
            }
        }
        return null;
    }

    public void viewConfiguration(IThreadContext threadContext, IHTTPOutput out, ConfigParams parameters) throws ManifoldCFException, IOException {
        String regexp;
        String type;
        String regexp2;
        ConfigNode cn;
        String email = parameters.getParameter("Email address");
        String robots = parameters.getParameter("Robots usage");
        if (robots.equals("none")) {
            robots = "Ignore robots.txt";
        } else if (robots.equals("data")) {
            robots = "Obey robots.txt for data fetches only";
        } else if (robots.equals("all")) {
            robots = "Obey robots.txt for all fetches";
        }
        out.print("<table class=\"displaytable\">\n  <tr>\n    <td class=\"description\" colspan=\"1\"><nobr>Email address:</nobr></td>\n    <td class=\"value\" colspan=\"1\">" + Encoder.bodyEscape((String)email) + "</td>\n" + "    <td class=\"description\" colspan=\"1\"><nobr>Robots usage:</nobr></td>\n" + "    <td class=\"value\" colspan=\"1\"><nobr>" + Encoder.bodyEscape((String)robots) + "</nobr></td>\n" + "  </tr>\n" + "  <tr>\n" + "    <td class=\"description\" colspan=\"1\"><nobr>Bandwidth throttling:</nobr></td>\n" + "    <td class=\"boxcell\" colspan=\"3\">\n" + "      <table class=\"formtable\">\n" + "        <tr class=\"formheaderrow\">\n" + "          <td class=\"formcolumnheader\"><nobr>Bin regular expression</nobr></td>\n" + "          <td class=\"formcolumnheader\"><nobr>Case insensitive?</nobr></td>\n" + "          <td class=\"formcolumnheader\"><nobr>Max connections</nobr></td>\n" + "          <td class=\"formcolumnheader\"><nobr>Max kbytes/sec</nobr></td>\n" + "          <td class=\"formcolumnheader\"><nobr>Max fetches/min</nobr></td>\n" + "        </tr>\n");
        int i = 0;
        int instanceNumber = 0;
        while (i < parameters.getChildCount()) {
            if (!(cn = parameters.getChild(i++)).getType().equals("bindesc")) continue;
            regexp2 = cn.getAttributeValue("binregexp");
            String isCaseInsensitive = cn.getAttributeValue("caseinsensitive");
            String maxConnections = null;
            String maxKBPerSecond = null;
            String maxFetchesPerMinute = null;
            int j = 0;
            while (j < cn.getChildCount()) {
                ConfigNode childNode;
                if ((childNode = cn.getChild(j++)).getType().equals("maxconnections")) {
                    maxConnections = childNode.getAttributeValue("value");
                    continue;
                }
                if (childNode.getType().equals("maxkbpersecond")) {
                    maxKBPerSecond = childNode.getAttributeValue("value");
                    continue;
                }
                if (!childNode.getType().equals("maxfetchesperminute")) continue;
                maxFetchesPerMinute = childNode.getAttributeValue("value");
            }
            if (maxConnections == null) {
                maxConnections = "Not limited";
            }
            if (maxKBPerSecond == null) {
                maxKBPerSecond = "Not limited";
            }
            if (maxFetchesPerMinute == null) {
                maxFetchesPerMinute = "Not limited";
            }
            if (isCaseInsensitive == null || isCaseInsensitive.length() == 0) {
                isCaseInsensitive = "false";
            }
            out.print("        <tr class=\"" + (instanceNumber % 2 == 0 ? "evenformrow" : "oddformrow") + "\">\n" + "          <td class=\"formcolumncell\"><nobr>" + Encoder.bodyEscape((String)regexp2) + "</nobr></td>\n" + "          <td class=\"formcolumncell\">" + isCaseInsensitive + "</td>\n" + "          <td class=\"formcolumncell\"><nobr>" + maxConnections + "</nobr></td>\n" + "          <td class=\"formcolumncell\"><nobr>" + maxKBPerSecond + "</nobr></td>\n" + "          <td class=\"formcolumncell\"><nobr>" + maxFetchesPerMinute + "</nobr></td>\n" + "        </tr>\n");
            ++instanceNumber;
        }
        if (instanceNumber == 0) {
            out.print("        <tr class=\"formrow\"><td class=\"formmessage\" colspan=\"5\">No bandwidth throttling</td></tr>\n");
        }
        out.print("      </table>\n    </td>\n  </tr>\n  \n  <tr>\n    <td class=\"description\" colspan=\"1\"><nobr>Page access credentials:</nobr></td>\n    <td class=\"boxcell\" colspan=\"3\">\n      <table class=\"formtable\">\n        <tr class=\"formheaderrow\">\n          <td class=\"formcolumnheader\"><nobr>URL regular expression</nobr></td>\n          <td class=\"formcolumnheader\"><nobr>Credential type</nobr></td>\n          <td class=\"formcolumnheader\"><nobr>Credential domain</nobr></td>\n          <td class=\"formcolumnheader\"><nobr>User name</nobr></td>\n        </tr>\n");
        i = 0;
        instanceNumber = 0;
        while (i < parameters.getChildCount()) {
            if (!(cn = parameters.getChild(i++)).getType().equals("accesscredential") || (type = cn.getAttributeValue("type")).equals("session")) continue;
            regexp = cn.getAttributeValue("urlregexp");
            String domain = cn.getAttributeValue("domain");
            if (domain == null) {
                domain = "";
            }
            String userName = cn.getAttributeValue("username");
            out.print("        <tr>\n          <td class=\"formcolumncell\"><nobr>" + Encoder.bodyEscape((String)regexp) + "</nobr></td>\n" + "          <td class=\"formcolumncell\"><nobr>" + type + "</nobr></td>\n" + "          <td class=\"formcolumncell\"><nobr>" + Encoder.bodyEscape((String)domain) + "</nobr></td>\n" + "          <td class=\"formcolumncell\"><nobr>" + Encoder.bodyEscape((String)userName) + "</nobr></td>\n" + "        </tr>\n");
            ++instanceNumber;
        }
        if (instanceNumber == 0) {
            out.print("        <tr class=\"formrow\"><td class=\"formmessage\" colspan=\"4\"><nobr>No page access credentials</nobr></td></tr>\n");
        }
        out.print("      </table>\n    </td>\n  </tr>\n\n  <tr>\n    <td class=\"description\" colspan=\"1\"><nobr>Session-based access credentials:</nobr></td>\n    <td class=\"boxcell\" colspan=\"3\">\n      <table class=\"formtable\">\n        <tr class=\"formheaderrow\">\n          <td class=\"formcolumnheader\"><nobr>URL regular expression</nobr></td>\n          <td class=\"formcolumnheader\"><nobr>Login pages</nobr></td>\n        </tr>\n");
        i = 0;
        instanceNumber = 0;
        while (i < parameters.getChildCount()) {
            if (!(cn = parameters.getChild(i++)).getType().equals("accesscredential") || !(type = cn.getAttributeValue("type")).equals("session")) continue;
            regexp = cn.getAttributeValue("urlregexp");
            out.print("        <tr class=\"" + (instanceNumber % 2 == 0 ? "evenformrow" : "oddformrow") + "\">\n" + "          <td class=\"formcolumncell\"><nobr>" + Encoder.bodyEscape((String)regexp) + "</nobr></td>\n" + "          <td class=\"boxcell\">\n");
            int q = 0;
            int authPageInstanceNumber = 0;
            while (q < cn.getChildCount()) {
                ConfigNode authPageNode;
                if (!(authPageNode = cn.getChild(q++)).getType().equals("authpage")) continue;
                String authURLRegexp = authPageNode.getAttributeValue("urlregexp");
                String pageType = authPageNode.getAttributeValue("type");
                String authMatchRegexp = authPageNode.getAttributeValue("match");
                if (authMatchRegexp == null) {
                    authMatchRegexp = "";
                }
                if (authPageInstanceNumber == 0) {
                    out.print("            <table class=\"formtable\">\n              <tr class=\"formheaderrow\">\n                <td class=\"formcolumnheader\"><nobr>Login URL regular expression</nobr></td>\n                <td class=\"formcolumnheader\"><nobr>Page type</nobr></td>\n                <td class=\"formcolumnheader\"><nobr>Form name/link target regular expression</nobr></td>\n                <td class=\"formcolumnheader\"><nobr>Override form parameters</nobr></td>\n              </tr>\n");
                }
                out.print("              <tr class=\"" + (authPageInstanceNumber % 2 == 0 ? "evenformrow" : "oddformrow") + "\">\n" + "                <td class=\"formcolumncell\"><nobr>" + Encoder.bodyEscape((String)authURLRegexp) + "</nobr></td>\n" + "                <td class=\"formcolumncell\"><nobr>" + pageType + "</nobr></td>\n" + "                <td class=\"formcolumncell\"><nobr>" + Encoder.bodyEscape((String)authMatchRegexp) + "</nobr></td>\n" + "                <td class=\"formcolumncell\">\n");
                if (pageType.equals("form")) {
                    int z = 0;
                    while (z < authPageNode.getChildCount()) {
                        String password;
                        String paramValue;
                        ConfigNode authParameter;
                        if (!(authParameter = authPageNode.getChild(z++)).getType().equals("authparameter")) continue;
                        String paramName = authParameter.getAttributeValue("name");
                        if (paramName == null) {
                            paramName = "";
                        }
                        if ((paramValue = authParameter.getAttributeValue("value")) == null) {
                            paramValue = "";
                        }
                        if ((password = authParameter.getAttributeValue("password")) != null && password.length() > 0) {
                            paramValue = "*****";
                        }
                        out.print("                  <nobr>" + Encoder.bodyEscape((String)(paramName + ": " + paramValue)) + "</nobr><br/>\n");
                    }
                }
                out.print("                </td>\n              </tr>\n");
                ++authPageInstanceNumber;
            }
            if (authPageInstanceNumber == 0) {
                out.print("            <nobr>No login pages specified</nobr>\n");
            } else {
                out.print("            </table>\n");
            }
            out.print("          </td>\n        </tr>\n");
            ++instanceNumber;
        }
        if (instanceNumber == 0) {
            out.print("        <tr class=\"formrow\"><td class=\"formmessage\" colspan=\"2\"><nobr>No session-based access credentials</nobr></td></tr>\n");
        }
        out.print("      </table>\n    </td>\n  </tr>\n  \n  <tr>\n    <td class=\"description\" colspan=\"1\"><nobr>Trust certificates:</nobr></td>\n    <td class=\"boxcell\" colspan=\"3\">\n      <table class=\"formtable\">\n        <tr class=\"formheaderrow\">\n          <td class=\"formcolumnheader\"><nobr>URL regular expression</nobr></td>\n          <td class=\"formcolumnheader\"><nobr>Certificate</nobr></td>\n        </tr>\n");
        i = 0;
        instanceNumber = 0;
        while (i < parameters.getChildCount()) {
            if (!(cn = parameters.getChild(i++)).getType().equals("trust")) continue;
            regexp2 = cn.getAttributeValue("urlregexp");
            String trustEverything = cn.getAttributeValue("trusteverything");
            if (trustEverything != null && trustEverything.equals("true")) {
                out.print("        <tr class=\"" + (instanceNumber % 2 == 0 ? "evenformrow" : "oddformrow") + "\">\n" + "          <td class=\"formcolumncell\"><nobr>" + Encoder.bodyEscape((String)regexp2) + "</nobr></td>\n" + "          <td class=\"formcolumncell\"><i>Trust everything</i></td>\n" + "        </tr>\n");
                ++instanceNumber;
                continue;
            }
            String trustStore = cn.getAttributeValue("truststore");
            IKeystoreManager localTruststore = KeystoreManagerFactory.make((String)"", (String)trustStore);
            String[] truststoreContents = localTruststore.getContents();
            if (truststoreContents.length != 1) continue;
            String alias = truststoreContents[0];
            String description = localTruststore.getDescription(alias);
            String shortenedDescription = description;
            if (shortenedDescription.length() > 100) {
                shortenedDescription = shortenedDescription.substring(0, 100) + "...";
            }
            out.print("        <tr class=\"" + (instanceNumber % 2 == 0 ? "evenformrow" : "oddformrow") + "\">\n" + "          <td class=\"formcolumncell\"><nobr>" + Encoder.bodyEscape((String)regexp2) + "</nobr></td>\n" + "          <td class=\"formcolumncell\">" + Encoder.bodyEscape((String)shortenedDescription) + "</td>\n" + "        </tr>\n");
            ++instanceNumber;
        }
        if (instanceNumber == 0) {
            out.print("        <tr class=\"formrow\"><td class=\"formmessage\" colspan=\"2\">No trust certificates</td></tr>\n");
        }
        out.print("      </table>\n    </td>\n  </tr>\n</table>\n");
    }

    public void outputSpecificationHeader(IHTTPOutput out, DocumentSpecification ds, ArrayList tabsArray) throws ManifoldCFException, IOException {
        tabsArray.add("Seeds");
        tabsArray.add("Canonicalization");
        tabsArray.add("Inclusions");
        tabsArray.add("Exclusions");
        tabsArray.add("Security");
        tabsArray.add("Metadata");
        out.print("<script type=\"text/javascript\">\n<!--\n\nfunction SpecOp(n, opValue, anchorvalue)\n{\n  eval(\"editjob.\"+n+\".value = \\\"\"+opValue+\"\\\"\");\n  postFormSetAnchor(anchorvalue);\n}\n\nfunction URLRegexpDelete(index, anchorvalue)\n{\n  editjob.urlregexpnumber.value = index;\n  SpecOp(\"urlregexpop\",\"Delete\",anchorvalue);\n}\n\nfunction URLRegexpAdd(anchorvalue)\n{\n  SpecOp(\"urlregexpop\",\"Add\",anchorvalue);\n}\n\nfunction checkSpecification()\n{\n  if (check_expressions(\"inclusions\",editjob.inclusions.value) == false)\n  {\n    editjob.inclusions.focus();\n    return false;\n  }  \n  if (check_expressions(\"exclusions\",editjob.exclusions.value) == false)\n  {\n    editjob.exclusions.focus();\n    return false;\n  }\n  return true;\n}\n\nfunction check_expressions(thecontext,theexpressionlist)\n{\n  var rval = true;\n  var theArray = theexpressionlist.split(\"\\n\");\n  var i = 0;\n  while (i < theArray.length)\n  {\n    // For legality check, we must cut out anything useful that is java-only\n    var theexp = theArray[i];\n    var trimmed = theexp.replace(/^\\s+/,\"\");\n    i = i + 1;\n    if (trimmed.length == 0 || (trimmed.length >= 1 && trimmed.substring(0,1) == \"#\"))\n      continue;\n    try\n    {\n      var foo = \"teststring\";\n      foo.search(theexp.replace(/\\(\\?i\\)/,\"\"));\n    }\n    catch (e)\n    {\n      alert(\"Found an illegal regular expression in \"+thecontext+\": '\"+theexp+\"'.  Error was: \"+e);\n      rval = false;\n    }\n  }\n  return rval;\n}\n\nfunction SpecAddToken(anchorvalue)\n{\n  if (editjob.spectoken.value == \"\")\n  {\n    alert(\"Type in an access token\");\n    editjob.spectoken.focus();\n    return;\n  }\n  SpecOp(\"accessop\",\"Add\",anchorvalue);\n}\n\nfunction SpecAddMetadata(anchorvalue)\n{\n  if (editjob.specmetaname.value == \"\")\n  {\n    alert(\"Type in metadata name\");\n    editjob.specmetaname.focus();\n    return;\n  }\n  if (editjob.specmetavalue.value == \"\")\n  {\n    alert(\"Type in metadata value\");\n    editjob.specmetavalue.focus();\n    return;\n  }\n  SpecOp(\"metadataop\",\"Add\",anchorvalue);\n}\n\n//-->\n</script>\n");
    }

    public void outputSpecificationBody(IHTTPOutput out, DocumentSpecification ds, String tabName) throws ManifoldCFException, IOException {
        int k;
        String allowBVSessionRemoval;
        String allowPHPSessionRemoval;
        String allowASPSessionRemoval;
        String allowJavaSessionRemoval;
        String allowReorder;
        String description;
        String regexpString;
        SpecificationNode specNode;
        int l;
        int q;
        String seeds = "";
        String inclusions = ".*\n";
        String exclusions = "";
        boolean includeMatching = false;
        int i = 0;
        while (i < ds.getChildCount()) {
            SpecificationNode sn;
            if ((sn = ds.getChild(i++)).getType().equals("seeds")) {
                seeds = sn.getValue();
                if (seeds != null) continue;
                seeds = "";
                continue;
            }
            if (sn.getType().equals("includes")) {
                inclusions = sn.getValue();
                if (inclusions != null) continue;
                inclusions = "";
                continue;
            }
            if (sn.getType().equals("excludes")) {
                exclusions = sn.getValue();
                if (exclusions != null) continue;
                exclusions = "";
                continue;
            }
            if (!sn.getType().equals("limittoseeds")) continue;
            String value = sn.getAttributeValue("value");
            if (value == null || value.equals("false")) {
                includeMatching = false;
                continue;
            }
            includeMatching = true;
        }
        if (tabName.equals("Seeds")) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"value\" colspan=\"2\">\n      <textarea rows=\"25\" cols=\"80\" name=\"seeds\">" + Encoder.bodyEscape((String)seeds) + "</textarea>\n" + "    </td>\n" + "  </tr>\n" + "</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"seeds\" value=\"" + Encoder.attributeEscape((String)seeds) + "\"/>\n");
        }
        if (tabName.equals("Canonicalization")) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"boxcell\" colspan=\"2\">\n      <input type=\"hidden\" name=\"urlregexpop\" value=\"Continue\"/>\n      <input type=\"hidden\" name=\"urlregexpnumber\" value=\"\"/>\n      <table class=\"formtable\">\n        <tr class=\"formheaderrow\">\n          <td class=\"formcolumnheader\"></td>\n          <td class=\"formcolumnheader\"><nobr>URL regular expression</nobr></td>\n          <td class=\"formcolumnheader\"><nobr>Description</nobr></td>\n          <td class=\"formcolumnheader\"><nobr>Reorder?</nobr></td>\n          <td class=\"formcolumnheader\"><nobr>Remove JSP sessions?</nobr></td>\n          <td class=\"formcolumnheader\"><nobr>Remove ASP sessions?</nobr></td>\n          <td class=\"formcolumnheader\"><nobr>Remove PHP sessions?</nobr></td>\n          <td class=\"formcolumnheader\"><nobr>Remove BV sessions?</nobr></td>\n        </tr>\n");
            q = 0;
            l = 0;
            while (q < ds.getChildCount()) {
                if (!(specNode = ds.getChild(q++)).getType().equals("urlspec")) continue;
                regexpString = specNode.getAttributeValue("regexp");
                description = specNode.getAttributeValue("description");
                if (description == null) {
                    description = "";
                }
                if ((allowReorder = specNode.getAttributeValue("reorder")) == null || allowReorder.length() == 0) {
                    allowReorder = "no";
                }
                if ((allowJavaSessionRemoval = specNode.getAttributeValue("javasessionremoval")) == null || allowJavaSessionRemoval.length() == 0) {
                    allowJavaSessionRemoval = "no";
                }
                if ((allowASPSessionRemoval = specNode.getAttributeValue("aspsessionremoval")) == null || allowASPSessionRemoval.length() == 0) {
                    allowASPSessionRemoval = "no";
                }
                if ((allowPHPSessionRemoval = specNode.getAttributeValue("phpsessionremoval")) == null || allowPHPSessionRemoval.length() == 0) {
                    allowPHPSessionRemoval = "no";
                }
                if ((allowBVSessionRemoval = specNode.getAttributeValue("bvsessionremoval")) == null || allowBVSessionRemoval.length() == 0) {
                    allowBVSessionRemoval = "no";
                }
                out.print("        <tr class=\"" + (l % 2 == 0 ? "evenformrow" : "oddformrow") + "\">\n" + "          <td class=\"formcolumncell\">\n" + "            <a name=\"" + "urlregexp_" + Integer.toString(l) + "\">\n" + "              <input type=\"button\" value=\"Delete\" alt=\"" + "Delete url regexp " + Encoder.attributeEscape((String)regexpString) + "\" onclick='javascript:URLRegexpDelete(" + Integer.toString(l) + ",\"urlregexp_" + Integer.toString(l) + "\");'/>\n" + "            </a>\n" + "          </td>\n" + "          <td class=\"formcolumncell\">\n" + "            <input type=\"hidden\" name=\"" + "urlregexp_" + Integer.toString(l) + "\" value=\"" + Encoder.attributeEscape((String)regexpString) + "\"/>\n" + "            <input type=\"hidden\" name=\"" + "urlregexpdesc_" + Integer.toString(l) + "\" value=\"" + Encoder.attributeEscape((String)description) + "\"/>\n" + "            <input type=\"hidden\" name=\"" + "urlregexpreorder_" + Integer.toString(l) + "\" value=\"" + allowReorder + "\"/>\n" + "            <input type=\"hidden\" name=\"" + "urlregexpjava_" + Integer.toString(l) + "\" value=\"" + allowJavaSessionRemoval + "\"/>\n" + "            <input type=\"hidden\" name=\"" + "urlregexpasp_" + Integer.toString(l) + "\" value=\"" + allowASPSessionRemoval + "\"/>\n" + "            <input type=\"hidden\" name=\"" + "urlregexpphp_" + Integer.toString(l) + "\" value=\"" + allowPHPSessionRemoval + "\"/>\n" + "            <input type=\"hidden\" name=\"" + "urlregexpbv_" + Integer.toString(l) + "\" value=\"" + allowBVSessionRemoval + "\"/>\n" + "            <nobr>" + Encoder.bodyEscape((String)regexpString) + "</nobr>\n" + "          </td>\n" + "          <td class=\"formcolumncell\">" + Encoder.bodyEscape((String)description) + "</td>\n" + "          <td class=\"formcolumncell\">" + allowReorder + "</td>\n" + "          <td class=\"formcolumncell\">" + allowJavaSessionRemoval + "</td>\n" + "          <td class=\"formcolumncell\">" + allowASPSessionRemoval + "</td>\n" + "          <td class=\"formcolumncell\">" + allowPHPSessionRemoval + "</td>\n" + "          <td class=\"formcolumncell\">" + allowBVSessionRemoval + "</td>\n" + "        </tr>\n");
                ++l;
            }
            if (l == 0) {
                out.print("        <tr class=\"formrow\"><td colspan=\"8\" class=\"formcolumnmessage\"><nobr>No canonicalization specified - all URLs will be reordered and have all sessions removed</nobr></td></tr>\n");
            }
            out.print("        <tr class=\"formrow\"><td colspan=\"8\" class=\"formseparator\"><hr/></td></tr>\n        <tr class=\"formrow\">\n          <td class=\"formcolumncell\">\n            <a name=\"urlregexp_" + Integer.toString(l) + "\">\n" + "              <input type=\"button\" value=\"Add\" alt=\"Add url regexp\" onclick='javascript:URLRegexpAdd(\"urlregexp_" + Integer.toString(l + 1) + "\");'/>\n" + "              <input type=\"hidden\" name=\"urlregexpcount\" value=\"" + Integer.toString(l) + "\"/>\n" + "            </a>\n" + "          </td>\n" + "          <td class=\"formcolumncell\"><input type=\"text\" name=\"urlregexp\" size=\"30\" value=\"\"/></td>\n" + "          <td class=\"formcolumncell\"><input type=\"text\" name=\"urlregexpdesc\" size=\"30\" value=\"\"/></td>\n" + "          <td class=\"formcolumncell\"><input type=\"checkbox\" name=\"urlregexpreorder\" value=\"yes\"/></td>\n" + "          <td class=\"formcolumncell\"><input type=\"checkbox\" name=\"urlregexpjava\" value=\"yes\" checked=\"true\"/></td>\n" + "          <td class=\"formcolumncell\"><input type=\"checkbox\" name=\"urlregexpasp\" value=\"yes\" checked=\"true\"/></td>\n" + "          <td class=\"formcolumncell\"><input type=\"checkbox\" name=\"urlregexpphp\" value=\"yes\" checked=\"true\"/></td>\n" + "          <td class=\"formcolumncell\"><input type=\"checkbox\" name=\"urlregexpbv\" value=\"yes\" checked=\"true\"/></td>\n" + "        </tr>\n" + "      </table>\n" + "    </td>\n" + "  </tr>\n" + "</table>\n");
        } else {
            q = 0;
            l = 0;
            while (q < ds.getChildCount()) {
                if (!(specNode = ds.getChild(q++)).getType().equals("urlspec")) continue;
                regexpString = specNode.getAttributeValue("regexp");
                description = specNode.getAttributeValue("description");
                if (description == null) {
                    description = "";
                }
                if ((allowReorder = specNode.getAttributeValue("reorder")) == null || allowReorder.length() == 0) {
                    allowReorder = "no";
                }
                if ((allowJavaSessionRemoval = specNode.getAttributeValue("javasessionremoval")) == null || allowJavaSessionRemoval.length() == 0) {
                    allowJavaSessionRemoval = "no";
                }
                if ((allowASPSessionRemoval = specNode.getAttributeValue("aspsessionremoval")) == null || allowASPSessionRemoval.length() == 0) {
                    allowASPSessionRemoval = "no";
                }
                if ((allowPHPSessionRemoval = specNode.getAttributeValue("phpsessionremoval")) == null || allowPHPSessionRemoval.length() == 0) {
                    allowPHPSessionRemoval = "no";
                }
                if ((allowBVSessionRemoval = specNode.getAttributeValue("bvsessionremoval")) == null || allowBVSessionRemoval.length() == 0) {
                    allowBVSessionRemoval = "no";
                }
                out.print("<input type=\"hidden\" name=\"urlregexp_" + Integer.toString(l) + "\" value=\"" + Encoder.attributeEscape((String)regexpString) + "\"/>\n" + "<input type=\"hidden\" name=\"" + "urlregexpdesc_" + Integer.toString(l) + "\" value=\"" + Encoder.attributeEscape((String)description) + "\"/>\n" + "<input type=\"hidden\" name=\"" + "urlregexpreorder_" + Integer.toString(l) + "\" value=\"" + allowReorder + "\"/>\n" + "<input type=\"hidden\" name=\"" + "urlregexpjava_" + Integer.toString(l) + "\" value=\"" + allowJavaSessionRemoval + "\"/>\n" + "<input type=\"hidden\" name=\"" + "urlregexpasp_" + Integer.toString(l) + "\" value=\"" + allowASPSessionRemoval + "\"/>\n" + "<input type=\"hidden\" name=\"" + "urlregexpphp_" + Integer.toString(l) + "\" value=\"" + allowPHPSessionRemoval + "\"/>\n" + "<input type=\"hidden\" name=\"" + "urlregexpbv_" + Integer.toString(l) + "\" value=\"" + allowBVSessionRemoval + "\"/>\n");
                ++l;
            }
            out.print("<input type=\"hidden\" name=\"urlregexpcount\" value=\"" + Integer.toString(l) + "\"/>\n");
        }
        if (tabName.equals("Inclusions")) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"value\" colspan=\"2\">\n      <textarea rows=\"25\" cols=\"80\" name=\"inclusions\">" + Encoder.bodyEscape((String)inclusions) + "</textarea>\n" + "    </td>\n" + "  </tr>\n" + "  <tr>\n" + "    <td class=\"description\"><nobr>Include only hosts matching seeds?</nobr></td>\n" + "    <td class=\"value\">\n" + "      <input type=\"checkbox\" name=\"matchinghosts\" value=\"true\"" + (includeMatching ? " checked=\"yes\"" : "") + "/>\n" + "      <input type=\"hidden\" name=\"matchinghosts_present\" value=\"true\"/>\n" + "    </td>\n" + "</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"inclusions\" value=\"" + Encoder.attributeEscape((String)inclusions) + "\"/>\n" + "<input type=\"hidden\" name=\"matchinghosts\" value=\"" + (includeMatching ? "true" : "false") + "\"/>\n" + "<input type=\"hidden\" name=\"matchinghosts_present\" value=\"true\"/>\n");
        }
        if (tabName.equals("Exclusions")) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"value\" colspan=\"2\">\n      <textarea rows=\"25\" cols=\"80\" name=\"exclusions\">" + Encoder.bodyEscape((String)exclusions) + "</textarea>\n" + "    </td>\n" + "  </tr>\n" + "</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"exclusions\" value=\"" + Encoder.attributeEscape((String)exclusions) + "\"/>\n");
        }
        i = 0;
        if (tabName.equals("Security")) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n");
            i = 0;
            k = 0;
            while (i < ds.getChildCount()) {
                SpecificationNode sn;
                if (!(sn = ds.getChild(i++)).getType().equals("access")) continue;
                String accessDescription = "_" + Integer.toString(k);
                String accessOpName = "accessop" + accessDescription;
                String token = sn.getAttributeValue("token");
                out.print("  <tr>\n    <td class=\"description\">\n      <input type=\"hidden\" name=\"" + accessOpName + "\" value=\"\"/>\n" + "      <input type=\"hidden\" name=\"" + "spectoken" + accessDescription + "\" value=\"" + Encoder.attributeEscape((String)token) + "\"/>\n" + "      <a name=\"" + "token_" + Integer.toString(k) + "\">\n" + "        <input type=\"button\" value=\"Delete\" onClick='Javascript:SpecOp(\"" + accessOpName + "\",\"Delete\",\"token_" + Integer.toString(k) + "\")' alt=\"" + "Delete token #" + Integer.toString(k) + "\"/>\n" + "      </a>&nbsp;\n" + "    </td>\n" + "    <td class=\"value\">\n" + "      " + Encoder.bodyEscape((String)token) + "\n" + "    </td>\n" + "  </tr>\n");
                ++k;
            }
            if (k == 0) {
                out.print("  <tr>\n    <td class=\"message\" colspan=\"2\">No access tokens present</td>\n  </tr>\n");
            }
            out.print("  <tr><td class=\"lightseparator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\">\n      <input type=\"hidden\" name=\"tokencount\" value=\"" + Integer.toString(k) + "\"/>\n" + "      <input type=\"hidden\" name=\"accessop\" value=\"\"/>\n" + "      <a name=\"" + "token_" + Integer.toString(k) + "\">\n" + "        <input type=\"button\" value=\"Add\" onClick='Javascript:SpecAddToken(\"token_" + Integer.toString(k + 1) + "\")' alt=\"Add access token\"/>\n" + "      </a>&nbsp;\n" + "    </td>\n" + "    <td class=\"value\">\n" + "      <input type=\"text\" size=\"30\" name=\"spectoken\" value=\"\"/>\n" + "    </td>\n" + "  </tr>\n" + "</table>\n");
        } else {
            i = 0;
            k = 0;
            while (i < ds.getChildCount()) {
                SpecificationNode sn;
                if (!(sn = ds.getChild(i++)).getType().equals("access")) continue;
                String accessDescription = "_" + Integer.toString(k);
                String token = sn.getAttributeValue("token");
                out.print("<input type=\"hidden\" name=\"spectoken" + accessDescription + "\" value=\"" + Encoder.attributeEscape((String)token) + "\"/>\n");
                ++k;
            }
            out.print("<input type=\"hidden\" name=\"tokencount\" value=\"" + Integer.toString(k) + "\"/>\n");
        }
        if (tabName.equals("Metadata")) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"4\"><hr/></td></tr>\n");
            i = 0;
            k = 0;
            while (i < ds.getChildCount()) {
                SpecificationNode sn;
                if (!(sn = ds.getChild(i++)).getType().equals("metadata")) continue;
                String metadataDescription = "_" + Integer.toString(k);
                String metadataOpName = "metadataop" + metadataDescription;
                String name = sn.getAttributeValue("name");
                String value = sn.getAttributeValue("value");
                out.print("  <tr>\n    <td class=\"description\">\n      <input type=\"hidden\" name=\"" + metadataOpName + "\" value=\"\"/>\n" + "      <input type=\"hidden\" name=\"" + "specmetaname" + metadataDescription + "\" value=\"" + Encoder.attributeEscape((String)name) + "\"/>\n" + "      <input type=\"hidden\" name=\"" + "specmetavalue" + metadataDescription + "\" value=\"" + Encoder.attributeEscape((String)value) + "\"/>\n" + "      <a name=\"" + "metadata_" + Integer.toString(k) + "\">\n" + "        <input type=\"button\" value=\"Delete\" onClick='Javascript:SpecOp(\"" + metadataOpName + "\",\"Delete\",\"metadata_" + Integer.toString(k) + "\")' alt=\"" + "Delete metadata #" + Integer.toString(k) + "\"/>\n" + "      </a>&nbsp;\n" + "    </td>\n" + "    <td class=\"value\">\n" + "      " + Encoder.bodyEscape((String)name) + "\n" + "    </td>\n" + "    <td class=\"value\">=</td>\n" + "    <td class=\"value\">\n" + "      " + Encoder.bodyEscape((String)value) + "\n" + "    </td>\n" + "  </tr>\n");
                ++k;
            }
            if (k == 0) {
                out.print("  <tr>\n    <td class=\"message\" colspan=\"4\">No metadata present</td>\n  </tr>\n");
            }
            out.print("  <tr><td class=\"lightseparator\" colspan=\"4\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\">\n      <input type=\"hidden\" name=\"metadatacount\" value=\"" + Integer.toString(k) + "\"/>\n" + "      <input type=\"hidden\" name=\"metadataop\" value=\"\"/>\n" + "      <a name=\"" + "metadata_" + Integer.toString(k) + "\">\n" + "        <input type=\"button\" value=\"Add\" onClick='Javascript:SpecAddMetadata(\"metadata_" + Integer.toString(k + 1) + "\")' alt=\"Add metadata\"/>\n" + "      </a>&nbsp;\n" + "    </td>\n" + "    <td class=\"value\">\n" + "      <input type=\"text\" size=\"30\" name=\"specmetaname\" value=\"\"/>\n" + "    </td>\n" + "    <td class=\"value\">=</td>\n" + "    <td class=\"value\">\n" + "      <input type=\"text\" size=\"80\" name=\"specmetavalue\" value=\"\"/>\n" + "    </td>\n" + "  </tr>\n" + "</table>\n");
        } else {
            i = 0;
            k = 0;
            while (i < ds.getChildCount()) {
                SpecificationNode sn;
                if (!(sn = ds.getChild(i++)).getType().equals("metadata")) continue;
                String metadataDescription = "_" + Integer.toString(k);
                String name = sn.getAttributeValue("name");
                String value = sn.getAttributeValue("value");
                out.print("<input type=\"hidden\" name=\"specmetaname" + metadataDescription + "\" value=\"" + Encoder.attributeEscape((String)name) + "\"/>\n" + "<input type=\"hidden\" name=\"" + "specmetavalue" + metadataDescription + "\" value=\"" + Encoder.attributeEscape((String)value) + "\"/>\n");
                ++k;
            }
            out.print("<input type=\"hidden\" name=\"metadatacount\" value=\"" + Integer.toString(k) + "\"/>\n");
        }
    }

    public String processSpecificationPost(IPostParameters variableContext, DocumentSpecification ds) throws ManifoldCFException {
        SpecificationNode node;
        int i;
        String xc;
        SpecificationNode sn;
        String urlRegexpCount;
        String exclusions;
        SpecificationNode cn;
        String matchingHostsPresent;
        String inclusions;
        String seeds = variableContext.getParameter("seeds");
        if (seeds != null) {
            int i2 = 0;
            while (i2 < ds.getChildCount()) {
                SpecificationNode sn2 = ds.getChild(i2);
                if (sn2.getType().equals("seeds")) {
                    ds.removeChild(i2);
                    continue;
                }
                ++i2;
            }
            SpecificationNode cn2 = new SpecificationNode("seeds");
            cn2.setValue(seeds);
            ds.addChild(ds.getChildCount(), (ConfigurationNode)cn2);
        }
        if ((inclusions = variableContext.getParameter("inclusions")) != null) {
            int i3 = 0;
            while (i3 < ds.getChildCount()) {
                SpecificationNode sn3 = ds.getChild(i3);
                if (sn3.getType().equals("includes")) {
                    ds.removeChild(i3);
                    continue;
                }
                ++i3;
            }
            SpecificationNode cn3 = new SpecificationNode("includes");
            cn3.setValue(inclusions);
            ds.addChild(ds.getChildCount(), (ConfigurationNode)cn3);
        }
        if ((matchingHostsPresent = variableContext.getParameter("matchinghosts_present")) != null) {
            int i4 = 0;
            while (i4 < ds.getChildCount()) {
                SpecificationNode sn4 = ds.getChild(i4);
                if (sn4.getType().equals("limittoseeds")) {
                    ds.removeChild(i4);
                    continue;
                }
                ++i4;
            }
            String matchingHosts = variableContext.getParameter("matchinghosts");
            cn = new SpecificationNode("limittoseeds");
            cn.setAttribute("value", matchingHosts == null || matchingHosts.equals("false") ? "false" : "true");
            ds.addChild(ds.getChildCount(), (ConfigurationNode)cn);
        }
        if ((exclusions = variableContext.getParameter("exclusions")) != null) {
            int i5 = 0;
            while (i5 < ds.getChildCount()) {
                SpecificationNode sn5 = ds.getChild(i5);
                if (sn5.getType().equals("excludes")) {
                    ds.removeChild(i5);
                    continue;
                }
                ++i5;
            }
            cn = new SpecificationNode("excludes");
            cn.setValue(exclusions);
            ds.addChild(ds.getChildCount(), (ConfigurationNode)cn);
        }
        if ((urlRegexpCount = variableContext.getParameter("urlregexpcount")) != null && urlRegexpCount.length() > 0) {
            SpecificationNode newSn;
            String bvSession;
            String phpSession;
            String aspSession;
            String javaSession;
            String reorder;
            String regexpDescription;
            String regexp;
            int regexpCount = Integer.parseInt(urlRegexpCount);
            int j = 0;
            while (j < ds.getChildCount()) {
                sn = ds.getChild(j);
                if (sn.getType().equals("urlspec")) {
                    ds.removeChild(j);
                    continue;
                }
                ++j;
            }
            String operation = variableContext.getParameter("urlregexpop");
            if (operation == null) {
                operation = "Continue";
            }
            int opIndex = -1;
            if (operation.equals("Delete")) {
                opIndex = Integer.parseInt(variableContext.getParameter("urlregexpnumber"));
            }
            for (j = 0; j < regexpCount; ++j) {
                if (operation.equals("Delete") && j == opIndex) continue;
                regexp = variableContext.getParameter("urlregexp_" + Integer.toString(j));
                regexpDescription = variableContext.getParameter("urlregexpdesc_" + Integer.toString(j));
                reorder = variableContext.getParameter("urlregexpreorder_" + Integer.toString(j));
                javaSession = variableContext.getParameter("urlregexpjava_" + Integer.toString(j));
                aspSession = variableContext.getParameter("urlregexpasp_" + Integer.toString(j));
                phpSession = variableContext.getParameter("urlregexpphp_" + Integer.toString(j));
                bvSession = variableContext.getParameter("urlregexpbv_" + Integer.toString(j));
                newSn = new SpecificationNode("urlspec");
                newSn.setAttribute("regexp", regexp);
                if (regexpDescription != null && regexpDescription.length() > 0) {
                    newSn.setAttribute("description", regexpDescription);
                }
                if (reorder != null && reorder.length() > 0) {
                    newSn.setAttribute("reorder", reorder);
                }
                if (javaSession != null && javaSession.length() > 0) {
                    newSn.setAttribute("javasessionremoval", javaSession);
                }
                if (aspSession != null && aspSession.length() > 0) {
                    newSn.setAttribute("aspsessionremoval", aspSession);
                }
                if (phpSession != null && phpSession.length() > 0) {
                    newSn.setAttribute("phpsessionremoval", phpSession);
                }
                if (bvSession != null && bvSession.length() > 0) {
                    newSn.setAttribute("bvsessionremoval", bvSession);
                }
                ds.addChild(ds.getChildCount(), (ConfigurationNode)newSn);
            }
            if (operation.equals("Add")) {
                regexp = variableContext.getParameter("urlregexp");
                regexpDescription = variableContext.getParameter("urlregexpdesc");
                reorder = variableContext.getParameter("urlregexpreorder");
                javaSession = variableContext.getParameter("urlregexpjava");
                aspSession = variableContext.getParameter("urlregexpasp");
                phpSession = variableContext.getParameter("urlregexpphp");
                bvSession = variableContext.getParameter("urlregexpbv");
                newSn = new SpecificationNode("urlspec");
                newSn.setAttribute("regexp", regexp);
                if (regexpDescription != null && regexpDescription.length() > 0) {
                    newSn.setAttribute("description", regexpDescription);
                }
                if (reorder != null && reorder.length() > 0) {
                    newSn.setAttribute("reorder", reorder);
                }
                if (javaSession != null && javaSession.length() > 0) {
                    newSn.setAttribute("javasessionremoval", javaSession);
                }
                if (aspSession != null && aspSession.length() > 0) {
                    newSn.setAttribute("aspsessionremoval", aspSession);
                }
                if (phpSession != null && phpSession.length() > 0) {
                    newSn.setAttribute("phpsessionremoval", phpSession);
                }
                if (bvSession != null && bvSession.length() > 0) {
                    newSn.setAttribute("bvsessionremoval", bvSession);
                }
                ds.addChild(ds.getChildCount(), (ConfigurationNode)newSn);
            }
        }
        if ((xc = variableContext.getParameter("tokencount")) != null) {
            i = 0;
            while (i < ds.getChildCount()) {
                sn = ds.getChild(i);
                if (sn.getType().equals("access")) {
                    ds.removeChild(i);
                    continue;
                }
                ++i;
            }
            int accessCount = Integer.parseInt(xc);
            i = 0;
            while (i < accessCount) {
                String accessDescription = "_" + Integer.toString(i);
                String accessOpName = "accessop" + accessDescription;
                xc = variableContext.getParameter(accessOpName);
                if (xc != null && xc.equals("Delete")) {
                    ++i;
                    continue;
                }
                String accessSpec = variableContext.getParameter("spectoken" + accessDescription);
                node = new SpecificationNode("access");
                node.setAttribute("token", accessSpec);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node);
                ++i;
            }
            String op = variableContext.getParameter("accessop");
            if (op != null && op.equals("Add")) {
                String accessspec = variableContext.getParameter("spectoken");
                SpecificationNode node2 = new SpecificationNode("access");
                node2.setAttribute("token", accessspec);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node2);
            }
        }
        if ((xc = variableContext.getParameter("metadatacount")) != null) {
            i = 0;
            while (i < ds.getChildCount()) {
                SpecificationNode sn6 = ds.getChild(i);
                if (sn6.getType().equals("metadata")) {
                    ds.removeChild(i);
                    continue;
                }
                ++i;
            }
            int metadataCount = Integer.parseInt(xc);
            i = 0;
            while (i < metadataCount) {
                String metadataDescription = "_" + Integer.toString(i);
                String metadataOpName = "metadataop" + metadataDescription;
                xc = variableContext.getParameter(metadataOpName);
                if (xc != null && xc.equals("Delete")) {
                    ++i;
                    continue;
                }
                String metaNameSpec = variableContext.getParameter("specmetaname" + metadataDescription);
                String metaValueSpec = variableContext.getParameter("specmetavalue" + metadataDescription);
                SpecificationNode node3 = new SpecificationNode("metadata");
                node3.setAttribute("name", metaNameSpec);
                node3.setAttribute("value", metaValueSpec);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node3);
                ++i;
            }
            String op = variableContext.getParameter("metadataop");
            if (op != null && op.equals("Add")) {
                String metaNameSpec = variableContext.getParameter("specmetaname");
                String metaValueSpec = variableContext.getParameter("specmetavalue");
                node = new SpecificationNode("metadata");
                node.setAttribute("name", metaNameSpec);
                node.setAttribute("value", metaValueSpec);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void viewSpecification(IHTTPOutput out, DocumentSpecification ds) throws ManifoldCFException, IOException {
        String nextString;
        BufferedReader is;
        StringReader str;
        SpecificationNode sn;
        String seeds = "";
        String inclusions = ".*\n";
        String exclusions = "";
        boolean includeMatching = false;
        int i = 0;
        while (i < ds.getChildCount()) {
            SpecificationNode sn2;
            if ((sn2 = ds.getChild(i++)).getType().equals("seeds")) {
                seeds = sn2.getValue();
                if (seeds != null) continue;
                seeds = "";
                continue;
            }
            if (sn2.getType().equals("includes")) {
                inclusions = sn2.getValue();
                if (inclusions != null) continue;
                inclusions = "";
                continue;
            }
            if (sn2.getType().equals("excludes")) {
                exclusions = sn2.getValue();
                if (exclusions != null) continue;
                exclusions = "";
                continue;
            }
            if (!sn2.getType().equals("limittoseeds")) continue;
            String value = sn2.getAttributeValue("value");
            if (value == null || value.equals("false")) {
                includeMatching = false;
                continue;
            }
            includeMatching = true;
        }
        out.print("<table class=\"displaytable\">\n  <tr>\n    <td class=\"description\"><nobr>Seeds:</nobr></td>\n    <td class=\"value\">\n");
        try {
            StringReader str2 = new StringReader(seeds);
            try {
                BufferedReader is2 = new BufferedReader(str2);
                try {
                    String nextString2;
                    while ((nextString2 = is2.readLine()) != null) {
                        if (nextString2.length() == 0) continue;
                        out.print("      <nobr>" + Encoder.bodyEscape((String)nextString2) + "</nobr><br/>\n");
                    }
                }
                finally {
                    is2.close();
                }
            }
            finally {
                ((Reader)str2).close();
            }
        }
        catch (IOException e) {
            throw new ManifoldCFException("IO error: " + e.getMessage(), (Throwable)e);
        }
        out.print("    </td>\n  </tr>\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n");
        i = 0;
        int l = 0;
        boolean seenAny = false;
        while (i < ds.getChildCount()) {
            String allowBVSessionRemoval;
            String allowPHPSessionRemoval;
            String allowASPSessionRemoval;
            String allowJavaSessionRemoval;
            String allowReorder;
            if (!(sn = ds.getChild(i++)).getType().equals("urlspec")) continue;
            if (l == 0) {
                out.print("  <tr>\n    <td class=\"description\"><nobr>URL canonicalization:</nobr></td>\n    <td class=\"value\">\n      <table class=\"formtable\">\n        <tr class=\"formheaderrow\">\n          <td class=\"formcolumnheader\"><nobr>URL regexp</nobr></td>\n          <td class=\"formcolumnheader\"><nobr>Description</nobr></td>\n          <td class=\"formcolumnheader\"><nobr>Reorder?</nobr></td>\n          <td class=\"formcolumnheader\"><nobr>Remove JSP sessions?</nobr></td>\n          <td class=\"formcolumnheader\"><nobr>Remove ASP sessions?</nobr></td>\n          <td class=\"formcolumnheader\"><nobr>Remove PHP sessions?</nobr></td>\n          <td class=\"formcolumnheader\"><nobr>Remove BV sessions?</nobr></td>\n        </tr>\n");
            }
            String regexpString = sn.getAttributeValue("regexp");
            String description = sn.getAttributeValue("description");
            if (description == null) {
                description = "";
            }
            if ((allowReorder = sn.getAttributeValue("reorder")) == null || allowReorder.length() == 0) {
                allowReorder = "no";
            }
            if ((allowJavaSessionRemoval = sn.getAttributeValue("javasessionremoval")) == null || allowJavaSessionRemoval.length() == 0) {
                allowJavaSessionRemoval = "no";
            }
            if ((allowASPSessionRemoval = sn.getAttributeValue("aspsessionremoval")) == null || allowASPSessionRemoval.length() == 0) {
                allowASPSessionRemoval = "no";
            }
            if ((allowPHPSessionRemoval = sn.getAttributeValue("phpsessionremoval")) == null || allowPHPSessionRemoval.length() == 0) {
                allowPHPSessionRemoval = "no";
            }
            if ((allowBVSessionRemoval = sn.getAttributeValue("bvsessionremoval")) == null || allowBVSessionRemoval.length() == 0) {
                allowBVSessionRemoval = "no";
            }
            out.print("        <tr class=\"" + (l % 2 == 0 ? "evenformrow" : "oddformrow") + "\">\n" + "          <td class=\"formcolumncell\"><nobr>" + Encoder.bodyEscape((String)regexpString) + "</nobr></td>\n" + "          <td class=\"formcolumncell\">" + Encoder.bodyEscape((String)description) + "</td>\n" + "          <td class=\"formcolumncell\"><nobr>" + allowReorder + "</nobr></td>\n" + "          <td class=\"formcolumncell\"><nobr>" + allowJavaSessionRemoval + "</nobr></td>\n" + "          <td class=\"formcolumncell\"><nobr>" + allowASPSessionRemoval + "</nobr></td>\n" + "          <td class=\"formcolumncell\"><nobr>" + allowPHPSessionRemoval + "</nobr></td>\n" + "          <td class=\"formcolumncell\"><nobr>" + allowBVSessionRemoval + "</nobr></td>\n" + "        </tr>\n");
            ++l;
        }
        if (l > 0) {
            out.print("      </table>\n    </td>\n  </tr>\n");
        } else {
            out.print("  <tr><td class=\"message\" colspan=\"2\"><nobr>No url canonicalization specified; will reorder all urls and remove all sessions</nobr></td></tr>\n");
        }
        out.print("  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>Include only hosts mentioned in seeds?</nobr></td>\n    <td class=\"value\">\n    " + (includeMatching ? "yes" : "no") + "\n" + "    </td>\n" + "  </tr>\n");
        out.print("  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>Includes:</nobr></td>\n    <td class=\"value\">\n");
        try {
            str = new StringReader(inclusions);
            try {
                is = new BufferedReader(str);
                try {
                    while ((nextString = is.readLine()) != null) {
                        if (nextString.length() == 0) continue;
                        out.print("      <nobr>" + Encoder.bodyEscape((String)nextString) + "</nobr><br/>\n");
                    }
                }
                finally {
                    is.close();
                }
            }
            finally {
                ((Reader)str).close();
            }
        }
        catch (IOException e) {
            throw new ManifoldCFException("IO error: " + e.getMessage(), (Throwable)e);
        }
        out.print("    </td>\n  </tr>\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>Excludes:</nobr></td>\n    <td class=\"value\">\n");
        try {
            str = new StringReader(exclusions);
            try {
                is = new BufferedReader(str);
                try {
                    while ((nextString = is.readLine()) != null) {
                        if (nextString.length() == 0) continue;
                        out.print("      <nobr>" + Encoder.bodyEscape((String)nextString) + "</nobr><br/>\n");
                    }
                }
                finally {
                    is.close();
                }
            }
            finally {
                ((Reader)str).close();
            }
        }
        catch (IOException e) {
            throw new ManifoldCFException("IO error: " + e.getMessage(), (Throwable)e);
        }
        out.print("    </td>\n  </tr>\n    \n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n");
        seenAny = false;
        i = 0;
        while (i < ds.getChildCount()) {
            if (!(sn = ds.getChild(i++)).getType().equals("access")) continue;
            if (!seenAny) {
                out.print("  <tr>\n    <td class=\"description\"><nobr>Access tokens:</nobr></td>\n    <td class=\"value\">\n");
                seenAny = true;
            }
            String token = sn.getAttributeValue("token");
            out.print("      " + Encoder.bodyEscape((String)token) + "<br/>\n");
        }
        if (seenAny) {
            out.print("    </td>\n  </tr>\n");
        } else {
            out.print("  <tr><td class=\"message\" colspan=\"2\"><nobr>No access tokens specified</nobr></td></tr>\n");
        }
        out.print("  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n");
        seenAny = false;
        i = 0;
        while (i < ds.getChildCount()) {
            if (!(sn = ds.getChild(i++)).getType().equals("metadata")) continue;
            if (!seenAny) {
                out.print("  <tr>\n    <td class=\"description\"><nobr>Metadata:</nobr></td>\n    <td class=\"value\">\n");
                seenAny = true;
            }
            String name = sn.getAttributeValue("name");
            String value = sn.getAttributeValue("value");
            out.print("      " + Encoder.bodyEscape((String)name) + "&nbsp;=&nbsp;" + Encoder.bodyEscape((String)value) + "<br/>\n");
        }
        if (seenAny) {
            out.print("    </td>\n  </tr>\n");
        } else {
            out.print("  <tr><td class=\"message\" colspan=\"2\"><nobr>No metadata specified</nobr></td></tr>\n");
        }
        out.print("</table>\n");
    }

    protected String makeSessionLoginEventName(INamingActivity activities, String sequenceKey) {
        return activities.createGlobalString(this.getJSPFolder() + ":session:" + sequenceKey);
    }

    protected String makeDNSEventName(INamingActivity activities, String hostNameKey) {
        return activities.createGlobalString(this.getJSPFolder() + ":dns:" + hostNameKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int lookupIPAddress(String documentIdentifier, IVersionActivity activities, String hostName, long currentTime, StringBuffer ipAddressBuffer) throws ManifoldCFException, ServiceInterruption {
        String eventName = this.makeDNSEventName((INamingActivity)activities, hostName);
        DNSManager.DNSInfo info = this.dnsManager.lookup(hostName, currentTime);
        if (info != null) {
            String ipAddress = info.getIPAddress();
            if (ipAddress == null) {
                return 0;
            }
            ipAddressBuffer.append(ipAddress);
            return 1;
        }
        if (activities.beginEventSequence(eventName)) {
            try {
                InetAddress ip = null;
                try {
                    ip = InetAddress.getByName(hostName);
                }
                catch (UnknownHostException e) {
                    // empty catch block
                }
                String fqdn = null;
                String ipAddress = null;
                if (ip != null) {
                    fqdn = ip.getCanonicalHostName();
                    ipAddress = ip.getHostAddress();
                }
                this.dnsManager.writeDNSData(hostName, fqdn, ipAddress, currentTime + 21600000L);
                if (ipAddress == null) {
                    int n = 0;
                    return n;
                }
                ipAddressBuffer.append(ipAddress);
                int n = 1;
                return n;
            }
            finally {
                activities.completeEventSequence(eventName);
            }
        }
        return 2;
    }

    protected static String makeRobotsKey(String protocol, String hostName, int port) {
        String rval = hostName + ":" + port;
        if (!protocol.equalsIgnoreCase("http")) {
            rval = protocol.toLowerCase() + ":" + rval;
        }
        return rval;
    }

    protected String makeRobotsEventName(INamingActivity versionActivities, String robotsKey) {
        return versionActivities.createGlobalString(this.getJSPFolder() + ":robots:" + robotsKey);
    }

    /*
     * Exception decompiling
     */
    protected int checkFetchAllowed(String documentIdentifier, String protocol, String hostIPAddress, int port, PageCredentials credential, IKeystoreManager trustStore, String hostName, String[] binNames, long currentTime, String pathString, IVersionActivity versionActivities, int connectionLimit) throws ManifoldCFException, ServiceInterruption {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [26[CATCHBLOCK]], but top level block is 10[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected String makeDocumentIdentifier(String parentIdentifier, String rawURL, DocumentURLFilter filter) throws ManifoldCFException {
        try {
            URI url;
            URI rawPiece = new URI(rawURL);
            if (parentIdentifier != null) {
                if (rawPiece.isAbsolute()) {
                    url = rawPiece;
                } else {
                    URI parentURL = new URI(parentIdentifier);
                    if (parentURL.getPath() == null || parentURL.getPath().length() == 0) {
                        parentURL = new URI(parentIdentifier + "/");
                    }
                    url = parentURL.resolve(rawPiece);
                }
            } else {
                url = rawPiece;
            }
            String protocol = url.getScheme();
            String host = url.getHost();
            if (protocol == null || host == null) {
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("WEB: Can't use url '" + rawURL + "' because it has no protocol or host"));
                }
                return null;
            }
            if (understoodProtocols.get(protocol) == null) {
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("WEB: Can't use url '" + rawURL + "' because it has an unsupported protocol '" + protocol + "'"));
                }
                return null;
            }
            if (!filter.isHostLegal(host)) {
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("WEB: Can't use url '" + rawURL + "' because its host is not found in the seeds ('" + host + "')"));
                }
                return null;
            }
            String id = this.doCanonicalization(filter, url);
            if (id == null) {
                return null;
            }
            int i = 0;
            while (i < id.length()) {
                char x;
                if ((x = id.charAt(i++)) >= ' ' && x <= '\u007f') continue;
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("WEB: Can't use url '" + rawURL + "' because it has illegal characters in it"));
                }
                return null;
            }
            if (!filter.isDocumentLegal(id)) {
                return null;
            }
            return id;
        }
        catch (URISyntaxException e) {
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("WEB: Can't use url '" + rawURL + "' because it is badly formed: " + e.getMessage()));
            }
            return null;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    protected String doCanonicalization(DocumentURLFilter filter, URI url) throws ManifoldCFException, URISyntaxException {
        String rval;
        String pathString = url.getPath();
        String queryString = url.getRawQuery();
        URI rawURI = new URI(url.getScheme(), null, url.getHost(), url.getPort(), pathString, null, null);
        String completeRawURL = rawURI.toASCIIString();
        if (completeRawURL != null && queryString != null && queryString.length() > 0) {
            completeRawURL = completeRawURL + "?" + queryString;
        }
        CanonicalizationPolicy p = completeRawURL != null ? filter.getCanonicalizationPolicies().findMatch(completeRawURL) : null;
        if (queryString != null) {
            if (p == null || p.canReorder()) {
                HashMap<String, ArrayList<String>> argumentMap = new HashMap<String, ArrayList<String>>();
                int index = 0;
                while (index < queryString.length()) {
                    String argument;
                    int valueIndex;
                    int newIndex = queryString.indexOf("&", index);
                    if (newIndex == -1) {
                        newIndex = queryString.length();
                    }
                    String key = (valueIndex = (argument = queryString.substring(index, newIndex)).indexOf("=")) == -1 ? argument : argument.substring(0, valueIndex);
                    boolean includeArgument = true;
                    if ((p == null || p.canRemovePhpSession()) && key.equals("PHPSESSID")) {
                        includeArgument = false;
                    }
                    if (p != null && p.canRemoveBvSession() && key.indexOf("BVSession@@@@") != -1) {
                        includeArgument = false;
                    }
                    if (includeArgument) {
                        ArrayList<String> list = (ArrayList<String>)argumentMap.get(key);
                        if (list == null) {
                            list = new ArrayList<String>();
                            argumentMap.put(key, list);
                        }
                        list.add(argument);
                    }
                    if (newIndex < queryString.length()) {
                        index = newIndex + 1;
                        continue;
                    }
                    index = newIndex;
                }
                Object[] sortArray = new String[argumentMap.size()];
                int i = 0;
                Iterator iter = argumentMap.keySet().iterator();
                while (iter.hasNext()) {
                    sortArray[i++] = (String)iter.next();
                }
                Arrays.sort(sortArray);
                StringBuffer newString = new StringBuffer();
                boolean isFirst = true;
                i = 0;
                while (i < sortArray.length) {
                    Object key = sortArray[i++];
                    ArrayList list = (ArrayList)argumentMap.get(key);
                    int j = 0;
                    while (j < list.size()) {
                        if (!isFirst) {
                            newString.append("&");
                        } else {
                            isFirst = false;
                        }
                        newString.append((String)list.get(j++));
                    }
                }
                queryString = newString.toString();
            } else {
                StringBuffer newString = new StringBuffer();
                int index = 0;
                boolean isFirst = true;
                while (index < queryString.length()) {
                    String argument;
                    int valueIndex;
                    int newIndex = queryString.indexOf("&", index);
                    if (newIndex == -1) {
                        newIndex = queryString.length();
                    }
                    String key = (valueIndex = (argument = queryString.substring(index, newIndex)).indexOf("=")) == -1 ? argument : argument.substring(0, valueIndex);
                    boolean includeArgument = true;
                    if ((p == null || p.canRemovePhpSession()) && key.equals("PHPSESSID")) {
                        includeArgument = false;
                    }
                    if (p != null && p.canRemoveBvSession() && key.indexOf("BVSession@@@@") != -1) {
                        includeArgument = false;
                    }
                    if (includeArgument) {
                        if (!isFirst) {
                            newString.append("&");
                        } else {
                            isFirst = false;
                        }
                        newString.append(argument);
                    }
                    if (newIndex < queryString.length()) {
                        index = newIndex + 1;
                        continue;
                    }
                    index = newIndex;
                }
                queryString = newString.toString();
            }
        }
        if (pathString != null) {
            int index = pathString.indexOf(";jsessionid=");
            if ((p == null || p.canRemoveJavaSession()) && index != -1) {
                pathString = pathString.substring(0, index);
            }
            if ((p == null || p.canRemoveAspSession()) && pathString.startsWith("/s(") && (index = pathString.indexOf(")")) != -1) {
                pathString = pathString.substring(index + 1);
            }
        }
        if ((rval = (url = new URI(url.getScheme(), null, url.getHost(), url.getPort(), pathString, null, null)).toASCIIString()) != null && queryString != null && queryString.length() > 0) {
            rval = rval + "?" + queryString;
        }
        return rval;
    }

    protected boolean isContentInteresting(IFingerprintActivity activities, String documentIdentifier, int response, String contentType) throws ServiceInterruption, ManifoldCFException {
        if (response != 200) {
            return true;
        }
        if (contentType == null) {
            return false;
        }
        int pos = contentType.indexOf(";");
        if (pos != -1) {
            contentType = contentType.substring(0, pos);
        }
        if (interestingMimeTypeMap.get(contentType = contentType.trim()) != null) {
            return true;
        }
        return activities.checkMimeTypeIndexable(contentType);
    }

    protected boolean isDataIngestable(IFingerprintActivity activities, String documentIdentifier) throws ServiceInterruption, ManifoldCFException {
        if (cache.getResponseCode(documentIdentifier) != 200) {
            return false;
        }
        String contentType = cache.getContentType(documentIdentifier);
        if (contentType != null) {
            String[] contentTypes = contentType.split(",");
            contentType = contentTypes.length > 0 ? contentTypes[contentTypes.length - 1].trim() : null;
        }
        if (contentType == null) {
            return false;
        }
        int pos = contentType.indexOf(";");
        if (pos != -1) {
            contentType = contentType.substring(0, pos);
        }
        contentType = contentType.trim();
        return activities.checkMimeTypeIndexable(contentType);
    }

    protected String findRedirectionURI(String currentURI) throws ManifoldCFException {
        FindRedirectionHandler handler = new FindRedirectionHandler(currentURI);
        this.handleRedirects(currentURI, handler);
        return handler.getTargetURI();
    }

    protected FormData findHTMLForm(String currentURI, LoginParameters lp) throws ManifoldCFException {
        if (lp == null || lp.getFormNamePattern() == null) {
            return null;
        }
        FindHTMLFormHandler handler = new FindHTMLFormHandler(currentURI, lp.getFormNamePattern());
        this.handleHTML(currentURI, handler);
        handler.applyFormOverrides(lp);
        return handler.getFormData();
    }

    protected String findPreferredRedirectionURI(String currentURI, LoginParameters lp) throws ManifoldCFException {
        if (lp == null || lp.getPreferredRedirectionPattern() == null) {
            return null;
        }
        FindPreferredRedirectionHandler handler = new FindPreferredRedirectionHandler(currentURI, lp.getPreferredRedirectionPattern());
        this.handleRedirects(currentURI, handler);
        return handler.getTargetURI();
    }

    protected String findHTMLLinkURI(String currentURI, LoginParameters lp) throws ManifoldCFException {
        if (lp == null || lp.getPreferredLinkPattern() == null) {
            return null;
        }
        FindHTMLHrefHandler handler = new FindHTMLHrefHandler(currentURI, lp.getPreferredLinkPattern());
        this.handleHTML(currentURI, handler);
        return handler.getTargetURI();
    }

    protected boolean extractLinks(String documentIdentifier, IProcessActivity activities, DocumentURLFilter filter) throws ManifoldCFException, ServiceInterruption {
        ProcessActivityRedirectionHandler redirectHandler = new ProcessActivityRedirectionHandler(documentIdentifier, activities, filter);
        this.handleRedirects(documentIdentifier, redirectHandler);
        ProcessActivityHTMLHandler htmlHandler = new ProcessActivityHTMLHandler(documentIdentifier, activities, filter);
        this.handleHTML(documentIdentifier, htmlHandler);
        ProcessActivityXMLHandler xmlHandler = new ProcessActivityXMLHandler(documentIdentifier, activities, filter);
        this.handleXML(documentIdentifier, xmlHandler);
        return htmlHandler.shouldIndex() && redirectHandler.shouldIndex() && xmlHandler.shouldIndex();
    }

    protected void handleRedirects(String documentURI, IRedirectionHandler handler) throws ManifoldCFException {
        int responseCode = cache.getResponseCode(documentURI);
        if (responseCode == 302 || responseCode == 301) {
            String referralURI = cache.getReferralURI(documentURI);
            if (referralURI == null) {
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("WEB: The document '" + documentURI + "' is a redirection, but there was no URI header!"));
                }
                return;
            }
            int index = referralURI.indexOf(" ");
            if (index != -1) {
                referralURI = referralURI.substring(0, index);
            }
            handler.noteDiscoveredLink(referralURI);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleXML(String documentURI, IXMLHandler handler) throws ManifoldCFException, ServiceInterruption {
        try {
            InputStream is;
            boolean isXML;
            int responseCode = cache.getResponseCode(documentURI);
            if (responseCode != 200) {
                return;
            }
            String contentType = cache.getContentType(documentURI);
            if (contentType != null) {
                String[] contentTypes = contentType.split(",");
                contentType = contentTypes.length > 0 ? contentTypes[contentTypes.length - 1].trim() : null;
            }
            if (contentType == null) {
                return;
            }
            int semiIndex = contentType.indexOf(";");
            String suffix = null;
            if (semiIndex != -1) {
                suffix = contentType.substring(semiIndex + 1);
                contentType = contentType.substring(0, semiIndex);
            }
            boolean bl = isXML = (contentType = contentType.trim()).equals("text/xml") || contentType.equals("application/rss+xml") || contentType.equals("application/xml") || contentType.equals("application/atom+xml") || contentType.equals("application/xhtml+xml") || contentType.equals("text/XML") || contentType.equals("application/rdf+xml") || contentType.equals("text/application") || contentType.equals("XML");
            if (!isXML) {
                return;
            }
            String encoding = "utf-8";
            if (suffix != null && (suffix = suffix.trim()).startsWith("charset=")) {
                encoding = suffix.substring("charset=".length());
            }
            if ((is = cache.getData(documentURI)) == null) {
                Logging.connectors.error((Object)("WEB: Document '" + documentURI + "' should be in cache but isn't"));
                return;
            }
            try {
                XMLStream x = new XMLStream();
                OuterContextClass c = new OuterContextClass(x, documentURI, handler);
                x.setContext((XMLContext)c);
                try {
                    x.parse(is);
                    c.checkIfValidFeed();
                }
                finally {
                    x.cleanup();
                }
            }
            catch (ManifoldCFException e) {
                if (e.getMessage().indexOf("pars") >= 0) {
                    if (Logging.connectors.isDebugEnabled()) {
                        Logging.connectors.debug((Object)("WEB: XML document '" + documentURI + "' was unparseable (" + e.getMessage() + "), skipping"));
                    }
                    return;
                }
                throw e;
            }
            finally {
                is.close();
            }
        }
        catch (SocketTimeoutException e) {
            throw new ManifoldCFException("Socket timeout exception: " + e.getMessage(), (Throwable)e);
        }
        catch (ConnectTimeoutException e) {
            throw new ManifoldCFException("Socket connect timeout exception: " + e.getMessage(), (Throwable)e);
        }
        catch (InterruptedIOException e) {
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
        }
        catch (IOException e) {
            throw new ManifoldCFException("IO error: " + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleHTML(String documentURI, IHTMLHandler handler) throws ManifoldCFException {
        int responseCode = cache.getResponseCode(documentURI);
        if (responseCode != 200) {
            return;
        }
        try {
            InputStream is;
            int pos;
            if (!this.isDocumentText(documentURI)) {
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("WEB: Document '" + documentURI + "' is not text; can't extract links"));
                }
                return;
            }
            String encoding = "utf-8";
            String contentType = cache.getContentType(documentURI);
            if (contentType != null) {
                String[] contentTypes = contentType.split(",");
                contentType = contentTypes.length > 0 ? contentTypes[contentTypes.length - 1].trim() : null;
            }
            if (contentType != null && (pos = contentType.indexOf(";")) != -1 && (contentType = contentType.substring(pos + 1).trim()).startsWith("charset=")) {
                encoding = contentType.substring("charset=".length());
            }
            if ((is = cache.getData(documentURI)) == null) {
                Logging.connectors.error((Object)("WEB: Document '" + documentURI + "' should be in cache but isn't"));
                return;
            }
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("WEB: Document '" + documentURI + "' is text, with encoding '" + encoding + "'; link extraction starting"));
            }
            try {
                InputStreamReader r = new InputStreamReader(is, encoding);
                try {
                    int x;
                    FormParseState currentParseState = new FormParseState(handler);
                    while ((x = ((Reader)r).read()) != -1) {
                        currentParseState.dealWithCharacter((char)x);
                    }
                    currentParseState.finishUp();
                }
                finally {
                    ((Reader)r).close();
                }
            }
            catch (UnsupportedEncodingException e) {
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("WEB: Document '" + documentURI + "' had an unrecognized encoding '" + encoding + "'"));
                }
                return;
            }
            finally {
                is.close();
            }
        }
        catch (SocketTimeoutException e) {
            throw new ManifoldCFException("Socket timeout exception: " + e.getMessage(), (Throwable)e);
        }
        catch (ConnectTimeoutException e) {
            throw new ManifoldCFException("Socket connect timeout exception: " + e.getMessage(), (Throwable)e);
        }
        catch (InterruptedIOException e) {
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
        }
        catch (IOException e) {
            throw new ManifoldCFException("IO error: " + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isDocumentText(String documentURI) throws ManifoldCFException {
        try {
            int amt;
            byte[] byteBuffer = new byte[4096];
            InputStream is = cache.getData(documentURI);
            if (is == null) {
                return false;
            }
            try {
                int incr;
                for (amt = 0; amt < byteBuffer.length; amt += incr) {
                    incr = is.read(byteBuffer, amt, byteBuffer.length - amt);
                    if (incr != -1) continue;
                    break;
                }
            }
            finally {
                is.close();
            }
            if (amt == 0) {
                return false;
            }
            return WebcrawlerConnector.isText(byteBuffer, amt);
        }
        catch (SocketTimeoutException e) {
            throw new ManifoldCFException("Socket timeout exception accessing cached document: " + e.getMessage(), (Throwable)e);
        }
        catch (ConnectTimeoutException e) {
            throw new ManifoldCFException("Socket timeout exception accessing cached document: " + e.getMessage(), (Throwable)e);
        }
        catch (InterruptedIOException e) {
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
        }
        catch (IOException e) {
            throw new ManifoldCFException("IO exception accessing cached document: " + e.getMessage(), (Throwable)e);
        }
    }

    protected static boolean isText(byte[] beginChunk, int chunkLength) {
        if (chunkLength == 0) {
            return true;
        }
        int i = 0;
        int count = 0;
        while (i < chunkLength) {
            byte x;
            if ((x = beginChunk[i++]) == 0) {
                return false;
            }
            if (!WebcrawlerConnector.isStrange(x)) continue;
            ++count;
        }
        return (double)count / (double)chunkLength < 0.3;
    }

    protected static boolean isStrange(byte x) {
        return (x > 127 || x < 32) && !WebcrawlerConnector.isWhiteSpace(x);
    }

    protected static boolean isWhiteSpace(byte x) {
        return x == 9 || x == 10 || x == 13 || x == 32;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ArrayList stringToArray(String input) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            StringReader str = new StringReader(input);
            try {
                BufferedReader is = new BufferedReader(str);
                try {
                    String nextString;
                    while ((nextString = is.readLine()) != null) {
                        if (nextString.length() == 0) continue;
                        nextString.trim();
                        if (nextString.startsWith("#")) continue;
                        list.add(nextString);
                    }
                }
                finally {
                    is.close();
                }
            }
            finally {
                ((Reader)str).close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return list;
    }

    protected static void compileList(ArrayList output, ArrayList input) throws ManifoldCFException {
        int i = 0;
        while (i < input.size()) {
            String inputString = (String)input.get(i++);
            try {
                output.add(Pattern.compile(inputString));
            }
            catch (PatternSyntaxException e) {
                throw new ManifoldCFException("Mapping regular expression '" + inputString + "' is illegal: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    protected PageCredentials getPageCredential(String documentIdentifier) {
        return this.credentialsDescription.getPageCredential(documentIdentifier);
    }

    protected SequenceCredentials getSequenceCredential(String documentIdentifier) {
        return this.credentialsDescription.getSequenceCredential(documentIdentifier);
    }

    protected IKeystoreManager getTrustStore(String documentIdentifier) throws ManifoldCFException {
        return this.trustsDescription.getTrustStore(documentIdentifier);
    }

    protected static String[] getAcls(DocumentSpecification spec) {
        HashMap<String, String> map = new HashMap<String, String>();
        int i = 0;
        while (i < spec.getChildCount()) {
            SpecificationNode sn;
            if (!(sn = spec.getChild(i++)).getType().equals("access")) continue;
            String token = sn.getAttributeValue("token");
            map.put(token, token);
        }
        String[] rval = new String[map.size()];
        Iterator iter = map.keySet().iterator();
        i = 0;
        while (iter.hasNext()) {
            rval[i++] = (String)iter.next();
        }
        return rval;
    }

    protected static ArrayList findMetadata(DocumentSpecification spec) throws ManifoldCFException {
        ArrayList<NameValue> rval = new ArrayList<NameValue>();
        int i = 0;
        while (i < spec.getChildCount()) {
            SpecificationNode n;
            if (!(n = spec.getChild(i++)).getType().equals("metadata")) continue;
            String name = n.getAttributeValue("name");
            String value = n.getAttributeValue("value");
            if (name == null || name.length() <= 0 || value == null || value.length() <= 0) continue;
            rval.add(new NameValue(name, value));
        }
        return rval;
    }

    protected static void pack(StringBuffer output, String value, char delimiter) {
        int i = 0;
        while (i < value.length()) {
            char x;
            if ((x = value.charAt(i++)) == '\\' || x == delimiter) {
                output.append('\\');
            }
            output.append(x);
        }
        output.append(delimiter);
    }

    protected static int unpack(StringBuffer sb, String value, int startPosition, char delimiter) {
        while (startPosition < value.length()) {
            char x;
            if ((x = value.charAt(startPosition++)) == '\\') {
                if (startPosition < value.length()) {
                    x = value.charAt(startPosition++);
                }
            } else if (x == delimiter) break;
            sb.append(x);
        }
        return startPosition;
    }

    protected static void packFixedList(StringBuffer output, String[] values, char delimiter) {
        int i = 0;
        while (i < values.length) {
            WebcrawlerConnector.pack(output, values[i++], delimiter);
        }
    }

    protected static int unpackFixedList(String[] output, String value, int startPosition, char delimiter) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < output.length) {
            sb.setLength(0);
            startPosition = WebcrawlerConnector.unpack(sb, value, startPosition, delimiter);
            output[i++] = sb.toString();
        }
        return startPosition;
    }

    protected static void packList(StringBuffer output, ArrayList values, char delimiter) {
        WebcrawlerConnector.pack(output, Integer.toString(values.size()), delimiter);
        int i = 0;
        while (i < values.size()) {
            WebcrawlerConnector.pack(output, values.get(i++).toString(), delimiter);
        }
    }

    protected static void packList(StringBuffer output, String[] values, char delimiter) {
        WebcrawlerConnector.pack(output, Integer.toString(values.length), delimiter);
        int i = 0;
        while (i < values.length) {
            WebcrawlerConnector.pack(output, values[i++], delimiter);
        }
    }

    protected static int unpackList(ArrayList output, String value, int startPosition, char delimiter) {
        StringBuffer sb = new StringBuffer();
        startPosition = WebcrawlerConnector.unpack(sb, value, startPosition, delimiter);
        try {
            int count = Integer.parseInt(sb.toString());
            for (int i = 0; i < count; ++i) {
                sb.setLength(0);
                startPosition = WebcrawlerConnector.unpack(sb, value, startPosition, delimiter);
                output.add(sb.toString());
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        return startPosition;
    }

    protected String[] calculateDocumentEvents(INamingActivity activities, String documentIdentifier) {
        try {
            URL url = new URL(documentIdentifier);
            String hostName = url.getHost();
            String protocol = url.getProtocol();
            int port = url.getPort();
            if (port == -1) {
                port = url.getDefaultPort();
            }
            String robotsKey = WebcrawlerConnector.makeRobotsKey(protocol, hostName, port);
            String robotsEventName = this.makeRobotsEventName(activities, robotsKey);
            String dnsEventName = this.makeDNSEventName(activities, hostName);
            SequenceCredentials sequenceCredential = this.getSequenceCredential(documentIdentifier);
            if (sequenceCredential != null) {
                String sessionKey = sequenceCredential.getSequenceKey();
                String sessionEventName = this.makeSessionLoginEventName(activities, sessionKey);
                return new String[]{robotsEventName, hostName, sessionEventName};
            }
            return new String[]{robotsEventName, hostName};
        }
        catch (MalformedURLException e) {
            Logging.connectors.warn((Object)("WEB: Could not form event names for identifier '" + documentIdentifier + "' because it was malformed: " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    static {
        int i = 0;
        while (i < interestingMimeTypeArray.length) {
            String type = interestingMimeTypeArray[i++];
            interestingMimeTypeMap.put(type, type);
        }
        understoodProtocols = new HashMap();
        understoodProtocols.put("http", "http");
        understoodProtocols.put("https", "https");
        cache = new DataCache();
    }

    protected static class DocumentURLFilter {
        protected ArrayList includePatterns = new ArrayList();
        protected ArrayList excludePatterns = new ArrayList();
        protected HashMap seedHosts = null;
        protected CanonicalizationPolicies canonicalizationPolicies = new CanonicalizationPolicies();

        public DocumentURLFilter(DocumentSpecification spec) throws ManifoldCFException {
            String includes = "";
            String excludes = "";
            String seeds = "";
            boolean limitToSeeds = false;
            int i = 0;
            while (i < spec.getChildCount()) {
                String reorder;
                SpecificationNode sn;
                if ((sn = spec.getChild(i++)).getType().equals("seeds")) {
                    seeds = sn.getValue();
                    if (seeds != null) continue;
                    seeds = "";
                    continue;
                }
                if (sn.getType().equals("includes")) {
                    includes = sn.getValue();
                    if (includes != null) continue;
                    includes = "";
                    continue;
                }
                if (sn.getType().equals("excludes")) {
                    excludes = sn.getValue();
                    if (excludes != null) continue;
                    excludes = "";
                    continue;
                }
                if (sn.getType().equals("limittoseeds")) {
                    String value = sn.getAttributeValue("value");
                    if (value == null || value.equals("false")) {
                        limitToSeeds = false;
                        continue;
                    }
                    limitToSeeds = true;
                    continue;
                }
                if (!sn.getType().equals("urlspec")) continue;
                String urlRegexp = sn.getAttributeValue("regexp");
                if (urlRegexp == null) {
                    urlRegexp = "";
                }
                boolean reorderValue = (reorder = sn.getAttributeValue("reorder")) == null ? false : reorder.equals("yes");
                String javaSession = sn.getAttributeValue("javasessionremoval");
                boolean javaSessionValue = javaSession == null ? false : javaSession.equals("yes");
                String aspSession = sn.getAttributeValue("aspsessionremoval");
                boolean aspSessionValue = aspSession == null ? false : aspSession.equals("yes");
                String phpSession = sn.getAttributeValue("phpsessionremoval");
                boolean phpSessionValue = phpSession == null ? false : phpSession.equals("yes");
                String bvSession = sn.getAttributeValue("bvsessionremoval");
                boolean bvSessionValue = bvSession == null ? false : bvSession.equals("yes");
                try {
                    this.canonicalizationPolicies.addRule(new CanonicalizationPolicy(Pattern.compile(urlRegexp), reorderValue, javaSessionValue, aspSessionValue, phpSessionValue, bvSessionValue));
                }
                catch (PatternSyntaxException e) {
                    throw new ManifoldCFException("Canonicalization regular expression '" + urlRegexp + "' is illegal: " + e.getMessage(), (Throwable)e);
                }
            }
            ArrayList list = WebcrawlerConnector.stringToArray(includes);
            WebcrawlerConnector.compileList(this.includePatterns, list);
            list = WebcrawlerConnector.stringToArray(excludes);
            WebcrawlerConnector.compileList(this.excludePatterns, list);
            if (limitToSeeds) {
                this.seedHosts = new HashMap();
                list = WebcrawlerConnector.stringToArray(seeds);
                int index = 0;
                while (index < list.size()) {
                    String urlCandidate = (String)list.get(index++);
                    try {
                        URI url = new URI(urlCandidate);
                        String host = url.getHost();
                        if (host == null) continue;
                        this.seedHosts.put(host, host);
                    }
                    catch (URISyntaxException e) {
                    }
                    catch (IllegalArgumentException e) {}
                }
            }
        }

        public boolean isDocumentAndHostLegal(String url) {
            if (!this.isDocumentLegal(url)) {
                return false;
            }
            if (this.seedHosts == null) {
                return true;
            }
            try {
                URI uri = new URI(url);
                String host = uri.getHost();
                if (host == null) {
                    return false;
                }
                return this.isHostLegal(host);
            }
            catch (URISyntaxException e) {
                return false;
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }

        public boolean isHostLegal(String host) {
            if (this.seedHosts == null) {
                return true;
            }
            return this.seedHosts.get(host) != null;
        }

        public boolean isDocumentLegal(String url) {
            Pattern p;
            Matcher m;
            int i;
            for (i = 0; i < this.includePatterns.size() && !(m = (p = (Pattern)this.includePatterns.get(i)).matcher(url)).find(); ++i) {
            }
            if (i == this.includePatterns.size()) {
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("WEB: Url '" + url + "' is illegal because no include patterns match it"));
                }
                return false;
            }
            for (i = 0; i < this.excludePatterns.size(); ++i) {
                p = (Pattern)this.excludePatterns.get(i);
                m = p.matcher(url);
                if (!m.find()) continue;
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("WEB: Url '" + url + "' is illegal because exclude pattern '" + p.toString() + "' matched it"));
                }
                return false;
            }
            return true;
        }

        public CanonicalizationPolicies getCanonicalizationPolicies() {
            return this.canonicalizationPolicies;
        }
    }

    protected static class CanonicalizationPolicies {
        protected ArrayList rules = new ArrayList();

        public void addRule(CanonicalizationPolicy rule) {
            this.rules.add(rule);
        }

        public CanonicalizationPolicy findMatch(String url) {
            int i = 0;
            while (i < this.rules.size()) {
                CanonicalizationPolicy rule;
                if (!(rule = (CanonicalizationPolicy)this.rules.get(i++)).checkMatch(url)) continue;
                return rule;
            }
            return null;
        }
    }

    protected static class CanonicalizationPolicy {
        protected Pattern matchPattern;
        protected boolean reorder;
        protected boolean removeJavaSession;
        protected boolean removeAspSession;
        protected boolean removePhpSession;
        protected boolean removeBVSession;

        public CanonicalizationPolicy(Pattern matchPattern, boolean reorder, boolean removeJavaSession, boolean removeAspSession, boolean removePhpSession, boolean removeBVSession) {
            this.matchPattern = matchPattern;
            this.reorder = reorder;
            this.removeJavaSession = removeJavaSession;
            this.removeAspSession = removeAspSession;
            this.removePhpSession = removePhpSession;
            this.removeBVSession = removeBVSession;
        }

        public boolean checkMatch(String url) {
            Matcher matcher = this.matchPattern.matcher(url);
            return matcher.find();
        }

        public boolean canReorder() {
            return this.reorder;
        }

        public boolean canRemoveJavaSession() {
            return this.removeJavaSession;
        }

        public boolean canRemoveAspSession() {
            return this.removeAspSession;
        }

        public boolean canRemovePhpSession() {
            return this.removePhpSession;
        }

        public boolean canRemoveBvSession() {
            return this.removeBVSession;
        }
    }

    protected static class NameValue {
        protected String name;
        protected String value;

        public NameValue(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }

    protected class FeedItemContextClass
    extends XMLContext {
        protected String linkField;

        public FeedItemContextClass(XMLStream theStream, String namespaceURI, String localName, String qName, Attributes atts) {
            super(theStream, namespaceURI, localName, qName, atts);
            this.linkField = null;
        }

        protected XMLContext beginTag(String namespaceURI, String localName, String qName, Attributes atts) throws ManifoldCFException, ServiceInterruption {
            if (qName.equals(WebcrawlerConnector.REL_LINK)) {
                this.linkField = atts.getValue("href");
                return super.beginTag(namespaceURI, localName, qName, atts);
            }
            return super.beginTag(namespaceURI, localName, qName, atts);
        }

        public void process(IXMLHandler handler) throws ManifoldCFException {
            if (this.linkField != null && this.linkField.length() > 0) {
                String[] links = this.linkField.split(", ");
                int l = 0;
                while (l < links.length) {
                    String rawURL = links[l++].trim();
                    handler.noteDiscoveredLink(rawURL);
                }
            }
        }
    }

    protected class FeedContextClass
    extends XMLContext {
        protected String documentURI;
        protected IXMLHandler handler;
        protected String ttlValue;

        public FeedContextClass(XMLStream theStream, String namespaceURI, String localName, String qName, Attributes atts, String documentURI, IXMLHandler handler) {
            super(theStream, namespaceURI, localName, qName, atts);
            this.ttlValue = null;
            this.documentURI = documentURI;
            this.handler = handler;
        }

        protected XMLContext beginTag(String namespaceURI, String localName, String qName, Attributes atts) throws ManifoldCFException, ServiceInterruption {
            if (qName.equals("ttl")) {
                return new XMLStringContext(this.theStream, namespaceURI, localName, qName, atts);
            }
            if (qName.equals("entry")) {
                return new FeedItemContextClass(this.theStream, namespaceURI, localName, qName, atts);
            }
            return super.beginTag(namespaceURI, localName, qName, atts);
        }

        protected void endTag() throws ManifoldCFException, ServiceInterruption {
            XMLContext theContext = this.theStream.getContext();
            String theTag = theContext.getQname();
            if (theTag.equals("ttl")) {
                this.ttlValue = ((XMLStringContext)theContext).getValue();
            } else if (theTag.equals("entry")) {
                FeedItemContextClass itemContext = (FeedItemContextClass)theContext;
                itemContext.process(this.handler);
            } else {
                super.endTag();
            }
        }

        protected void process() throws ManifoldCFException {
            this.handler.noteDiscoveredTtlValue(this.ttlValue);
        }
    }

    protected class RDFItemContextClass
    extends XMLContext {
        protected String linkField;

        public RDFItemContextClass(XMLStream theStream, String namespaceURI, String localName, String qName, Attributes atts) {
            super(theStream, namespaceURI, localName, qName, atts);
            this.linkField = null;
        }

        protected XMLContext beginTag(String namespaceURI, String localName, String qName, Attributes atts) throws ManifoldCFException, ServiceInterruption {
            if (qName.equals(WebcrawlerConnector.REL_LINK)) {
                return new XMLStringContext(this.theStream, namespaceURI, localName, qName, atts);
            }
            return super.beginTag(namespaceURI, localName, qName, atts);
        }

        protected void endTag() throws ManifoldCFException, ServiceInterruption {
            XMLContext theContext = this.theStream.getContext();
            String theTag = theContext.getQname();
            if (theTag.equals(WebcrawlerConnector.REL_LINK)) {
                this.linkField = ((XMLStringContext)theContext).getValue();
            } else {
                super.endTag();
            }
        }

        public void process(IXMLHandler handler) throws ManifoldCFException {
            if (this.linkField != null && this.linkField.length() > 0) {
                String[] links = this.linkField.split(", ");
                int l = 0;
                while (l < links.length) {
                    String rawURL = links[l++].trim();
                    handler.noteDiscoveredLink(rawURL);
                }
            }
        }
    }

    protected class RDFContextClass
    extends XMLContext {
        protected String documentURI;
        protected IXMLHandler handler;
        protected String ttlValue;

        public RDFContextClass(XMLStream theStream, String namespaceURI, String localName, String qName, Attributes atts, String documentURI, IXMLHandler handler) {
            super(theStream, namespaceURI, localName, qName, atts);
            this.ttlValue = null;
            this.documentURI = documentURI;
            this.handler = handler;
        }

        protected XMLContext beginTag(String namespaceURI, String localName, String qName, Attributes atts) throws ManifoldCFException, ServiceInterruption {
            if (qName.equals("ttl")) {
                return new XMLStringContext(this.theStream, namespaceURI, localName, qName, atts);
            }
            if (qName.equals("item")) {
                return new RDFItemContextClass(this.theStream, namespaceURI, localName, qName, atts);
            }
            return super.beginTag(namespaceURI, localName, qName, atts);
        }

        protected void endTag() throws ManifoldCFException, ServiceInterruption {
            XMLContext theContext = this.theStream.getContext();
            String theTag = theContext.getQname();
            if (theTag.equals("ttl")) {
                this.ttlValue = ((XMLStringContext)theContext).getValue();
            } else if (theTag.equals("item")) {
                RDFItemContextClass itemContext = (RDFItemContextClass)theContext;
                itemContext.process(this.handler);
            } else {
                super.endTag();
            }
        }

        protected void process() throws ManifoldCFException {
            this.handler.noteDiscoveredTtlValue(this.ttlValue);
        }
    }

    protected class RSSItemContextClass
    extends XMLContext {
        protected String guidField;
        protected String linkField;

        public RSSItemContextClass(XMLStream theStream, String namespaceURI, String localName, String qName, Attributes atts) {
            super(theStream, namespaceURI, localName, qName, atts);
            this.guidField = null;
            this.linkField = null;
        }

        protected XMLContext beginTag(String namespaceURI, String localName, String qName, Attributes atts) throws ManifoldCFException, ServiceInterruption {
            if (qName.equals(WebcrawlerConnector.REL_LINK)) {
                return new XMLStringContext(this.theStream, namespaceURI, localName, qName, atts);
            }
            if (qName.equals("guid")) {
                return new XMLStringContext(this.theStream, namespaceURI, localName, qName, atts);
            }
            return super.beginTag(namespaceURI, localName, qName, atts);
        }

        protected void endTag() throws ManifoldCFException, ServiceInterruption {
            XMLContext theContext = this.theStream.getContext();
            String theTag = theContext.getQname();
            if (theTag.equals(WebcrawlerConnector.REL_LINK)) {
                this.linkField = ((XMLStringContext)theContext).getValue();
            } else if (theTag.equals("guid")) {
                this.guidField = ((XMLStringContext)theContext).getValue();
            } else {
                super.endTag();
            }
        }

        public void process(IXMLHandler handler) throws ManifoldCFException {
            if (this.linkField == null || this.linkField.length() == 0) {
                this.linkField = this.guidField;
            }
            if (this.linkField != null && this.linkField.length() > 0) {
                String[] links = this.linkField.split(", ");
                int l = 0;
                while (l < links.length) {
                    String rawURL = links[l++].trim();
                    handler.noteDiscoveredLink(rawURL);
                }
            }
        }
    }

    protected class RSSChannelContextClass
    extends XMLContext {
        protected String documentURI;
        protected IXMLHandler handler;
        protected String ttlValue;

        public RSSChannelContextClass(XMLStream theStream, String namespaceURI, String localName, String qName, Attributes atts, String documentURI, IXMLHandler handler) {
            super(theStream, namespaceURI, localName, qName, atts);
            this.ttlValue = null;
            this.documentURI = documentURI;
            this.handler = handler;
        }

        protected XMLContext beginTag(String namespaceURI, String localName, String qName, Attributes atts) throws ManifoldCFException, ServiceInterruption {
            if (qName.equals("ttl")) {
                return new XMLStringContext(this.theStream, namespaceURI, localName, qName, atts);
            }
            if (qName.equals("item")) {
                return new RSSItemContextClass(this.theStream, namespaceURI, localName, qName, atts);
            }
            return super.beginTag(namespaceURI, localName, qName, atts);
        }

        protected void endTag() throws ManifoldCFException, ServiceInterruption {
            XMLContext theContext = this.theStream.getContext();
            String theTag = theContext.getQname();
            if (theTag.equals("ttl")) {
                this.ttlValue = ((XMLStringContext)theContext).getValue();
            } else if (theTag.equals("item")) {
                RSSItemContextClass itemContext = (RSSItemContextClass)theContext;
                itemContext.process(this.handler);
            } else {
                super.endTag();
            }
        }

        protected void process() throws ManifoldCFException {
            this.handler.noteDiscoveredTtlValue(this.ttlValue);
        }
    }

    protected class RSSContextClass
    extends XMLContext {
        protected String documentURI;
        protected IXMLHandler handler;

        public RSSContextClass(XMLStream theStream, String namespaceURI, String localName, String qName, Attributes atts, String documentURI, IXMLHandler handler) {
            super(theStream, namespaceURI, localName, qName, atts);
            this.documentURI = documentURI;
            this.handler = handler;
        }

        protected XMLContext beginTag(String namespaceURI, String localName, String qName, Attributes atts) throws ManifoldCFException, ServiceInterruption {
            if (qName.equals("channel")) {
                return new RSSChannelContextClass(this.theStream, namespaceURI, localName, qName, atts, this.documentURI, this.handler);
            }
            return super.beginTag(namespaceURI, localName, qName, atts);
        }

        protected void endTag() throws ManifoldCFException, ServiceInterruption {
            XMLContext context = this.theStream.getContext();
            String tagName = context.getQname();
            if (tagName.equals("channel")) {
                ((RSSChannelContextClass)context).process();
            } else {
                super.endTag();
            }
        }
    }

    protected class OuterContextClass
    extends XMLContext {
        protected int outerTagCount;
        protected String documentURI;
        protected IXMLHandler handler;

        public OuterContextClass(XMLStream theStream, String documentURI, IXMLHandler handler) {
            super(theStream);
            this.outerTagCount = 0;
            this.documentURI = documentURI;
            this.handler = handler;
        }

        public void checkIfValidFeed() {
            if (this.outerTagCount == 0 && Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("WEB: XML document '" + this.documentURI + "' does not have rss, feed, or rdf:RDF tag - not valid feed"));
            }
        }

        protected XMLContext beginTag(String namespaceURI, String localName, String qName, Attributes atts) throws ManifoldCFException, ServiceInterruption {
            if (qName.equals("rss")) {
                ++this.outerTagCount;
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("WEB: Parsed bottom-level XML for RSS document '" + this.documentURI + "'"));
                }
                return new RSSContextClass(this.theStream, namespaceURI, localName, qName, atts, this.documentURI, this.handler);
            }
            if (qName.equals("rdf:RDF")) {
                ++this.outerTagCount;
                return new RDFContextClass(this.theStream, namespaceURI, localName, qName, atts, this.documentURI, this.handler);
            }
            if (qName.equals("feed")) {
                ++this.outerTagCount;
                return new FeedContextClass(this.theStream, namespaceURI, localName, qName, atts, this.documentURI, this.handler);
            }
            return super.beginTag(namespaceURI, localName, qName, atts);
        }

        protected void endTag() throws ManifoldCFException, ServiceInterruption {
            XMLContext context = this.theStream.getContext();
            String tagName = context.getQname();
            if (tagName.equals("rdf:RDF")) {
                ((RDFContextClass)context).process();
            } else if (tagName.equals("feed")) {
                ((FeedContextClass)context).process();
            } else {
                super.endTag();
            }
        }
    }

    protected class ProcessActivityXMLHandler
    extends ProcessActivityLinkHandler
    implements IXMLHandler {
        public ProcessActivityXMLHandler(String documentIdentifier, IProcessActivity activities, DocumentURLFilter filter) {
            super(documentIdentifier, activities, filter, "xml", WebcrawlerConnector.REL_LINK);
        }

        public boolean shouldIndex() {
            return true;
        }

        public void noteDiscoveredTtlValue(String rawTtlValue) throws ManifoldCFException {
            long currentTime = System.currentTimeMillis();
            Long rescanTime = null;
            if (rawTtlValue != null) {
                try {
                    int minutes = Integer.parseInt(rawTtlValue);
                    long nextTime = currentTime + (long)minutes * 60000L;
                    rescanTime = new Long(nextTime);
                    if (Logging.connectors.isDebugEnabled()) {
                        Logging.connectors.debug((Object)("WEB: In " + this.contextDescription + " document '" + this.documentIdentifier + "', found a ttl value of " + rawTtlValue + "; setting refetch time accordingly"));
                    }
                }
                catch (NumberFormatException e) {
                    Logging.connectors.warn((Object)("WEB: In " + this.contextDescription + " document '" + this.documentIdentifier + "' found illegal ttl value '" + rawTtlValue + "': " + e.getMessage()), (Throwable)e);
                }
            }
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("WEB: In " + this.contextDescription + " document '" + this.documentIdentifier + "' setting rescan time to " + (rescanTime == null ? "null" : rescanTime.toString())));
            }
            this.activities.setDocumentScheduleBounds(this.documentIdentifier, rescanTime, rescanTime, null, null);
        }
    }

    protected class ProcessActivityHTMLHandler
    extends ProcessActivityLinkHandler
    implements IHTMLHandler {
        boolean allowIndex;
        boolean allowFollow;

        public ProcessActivityHTMLHandler(String documentIdentifier, IProcessActivity activities, DocumentURLFilter filter) {
            super(documentIdentifier, activities, filter, "html", WebcrawlerConnector.REL_LINK);
            this.allowIndex = true;
            this.allowFollow = true;
        }

        public boolean shouldIndex() {
            return this.allowIndex;
        }

        public void noteMetaTag(Map metaAttributes) throws ManifoldCFException {
            String contentValue;
            String name = (String)metaAttributes.get("name");
            if (name != null && name.toLowerCase().equals("robots") && (contentValue = (String)metaAttributes.get("content")) != null) {
                contentValue = contentValue.toLowerCase();
                try {
                    String[] contentValues = contentValue.split(",");
                    int i = 0;
                    while (i < contentValues.length) {
                        String cv;
                        if ((cv = contentValues[i++].trim()).equals("index")) {
                            this.allowIndex = true;
                            continue;
                        }
                        if (cv.equals("noindex")) {
                            this.allowIndex = false;
                            continue;
                        }
                        if (cv.equals("none")) {
                            this.allowFollow = false;
                            this.allowIndex = false;
                            continue;
                        }
                        if (cv.equals("follow")) {
                            this.allowFollow = true;
                            continue;
                        }
                        if (!cv.equals("nofollow")) continue;
                        this.allowFollow = false;
                    }
                }
                catch (PatternSyntaxException e) {
                    throw new ManifoldCFException(e.getMessage(), (Throwable)e);
                }
            }
        }

        public void noteFormStart(Map formAttributes) throws ManifoldCFException {
        }

        public void noteFormInput(Map inputAttributes) throws ManifoldCFException {
        }

        public void noteFormEnd() throws ManifoldCFException {
        }

        public void noteAHREF(String rawURL) throws ManifoldCFException {
            if (this.allowFollow) {
                this.noteDiscoveredLink(rawURL);
            }
        }

        public void noteLINKHREF(String rawURL) throws ManifoldCFException {
            if (this.allowFollow) {
                this.noteDiscoveredLink(rawURL);
            }
        }

        public void noteIMGSRC(String rawURL) throws ManifoldCFException {
            if (this.allowFollow) {
                this.noteDiscoveredLink(rawURL);
            }
        }

        public void noteFRAMESRC(String rawURL) throws ManifoldCFException {
            if (this.allowFollow) {
                this.noteDiscoveredLink(rawURL);
            }
        }
    }

    protected class ProcessActivityRedirectionHandler
    extends ProcessActivityLinkHandler
    implements IRedirectionHandler {
        public ProcessActivityRedirectionHandler(String documentIdentifier, IProcessActivity activities, DocumentURLFilter filter) {
            super(documentIdentifier, activities, filter, "redirection", WebcrawlerConnector.REL_REDIRECT);
        }

        public boolean shouldIndex() {
            return true;
        }
    }

    protected class ProcessActivityLinkHandler
    implements IDiscoveredLinkHandler {
        protected String documentIdentifier;
        protected IProcessActivity activities;
        protected DocumentURLFilter filter;
        protected String contextDescription;
        protected String linkType;

        public ProcessActivityLinkHandler(String documentIdentifier, IProcessActivity activities, DocumentURLFilter filter, String contextDescription, String linkType) {
            this.documentIdentifier = documentIdentifier;
            this.activities = activities;
            this.filter = filter;
            this.contextDescription = contextDescription;
            this.linkType = linkType;
        }

        public void noteDiscoveredLink(String rawURL) throws ManifoldCFException {
            String newIdentifier = WebcrawlerConnector.this.makeDocumentIdentifier(this.documentIdentifier, rawURL, this.filter);
            if (newIdentifier != null) {
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("WEB: In " + this.contextDescription + " document '" + this.documentIdentifier + "', found link to '" + newIdentifier + "'"));
                }
                this.activities.addDocumentReference(newIdentifier, this.documentIdentifier, this.linkType, null, (Object[][])null, null, WebcrawlerConnector.this.calculateDocumentEvents((INamingActivity)this.activities, newIdentifier));
            } else if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("WEB: In " + this.contextDescription + " document '" + this.documentIdentifier + "', found an unincluded URL '" + rawURL + "'"));
            }
        }
    }

    protected class FindHandler
    implements IDiscoveredLinkHandler {
        protected String parentURI;
        protected String targetURI = null;

        public FindHandler(String parentURI) {
            this.parentURI = parentURI;
        }

        public void noteDiscoveredLink(String rawURL) throws ManifoldCFException {
            try {
                URI url;
                if (this.parentURI != null) {
                    URI parentURL = new URI(this.parentURI);
                    url = parentURL.resolve(rawURL);
                } else {
                    url = new URI(rawURL);
                }
                String protocol = url.getScheme();
                String host = url.getHost();
                if (protocol == null || host == null) {
                    return;
                }
                if (understoodProtocols.get(protocol) == null) {
                    return;
                }
                String id = url.toASCIIString();
                if (id == null) {
                    return;
                }
                int i = 0;
                while (i < id.length()) {
                    char x;
                    if ((x = id.charAt(i++)) >= ' ' && x <= '\u007f') continue;
                    return;
                }
                this.targetURI = id;
            }
            catch (URISyntaxException e) {
                return;
            }
            catch (IllegalArgumentException e) {
                return;
            }
            catch (NullPointerException e) {
                return;
            }
        }

        public String getTargetURI() {
            return this.targetURI;
        }
    }

    protected class FindHTMLHrefHandler
    extends FindHandler
    implements IHTMLHandler {
        protected Pattern preferredLinkPattern;

        public FindHTMLHrefHandler(String parentURI, Pattern preferredLinkPattern) {
            super(parentURI);
            this.preferredLinkPattern = preferredLinkPattern;
        }

        public void noteMetaTag(Map metaAttributes) throws ManifoldCFException {
        }

        public void noteFormStart(Map formAttributes) throws ManifoldCFException {
        }

        public void noteFormInput(Map inputAttributes) throws ManifoldCFException {
        }

        public void noteFormEnd() throws ManifoldCFException {
        }

        public void noteDiscoveredLink(String rawURL) throws ManifoldCFException {
            if (this.targetURI == null) {
                Logging.connectors.debug((Object)("WEB: Tried to match raw url '" + rawURL + "'"));
                super.noteDiscoveredLink(rawURL);
                if (this.targetURI != null) {
                    boolean canUse;
                    Logging.connectors.debug((Object)("WEB: Tried to match cooked url '" + this.targetURI + "'"));
                    if (this.preferredLinkPattern != null) {
                        Matcher m = this.preferredLinkPattern.matcher(this.targetURI);
                        canUse = m.find();
                        Logging.connectors.debug((Object)("WEB: Preferred link lookup " + (canUse ? "matched" : "didn't match") + " '" + this.targetURI + "'"));
                    } else {
                        Logging.connectors.debug((Object)("WEB: Preferred link lookup for '" + this.targetURI + "' had no pattern to match"));
                        canUse = true;
                    }
                    if (!canUse) {
                        this.targetURI = null;
                    }
                }
            }
        }

        public void noteAHREF(String rawURL) throws ManifoldCFException {
            this.noteDiscoveredLink(rawURL);
        }

        public void noteLINKHREF(String rawURL) throws ManifoldCFException {
            this.noteDiscoveredLink(rawURL);
        }

        public void noteIMGSRC(String rawURL) throws ManifoldCFException {
        }

        public void noteFRAMESRC(String rawURL) throws ManifoldCFException {
            this.noteDiscoveredLink(rawURL);
        }
    }

    protected class FindHTMLFormHandler
    extends FindHandler
    implements IHTMLHandler {
        protected Pattern formNamePattern;
        protected FormDataAccumulator discoveredFormData;
        protected FormDataAccumulator currentFormData;

        public FindHTMLFormHandler(String parentURI, Pattern formNamePattern) {
            super(parentURI);
            this.discoveredFormData = null;
            this.currentFormData = null;
            this.formNamePattern = formNamePattern;
        }

        public void applyFormOverrides(LoginParameters lp) {
            if (this.discoveredFormData != null && lp != null) {
                this.discoveredFormData.applyOverrides(lp);
            }
        }

        public FormData getFormData() {
            return this.discoveredFormData;
        }

        public void noteMetaTag(Map metaAttributes) throws ManifoldCFException {
        }

        public void noteFormStart(Map formAttributes) throws ManifoldCFException {
            boolean canUse;
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("WEB: Saw form with name " + (formAttributes.get("name") == null ? "null" : "'" + formAttributes.get("name") + "'")));
            }
            if (this.formNamePattern != null) {
                String formName = (String)formAttributes.get("name");
                if (formName == null) {
                    formName = "";
                }
                Matcher m = this.formNamePattern.matcher(formName);
                canUse = m.find();
            } else {
                canUse = true;
            }
            if (canUse) {
                String actionURI = (String)formAttributes.get("action");
                if (actionURI == null) {
                    actionURI = this.parentURI;
                } else if (actionURI.length() == 0) {
                    actionURI = "";
                }
                this.noteDiscoveredLink(actionURI);
                actionURI = this.getTargetURI();
                if (actionURI != null) {
                    String method = (String)formAttributes.get("method");
                    method = method == null || method.length() == 0 ? "get" : method.toLowerCase();
                    this.currentFormData = new FormDataAccumulator(actionURI, method.equals("post") ? 1 : 0);
                }
            }
        }

        public void noteFormInput(Map inputAttributes) throws ManifoldCFException {
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("WEB: Saw form element of type '" + inputAttributes.get("type") + "' name '" + inputAttributes.get("name") + "'"));
            }
            if (this.currentFormData != null) {
                this.currentFormData.addElement(inputAttributes);
            }
        }

        public void noteFormEnd() throws ManifoldCFException {
            if (this.currentFormData != null) {
                this.discoveredFormData = this.currentFormData;
                this.currentFormData = null;
            }
        }

        public void noteAHREF(String rawURL) throws ManifoldCFException {
        }

        public void noteLINKHREF(String rawURL) throws ManifoldCFException {
        }

        public void noteIMGSRC(String rawURL) throws ManifoldCFException {
        }

        public void noteFRAMESRC(String rawURL) throws ManifoldCFException {
        }
    }

    protected class FindPreferredRedirectionHandler
    extends FindHandler
    implements IRedirectionHandler {
        protected Pattern redirectionURIPattern;

        public FindPreferredRedirectionHandler(String parentURI, Pattern redirectionURIPattern) {
            super(parentURI);
            this.redirectionURIPattern = redirectionURIPattern;
        }

        public void noteDiscoveredLink(String rawURL) throws ManifoldCFException {
            if (this.targetURI == null) {
                Logging.connectors.debug((Object)("WEB: Tried to match raw url '" + rawURL + "'"));
                super.noteDiscoveredLink(rawURL);
                if (this.targetURI != null) {
                    boolean canUse;
                    Logging.connectors.debug((Object)("WEB: Tried to match cooked url '" + this.targetURI + "'"));
                    if (this.redirectionURIPattern != null) {
                        Matcher m = this.redirectionURIPattern.matcher(this.targetURI);
                        canUse = m.find();
                        Logging.connectors.debug((Object)("WEB: Redirection link lookup " + (canUse ? "matched" : "didn't match") + " '" + this.targetURI + "'"));
                    } else {
                        Logging.connectors.debug((Object)("WEB: Redirection link lookup for '" + this.targetURI + "' had no pattern to match"));
                        canUse = true;
                    }
                    if (!canUse) {
                        this.targetURI = null;
                    }
                }
            }
        }
    }

    protected class FindRedirectionHandler
    extends FindHandler
    implements IRedirectionHandler {
        public FindRedirectionHandler(String parentURI) {
            super(parentURI);
        }
    }
}

