/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.indexwriter.elastic;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.nutch.indexer.IndexWriter;
import org.apache.nutch.indexer.NutchDocument;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.action.ListenableActionFuture;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequestBuilder;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticIndexWriter
implements IndexWriter {
    public static Logger LOG = LoggerFactory.getLogger(ElasticIndexWriter.class);
    private static final int DEFAULT_MAX_BULK_DOCS = 250;
    private static final int DEFAULT_MAX_BULK_LENGTH = 2500500;
    private Client client;
    private Node node;
    private String defaultIndex;
    private Configuration config;
    private BulkRequestBuilder bulk;
    private ListenableActionFuture<BulkResponse> execute;
    private int port = -1;
    private String host = null;
    private String clusterName = null;
    private int maxBulkDocs;
    private int maxBulkLength;
    private long indexedDocs = 0L;
    private int bulkDocs = 0;
    private int bulkLength = 0;
    private boolean createNewBulk = false;

    public void open(JobConf job, String name) throws IOException {
        String line;
        this.clusterName = job.get("elastic.cluster");
        this.host = job.get("elastic.host");
        this.port = job.getInt("elastic.port", -1);
        ImmutableSettings.Builder settingsBuilder = ImmutableSettings.settingsBuilder();
        BufferedReader reader = new BufferedReader(job.getConfResourceAsReader("elasticsearch.conf"));
        while ((line = reader.readLine()) != null) {
            if (!StringUtils.isNotBlank((String)line) || line.startsWith("#")) continue;
            line.trim();
            String[] parts = line.split("=");
            if (parts.length != 2) continue;
            settingsBuilder.put(parts[0].trim(), parts[1].trim());
        }
        Settings settings = settingsBuilder.put("cluster.name", this.clusterName).build();
        if (this.host != null && this.port > 1) {
            this.client = new TransportClient(settings).addTransportAddress((TransportAddress)new InetSocketTransportAddress(this.host, this.port));
        } else if (this.clusterName != null) {
            this.node = NodeBuilder.nodeBuilder().settings(settings).client(true).node();
            this.client = this.node.client();
        }
        this.bulk = this.client.prepareBulk();
        this.defaultIndex = job.get("elastic.index", "nutch");
        this.maxBulkDocs = job.getInt("elastic.max.bulk.docs", 250);
        this.maxBulkLength = job.getInt("elastic.max.bulk.size", 2500500);
    }

    public void write(NutchDocument doc) throws IOException {
        String id = (String)doc.getFieldValue("url");
        String type = doc.getDocumentMeta().get("type");
        if (type == null) {
            type = "doc";
        }
        IndexRequestBuilder request = this.client.prepareIndex(this.defaultIndex, type, id);
        HashMap<String, Object> source = new HashMap<String, Object>();
        for (String fieldName : doc.getFieldNames()) {
            if (doc.getField(fieldName).getValues().size() > 1) {
                source.put(fieldName, doc.getFieldValue(fieldName));
                for (Object value : doc.getField(fieldName).getValues()) {
                    this.bulkLength += value.toString().length();
                }
                continue;
            }
            source.put(fieldName, doc.getFieldValue(fieldName));
            this.bulkLength += doc.getFieldValue(fieldName).toString().length();
        }
        request.setSource(source);
        this.bulk.add(request);
        ++this.indexedDocs;
        ++this.bulkDocs;
        if (this.bulkDocs >= this.maxBulkDocs || this.bulkLength >= this.maxBulkLength) {
            LOG.info("Processing bulk request [docs = " + this.bulkDocs + ", length = " + this.bulkLength + ", total docs = " + this.indexedDocs + ", last doc in bulk = '" + id + "']");
            this.createNewBulk = true;
            this.commit();
        }
    }

    public void delete(String key) throws IOException {
        try {
            DeleteRequestBuilder builder = this.client.prepareDelete();
            builder.setIndex(this.defaultIndex);
            builder.setType("doc");
            builder.setId(key);
            builder.execute().actionGet();
        }
        catch (ElasticSearchException e) {
            throw ElasticIndexWriter.makeIOException(e);
        }
    }

    public static IOException makeIOException(ElasticSearchException e) {
        IOException ioe = new IOException();
        ioe.initCause(e);
        return ioe;
    }

    public void update(NutchDocument doc) throws IOException {
        this.write(doc);
    }

    public void commit() throws IOException {
        if (this.execute != null) {
            long beforeWait = System.currentTimeMillis();
            BulkResponse actionGet = (BulkResponse)this.execute.actionGet();
            if (actionGet.hasFailures()) {
                for (BulkItemResponse item : actionGet) {
                    if (!item.isFailed()) continue;
                    throw new RuntimeException("First failure in bulk: " + item.getFailureMessage());
                }
            }
            long msWaited = System.currentTimeMillis() - beforeWait;
            LOG.info("Previous took in ms " + actionGet.getTookInMillis() + ", including wait " + msWaited);
            this.execute = null;
        }
        if (this.bulk != null) {
            if (this.bulkDocs > 0) {
                this.execute = this.bulk.execute();
            }
            this.bulk = null;
        }
        if (this.createNewBulk) {
            this.bulk = this.client.prepareBulk();
            this.bulkDocs = 0;
            this.bulkLength = 0;
        }
    }

    public void close() throws IOException {
        LOG.info("Processing remaining requests [docs = " + this.bulkDocs + ", length = " + this.bulkLength + ", total docs = " + this.indexedDocs + "]");
        this.createNewBulk = false;
        this.commit();
        LOG.info("Processing to finalize last execute");
        this.createNewBulk = false;
        this.commit();
        this.client.close();
        if (this.node != null) {
            this.node.close();
        }
    }

    public String describe() {
        StringBuffer sb = new StringBuffer("ElasticIndexWriter\n");
        sb.append("\t").append("elastic.cluster").append(" : elastic prefix cluster\n");
        sb.append("\t").append("elastic.host").append(" : hostname\n");
        sb.append("\t").append("elastic.port").append(" : port\n");
        sb.append("\t").append("elastic.index").append(" : elastic index command \n");
        sb.append("\t").append("elastic.max.bulk.docs").append(" : elastic bulk index doc counts. (default 250) \n");
        sb.append("\t").append("elastic.max.bulk.size").append(" : elastic bulk index length. (default 2500500 ~2.5MB)\n");
        return sb.toString();
    }

    public void setConf(Configuration conf) {
        this.config = conf;
        String cluster = conf.get("elastic.cluster");
        if (cluster == null) {
            String message = "Missing elastic.cluster. Should be set in nutch-site.xml ";
            message = message + "\n" + this.describe();
            LOG.error(message);
            throw new RuntimeException(message);
        }
    }

    public Configuration getConf() {
        return this.config;
    }
}

