/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.el;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.servlet.jsp.el.ELException;
import org.apache.commons.el.ArithmeticOperator;
import org.apache.commons.el.Constants;
import org.apache.commons.el.EqualityOperator;
import org.apache.commons.el.Logger;
import org.apache.commons.el.PrimitiveObjects;
import org.apache.commons.el.RelationalOperator;

public class Coercions {
    private static final Number ZERO = new Integer(0);
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;

    public static Object coerce(Object pValue, Class pClass, Logger pLogger) throws ELException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (pClass == clazz) {
            return Coercions.coerceToString(pValue, pLogger);
        }
        if (Coercions.isNumberClass(pClass)) {
            return Coercions.coerceToPrimitiveNumber(pValue, pClass, pLogger);
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.lang.Character");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (pClass == clazz2 || pClass == Character.TYPE) {
            return Coercions.coerceToCharacter(pValue, pLogger);
        }
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (pClass == clazz3 || pClass == Boolean.TYPE) {
            return Coercions.coerceToBoolean(pValue, pLogger);
        }
        return Coercions.coerceToObject(pValue, pClass, pLogger);
    }

    static boolean isNumberClass(Class pClass) {
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("java.lang.Byte");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (pClass != clazz && pClass != Byte.TYPE) {
            Class<?> clazz2 = class$4;
            if (clazz2 == null) {
                try {
                    clazz2 = class$4 = Class.forName("java.lang.Short");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (pClass != clazz2 && pClass != Short.TYPE) {
                Class<?> clazz3 = class$5;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$5 = Class.forName("java.lang.Integer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (pClass != clazz3 && pClass != Integer.TYPE) {
                    Class<?> clazz4 = class$6;
                    if (clazz4 == null) {
                        try {
                            clazz4 = class$6 = Class.forName("java.lang.Long");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (pClass != clazz4 && pClass != Long.TYPE) {
                        Class<?> clazz5 = class$7;
                        if (clazz5 == null) {
                            try {
                                clazz5 = class$7 = Class.forName("java.lang.Float");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (pClass != clazz5 && pClass != Float.TYPE) {
                            Class<?> clazz6 = class$8;
                            if (clazz6 == null) {
                                try {
                                    clazz6 = class$8 = Class.forName("java.lang.Double");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            if (pClass != clazz6 && pClass != Double.TYPE) {
                                Class<?> clazz7 = class$9;
                                if (clazz7 == null) {
                                    try {
                                        clazz7 = class$9 = Class.forName("java.math.BigInteger");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                if (pClass != clazz7) {
                                    Class<?> clazz8 = class$10;
                                    if (clazz8 == null) {
                                        try {
                                            clazz8 = class$10 = Class.forName("java.math.BigDecimal");
                                        }
                                        catch (ClassNotFoundException classNotFoundException) {
                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                        }
                                    }
                                    if (pClass != clazz8) {
                                        return false;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return true;
    }

    public static String coerceToString(Object pValue, Logger pLogger) throws ELException {
        if (pValue == null) {
            return "";
        }
        if (pValue instanceof String) {
            return (String)pValue;
        }
        try {
            return pValue.toString();
        }
        catch (Exception exc) {
            if (pLogger.isLoggingError()) {
                pLogger.logError(Constants.TOSTRING_EXCEPTION, exc, (Object)pValue.getClass().getName());
            }
            return "";
        }
    }

    public static Number coerceToPrimitiveNumber(Object pValue, Class pClass, Logger pLogger) throws ELException {
        if (pValue == null || "".equals(pValue)) {
            return Coercions.coerceToPrimitiveNumber(ZERO, pClass);
        }
        if (pValue instanceof Character) {
            char val = ((Character)pValue).charValue();
            return Coercions.coerceToPrimitiveNumber(new Short((short)val), pClass);
        }
        if (pValue instanceof Boolean) {
            if (pLogger.isLoggingError()) {
                pLogger.logError(Constants.BOOLEAN_TO_NUMBER, pValue, (Object)pClass.getName());
            }
            return Coercions.coerceToPrimitiveNumber(ZERO, pClass);
        }
        if (pValue.getClass() == pClass) {
            return (Number)pValue;
        }
        if (pValue instanceof Number) {
            return Coercions.coerceToPrimitiveNumber((Number)pValue, pClass);
        }
        if (pValue instanceof String) {
            try {
                return Coercions.coerceToPrimitiveNumber((String)pValue, pClass);
            }
            catch (Exception exception) {
                if (pLogger.isLoggingError()) {
                    pLogger.logError(Constants.STRING_TO_NUMBER_EXCEPTION, (String)pValue, (Object)pClass.getName());
                }
                return Coercions.coerceToPrimitiveNumber(ZERO, pClass);
            }
        }
        if (pLogger.isLoggingError()) {
            pLogger.logError(Constants.COERCE_TO_NUMBER, pValue.getClass().getName(), (Object)pClass.getName());
        }
        return Coercions.coerceToPrimitiveNumber(0L, pClass);
    }

    public static Integer coerceToInteger(Object pValue, Logger pLogger) throws ELException {
        if (pValue == null) {
            return null;
        }
        if (pValue instanceof Character) {
            return PrimitiveObjects.getInteger(((Character)pValue).charValue());
        }
        if (pValue instanceof Boolean) {
            if (pLogger.isLoggingWarning()) {
                Class<?> clazz = class$5;
                if (clazz == null) {
                    try {
                        clazz = class$5 = Class.forName("java.lang.Integer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                pLogger.logWarning(Constants.BOOLEAN_TO_NUMBER, pValue, (Object)clazz.getName());
            }
            return PrimitiveObjects.getInteger((Boolean)pValue != false ? 1 : 0);
        }
        if (pValue instanceof Integer) {
            return (Integer)pValue;
        }
        if (pValue instanceof Number) {
            return PrimitiveObjects.getInteger(((Number)pValue).intValue());
        }
        if (pValue instanceof String) {
            try {
                return Integer.valueOf((String)pValue);
            }
            catch (Exception exception) {
                if (pLogger.isLoggingWarning()) {
                    String string = (String)pValue;
                    Class<?> clazz = class$5;
                    if (clazz == null) {
                        try {
                            clazz = class$5 = Class.forName("java.lang.Integer");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    pLogger.logWarning(Constants.STRING_TO_NUMBER_EXCEPTION, string, (Object)clazz.getName());
                }
                return null;
            }
        }
        if (pLogger.isLoggingWarning()) {
            String string = pValue.getClass().getName();
            Class<?> clazz = class$5;
            if (clazz == null) {
                try {
                    clazz = class$5 = Class.forName("java.lang.Integer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            pLogger.logWarning(Constants.COERCE_TO_NUMBER, string, (Object)clazz.getName());
        }
        return null;
    }

    static Number coerceToPrimitiveNumber(long pValue, Class pClass) throws ELException {
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("java.lang.Byte");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (pClass == clazz || pClass == Byte.TYPE) {
            return PrimitiveObjects.getByte((byte)pValue);
        }
        Class<?> clazz2 = class$4;
        if (clazz2 == null) {
            try {
                clazz2 = class$4 = Class.forName("java.lang.Short");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (pClass == clazz2 || pClass == Short.TYPE) {
            return PrimitiveObjects.getShort((short)pValue);
        }
        Class<?> clazz3 = class$5;
        if (clazz3 == null) {
            try {
                clazz3 = class$5 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (pClass == clazz3 || pClass == Integer.TYPE) {
            return PrimitiveObjects.getInteger((int)pValue);
        }
        Class<?> clazz4 = class$6;
        if (clazz4 == null) {
            try {
                clazz4 = class$6 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (pClass == clazz4 || pClass == Long.TYPE) {
            return PrimitiveObjects.getLong(pValue);
        }
        Class<?> clazz5 = class$7;
        if (clazz5 == null) {
            try {
                clazz5 = class$7 = Class.forName("java.lang.Float");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (pClass == clazz5 || pClass == Float.TYPE) {
            return PrimitiveObjects.getFloat(pValue);
        }
        Class<?> clazz6 = class$8;
        if (clazz6 == null) {
            try {
                clazz6 = class$8 = Class.forName("java.lang.Double");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (pClass == clazz6 || pClass == Double.TYPE) {
            return PrimitiveObjects.getDouble(pValue);
        }
        return PrimitiveObjects.getInteger(0);
    }

    static Number coerceToPrimitiveNumber(double pValue, Class pClass) throws ELException {
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("java.lang.Byte");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (pClass == clazz || pClass == Byte.TYPE) {
            return PrimitiveObjects.getByte((byte)pValue);
        }
        Class<?> clazz2 = class$4;
        if (clazz2 == null) {
            try {
                clazz2 = class$4 = Class.forName("java.lang.Short");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (pClass == clazz2 || pClass == Short.TYPE) {
            return PrimitiveObjects.getShort((short)pValue);
        }
        Class<?> clazz3 = class$5;
        if (clazz3 == null) {
            try {
                clazz3 = class$5 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (pClass == clazz3 || pClass == Integer.TYPE) {
            return PrimitiveObjects.getInteger((int)pValue);
        }
        Class<?> clazz4 = class$6;
        if (clazz4 == null) {
            try {
                clazz4 = class$6 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (pClass == clazz4 || pClass == Long.TYPE) {
            return PrimitiveObjects.getLong((long)pValue);
        }
        Class<?> clazz5 = class$7;
        if (clazz5 == null) {
            try {
                clazz5 = class$7 = Class.forName("java.lang.Float");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (pClass == clazz5 || pClass == Float.TYPE) {
            return PrimitiveObjects.getFloat((float)pValue);
        }
        Class<?> clazz6 = class$8;
        if (clazz6 == null) {
            try {
                clazz6 = class$8 = Class.forName("java.lang.Double");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (pClass == clazz6 || pClass == Double.TYPE) {
            return PrimitiveObjects.getDouble(pValue);
        }
        return PrimitiveObjects.getInteger(0);
    }

    static Number coerceToPrimitiveNumber(Number pValue, Class pClass) throws ELException {
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("java.lang.Byte");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (pClass == clazz || pClass == Byte.TYPE) {
            return PrimitiveObjects.getByte(pValue.byteValue());
        }
        Class<?> clazz2 = class$4;
        if (clazz2 == null) {
            try {
                clazz2 = class$4 = Class.forName("java.lang.Short");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (pClass == clazz2 || pClass == Short.TYPE) {
            return PrimitiveObjects.getShort(pValue.shortValue());
        }
        Class<?> clazz3 = class$5;
        if (clazz3 == null) {
            try {
                clazz3 = class$5 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (pClass == clazz3 || pClass == Integer.TYPE) {
            return PrimitiveObjects.getInteger(pValue.intValue());
        }
        Class<?> clazz4 = class$6;
        if (clazz4 == null) {
            try {
                clazz4 = class$6 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (pClass == clazz4 || pClass == Long.TYPE) {
            return PrimitiveObjects.getLong(pValue.longValue());
        }
        Class<?> clazz5 = class$7;
        if (clazz5 == null) {
            try {
                clazz5 = class$7 = Class.forName("java.lang.Float");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (pClass == clazz5 || pClass == Float.TYPE) {
            return PrimitiveObjects.getFloat(pValue.floatValue());
        }
        Class<?> clazz6 = class$8;
        if (clazz6 == null) {
            try {
                clazz6 = class$8 = Class.forName("java.lang.Double");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (pClass == clazz6 || pClass == Double.TYPE) {
            return PrimitiveObjects.getDouble(pValue.doubleValue());
        }
        Class<?> clazz7 = class$9;
        if (clazz7 == null) {
            try {
                clazz7 = class$9 = Class.forName("java.math.BigInteger");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (pClass == clazz7) {
            if (pValue instanceof BigDecimal) {
                return ((BigDecimal)pValue).toBigInteger();
            }
            return BigInteger.valueOf(pValue.longValue());
        }
        Class<?> clazz8 = class$10;
        if (clazz8 == null) {
            try {
                clazz8 = class$10 = Class.forName("java.math.BigDecimal");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (pClass == clazz8) {
            if (pValue instanceof BigInteger) {
                return new BigDecimal((BigInteger)pValue);
            }
            return new BigDecimal(pValue.doubleValue());
        }
        return PrimitiveObjects.getInteger(0);
    }

    static Number coerceToPrimitiveNumber(String pValue, Class pClass) throws ELException {
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("java.lang.Byte");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (pClass == clazz || pClass == Byte.TYPE) {
            return Byte.valueOf(pValue);
        }
        Class<?> clazz2 = class$4;
        if (clazz2 == null) {
            try {
                clazz2 = class$4 = Class.forName("java.lang.Short");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (pClass == clazz2 || pClass == Short.TYPE) {
            return Short.valueOf(pValue);
        }
        Class<?> clazz3 = class$5;
        if (clazz3 == null) {
            try {
                clazz3 = class$5 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (pClass == clazz3 || pClass == Integer.TYPE) {
            return Integer.valueOf(pValue);
        }
        Class<?> clazz4 = class$6;
        if (clazz4 == null) {
            try {
                clazz4 = class$6 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (pClass == clazz4 || pClass == Long.TYPE) {
            return Long.valueOf(pValue);
        }
        Class<?> clazz5 = class$7;
        if (clazz5 == null) {
            try {
                clazz5 = class$7 = Class.forName("java.lang.Float");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (pClass == clazz5 || pClass == Float.TYPE) {
            return Float.valueOf(pValue);
        }
        Class<?> clazz6 = class$8;
        if (clazz6 == null) {
            try {
                clazz6 = class$8 = Class.forName("java.lang.Double");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (pClass == clazz6 || pClass == Double.TYPE) {
            return Double.valueOf(pValue);
        }
        Class<?> clazz7 = class$9;
        if (clazz7 == null) {
            try {
                clazz7 = class$9 = Class.forName("java.math.BigInteger");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (pClass == clazz7) {
            return new BigInteger(pValue);
        }
        Class<?> clazz8 = class$10;
        if (clazz8 == null) {
            try {
                clazz8 = class$10 = Class.forName("java.math.BigDecimal");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (pClass == clazz8) {
            return new BigDecimal(pValue);
        }
        return PrimitiveObjects.getInteger(0);
    }

    public static Character coerceToCharacter(Object pValue, Logger pLogger) throws ELException {
        if (pValue == null || "".equals(pValue)) {
            return PrimitiveObjects.getCharacter('\u0000');
        }
        if (pValue instanceof Character) {
            return (Character)pValue;
        }
        if (pValue instanceof Boolean) {
            if (pLogger.isLoggingError()) {
                pLogger.logError(Constants.BOOLEAN_TO_CHARACTER, pValue);
            }
            return PrimitiveObjects.getCharacter('\u0000');
        }
        if (pValue instanceof Number) {
            return PrimitiveObjects.getCharacter((char)((Number)pValue).shortValue());
        }
        if (pValue instanceof String) {
            String str = (String)pValue;
            return PrimitiveObjects.getCharacter(str.charAt(0));
        }
        if (pLogger.isLoggingError()) {
            pLogger.logError(Constants.COERCE_TO_CHARACTER, pValue.getClass().getName());
        }
        return PrimitiveObjects.getCharacter('\u0000');
    }

    public static Boolean coerceToBoolean(Object pValue, Logger pLogger) throws ELException {
        if (pValue == null || "".equals(pValue)) {
            return Boolean.FALSE;
        }
        if (pValue instanceof Boolean) {
            return (Boolean)pValue;
        }
        if (pValue instanceof String) {
            String str = (String)pValue;
            try {
                return Boolean.valueOf(str);
            }
            catch (Exception exc) {
                if (pLogger.isLoggingError()) {
                    pLogger.logError(Constants.STRING_TO_BOOLEAN, exc, (Object)((String)pValue));
                }
                return Boolean.FALSE;
            }
        }
        if (pLogger.isLoggingError()) {
            pLogger.logError(Constants.COERCE_TO_BOOLEAN, pValue.getClass().getName());
        }
        return Boolean.TRUE;
    }

    public static Object coerceToObject(Object pValue, Class pClass, Logger pLogger) throws ELException {
        if (pValue == null) {
            return null;
        }
        if (pClass.isAssignableFrom(pValue.getClass())) {
            return pValue;
        }
        if (pValue instanceof String) {
            String str = (String)pValue;
            PropertyEditor pe = PropertyEditorManager.findEditor(pClass);
            if (pe == null) {
                if ("".equals(str)) {
                    return null;
                }
                if (pLogger.isLoggingError()) {
                    pLogger.logError(Constants.NO_PROPERTY_EDITOR, str, (Object)pClass.getName());
                }
                return null;
            }
            try {
                pe.setAsText(str);
                return pe.getValue();
            }
            catch (IllegalArgumentException exc) {
                if ("".equals(str)) {
                    return null;
                }
                if (pLogger.isLoggingError()) {
                    pLogger.logError(Constants.PROPERTY_EDITOR_ERROR, exc, pValue, (Object)pClass.getName());
                }
                return null;
            }
        }
        if (pLogger.isLoggingError()) {
            pLogger.logError(Constants.COERCE_TO_OBJECT, pValue.getClass().getName(), (Object)pClass.getName());
        }
        return null;
    }

    public static Object applyArithmeticOperator(Object pLeft, Object pRight, ArithmeticOperator pOperator, Logger pLogger) throws ELException {
        if (pLeft == null && pRight == null) {
            if (pLogger.isLoggingWarning()) {
                pLogger.logWarning(Constants.ARITH_OP_NULL, pOperator.getOperatorSymbol());
            }
            return PrimitiveObjects.getInteger(0);
        }
        if (Coercions.isBigDecimal(pLeft) || Coercions.isBigDecimal(pRight)) {
            Class<?> clazz = class$10;
            if (clazz == null) {
                try {
                    clazz = class$10 = Class.forName("java.math.BigDecimal");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            BigDecimal left = (BigDecimal)Coercions.coerceToPrimitiveNumber(pLeft, clazz, pLogger);
            Class<?> clazz2 = class$10;
            if (clazz2 == null) {
                try {
                    clazz2 = class$10 = Class.forName("java.math.BigDecimal");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            BigDecimal right = (BigDecimal)Coercions.coerceToPrimitiveNumber(pRight, clazz2, pLogger);
            return pOperator.apply(left, right);
        }
        if (Coercions.isFloatingPointType(pLeft) || Coercions.isFloatingPointType(pRight) || Coercions.isFloatingPointString(pLeft) || Coercions.isFloatingPointString(pRight)) {
            if (Coercions.isBigInteger(pLeft) || Coercions.isBigInteger(pRight)) {
                Class<?> clazz = class$10;
                if (clazz == null) {
                    try {
                        clazz = class$10 = Class.forName("java.math.BigDecimal");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                BigDecimal left = (BigDecimal)Coercions.coerceToPrimitiveNumber(pLeft, clazz, pLogger);
                Class<?> clazz3 = class$10;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$10 = Class.forName("java.math.BigDecimal");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                BigDecimal right = (BigDecimal)Coercions.coerceToPrimitiveNumber(pRight, clazz3, pLogger);
                return pOperator.apply(left, right);
            }
            Class<?> clazz = class$8;
            if (clazz == null) {
                try {
                    clazz = class$8 = Class.forName("java.lang.Double");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            double left = Coercions.coerceToPrimitiveNumber(pLeft, clazz, pLogger).doubleValue();
            Class<?> clazz4 = class$8;
            if (clazz4 == null) {
                try {
                    clazz4 = class$8 = Class.forName("java.lang.Double");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            double right = Coercions.coerceToPrimitiveNumber(pRight, clazz4, pLogger).doubleValue();
            return PrimitiveObjects.getDouble(pOperator.apply(left, right));
        }
        if (Coercions.isBigInteger(pLeft) || Coercions.isBigInteger(pRight)) {
            Class<?> clazz = class$9;
            if (clazz == null) {
                try {
                    clazz = class$9 = Class.forName("java.math.BigInteger");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            BigInteger left = (BigInteger)Coercions.coerceToPrimitiveNumber(pLeft, clazz, pLogger);
            Class<?> clazz5 = class$9;
            if (clazz5 == null) {
                try {
                    clazz5 = class$9 = Class.forName("java.math.BigInteger");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            BigInteger right = (BigInteger)Coercions.coerceToPrimitiveNumber(pRight, clazz5, pLogger);
            return pOperator.apply(left, right);
        }
        Class<?> clazz = class$6;
        if (clazz == null) {
            try {
                clazz = class$6 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        long left = Coercions.coerceToPrimitiveNumber(pLeft, clazz, pLogger).longValue();
        Class<?> clazz6 = class$6;
        if (clazz6 == null) {
            try {
                clazz6 = class$6 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        long right = Coercions.coerceToPrimitiveNumber(pRight, clazz6, pLogger).longValue();
        return PrimitiveObjects.getLong(pOperator.apply(left, right));
    }

    public static Object applyRelationalOperator(Object pLeft, Object pRight, RelationalOperator pOperator, Logger pLogger) throws ELException {
        if (Coercions.isBigDecimal(pLeft) || Coercions.isBigDecimal(pRight)) {
            Class<?> clazz = class$10;
            if (clazz == null) {
                try {
                    clazz = class$10 = Class.forName("java.math.BigDecimal");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            BigDecimal left = (BigDecimal)Coercions.coerceToPrimitiveNumber(pLeft, clazz, pLogger);
            Class<?> clazz2 = class$10;
            if (clazz2 == null) {
                try {
                    clazz2 = class$10 = Class.forName("java.math.BigDecimal");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            BigDecimal right = (BigDecimal)Coercions.coerceToPrimitiveNumber(pRight, clazz2, pLogger);
            return PrimitiveObjects.getBoolean(pOperator.apply(left, right));
        }
        if (Coercions.isFloatingPointType(pLeft) || Coercions.isFloatingPointType(pRight)) {
            Class<?> clazz = class$8;
            if (clazz == null) {
                try {
                    clazz = class$8 = Class.forName("java.lang.Double");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            double left = Coercions.coerceToPrimitiveNumber(pLeft, clazz, pLogger).doubleValue();
            Class<?> clazz3 = class$8;
            if (clazz3 == null) {
                try {
                    clazz3 = class$8 = Class.forName("java.lang.Double");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            double right = Coercions.coerceToPrimitiveNumber(pRight, clazz3, pLogger).doubleValue();
            return PrimitiveObjects.getBoolean(pOperator.apply(left, right));
        }
        if (Coercions.isBigInteger(pLeft) || Coercions.isBigInteger(pRight)) {
            Class<?> clazz = class$9;
            if (clazz == null) {
                try {
                    clazz = class$9 = Class.forName("java.math.BigInteger");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            BigInteger left = (BigInteger)Coercions.coerceToPrimitiveNumber(pLeft, clazz, pLogger);
            Class<?> clazz4 = class$9;
            if (clazz4 == null) {
                try {
                    clazz4 = class$9 = Class.forName("java.math.BigInteger");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            BigInteger right = (BigInteger)Coercions.coerceToPrimitiveNumber(pRight, clazz4, pLogger);
            return PrimitiveObjects.getBoolean(pOperator.apply(left, right));
        }
        if (Coercions.isIntegerType(pLeft) || Coercions.isIntegerType(pRight)) {
            Class<?> clazz = class$6;
            if (clazz == null) {
                try {
                    clazz = class$6 = Class.forName("java.lang.Long");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            long left = Coercions.coerceToPrimitiveNumber(pLeft, clazz, pLogger).longValue();
            Class<?> clazz5 = class$6;
            if (clazz5 == null) {
                try {
                    clazz5 = class$6 = Class.forName("java.lang.Long");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            long right = Coercions.coerceToPrimitiveNumber(pRight, clazz5, pLogger).longValue();
            return PrimitiveObjects.getBoolean(pOperator.apply(left, right));
        }
        if (pLeft instanceof String || pRight instanceof String) {
            String left = Coercions.coerceToString(pLeft, pLogger);
            String right = Coercions.coerceToString(pRight, pLogger);
            return PrimitiveObjects.getBoolean(pOperator.apply(left, right));
        }
        if (pLeft instanceof Comparable) {
            try {
                int result = ((Comparable)pLeft).compareTo(pRight);
                return PrimitiveObjects.getBoolean(pOperator.apply(result, -result));
            }
            catch (Exception exc) {
                if (pLogger.isLoggingError()) {
                    pLogger.logError(Constants.COMPARABLE_ERROR, exc, (Object)pLeft.getClass().getName(), (Object)(pRight == null ? "null" : pRight.getClass().getName()), (Object)pOperator.getOperatorSymbol());
                }
                return Boolean.FALSE;
            }
        }
        if (pRight instanceof Comparable) {
            try {
                int result = ((Comparable)pRight).compareTo(pLeft);
                return PrimitiveObjects.getBoolean(pOperator.apply(-result, result));
            }
            catch (Exception exc) {
                if (pLogger.isLoggingError()) {
                    pLogger.logError(Constants.COMPARABLE_ERROR, exc, (Object)pRight.getClass().getName(), (Object)(pLeft == null ? "null" : pLeft.getClass().getName()), (Object)pOperator.getOperatorSymbol());
                }
                return Boolean.FALSE;
            }
        }
        if (pLogger.isLoggingError()) {
            pLogger.logError(Constants.ARITH_OP_BAD_TYPE, pOperator.getOperatorSymbol(), (Object)pLeft.getClass().getName(), (Object)pRight.getClass().getName());
        }
        return Boolean.FALSE;
    }

    public static Object applyEqualityOperator(Object pLeft, Object pRight, EqualityOperator pOperator, Logger pLogger) throws ELException {
        if (pLeft == pRight) {
            return PrimitiveObjects.getBoolean(pOperator.apply(true, pLogger));
        }
        if (pLeft == null || pRight == null) {
            return PrimitiveObjects.getBoolean(pOperator.apply(false, pLogger));
        }
        if (Coercions.isBigDecimal(pLeft) || Coercions.isBigDecimal(pRight)) {
            Class<?> clazz = class$10;
            if (clazz == null) {
                try {
                    clazz = class$10 = Class.forName("java.math.BigDecimal");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            BigDecimal left = (BigDecimal)Coercions.coerceToPrimitiveNumber(pLeft, clazz, pLogger);
            Class<?> clazz2 = class$10;
            if (clazz2 == null) {
                try {
                    clazz2 = class$10 = Class.forName("java.math.BigDecimal");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            BigDecimal right = (BigDecimal)Coercions.coerceToPrimitiveNumber(pRight, clazz2, pLogger);
            return PrimitiveObjects.getBoolean(pOperator.apply(left.equals(right), pLogger));
        }
        if (Coercions.isFloatingPointType(pLeft) || Coercions.isFloatingPointType(pRight)) {
            double right;
            Class<?> clazz = class$8;
            if (clazz == null) {
                try {
                    clazz = class$8 = Class.forName("java.lang.Double");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            double left = Coercions.coerceToPrimitiveNumber(pLeft, clazz, pLogger).doubleValue();
            Class<?> clazz3 = class$8;
            if (clazz3 == null) {
                try {
                    clazz3 = class$8 = Class.forName("java.lang.Double");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return PrimitiveObjects.getBoolean(pOperator.apply(left == (right = Coercions.coerceToPrimitiveNumber(pRight, clazz3, pLogger).doubleValue()), pLogger));
        }
        if (Coercions.isBigInteger(pLeft) || Coercions.isBigInteger(pRight)) {
            Class<?> clazz = class$9;
            if (clazz == null) {
                try {
                    clazz = class$9 = Class.forName("java.math.BigInteger");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            BigInteger left = (BigInteger)Coercions.coerceToPrimitiveNumber(pLeft, clazz, pLogger);
            Class<?> clazz4 = class$9;
            if (clazz4 == null) {
                try {
                    clazz4 = class$9 = Class.forName("java.math.BigInteger");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            BigInteger right = (BigInteger)Coercions.coerceToPrimitiveNumber(pRight, clazz4, pLogger);
            return PrimitiveObjects.getBoolean(pOperator.apply(left.equals(right), pLogger));
        }
        if (Coercions.isIntegerType(pLeft) || Coercions.isIntegerType(pRight)) {
            long right;
            Class<?> clazz = class$6;
            if (clazz == null) {
                try {
                    clazz = class$6 = Class.forName("java.lang.Long");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            long left = Coercions.coerceToPrimitiveNumber(pLeft, clazz, pLogger).longValue();
            Class<?> clazz5 = class$6;
            if (clazz5 == null) {
                try {
                    clazz5 = class$6 = Class.forName("java.lang.Long");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return PrimitiveObjects.getBoolean(pOperator.apply(left == (right = Coercions.coerceToPrimitiveNumber(pRight, clazz5, pLogger).longValue()), pLogger));
        }
        if (pLeft instanceof Boolean || pRight instanceof Boolean) {
            boolean right;
            boolean left = Coercions.coerceToBoolean(pLeft, pLogger);
            return PrimitiveObjects.getBoolean(pOperator.apply(left == (right = Coercions.coerceToBoolean(pRight, pLogger).booleanValue()), pLogger));
        }
        if (pLeft instanceof String || pRight instanceof String) {
            String left = Coercions.coerceToString(pLeft, pLogger);
            String right = Coercions.coerceToString(pRight, pLogger);
            return PrimitiveObjects.getBoolean(pOperator.apply(left.equals(right), pLogger));
        }
        try {
            return PrimitiveObjects.getBoolean(pOperator.apply(pLeft.equals(pRight), pLogger));
        }
        catch (Exception exc) {
            if (pLogger.isLoggingError()) {
                pLogger.logError(Constants.ERROR_IN_EQUALS, exc, (Object)pLeft.getClass().getName(), (Object)pRight.getClass().getName(), (Object)pOperator.getOperatorSymbol());
            }
            return Boolean.FALSE;
        }
    }

    public static boolean isFloatingPointType(Object pObject) {
        return pObject != null && Coercions.isFloatingPointType(pObject.getClass());
    }

    public static boolean isFloatingPointType(Class pClass) {
        Class<?> clazz = class$7;
        if (clazz == null) {
            try {
                clazz = class$7 = Class.forName("java.lang.Float");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (pClass != clazz && pClass != Float.TYPE) {
            Class<?> clazz2 = class$8;
            if (clazz2 == null) {
                try {
                    clazz2 = class$8 = Class.forName("java.lang.Double");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (pClass != clazz2 && pClass != Double.TYPE) {
                return false;
            }
        }
        return true;
    }

    public static boolean isFloatingPointString(Object pObject) {
        if (pObject instanceof String) {
            String str = (String)pObject;
            int len = str.length();
            int i = 0;
            while (i < len) {
                char ch = str.charAt(i);
                if (ch == '.' || ch == 'e' || ch == 'E') {
                    return true;
                }
                ++i;
            }
            return false;
        }
        return false;
    }

    public static boolean isIntegerType(Object pObject) {
        return pObject != null && Coercions.isIntegerType(pObject.getClass());
    }

    public static boolean isIntegerType(Class pClass) {
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("java.lang.Byte");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (pClass != clazz && pClass != Byte.TYPE) {
            Class<?> clazz2 = class$4;
            if (clazz2 == null) {
                try {
                    clazz2 = class$4 = Class.forName("java.lang.Short");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (pClass != clazz2 && pClass != Short.TYPE) {
                Class<?> clazz3 = class$1;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$1 = Class.forName("java.lang.Character");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (pClass != clazz3 && pClass != Character.TYPE) {
                    Class<?> clazz4 = class$5;
                    if (clazz4 == null) {
                        try {
                            clazz4 = class$5 = Class.forName("java.lang.Integer");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (pClass != clazz4 && pClass != Integer.TYPE) {
                        Class<?> clazz5 = class$6;
                        if (clazz5 == null) {
                            try {
                                clazz5 = class$6 = Class.forName("java.lang.Long");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (pClass != clazz5 && pClass != Long.TYPE) {
                            return false;
                        }
                    }
                }
            }
        }
        return true;
    }

    public static boolean isBigInteger(Object pObject) {
        return pObject != null && pObject instanceof BigInteger;
    }

    public static boolean isBigDecimal(Object pObject) {
        return pObject != null && pObject instanceof BigDecimal;
    }
}

