/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.el;

import java.math.BigDecimal;
import javax.servlet.jsp.el.ELException;
import org.apache.commons.el.BinaryOperator;
import org.apache.commons.el.Coercions;
import org.apache.commons.el.Constants;
import org.apache.commons.el.Logger;
import org.apache.commons.el.PrimitiveObjects;

public class DivideOperator
extends BinaryOperator {
    public static final DivideOperator SINGLETON = new DivideOperator();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public String getOperatorSymbol() {
        return "/";
    }

    public Object apply(Object pLeft, Object pRight, Logger pLogger) throws ELException {
        if (pLeft == null && pRight == null) {
            if (pLogger.isLoggingWarning()) {
                pLogger.logWarning(Constants.ARITH_OP_NULL, this.getOperatorSymbol());
            }
            return PrimitiveObjects.getInteger(0);
        }
        if (Coercions.isBigDecimal(pLeft) || Coercions.isBigInteger(pLeft) || Coercions.isBigDecimal(pRight) || Coercions.isBigInteger(pRight)) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.math.BigDecimal");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            BigDecimal left = (BigDecimal)Coercions.coerceToPrimitiveNumber(pLeft, clazz, pLogger);
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("java.math.BigDecimal");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            BigDecimal right = (BigDecimal)Coercions.coerceToPrimitiveNumber(pRight, clazz2, pLogger);
            try {
                return left.divide(right, 4);
            }
            catch (Exception exception) {
                if (pLogger.isLoggingError()) {
                    pLogger.logError(Constants.ARITH_ERROR, this.getOperatorSymbol(), (Object)("" + left), (Object)("" + right));
                }
                return PrimitiveObjects.getInteger(0);
            }
        }
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.Double");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        double left = Coercions.coerceToPrimitiveNumber(pLeft, clazz, pLogger).doubleValue();
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("java.lang.Double");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        double right = Coercions.coerceToPrimitiveNumber(pRight, clazz3, pLogger).doubleValue();
        try {
            return PrimitiveObjects.getDouble(left / right);
        }
        catch (Exception exception) {
            if (pLogger.isLoggingError()) {
                pLogger.logError(Constants.ARITH_ERROR, this.getOperatorSymbol(), (Object)("" + left), (Object)("" + right));
            }
            return PrimitiveObjects.getInteger(0);
        }
    }
}

