/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.el;

import javax.servlet.jsp.el.ELException;
import org.apache.commons.el.BinaryOperator;
import org.apache.commons.el.Coercions;
import org.apache.commons.el.Constants;
import org.apache.commons.el.Logger;
import org.apache.commons.el.PrimitiveObjects;

public class IntegerDivideOperator
extends BinaryOperator {
    public static final IntegerDivideOperator SINGLETON = new IntegerDivideOperator();
    static /* synthetic */ Class class$0;

    public String getOperatorSymbol() {
        return "idiv";
    }

    public Object apply(Object pLeft, Object pRight, Logger pLogger) throws ELException {
        if (pLeft == null && pRight == null) {
            if (pLogger.isLoggingWarning()) {
                pLogger.logWarning(Constants.ARITH_OP_NULL, this.getOperatorSymbol());
            }
            return PrimitiveObjects.getInteger(0);
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        long left = Coercions.coerceToPrimitiveNumber(pLeft, clazz, pLogger).longValue();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        long right = Coercions.coerceToPrimitiveNumber(pRight, clazz2, pLogger).longValue();
        try {
            return PrimitiveObjects.getLong(left / right);
        }
        catch (Exception exception) {
            if (pLogger.isLoggingError()) {
                pLogger.logError(Constants.ARITH_ERROR, this.getOperatorSymbol(), (Object)("" + left), (Object)("" + right));
            }
            return PrimitiveObjects.getInteger(0);
        }
    }
}

