/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.urlfilter.prefix;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.nutch.net.URLFilter;
import org.apache.nutch.plugin.Extension;
import org.apache.nutch.plugin.PluginRepository;
import org.apache.nutch.util.PrefixStringMatcher;
import org.apache.nutch.util.TrieStringMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrefixURLFilter
implements URLFilter {
    private static final Logger LOG = LoggerFactory.getLogger(PrefixURLFilter.class);
    private static String attributeFile = null;
    private TrieStringMatcher trie;
    private Configuration conf;

    public PrefixURLFilter() throws IOException {
    }

    public PrefixURLFilter(String stringRules) throws IOException {
        this.trie = this.readConfiguration(new StringReader(stringRules));
    }

    public String filter(String url) {
        if (this.trie.shortestMatch(url) == null) {
            return null;
        }
        return url;
    }

    private TrieStringMatcher readConfiguration(Reader reader) throws IOException {
        String line;
        BufferedReader in = new BufferedReader(reader);
        ArrayList<String> urlprefixes = new ArrayList<String>();
        block3: while ((line = in.readLine()) != null) {
            if (line.length() == 0) continue;
            char first = line.charAt(0);
            switch (first) {
                case '\n': 
                case ' ': 
                case '#': {
                    continue block3;
                }
            }
            urlprefixes.add(line);
        }
        return new PrefixStringMatcher(urlprefixes);
    }

    public static void main(String[] args) throws IOException {
        String line;
        PrefixURLFilter filter = args.length >= 1 ? new PrefixURLFilter(args[0]) : new PrefixURLFilter();
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        while ((line = in.readLine()) != null) {
            String out = filter.filter(line);
            if (out == null) continue;
            System.out.println(out);
        }
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
        String pluginName = "urlfilter-prefix";
        Extension[] extensions = PluginRepository.get((Configuration)conf).getExtensionPoint(URLFilter.class.getName()).getExtensions();
        for (int i = 0; i < extensions.length; ++i) {
            Extension extension = extensions[i];
            if (!extension.getDescriptor().getPluginId().equals(pluginName)) continue;
            attributeFile = extension.getAttribute("file");
            break;
        }
        if (attributeFile != null && attributeFile.trim().equals("")) {
            attributeFile = null;
        }
        if (attributeFile != null && LOG.isInfoEnabled()) {
            LOG.info("Attribute \"file\" is defined for plugin " + pluginName + " as " + attributeFile);
        }
        String file = conf.get("urlfilter.prefix.file");
        String stringRules = conf.get("urlfilter.prefix.rules");
        if (attributeFile != null) {
            file = attributeFile;
        }
        Reader reader = null;
        reader = stringRules != null ? new StringReader(stringRules) : conf.getConfResourceAsReader(file);
        if (reader == null) {
            this.trie = new PrefixStringMatcher(new String[0]);
        } else {
            try {
                this.trie = this.readConfiguration(reader);
            }
            catch (IOException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error(e.getMessage());
                }
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }

    public Configuration getConf() {
        return this.conf;
    }
}

