/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.connectors.jdbc;

import java.io.InputStream;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.core.database.RRow;
import org.apache.manifoldcf.core.database.RSet;
import org.apache.manifoldcf.core.interfaces.BinaryInput;
import org.apache.manifoldcf.core.interfaces.IResultRow;
import org.apache.manifoldcf.core.interfaces.IResultSet;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.TempFileInput;
import org.apache.manifoldcf.core.interfaces.TimeMarker;
import org.apache.manifoldcf.crawler.connectors.jdbc.IDynamicResultSet;
import org.apache.manifoldcf.crawler.connectors.jdbc.JDBCConnectionFactory;

public class JDBCConnection {
    public static final String _rcsid = "@(#)$Id: JDBCConnection.java 988245 2010-08-23 18:39:35Z kwright $";
    protected String jdbcProvider = null;
    protected String host = null;
    protected String databaseName = null;
    protected String userName = null;
    protected String password = null;

    public JDBCConnection(String jdbcProvider, String host, String databaseName, String userName, String password) {
        this.jdbcProvider = jdbcProvider;
        this.host = host;
        this.databaseName = databaseName;
        this.userName = userName;
        this.password = password;
    }

    protected static IResultRow readNextResultRowViaThread(ResultSet rs, ResultSetMetaData rsmd, String[] resultCols) throws ManifoldCFException, ServiceInterruption {
        NextResultRowThread t = new NextResultRowThread(rs, rsmd, resultCols);
        try {
            t.start();
            t.join();
            Throwable thr = t.getException();
            if (thr != null) {
                if (thr instanceof SQLException) {
                    throw new ManifoldCFException("Error fetching next JDBC result row: " + thr.getMessage(), thr);
                }
                if (thr instanceof ManifoldCFException) {
                    throw (ManifoldCFException)thr;
                }
                if (thr instanceof ServiceInterruption) {
                    throw (ServiceInterruption)thr;
                }
                if (thr instanceof RuntimeException) {
                    throw (RuntimeException)thr;
                }
                throw (Error)thr;
            }
            return t.getResponse();
        }
        catch (InterruptedException e) {
            t.interrupt();
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
        }
    }

    protected static IResultRow readNextResultRow(ResultSet rs, ResultSetMetaData rsmd, String[] resultCols) throws ManifoldCFException, ServiceInterruption {
        try {
            if (rs.next()) {
                return JDBCConnection.readResultRow(rs, rsmd, resultCols);
            }
            return null;
        }
        catch (SQLException e) {
            throw new ManifoldCFException("Result set error: " + e.getMessage(), (Throwable)e);
        }
    }

    protected static void closeResultset(ResultSet rs) throws ManifoldCFException, ServiceInterruption {
        try {
            rs.close();
        }
        catch (SQLException e) {
            throw new ManifoldCFException("Exception closing resultset: " + e.getMessage(), (Throwable)e);
        }
    }

    protected static void closeStmt(Statement stmt) throws ManifoldCFException, ServiceInterruption {
        try {
            stmt.close();
        }
        catch (SQLException e) {
            throw new ManifoldCFException("Exception closing statement: " + e.getMessage(), (Throwable)e);
        }
    }

    protected static void closePS(PreparedStatement ps) throws ManifoldCFException, ServiceInterruption {
        try {
            ps.close();
        }
        catch (SQLException e) {
            throw new ManifoldCFException("Exception closing statement: " + e.getMessage(), (Throwable)e);
        }
    }

    public void testConnection() throws ManifoldCFException, ServiceInterruption {
        TestConnectionThread t = new TestConnectionThread();
        try {
            t.start();
            t.join();
            Throwable thr = t.getException();
            if (thr != null) {
                if (thr instanceof SQLException) {
                    throw new ManifoldCFException("Error doing JDBC connection test: " + thr.getMessage(), thr);
                }
                if (thr instanceof ManifoldCFException) {
                    throw (ManifoldCFException)thr;
                }
                if (thr instanceof ServiceInterruption) {
                    throw (ServiceInterruption)thr;
                }
                if (thr instanceof RuntimeException) {
                    throw (RuntimeException)thr;
                }
                throw (Error)thr;
            }
        }
        catch (InterruptedException e) {
            t.interrupt();
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
        }
    }

    public IDynamicResultSet executeUncachedQuery(String query, ArrayList params, int maxResults) throws ManifoldCFException, ServiceInterruption {
        if (params == null) {
            return new JDBCResultSet(query, maxResults);
        }
        return new JDBCPSResultSet(query, params, maxResults);
    }

    public void executeOperation(String query, ArrayList params) throws ManifoldCFException, ServiceInterruption {
        ExecuteOperationThread t = new ExecuteOperationThread(query, params);
        try {
            t.start();
            t.join();
            Throwable thr = t.getException();
            if (thr != null) {
                if (thr instanceof SQLException) {
                    throw new ManifoldCFException("Exception doing connector query '" + query + "': " + thr.getMessage(), thr);
                }
                if (thr instanceof ManifoldCFException) {
                    throw (ManifoldCFException)thr;
                }
                if (thr instanceof ServiceInterruption) {
                    throw (ServiceInterruption)thr;
                }
                if (thr instanceof RuntimeException) {
                    throw (RuntimeException)thr;
                }
                throw (Error)thr;
            }
        }
        catch (InterruptedException e) {
            t.interrupt();
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    protected static IResultSet execute(Connection connection, String query, ArrayList params, boolean bResults, int maxResults) throws ManifoldCFException, ServiceInterruption {
        try {
            if (params == null) {
                Statement stmt = connection.createStatement();
                try {
                    IResultSet iResultSet;
                    block24: {
                        ResultSet rs;
                        block22: {
                            IResultSet iResultSet2;
                            block23: {
                                stmt.execute(query);
                                rs = stmt.getResultSet();
                                try {
                                    if (!bResults) break block22;
                                    iResultSet2 = JDBCConnection.getData(rs, maxResults);
                                    if (rs == null) break block23;
                                }
                                catch (Throwable throwable) {
                                    if (rs != null) {
                                        rs.close();
                                    }
                                    throw throwable;
                                }
                                rs.close();
                            }
                            return iResultSet2;
                        }
                        iResultSet = null;
                        if (rs == null) break block24;
                        rs.close();
                    }
                    return iResultSet;
                }
                finally {
                    stmt.close();
                }
            }
            PreparedStatement ps = connection.prepareStatement(query);
            JDBCConnection.loadPS(ps, params);
            if (bResults) {
                ResultSet rs = ps.executeQuery();
                try {
                    IResultSet iResultSet = JDBCConnection.getData(rs, maxResults);
                    return iResultSet;
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            ps.executeUpdate();
            IResultSet iResultSet = null;
            return iResultSet;
            finally {
                ps.close();
                JDBCConnection.cleanupParameters(params);
            }
        }
        catch (ManifoldCFException e) {
            throw e;
        }
        catch (SQLException e) {
            throw new ManifoldCFException("Exception doing connector query '" + query + "': " + e.getMessage(), (Throwable)e);
        }
    }

    protected static IResultRow readResultRow(ResultSet rs, ResultSetMetaData rsmd, String[] resultCols) throws ManifoldCFException, ServiceInterruption {
        try {
            Object value = null;
            RRow m = new RRow();
            for (int i = 0; i < resultCols.length; ++i) {
                String key = resultCols[i];
                int colnum = JDBCConnection.findColumn(rs, key);
                if (colnum > -1) {
                    if (JDBCConnection.isBinaryData(rsmd, colnum)) {
                        InputStream bis = rs.getBinaryStream(colnum);
                        if (bis != null) {
                            value = new TempFileInput(bis);
                        }
                    } else if (JDBCConnection.isBLOB(rsmd, colnum)) {
                        Blob blob = JDBCConnection.getBLOB(rs, colnum);
                        if (blob != null) {
                            value = new TempFileInput(blob.getBinaryStream(), blob.length());
                        }
                    } else if (JDBCConnection.isCLOB(rsmd, colnum)) {
                        Clob clob = JDBCConnection.getCLOB(rs, colnum);
                        if (clob != null) {
                            value = new TempFileInput(clob.getAsciiStream(), clob.length());
                        }
                    } else {
                        value = JDBCConnection.getObject(rs, rsmd, colnum);
                    }
                }
                if (value == null) continue;
                m.put(key, value);
            }
            return m;
        }
        catch (SQLException e) {
            throw new ManifoldCFException("Resultset error: " + e.getMessage(), (Throwable)e);
        }
    }

    protected static String[] readColumnNames(ResultSetMetaData rsmd) throws ManifoldCFException, ServiceInterruption {
        try {
            String[] resultCols;
            if (rsmd != null) {
                int colcount = rsmd.getColumnCount();
                resultCols = new String[colcount];
                for (int i = 0; i < colcount; ++i) {
                    resultCols[i] = rsmd.getColumnName(i + 1);
                }
            } else {
                resultCols = new String[]{};
            }
            return resultCols;
        }
        catch (SQLException e) {
            throw new ManifoldCFException("Sql exception reading column names: " + e.getMessage(), (Throwable)e);
        }
    }

    protected static IResultSet getData(ResultSet rs, int maxResults) throws ManifoldCFException, ServiceInterruption {
        try {
            RSet results = new RSet();
            if (rs != null) {
                ResultSetMetaData rsmd = rs.getMetaData();
                String[] resultCols = JDBCConnection.readColumnNames(rsmd);
                if (resultCols.length == 0) {
                    throw new ManifoldCFException("Empty query, no columns returned", 0);
                }
                while (rs.next() && (maxResults == -1 || maxResults > 0)) {
                    IResultRow m = JDBCConnection.readResultRow(rs, rsmd, resultCols);
                    if (maxResults != -1) {
                        --maxResults;
                    }
                    results.addRow(m);
                }
            }
            return results;
        }
        catch (SQLException e) {
            throw new ManifoldCFException("Resultset error: " + e.getMessage(), (Throwable)e);
        }
    }

    protected static void loadPS(PreparedStatement ps, ArrayList data) throws SQLException, ManifoldCFException {
        if (data != null) {
            for (int i = 0; i < data.size(); ++i) {
                String value;
                Object x = data.get(i);
                if (x instanceof String) {
                    value = (String)x;
                    ps.setString(i + 1, value);
                }
                if (x instanceof BinaryInput) {
                    value = (BinaryInput)x;
                    ps.setAsciiStream(i + 1, value.getStream(), (int)value.getLength());
                }
                if (x instanceof java.util.Date) {
                    ps.setDate(i + 1, new Date(((java.util.Date)x).getTime()));
                }
                if (x instanceof Long) {
                    ps.setLong(i + 1, (Long)x);
                }
                if (x instanceof TimeMarker) {
                    ps.setTimestamp(i + 1, new Timestamp((Long)x));
                }
                if (x instanceof Double) {
                    ps.setDouble(i + 1, (Double)x);
                }
                if (x instanceof Integer) {
                    ps.setInt(i + 1, (Integer)x);
                }
                if (!(x instanceof Float)) continue;
                ps.setFloat(i + 1, ((Float)x).floatValue());
            }
        }
    }

    protected static void cleanupParameters(ArrayList data) throws ManifoldCFException {
        if (data != null) {
            for (int i = 0; i < data.size(); ++i) {
                Object x = data.get(i);
                if (!(x instanceof BinaryInput)) continue;
                BinaryInput value = (BinaryInput)x;
                value.doneWithStream();
            }
        }
    }

    protected static int findColumn(ResultSet rs, String name) throws ManifoldCFException, ServiceInterruption {
        try {
            return rs.findColumn(name);
        }
        catch (SQLException e) {
            return -1;
        }
    }

    protected static Blob getBLOB(ResultSet rs, int col) throws ManifoldCFException, ServiceInterruption {
        try {
            return rs.getBlob(col);
        }
        catch (SQLException sqle) {
            throw new ManifoldCFException("Error in getBlob(" + col + "): " + sqle.getMessage(), (Throwable)sqle, 1);
        }
    }

    protected static Clob getCLOB(ResultSet rs, int col) throws ManifoldCFException, ServiceInterruption {
        try {
            return rs.getClob(col);
        }
        catch (SQLException sqle) {
            throw new ManifoldCFException("Error in getClob(" + col + "): " + sqle.getMessage(), (Throwable)sqle, 1);
        }
    }

    protected static boolean isBLOB(ResultSetMetaData rsmd, int col) throws ManifoldCFException, ServiceInterruption {
        try {
            int type = rsmd.getColumnType(col);
            return type == 2004;
        }
        catch (SQLException sqle) {
            throw new ManifoldCFException("Error in isBlob(" + col + "): " + sqle.getMessage(), (Throwable)sqle, 1);
        }
    }

    protected static boolean isBinaryData(ResultSetMetaData rsmd, int col) throws ManifoldCFException, ServiceInterruption {
        try {
            int type = rsmd.getColumnType(col);
            return type == -3 || type == -2 || type == -4;
        }
        catch (SQLException sqle) {
            throw new ManifoldCFException("Error in isBinaryData(" + col + "): " + sqle.getMessage(), (Throwable)sqle, 1);
        }
    }

    protected static boolean isCLOB(ResultSetMetaData rsmd, int col) throws ManifoldCFException, ServiceInterruption {
        try {
            int type = rsmd.getColumnType(col);
            return type == 2005 || type == -1;
        }
        catch (SQLException sqle) {
            throw new ManifoldCFException("Error in isClob(" + col + "): " + sqle.getMessage(), (Throwable)sqle, 1);
        }
    }

    protected static Object getObject(ResultSet rs, ResultSetMetaData rsmd, int col) throws ManifoldCFException, ServiceInterruption {
        Object result = null;
        try {
            switch (rsmd.getColumnType(col)) {
                case 1: {
                    String resultString = rs.getString(col);
                    if (resultString == null) break;
                    if (rsmd.getColumnDisplaySize(col) < resultString.length()) {
                        result = resultString.substring(0, rsmd.getColumnDisplaySize(col));
                        break;
                    }
                    result = resultString;
                    break;
                }
                case 2005: {
                    Clob clob = rs.getClob(col);
                    if (clob == null) break;
                    result = clob.getSubString(1L, (int)clob.length());
                    break;
                }
                case -5: {
                    long l = rs.getLong(col);
                    if (rs.wasNull()) break;
                    result = new Long(l);
                    break;
                }
                case 4: {
                    int i = rs.getInt(col);
                    if (rs.wasNull()) break;
                    result = new Integer(i);
                    break;
                }
                case 6: 
                case 7: {
                    float f = rs.getFloat(col);
                    if (rs.wasNull()) break;
                    result = new Float(f);
                    break;
                }
                case 8: {
                    double d = rs.getDouble(col);
                    if (rs.wasNull()) break;
                    result = new Double(d);
                    break;
                }
                case 91: {
                    Date date = rs.getDate(col);
                    if (date == null) break;
                    result = new java.util.Date(date.getTime());
                    break;
                }
                case 93: {
                    Timestamp timestamp = rs.getTimestamp(col);
                    if (timestamp == null) break;
                    result = new TimeMarker(timestamp.getTime());
                    break;
                }
                case -4: 
                case -3: 
                case -2: 
                case 2004: {
                    throw new ManifoldCFException("Binary type is not a string, column = " + col, 0);
                }
                default: {
                    result = rs.getString(col);
                }
            }
            if (rs.wasNull()) {
                result = null;
            }
        }
        catch (SQLException e) {
            throw new ManifoldCFException("Exception in getString(): " + e.getMessage(), (Throwable)e, 1);
        }
        return result;
    }

    protected class PreparedStatementQueryThread
    extends Thread {
        protected ArrayList params;
        protected String query;
        protected Connection connection = null;
        protected Throwable exception = null;
        protected PreparedStatement ps = null;
        protected ResultSet rs = null;
        protected ResultSetMetaData rsmd = null;
        protected String[] resultCols = null;

        public PreparedStatementQueryThread(String query, ArrayList params) {
            this.setDaemon(true);
            this.query = query;
            this.params = params;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block30: {
                try {
                    this.connection = JDBCConnectionFactory.getConnection(JDBCConnection.this.jdbcProvider, JDBCConnection.this.host, JDBCConnection.this.databaseName, JDBCConnection.this.userName, JDBCConnection.this.password);
                    this.ps = this.connection.prepareStatement(this.query);
                    JDBCConnection.loadPS(this.ps, this.params);
                    this.rs = this.ps.executeQuery();
                    this.rsmd = this.rs.getMetaData();
                    this.resultCols = JDBCConnection.readColumnNames(this.rsmd);
                }
                catch (Throwable e) {
                    this.exception = e;
                    if (this.rs != null) {
                        try {
                            JDBCConnection.closeResultset(this.rs);
                        }
                        catch (ServiceInterruption e2) {
                        }
                        catch (ManifoldCFException e2) {
                            if (e2.getErrorCode() == 2) {
                                this.exception = e2;
                            }
                        }
                        finally {
                            this.rs = null;
                        }
                    }
                    if (this.ps != null) {
                        try {
                            JDBCConnection.closePS(this.ps);
                        }
                        catch (ServiceInterruption e2) {
                        }
                        catch (ManifoldCFException e2) {
                            if (e2.getErrorCode() == 2) {
                                this.exception = e2;
                            }
                        }
                        finally {
                            this.ps = null;
                        }
                    }
                    if (this.connection == null) break block30;
                    try {
                        JDBCConnectionFactory.releaseConnection(this.connection);
                    }
                    catch (ServiceInterruption e2) {
                    }
                    catch (ManifoldCFException e2) {
                        if (e2.getErrorCode() == 2) {
                            this.exception = e2;
                        }
                    }
                    finally {
                        this.connection = null;
                    }
                }
            }
        }

        public Throwable getException() {
            return this.exception;
        }

        public Connection getConnection() {
            return this.connection;
        }

        public PreparedStatement getPreparedStatement() {
            return this.ps;
        }

        public ResultSet getResultSet() {
            return this.rs;
        }

        public ResultSetMetaData getResultSetMetaData() {
            return this.rsmd;
        }

        public String[] getColumnNames() {
            return this.resultCols;
        }
    }

    protected class JDBCPSResultSet
    implements IDynamicResultSet {
        protected Connection connection;
        protected PreparedStatement ps;
        protected ResultSet rs;
        protected ResultSetMetaData rsmd;
        protected String[] resultCols;
        protected int maxResults;
        protected ArrayList params;

        public JDBCPSResultSet(String query, ArrayList params, int maxResults) throws ManifoldCFException, ServiceInterruption {
            this.maxResults = maxResults;
            this.params = params;
            PreparedStatementQueryThread t = new PreparedStatementQueryThread(query, params);
            try {
                t.start();
                t.join();
                Throwable thr = t.getException();
                if (thr != null) {
                    JDBCConnection.cleanupParameters(params);
                    if (thr instanceof SQLException) {
                        throw new ManifoldCFException("Exception doing connector query '" + query + "': " + thr.getMessage(), thr);
                    }
                    if (thr instanceof ManifoldCFException) {
                        throw (ManifoldCFException)thr;
                    }
                    if (thr instanceof ServiceInterruption) {
                        throw (ServiceInterruption)thr;
                    }
                    if (thr instanceof RuntimeException) {
                        throw (RuntimeException)thr;
                    }
                    throw (Error)thr;
                }
                this.connection = t.getConnection();
                this.ps = t.getPreparedStatement();
                this.rs = t.getResultSet();
                this.rsmd = t.getResultSetMetaData();
                this.resultCols = t.getColumnNames();
            }
            catch (InterruptedException e) {
                JDBCConnection.cleanupParameters(params);
                t.interrupt();
                throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
            }
        }

        public IResultRow getNextRow() throws ManifoldCFException, ServiceInterruption {
            if (this.maxResults == -1 || this.maxResults > 0) {
                IResultRow row = JDBCConnection.readNextResultRowViaThread(this.rs, this.rsmd, this.resultCols);
                if (row != null && this.maxResults != -1) {
                    --this.maxResults;
                }
                return row;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws ManifoldCFException, ServiceInterruption {
            ManifoldCFException rval;
            block34: {
                rval = null;
                if (this.rs != null) {
                    try {
                        JDBCConnection.closeResultset(this.rs);
                    }
                    catch (ServiceInterruption e) {
                    }
                    catch (ManifoldCFException e) {
                        if (rval == null || e.getErrorCode() == 2) {
                            rval = e;
                        }
                    }
                    finally {
                        this.rs = null;
                    }
                }
                if (this.ps != null) {
                    try {
                        JDBCConnection.closePS(this.ps);
                    }
                    catch (ServiceInterruption e) {
                    }
                    catch (ManifoldCFException e) {
                        if (rval == null || e.getErrorCode() == 2) {
                            rval = e;
                        }
                    }
                    finally {
                        this.ps = null;
                    }
                }
                if (this.connection != null) {
                    try {
                        JDBCConnectionFactory.releaseConnection(this.connection);
                    }
                    catch (ServiceInterruption e) {
                    }
                    catch (ManifoldCFException e) {
                        if (rval == null || e.getErrorCode() == 2) {
                            rval = e;
                        }
                    }
                    finally {
                        this.connection = null;
                    }
                }
                if (this.params != null) {
                    try {
                        JDBCConnection.cleanupParameters(this.params);
                        this.params = null;
                    }
                    catch (ManifoldCFException e) {
                        if (rval != null && e.getErrorCode() != 2) break block34;
                        rval = e;
                    }
                }
            }
            if (rval != null) {
                throw rval;
            }
        }
    }

    protected class StatementQueryThread
    extends Thread {
        protected String query;
        protected Throwable exception = null;
        protected Connection connection = null;
        protected Statement stmt = null;
        protected ResultSet rs = null;
        protected ResultSetMetaData rsmd = null;
        protected String[] resultCols = null;

        public StatementQueryThread(String query) {
            this.setDaemon(true);
            this.query = query;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block30: {
                try {
                    this.connection = JDBCConnectionFactory.getConnection(JDBCConnection.this.jdbcProvider, JDBCConnection.this.host, JDBCConnection.this.databaseName, JDBCConnection.this.userName, JDBCConnection.this.password);
                    this.stmt = this.connection.createStatement();
                    this.stmt.execute(this.query);
                    this.rs = this.stmt.getResultSet();
                    this.rsmd = this.rs.getMetaData();
                    this.resultCols = JDBCConnection.readColumnNames(this.rsmd);
                }
                catch (Throwable e) {
                    this.exception = e;
                    if (this.rs != null) {
                        try {
                            JDBCConnection.closeResultset(this.rs);
                        }
                        catch (ServiceInterruption e2) {
                        }
                        catch (ManifoldCFException e2) {
                            if (e2.getErrorCode() == 2) {
                                this.exception = e2;
                            }
                        }
                        finally {
                            this.rs = null;
                        }
                    }
                    if (this.stmt != null) {
                        try {
                            JDBCConnection.closeStmt(this.stmt);
                        }
                        catch (ServiceInterruption e2) {
                        }
                        catch (ManifoldCFException e2) {
                            if (e2.getErrorCode() == 2) {
                                this.exception = e2;
                            }
                        }
                        finally {
                            this.stmt = null;
                        }
                    }
                    if (this.connection == null) break block30;
                    try {
                        JDBCConnectionFactory.releaseConnection(this.connection);
                    }
                    catch (ServiceInterruption e2) {
                    }
                    catch (ManifoldCFException e2) {
                        if (e2.getErrorCode() == 2) {
                            this.exception = e2;
                        }
                    }
                    finally {
                        this.connection = null;
                    }
                }
            }
        }

        public Throwable getException() {
            return this.exception;
        }

        public Connection getConnection() {
            return this.connection;
        }

        public Statement getStatement() {
            return this.stmt;
        }

        public ResultSet getResultSet() {
            return this.rs;
        }

        public ResultSetMetaData getResultSetMetaData() {
            return this.rsmd;
        }

        public String[] getColumnNames() {
            return this.resultCols;
        }
    }

    protected class JDBCResultSet
    implements IDynamicResultSet {
        protected Connection connection;
        protected Statement stmt;
        protected ResultSet rs;
        protected ResultSetMetaData rsmd;
        protected String[] resultCols;
        protected int maxResults;

        public JDBCResultSet(String query, int maxResults) throws ManifoldCFException, ServiceInterruption {
            this.maxResults = maxResults;
            StatementQueryThread t = new StatementQueryThread(query);
            try {
                t.start();
                t.join();
                Throwable thr = t.getException();
                if (thr != null) {
                    if (thr instanceof SQLException) {
                        throw new ManifoldCFException("Exception doing connector query '" + query + "': " + thr.getMessage(), thr);
                    }
                    if (thr instanceof ManifoldCFException) {
                        throw (ManifoldCFException)thr;
                    }
                    if (thr instanceof ServiceInterruption) {
                        throw (ServiceInterruption)thr;
                    }
                    if (thr instanceof RuntimeException) {
                        throw (RuntimeException)thr;
                    }
                    throw (Error)thr;
                }
                this.connection = t.getConnection();
                this.stmt = t.getStatement();
                this.rs = t.getResultSet();
                this.rsmd = t.getResultSetMetaData();
                this.resultCols = t.getColumnNames();
            }
            catch (InterruptedException e) {
                t.interrupt();
                throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
            }
        }

        public IResultRow getNextRow() throws ManifoldCFException, ServiceInterruption {
            if (this.maxResults == -1 || this.maxResults > 0) {
                IResultRow row = JDBCConnection.readNextResultRowViaThread(this.rs, this.rsmd, this.resultCols);
                if (row != null && this.maxResults != -1) {
                    --this.maxResults;
                }
                return row;
            }
            return null;
        }

        public void close() throws ManifoldCFException, ServiceInterruption {
            ManifoldCFException rval;
            block12: {
                block11: {
                    block10: {
                        rval = null;
                        if (this.rs != null) {
                            try {
                                JDBCConnection.closeResultset(this.rs);
                                this.rs = null;
                            }
                            catch (ManifoldCFException e) {
                                if (rval != null && e.getErrorCode() != 2) break block10;
                                rval = e;
                            }
                        }
                    }
                    if (this.stmt != null) {
                        try {
                            JDBCConnection.closeStmt(this.stmt);
                            this.stmt = null;
                        }
                        catch (ManifoldCFException e) {
                            if (rval != null && e.getErrorCode() != 2) break block11;
                            rval = e;
                        }
                    }
                }
                if (this.connection != null) {
                    try {
                        JDBCConnectionFactory.releaseConnection(this.connection);
                        this.connection = null;
                    }
                    catch (ManifoldCFException e) {
                        if (rval != null && e.getErrorCode() != 2) break block12;
                        rval = e;
                    }
                }
            }
            if (rval != null) {
                throw rval;
            }
        }
    }

    protected class ExecuteOperationThread
    extends Thread {
        protected String query;
        protected ArrayList params;
        protected Throwable exception = null;

        public ExecuteOperationThread(String query, ArrayList params) {
            this.setDaemon(true);
            this.query = query;
            this.params = params;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Connection tempConnection = JDBCConnectionFactory.getConnection(JDBCConnection.this.jdbcProvider, JDBCConnection.this.host, JDBCConnection.this.databaseName, JDBCConnection.this.userName, JDBCConnection.this.password);
                try {
                    JDBCConnection.execute(tempConnection, this.query, this.params, false, 0);
                }
                finally {
                    JDBCConnectionFactory.releaseConnection(tempConnection);
                }
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public Throwable getException() {
            return this.exception;
        }
    }

    protected class TestConnectionThread
    extends Thread {
        protected Throwable exception = null;

        public TestConnectionThread() {
            this.setDaemon(true);
        }

        public void run() {
            try {
                Connection tempConnection = JDBCConnectionFactory.getConnection(JDBCConnection.this.jdbcProvider, JDBCConnection.this.host, JDBCConnection.this.databaseName, JDBCConnection.this.userName, JDBCConnection.this.password);
                JDBCConnectionFactory.releaseConnection(tempConnection);
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public Throwable getException() {
            return this.exception;
        }
    }

    protected static class NextResultRowThread
    extends Thread {
        protected ResultSet rs;
        protected ResultSetMetaData rsmd;
        protected String[] resultCols;
        protected Throwable exception = null;
        protected IResultRow response = null;

        public NextResultRowThread(ResultSet rs, ResultSetMetaData rsmd, String[] resultCols) {
            this.setDaemon(true);
            this.rs = rs;
            this.rsmd = rsmd;
            this.resultCols = resultCols;
        }

        public void run() {
            try {
                this.response = JDBCConnection.readNextResultRow(this.rs, this.rsmd, this.resultCols);
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public Throwable getException() {
            return this.exception;
        }

        public IResultRow getResponse() {
            return this.response;
        }
    }
}

