/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.connectors.jdbc;

import com.bitmechanic.sql.ConnectionPool;
import com.bitmechanic.sql.ConnectionPoolManager;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.crawler.system.Logging;
import org.apache.manifoldcf.crawler.system.ManifoldCF;

public class JDBCConnectionFactory {
    public static final String _rcsid = "@(#)$Id: JDBCConnectionFactory.java 988245 2010-08-23 18:39:35Z kwright $";
    private static Map driverMap;
    private static ConnectionPoolManager _pool;

    private JDBCConnectionFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection getConnection(String providerName, String host, String database, String userName, String password) throws ManifoldCFException, ServiceInterruption {
        int slashIndex;
        String driverClassName;
        if (database.length() == 0) {
            database = "_root_";
        }
        if ((driverClassName = (String)driverMap.get(providerName)) == null) {
            throw new ManifoldCFException("Unrecognized jdbc provider: '" + providerName + "'");
        }
        String instanceName = null;
        if (providerName.startsWith("jtds:") && (slashIndex = database.indexOf("/")) != -1) {
            instanceName = database.substring(0, slashIndex);
            database = database.substring(slashIndex + 1);
        }
        String dburl = "jdbc:" + providerName + "//" + host + "/" + database + (instanceName == null ? "" : ";instance=" + instanceName);
        if (Logging.connectors != null && Logging.connectors.isDebugEnabled()) {
            Logging.connectors.debug((Object)("JDBC: The connect string is '" + dburl + "'"));
        }
        try {
            if (_pool != null) {
                String poolKey = providerName + "/";
                poolKey = instanceName == null ? poolKey + host + "/" + database : poolKey + host + "/" + instanceName + "/" + database;
                poolKey = poolKey + "/" + userName + "/" + ManifoldCF.hash((String)password);
                ConnectionPoolManager connectionPoolManager = _pool;
                synchronized (connectionPoolManager) {
                    ConnectionPool cp = null;
                    try {
                        cp = _pool.getPool(poolKey);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (cp == null) {
                        _pool.addAlias(poolKey, driverClassName, dburl, userName, password, 25, 300, 3600, 30, false);
                    }
                }
                return DriverManager.getConnection("jdbc:bitmechanic:pool:" + poolKey, null, null);
            }
            throw new ManifoldCFException("Can't get connection since pool driver did not initialize properly");
        }
        catch (SQLException e) {
            try {
                if (userName != null && userName.length() > 0) {
                    DriverManager.getConnection(dburl, userName, password).close();
                } else {
                    DriverManager.getConnection(dburl).close();
                }
            }
            catch (SQLException e2) {
                throw new ManifoldCFException("Error getting connection: " + e2.getMessage(), (Throwable)e2, 3);
            }
            long currentTime = System.currentTimeMillis();
            throw new ServiceInterruption("Error getting connection: " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 21600000L, -1, true);
        }
        catch (ClassNotFoundException e) {
            throw new ManifoldCFException("Driver class not found: " + e.getMessage(), (Throwable)e, 3);
        }
        catch (InstantiationException e) {
            throw new ManifoldCFException("Driver class not instantiable: " + e.getMessage(), (Throwable)e, 3);
        }
        catch (IllegalAccessException e) {
            throw new ManifoldCFException("Driver class not accessible: " + e.getMessage(), (Throwable)e, 3);
        }
    }

    public static void releaseConnection(Connection c) throws ManifoldCFException, ServiceInterruption {
        try {
            c.close();
        }
        catch (SQLException e) {
            throw new ManifoldCFException("Error releasing connection: " + e.getMessage(), (Throwable)e);
        }
    }

    static {
        _pool = null;
        driverMap = new HashMap();
        driverMap.put("oracle:thin:@", "oracle.jdbc.OracleDriver");
        driverMap.put("postgresql:", "org.postgresql.Driver");
        driverMap.put("mysql:", "org.gjt.mm.mysql.Driver");
        driverMap.put("jtds:sqlserver:", "net.sourceforge.jtds.jdbc.Driver");
        driverMap.put("jtds:sybase:", "net.sourceforge.jtds.jdbc.Driver");
        try {
            _pool = new ConnectionPoolManager(120);
        }
        catch (Exception e) {
            System.err.println("Can't set up pool");
            e.printStackTrace(System.err);
        }
    }
}

