/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.connectors.jdbc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.manifoldcf.agents.interfaces.RepositoryDocument;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.core.interfaces.BinaryInput;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.ConfigurationNode;
import org.apache.manifoldcf.core.interfaces.IHTTPOutput;
import org.apache.manifoldcf.core.interfaces.IKeystoreManager;
import org.apache.manifoldcf.core.interfaces.IPostParameters;
import org.apache.manifoldcf.core.interfaces.IResultRow;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.KeystoreManagerFactory;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.SpecificationNode;
import org.apache.manifoldcf.crawler.connectors.BaseRepositoryConnector;
import org.apache.manifoldcf.crawler.connectors.jdbc.IDynamicResultSet;
import org.apache.manifoldcf.crawler.connectors.jdbc.JDBCConnection;
import org.apache.manifoldcf.crawler.connectors.jdbc.JDBCConstants;
import org.apache.manifoldcf.crawler.interfaces.DocumentSpecification;
import org.apache.manifoldcf.crawler.interfaces.IProcessActivity;
import org.apache.manifoldcf.crawler.interfaces.ISeedingActivity;
import org.apache.manifoldcf.crawler.interfaces.IVersionActivity;
import org.apache.manifoldcf.crawler.system.Logging;
import org.apache.manifoldcf.ui.util.Encoder;

public class JDBCConnector
extends BaseRepositoryConnector {
    public static final String _rcsid = "@(#)$Id: JDBCConnector.java 988245 2010-08-23 18:39:35Z kwright $";
    protected static final String ACTIVITY_EXTERNAL_QUERY = "external query";
    protected static final String[] activitiesList = new String[]{"external query"};
    private static final String defaultAuthorityDenyToken = "DEAD_AUTHORITY";
    protected JDBCConnection connection = null;
    protected String jdbcProvider = null;
    protected String host = null;
    protected String databaseName = null;
    protected String userName = null;
    protected String password = null;
    protected static HashMap documentKnownColumns = new HashMap();

    protected void getSession() throws ManifoldCFException {
        if (this.connection == null) {
            if (this.jdbcProvider == null || this.jdbcProvider.length() == 0) {
                throw new ManifoldCFException("Missing parameter '" + JDBCConstants.providerParameter + "'");
            }
            if (this.host == null || this.host.length() == 0) {
                throw new ManifoldCFException("Missing parameter '" + JDBCConstants.hostParameter + "'");
            }
            this.connection = new JDBCConnection(this.jdbcProvider, this.host, this.databaseName, this.userName, this.password);
        }
    }

    public String[] getActivitiesList() {
        return activitiesList;
    }

    public String getJSPFolder() {
        return "jdbc";
    }

    public int getConnectorModel() {
        return 2;
    }

    public void connect(ConfigParams configParams) {
        super.connect(configParams);
        this.jdbcProvider = configParams.getParameter(JDBCConstants.providerParameter);
        this.host = configParams.getParameter(JDBCConstants.hostParameter);
        this.databaseName = configParams.getParameter(JDBCConstants.databaseNameParameter);
        this.userName = configParams.getParameter(JDBCConstants.databaseUserName);
        this.password = configParams.getObfuscatedParameter(JDBCConstants.databasePassword);
    }

    public String check() throws ManifoldCFException {
        try {
            this.getSession();
            this.connection.testConnection();
            return super.check();
        }
        catch (ServiceInterruption e) {
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("Service interruption in check(): " + e.getMessage()), (Throwable)e);
            }
            return "Transient error: " + e.getMessage();
        }
    }

    public void disconnect() throws ManifoldCFException {
        this.connection = null;
        this.host = null;
        this.jdbcProvider = null;
        this.databaseName = null;
        this.userName = null;
        this.password = null;
        super.disconnect();
    }

    public String[] getBinNames(String documentIdentifier) {
        return new String[]{this.host};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSeedDocuments(ISeedingActivity activities, DocumentSpecification spec, long startTime, long endTime, int jobMode) throws ManifoldCFException, ServiceInterruption {
        IDynamicResultSet idSet;
        this.getSession();
        TableSpec ts = new TableSpec(spec);
        VariableMap vm = new VariableMap();
        JDBCConnector.addConstant(vm, JDBCConstants.idReturnVariable, JDBCConstants.idReturnColumnName);
        JDBCConnector.addVariable(vm, JDBCConstants.startTimeVariable, startTime);
        JDBCConnector.addVariable(vm, JDBCConstants.endTimeVariable, endTime);
        ArrayList paramList = new ArrayList();
        StringBuffer sb = new StringBuffer();
        JDBCConnector.substituteQuery(ts.idQuery, vm, sb, paramList);
        String queryText = sb.toString();
        long startQueryTime = System.currentTimeMillis();
        try {
            idSet = this.connection.executeUncachedQuery(queryText, paramList, -1);
        }
        catch (ServiceInterruption e) {
            activities.recordActivity(new Long(startQueryTime), ACTIVITY_EXTERNAL_QUERY, null, JDBCConnector.createQueryString(queryText, paramList), "ERROR", e.getMessage(), null);
            throw e;
        }
        catch (ManifoldCFException e) {
            activities.recordActivity(new Long(startQueryTime), ACTIVITY_EXTERNAL_QUERY, null, JDBCConnector.createQueryString(queryText, paramList), "ERROR", e.getMessage(), null);
            throw e;
        }
        try {
            IResultRow row;
            activities.recordActivity(new Long(startQueryTime), ACTIVITY_EXTERNAL_QUERY, null, JDBCConnector.createQueryString(queryText, paramList), "OK", null, null);
            while ((row = idSet.getNextRow()) != null) {
                Object o = row.getValue(JDBCConstants.idReturnColumnName);
                if (o == null) {
                    throw new ManifoldCFException("Bad seed query; doesn't return $(IDCOLUMN) column.  Try using quotes around $(IDCOLUMN) variable, e.g. \"$(IDCOLUMN)\".");
                }
                String idValue = o.toString();
                activities.addSeedDocument(idValue);
            }
        }
        finally {
            idSet.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getDocumentVersions(String[] documentIdentifiers, String[] oldVersions, IVersionActivity activities, DocumentSpecification spec, int jobMode, boolean usesDefaultAuthority) throws ManifoldCFException, ServiceInterruption {
        IDynamicResultSet result;
        this.getSession();
        TableSpec ts = new TableSpec(spec);
        Object[] acls = JDBCConnector.getAcls(spec);
        Arrays.sort(acls);
        String[] versionsReturned = new String[documentIdentifiers.length];
        if (ts.versionQuery == null || ts.versionQuery.length() == 0) {
            int i = 0;
            while (i < versionsReturned.length) {
                versionsReturned[i++] = "";
            }
            return versionsReturned;
        }
        VariableMap vm = new VariableMap();
        JDBCConnector.addConstant(vm, JDBCConstants.idReturnVariable, JDBCConstants.idReturnColumnName);
        JDBCConnector.addConstant(vm, JDBCConstants.versionReturnVariable, JDBCConstants.versionReturnColumnName);
        if (!JDBCConnector.addIDList(vm, JDBCConstants.idListVariable, documentIdentifiers, null)) {
            return new String[0];
        }
        ArrayList paramList = new ArrayList();
        StringBuffer sb = new StringBuffer();
        JDBCConnector.substituteQuery(ts.versionQuery, vm, sb, paramList);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (int j = 0; j < documentIdentifiers.length; ++j) {
            map.put(documentIdentifiers[j], new Integer(j));
            versionsReturned[j] = "";
        }
        String queryText = sb.toString();
        long startTime = System.currentTimeMillis();
        try {
            result = this.connection.executeUncachedQuery(queryText, paramList, -1);
        }
        catch (ManifoldCFException e) {
            activities.recordActivity(new Long(startTime), ACTIVITY_EXTERNAL_QUERY, null, JDBCConnector.createQueryString(queryText, paramList), "ERROR", e.getMessage(), null);
            throw e;
        }
        activities.recordActivity(new Long(startTime), ACTIVITY_EXTERNAL_QUERY, null, JDBCConnector.createQueryString(queryText, paramList), "OK", null, null);
        try {
            IResultRow row;
            while ((row = result.getNextRow()) != null) {
                String versionValue;
                Object o = row.getValue(JDBCConstants.idReturnColumnName);
                if (o == null) {
                    throw new ManifoldCFException("Bad version query; doesn't return $(IDCOLUMN) column.  Try using quotes around $(IDCOLUMN) variable, e.g. \"$(IDCOLUMN)\".");
                }
                String idValue = o.toString();
                o = row.getValue(JDBCConstants.versionReturnColumnName);
                if (o == null) {
                    versionValue = "";
                } else {
                    sb = new StringBuffer();
                    JDBCConnector.packList(sb, (String[])acls, '+');
                    if (acls.length > 0) {
                        sb.append('+');
                        JDBCConnector.pack(sb, defaultAuthorityDenyToken, '+');
                    } else {
                        sb.append('-');
                    }
                    sb.append(o.toString()).append("=").append(ts.dataQuery);
                    versionValue = sb.toString();
                }
                versionsReturned[((Integer)map.get((Object)idValue)).intValue()] = versionValue;
            }
        }
        finally {
            result.close();
        }
        return versionsReturned;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processDocuments(String[] documentIdentifiers, String[] versions, IProcessActivity activities, DocumentSpecification spec, boolean[] scanOnly) throws ManifoldCFException, ServiceInterruption {
        IDynamicResultSet result;
        int i;
        this.getSession();
        TableSpec ts = new TableSpec(spec);
        VariableMap vm = new VariableMap();
        JDBCConnector.addConstant(vm, JDBCConstants.idReturnVariable, JDBCConstants.idReturnColumnName);
        JDBCConnector.addConstant(vm, JDBCConstants.urlReturnVariable, JDBCConstants.urlReturnColumnName);
        JDBCConnector.addConstant(vm, JDBCConstants.dataReturnVariable, JDBCConstants.dataReturnColumnName);
        if (!JDBCConnector.addIDList(vm, JDBCConstants.idListVariable, documentIdentifiers, scanOnly)) {
            return;
        }
        ArrayList paramList = new ArrayList();
        StringBuffer sb = new StringBuffer();
        JDBCConnector.substituteQuery(ts.dataQuery, vm, sb, paramList);
        HashMap<String, String> map = new HashMap<String, String>();
        for (i = 0; i < documentIdentifiers.length; ++i) {
            if (scanOnly[i]) continue;
            map.put(documentIdentifiers[i], versions[i]);
        }
        String queryText = sb.toString();
        long startTime = System.currentTimeMillis();
        try {
            result = this.connection.executeUncachedQuery(queryText, paramList, -1);
        }
        catch (ManifoldCFException e) {
            activities.recordActivity(new Long(startTime), ACTIVITY_EXTERNAL_QUERY, null, JDBCConnector.createQueryString(queryText, paramList), "ERROR", e.getMessage(), null);
            throw e;
        }
        activities.recordActivity(new Long(startTime), ACTIVITY_EXTERNAL_QUERY, null, JDBCConnector.createQueryString(queryText, paramList), "OK", null, null);
        try {
            IResultRow row;
            while ((row = result.getNextRow()) != null) {
                Object o = row.getValue(JDBCConstants.idReturnColumnName);
                if (o == null) {
                    throw new ManifoldCFException("Bad document query; doesn't return $(IDCOLUMN) column.  Try using quotes around $(IDCOLUMN) variable, e.g. \"$(IDCOLUMN)\".");
                }
                String id = JDBCConnector.readAsString(o);
                String version = (String)map.get(id);
                if (version == null) continue;
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("JDBC: Document data result found for '" + id + "'"));
                }
                if ((o = row.getValue(JDBCConstants.urlReturnColumnName)) != null) {
                    boolean validURL;
                    String url = JDBCConnector.readAsString(o);
                    try {
                        new URI(url);
                        validURL = true;
                    }
                    catch (URISyntaxException e) {
                        validURL = false;
                    }
                    if (validURL) {
                        Object contents = row.getValue(JDBCConstants.dataReturnColumnName);
                        if (contents != null) {
                            map.remove(id);
                            if (contents instanceof BinaryInput) {
                                RepositoryDocument rd = new RepositoryDocument();
                                this.applyAccessTokens(rd, version, spec);
                                this.applyMetadata(rd, row);
                                BinaryInput bi = (BinaryInput)contents;
                                try {
                                    InputStream is = bi.getStream();
                                    try {
                                        rd.setBinary(is, bi.getLength());
                                        activities.ingestDocument(id, version, url, rd);
                                    }
                                    finally {
                                        is.close();
                                    }
                                }
                                catch (SocketTimeoutException e) {
                                    throw new ManifoldCFException("Socket timeout reading database data: " + e.getMessage(), (Throwable)e);
                                }
                                catch (InterruptedIOException e) {
                                    throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
                                }
                                catch (IOException e) {
                                    throw new ManifoldCFException("Error reading database data: " + e.getMessage(), (Throwable)e);
                                }
                                finally {
                                    bi.discard();
                                }
                                continue;
                            }
                            String value = contents.toString();
                            try {
                                byte[] bytes = value.getBytes("utf-8");
                                RepositoryDocument rd = new RepositoryDocument();
                                this.applyAccessTokens(rd, version, spec);
                                this.applyMetadata(rd, row);
                                ByteArrayInputStream is = new ByteArrayInputStream(bytes);
                                try {
                                    rd.setBinary((InputStream)is, (long)bytes.length);
                                    activities.ingestDocument(id, version, url, rd);
                                }
                                finally {
                                    ((InputStream)is).close();
                                }
                            }
                            catch (InterruptedIOException e) {
                                throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
                            }
                            catch (IOException e) {
                                throw new ManifoldCFException("Error reading database data: " + e.getMessage(), (Throwable)e);
                            }
                        }
                        Logging.connectors.warn((Object)("JDBC: Document '" + id + "' seems to have null data - skipping"));
                        continue;
                    }
                    Logging.connectors.warn((Object)("JDBC: Document '" + id + "' has an illegal url: '" + url + "' - skipping"));
                    continue;
                }
                Logging.connectors.warn((Object)("JDBC: Document '" + id + "' has a null url - skipping"));
            }
            for (i = 0; i < documentIdentifiers.length; ++i) {
                String documentIdentifier;
                if (scanOnly[i] || map.get(documentIdentifier = documentIdentifiers[i]) == null) continue;
                activities.deleteDocument(documentIdentifier);
            }
            return;
        }
        finally {
            result.close();
        }
    }

    public void outputConfigurationHeader(IThreadContext threadContext, IHTTPOutput out, ConfigParams parameters, ArrayList tabsArray) throws ManifoldCFException, IOException {
        tabsArray.add("Database Type");
        tabsArray.add("Server");
        tabsArray.add("Credentials");
        out.print("<script type=\"text/javascript\">\n<!--\nfunction checkConfigForSave()\n{\n  if (editconnection.databasehost.value == \"\")\n  {\n    alert(\"Please fill in a database server name\");\n    SelectTab(\"Server\");\n    editconnection.databasehost.focus();\n    return false;\n  }\n  if (editconnection.databasename.value == \"\")\n  {\n    alert(\"Please fill in the name of the database\");\n    SelectTab(\"Server\");\n    editconnection.databasename.focus();\n    return false;\n  }\n  if (editconnection.username.value == \"\")\n  {\n    alert(\"Please supply the database username for this connection\");\n    SelectTab(\"Credentials\");\n    editconnection.username.focus();\n    return false;\n  }\n  return true;\n}\n\n//-->\n</script>\n");
    }

    public void outputConfigurationBody(IThreadContext threadContext, IHTTPOutput out, ConfigParams parameters, String tabName) throws ManifoldCFException, IOException {
        String databasePassword;
        String databaseUser;
        String databaseName;
        String host;
        String jdbcProvider = parameters.getParameter(JDBCConstants.providerParameter);
        if (jdbcProvider == null) {
            jdbcProvider = "oracle:thin:@";
        }
        if ((host = parameters.getParameter(JDBCConstants.hostParameter)) == null) {
            host = "localhost";
        }
        if ((databaseName = parameters.getParameter(JDBCConstants.databaseNameParameter)) == null) {
            databaseName = "database";
        }
        if ((databaseUser = parameters.getParameter(JDBCConstants.databaseUserName)) == null) {
            databaseUser = "";
        }
        if ((databasePassword = parameters.getObfuscatedParameter(JDBCConstants.databasePassword)) == null) {
            databasePassword = "";
        }
        if (tabName.equals("Database Type")) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>Database type:</nobr></td><td class=\"value\">\n      <select multiple=\"false\" name=\"databasetype\" size=\"2\">\n        <option value=\"oracle:thin:@\" " + (jdbcProvider.equals("oracle:thin:@") ? "selected=\"selected\"" : "") + ">Oracle</option>\n" + "        <option value=\"postgresql:\" " + (jdbcProvider.equals("postgresql:") ? "selected=\"selected\"" : "") + ">Postgres SQL</option>\n" + "        <option value=\"jtds:sqlserver:\" " + (jdbcProvider.equals("jtds:sqlserver:") ? "selected=\"selected\"" : "") + ">MS SQL Server (&gt; V6.5)</option>\n" + "        <option value=\"jtds:sybase:\" " + (jdbcProvider.equals("jtds:sybase:") ? "selected=\"selected\"" : "") + ">Sybase (&gt;= V10)</option>\n" + "      </select>\n" + "    </td>\n" + "  </tr>\n" + "</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"databasetype\" value=\"" + jdbcProvider + "\"/>\n");
        }
        if (tabName.equals("Server")) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>Database host and port:</nobr></td><td class=\"value\"><input type=\"text\" size=\"64\" name=\"databasehost\" value=\"" + Encoder.attributeEscape((String)host) + "\"/></td>\n" + "  </tr>\n" + "  <tr>\n" + "    <td class=\"description\"><nobr>Database service name or instance/database:</nobr></td><td class=\"value\"><input type=\"text\" size=\"32\" name=\"databasename\" value=\"" + Encoder.attributeEscape((String)databaseName) + "\"/></td>\n" + "  </tr>\n" + "</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"databasehost\" value=\"" + Encoder.attributeEscape((String)host) + "\"/>\n" + "<input type=\"hidden\" name=\"databasename\" value=\"" + Encoder.attributeEscape((String)databaseName) + "\"/>\n");
        }
        if (tabName.equals("Credentials")) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>User name:</nobr></td><td class=\"value\"><input type=\"text\" size=\"32\" name=\"username\" value=\"" + Encoder.attributeEscape((String)databaseUser) + "\"/></td>\n" + "  </tr>\n" + "  <tr>\n" + "    <td class=\"description\"><nobr>Password:</nobr></td><td class=\"value\"><input type=\"password\" size=\"32\" name=\"password\" value=\"" + Encoder.attributeEscape((String)databasePassword) + "\"/></td>\n" + "  </tr>\n" + "</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"username\" value=\"" + Encoder.attributeEscape((String)databaseUser) + "\"/>\n" + "<input type=\"hidden\" name=\"password\" value=\"" + Encoder.attributeEscape((String)databasePassword) + "\"/>\n");
        }
    }

    public String processConfigurationPost(IThreadContext threadContext, IPostParameters variableContext, ConfigParams parameters) throws ManifoldCFException {
        String password;
        String userName;
        String databaseName;
        String host;
        String type = variableContext.getParameter("databasetype");
        if (type != null) {
            parameters.setParameter(JDBCConstants.providerParameter, type);
        }
        if ((host = variableContext.getParameter("databasehost")) != null) {
            parameters.setParameter(JDBCConstants.hostParameter, host);
        }
        if ((databaseName = variableContext.getParameter("databasename")) != null) {
            parameters.setParameter(JDBCConstants.databaseNameParameter, databaseName);
        }
        if ((userName = variableContext.getParameter("username")) != null) {
            parameters.setParameter(JDBCConstants.databaseUserName, userName);
        }
        if ((password = variableContext.getParameter("password")) != null) {
            parameters.setObfuscatedParameter(JDBCConstants.databasePassword, password);
        }
        return null;
    }

    public void viewConfiguration(IThreadContext threadContext, IHTTPOutput out, ConfigParams parameters) throws ManifoldCFException, IOException {
        out.print("<table class=\"displaytable\">\n  <tr>\n    <td class=\"description\" colspan=\"1\"><nobr>Parameters:</nobr></td>\n    <td class=\"value\" colspan=\"3\">\n");
        Iterator iter = parameters.listParameters();
        while (iter.hasNext()) {
            String param = (String)iter.next();
            String value = parameters.getParameter(param);
            if (param.length() >= "password".length() && param.substring(param.length() - "password".length()).equalsIgnoreCase("password")) {
                out.print("      <nobr>" + Encoder.bodyEscape((String)param) + "=********</nobr><br/>\n");
                continue;
            }
            if (param.length() >= "keystore".length() && param.substring(param.length() - "keystore".length()).equalsIgnoreCase("keystore")) {
                IKeystoreManager kmanager = KeystoreManagerFactory.make((String)"", (String)value);
                out.print("      <nobr>" + Encoder.bodyEscape((String)param) + "=<" + Integer.toString(kmanager.getContents().length) + " certificate(s)></nobr><br/>\n");
                continue;
            }
            out.print("      <nobr>" + Encoder.bodyEscape((String)param) + "=" + Encoder.bodyEscape((String)value) + "</nobr><br/>\n");
        }
        out.print("    </td>\n  </tr>\n</table>\n");
    }

    public void outputSpecificationHeader(IHTTPOutput out, DocumentSpecification ds, ArrayList tabsArray) throws ManifoldCFException, IOException {
        tabsArray.add("Queries");
        tabsArray.add("Security");
        out.print("<script type=\"text/javascript\">\n<!--\n\nfunction SpecOp(n, opValue, anchorvalue)\n{\n  eval(\"editjob.\"+n+\".value = \\\"\"+opValue+\"\\\"\");\n  postFormSetAnchor(anchorvalue);\n}\n\nfunction SpecAddToken(anchorvalue)\n{\n  if (editjob.spectoken.value == \"\")\n  {\n    alert(\"Type in an access token\");\n    editjob.spectoken.focus();\n    return;\n  }\n  SpecOp(\"accessop\",\"Add\",anchorvalue);\n}\n\nfunction checkSpecification()\n{\n  if (editjob.idquery.value == \"\")\n  {\n    alert(\"Enter a seeding query\");\n    editjob.idquery.focus();\n    return false;\n  }\n  if (editjob.idquery.value.indexOf(\"$(IDCOLUMN)\") == -1)\n  {\n    alert(\"Must return $(IDCOLUMN) in the result.\\nExample: SELECT idfield AS $(IDCOLUMN) FROM ...\");\n    editjob.idquery.focus();\n    return false;\n  }\n  if (editjob.versionquery.value != \"\")\n  {\n    if (editjob.versionquery.value.indexOf(\"$(IDCOLUMN)\") == -1)\n    {\n      alert(\"Must return $(IDCOLUMN) in the result.\\nExample: SELECT idfield AS $(IDCOLUMN), ...\");\n      editjob.versionquery.focus();\n      return false;\n    }\n    if (editjob.versionquery.value.indexOf(\"$(VERSIONCOLUMN)\") == -1)\n    {\n      alert(\"Must return $(VERSIONCOLUMN) in the result, containing the document version.\\nExample: SELECT versionfield AS $(VERSIONCOLUMN), ...\");\n      editjob.versionquery.focus();\n      return false;\n    }\n    if (editjob.versionquery.value.indexOf(\"$(IDLIST)\") == -1)\n    {\n      alert(\"Must use $(IDLIST) in WHERE clause.\\nExample: SELECT ... WHERE idfield IN $(IDLIST) ...\");\n      editjob.versionquery.focus();\n      return false;\n    }\n  }\n  if (editjob.dataquery.value == \"\")\n  {\n    alert(\"Enter a data query\");\n    editjob.dataquery.focus();\n    return false;\n  }\n  if (editjob.dataquery.value.indexOf(\"$(IDCOLUMN)\") == -1)\n  {\n    alert(\"Must return $(IDCOLUMN) in the result.\\nExample: SELECT idfield AS $(IDCOLUMN), ...\");\n    editjob.dataquery.focus();\n    return false;\n  }\n  if (editjob.dataquery.value.indexOf(\"$(URLCOLUMN)\") == -1)\n  {\n    alert(\"Must return $(URLCOLUMN) in the result, containing the url to use to reach the document.\\nExample: SELECT urlfield AS $(URLCOLUMN), ...\");\n    editjob.dataquery.focus();\n    return false;\n  }\n  if (editjob.dataquery.value.indexOf(\"$(DATACOLUMN)\") == -1)\n  {\n    alert(\"Must return $(DATACOLUMN) in the result, containing the document data.\\nExample: SELECT datafield AS $(DATACOLUMN), ...\");\n    editjob.dataquery.focus();\n    return false;\n  }\n  if (editjob.dataquery.value.indexOf(\"$(IDLIST)\") == -1)\n  {\n    alert(\"Must use $(IDLIST) in WHERE clause.\\nExample: SELECT ... WHERE idfield IN $(IDLIST) ...\");\n    editjob.dataquery.focus();\n    return false;\n  }\n\n  return true;\n}\n\n//-->\n</script>\n");
    }

    public void outputSpecificationBody(IHTTPOutput out, DocumentSpecification ds, String tabName) throws ManifoldCFException, IOException {
        String idQuery = "SELECT idfield AS $(IDCOLUMN) FROM documenttable WHERE modifydatefield > $(STARTTIME) AND modifydatefield <= $(ENDTIME)";
        String versionQuery = "SELECT idfield AS $(IDCOLUMN), versionfield AS $(VERSIONCOLUMN) FROM documenttable WHERE idfield IN $(IDLIST)";
        String dataQuery = "SELECT idfield AS $(IDCOLUMN), urlfield AS $(URLCOLUMN), datafield AS $(DATACOLUMN) FROM documenttable WHERE idfield IN $(IDLIST)";
        int i = 0;
        while (i < ds.getChildCount()) {
            SpecificationNode sn;
            if ((sn = ds.getChild(i++)).getType().equals(JDBCConstants.idQueryNode)) {
                idQuery = sn.getValue();
                if (idQuery != null) continue;
                idQuery = "";
                continue;
            }
            if (sn.getType().equals(JDBCConstants.versionQueryNode)) {
                versionQuery = sn.getValue();
                if (versionQuery != null) continue;
                versionQuery = "";
                continue;
            }
            if (!sn.getType().equals(JDBCConstants.dataQueryNode) || (dataQuery = sn.getValue()) != null) continue;
            dataQuery = "";
        }
        if (tabName.equals("Queries")) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>Seeding query:</nobr><br/><nobr>(return ids that need to be checked)</nobr></td>\n    <td class=\"value\"><textarea name=\"idquery\" cols=\"64\" rows=\"6\">" + Encoder.bodyEscape((String)idQuery) + "</textarea></td>\n" + "  </tr>\n" + "  <tr>\n" + "    <td class=\"description\"><nobr>Version check query:</nobr><br/><nobr>(return ids and versions for a set of documents;</nobr><br/><nobr>leave blank if no versioning capability)</nobr></td>\n" + "    <td class=\"value\"><textarea name=\"versionquery\" cols=\"64\" rows=\"6\">" + Encoder.bodyEscape((String)versionQuery) + "</textarea></td>\n" + "  </tr>\n" + "  <tr>\n" + "    <td class=\"description\"><nobr>Data query:</nobr><br/><nobr>(return ids, urls, and data for a set of documents)</nobr></td>\n" + "    <td class=\"value\"><textarea name=\"dataquery\" cols=\"64\" rows=\"6\">" + Encoder.bodyEscape((String)dataQuery) + "</textarea></td>\n" + "  </tr>\n" + "</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"idquery\" value=\"" + Encoder.attributeEscape((String)idQuery) + "\"/>\n" + "<input type=\"hidden\" name=\"versionquery\" value=\"" + Encoder.attributeEscape((String)versionQuery) + "\"/>\n" + "<input type=\"hidden\" name=\"dataquery\" value=\"" + Encoder.attributeEscape((String)dataQuery) + "\"/>\n");
        }
        i = 0;
        if (tabName.equals("Security")) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n");
            i = 0;
            int k = 0;
            while (i < ds.getChildCount()) {
                SpecificationNode sn;
                if (!(sn = ds.getChild(i++)).getType().equals("access")) continue;
                String accessDescription = "_" + Integer.toString(k);
                String accessOpName = "accessop" + accessDescription;
                String token = sn.getAttributeValue("token");
                out.print("  <tr>\n    <td class=\"description\">\n      <input type=\"hidden\" name=\"" + accessOpName + "\" value=\"\"/>\n" + "      <input type=\"hidden\" name=\"" + "spectoken" + accessDescription + "\" value=\"" + Encoder.attributeEscape((String)token) + "\"/>\n" + "      <a name=\"" + "token_" + Integer.toString(k) + "\">\n" + "        <input type=\"button\" value=\"Delete\" onClick='Javascript:SpecOp(\"" + accessOpName + "\",\"Delete\",\"token_" + Integer.toString(k) + "\")' alt=\"Delete token #\"" + Integer.toString(k) + "\"/>\n" + "      </a>&nbsp;\n" + "    </td>\n" + "    <td class=\"value\">\n" + "      " + Encoder.bodyEscape((String)token) + "\n" + "    </td>\n" + "  </tr>\n");
                ++k;
            }
            if (k == 0) {
                out.print("  <tr>\n    <td class=\"message\" colspan=\"2\">No access tokens present</td>\n  </tr>\n");
            }
            out.print("  <tr><td class=\"lightseparator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\">\n      <input type=\"hidden\" name=\"tokencount\" value=\"" + Integer.toString(k) + "\"/>\n" + "      <input type=\"hidden\" name=\"accessop\" value=\"\"/>\n" + "      <a name=\"" + "token_" + Integer.toString(k) + "\">\n" + "        <input type=\"button\" value=\"Add\" onClick='Javascript:SpecAddToken(\"token_" + Integer.toString(k + 1) + "\")' alt=\"Add access token\"/>\n" + "      </a>&nbsp;\n" + "    </td>\n" + "    <td class=\"value\">\n" + "      <input type=\"text\" size=\"30\" name=\"spectoken\" value=\"\"/>\n" + "    </td>\n" + "  </tr>\n" + "</table>\n");
        } else {
            i = 0;
            int k = 0;
            while (i < ds.getChildCount()) {
                SpecificationNode sn;
                if (!(sn = ds.getChild(i++)).getType().equals("access")) continue;
                String accessDescription = "_" + Integer.toString(k);
                String token = sn.getAttributeValue("token");
                out.print("<input type=\"hidden\" name=\"spectoken" + accessDescription + "\" value=\"" + Encoder.attributeEscape((String)token) + "\"/>\n");
                ++k;
            }
            out.print("<input type=\"hidden\" name=\"tokencount\" value=\"" + Integer.toString(k) + "\"/>\n");
        }
    }

    public String processSpecificationPost(IPostParameters variableContext, DocumentSpecification ds) throws ManifoldCFException {
        String xc;
        SpecificationNode sn;
        int i;
        String idQuery = variableContext.getParameter("idquery");
        String versionQuery = variableContext.getParameter("versionquery");
        String dataQuery = variableContext.getParameter("dataquery");
        if (idQuery != null) {
            i = 0;
            while (i < ds.getChildCount()) {
                if (ds.getChild(i).getType().equals(JDBCConstants.idQueryNode)) {
                    ds.removeChild(i);
                    continue;
                }
                ++i;
            }
            sn = new SpecificationNode(JDBCConstants.idQueryNode);
            sn.setValue(idQuery);
            ds.addChild(ds.getChildCount(), (ConfigurationNode)sn);
        }
        if (versionQuery != null) {
            i = 0;
            while (i < ds.getChildCount()) {
                if (ds.getChild(i).getType().equals(JDBCConstants.versionQueryNode)) {
                    ds.removeChild(i);
                    continue;
                }
                ++i;
            }
            sn = new SpecificationNode(JDBCConstants.versionQueryNode);
            sn.setValue(versionQuery);
            ds.addChild(ds.getChildCount(), (ConfigurationNode)sn);
        }
        if (dataQuery != null) {
            i = 0;
            while (i < ds.getChildCount()) {
                if (ds.getChild(i).getType().equals(JDBCConstants.dataQueryNode)) {
                    ds.removeChild(i);
                    continue;
                }
                ++i;
            }
            sn = new SpecificationNode(JDBCConstants.dataQueryNode);
            sn.setValue(dataQuery);
            ds.addChild(ds.getChildCount(), (ConfigurationNode)sn);
        }
        if ((xc = variableContext.getParameter("tokencount")) != null) {
            int i2 = 0;
            while (i2 < ds.getChildCount()) {
                sn = ds.getChild(i2);
                if (sn.getType().equals("access")) {
                    ds.removeChild(i2);
                    continue;
                }
                ++i2;
            }
            int accessCount = Integer.parseInt(xc);
            i2 = 0;
            while (i2 < accessCount) {
                String accessDescription = "_" + Integer.toString(i2);
                String accessOpName = "accessop" + accessDescription;
                xc = variableContext.getParameter(accessOpName);
                if (xc != null && xc.equals("Delete")) {
                    ++i2;
                    continue;
                }
                String accessSpec = variableContext.getParameter("spectoken" + accessDescription);
                SpecificationNode node = new SpecificationNode("access");
                node.setAttribute("token", accessSpec);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node);
                ++i2;
            }
            String op = variableContext.getParameter("accessop");
            if (op != null && op.equals("Add")) {
                String accessspec = variableContext.getParameter("spectoken");
                SpecificationNode node = new SpecificationNode("access");
                node.setAttribute("token", accessspec);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node);
            }
        }
        return null;
    }

    public void viewSpecification(IHTTPOutput out, DocumentSpecification ds) throws ManifoldCFException, IOException {
        String idQuery = "";
        String versionQuery = "";
        String dataQuery = "";
        int i = 0;
        while (i < ds.getChildCount()) {
            SpecificationNode sn;
            if ((sn = ds.getChild(i++)).getType().equals(JDBCConstants.idQueryNode)) {
                idQuery = sn.getValue();
                if (idQuery != null) continue;
                idQuery = "";
                continue;
            }
            if (sn.getType().equals(JDBCConstants.versionQueryNode)) {
                versionQuery = sn.getValue();
                if (versionQuery != null) continue;
                versionQuery = "";
                continue;
            }
            if (!sn.getType().equals(JDBCConstants.dataQueryNode) || (dataQuery = sn.getValue()) != null) continue;
            dataQuery = "";
        }
        out.print("<table class=\"displaytable\">\n  <tr>\n    <td class=\"description\"><nobr>Seeding query:</nobr></td>\n    <td class=\"value\">" + Encoder.bodyEscape((String)idQuery) + "</td>\n" + "  </tr>\n" + "  <tr>\n" + "    <td class=\"description\"><nobr>Version check query:</nobr></td>\n" + "    <td class=\"value\">" + Encoder.bodyEscape((String)versionQuery) + "</td>\n" + "  </tr>\n" + "  <tr>\n" + "    <td class=\"description\"><nobr>Data query:</nobr></td>\n" + "    <td class=\"value\">" + Encoder.bodyEscape((String)dataQuery) + "</td>\n" + "  </tr>\n" + "\n" + "  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n");
        boolean seenAny = false;
        i = 0;
        while (i < ds.getChildCount()) {
            SpecificationNode sn;
            if (!(sn = ds.getChild(i++)).getType().equals("access")) continue;
            if (!seenAny) {
                out.print("  <tr><td class=\"description\"><nobr>Access tokens:</nobr></td>\n    <td class=\"value\">\n");
                seenAny = true;
            }
            String token = sn.getAttributeValue("token");
            out.print("      " + Encoder.bodyEscape((String)token) + "<br/>\n");
        }
        if (seenAny) {
            out.print("    </td>\n  </tr>\n");
        } else {
            out.print("  <tr><td class=\"message\" colspan=\"2\"><nobr>No access tokens specified</nobr></td></tr>\n");
        }
        out.print("</table>\n");
    }

    protected void applyMetadata(RepositoryDocument rd, IResultRow row) throws ManifoldCFException {
        Iterator iter = row.getColumns();
        while (iter.hasNext()) {
            String columnName = (String)iter.next();
            if (documentKnownColumns.get(columnName) != null) continue;
            Object metadata = row.getValue(columnName);
            if (metadata instanceof BinaryInput) {
                throw new ManifoldCFException("Metadata column '" + columnName + "' must be convertible to a string, and cannot be binary");
            }
            rd.addField(columnName, metadata.toString());
        }
    }

    protected void applyAccessTokens(RepositoryDocument rd, String version, DocumentSpecification spec) throws ManifoldCFException {
        String[] accessAcls = null;
        String[] denyAcls = null;
        if (version.length() == 0) {
            String[] specAcls;
            accessAcls = specAcls = JDBCConnector.getAcls(spec);
            denyAcls = specAcls.length != 0 ? new String[]{defaultAuthorityDenyToken} : new String[]{};
        } else {
            ArrayList acls = new ArrayList();
            StringBuffer denyAclBuffer = new StringBuffer();
            int startPos = JDBCConnector.unpackList(acls, version, 0, '+');
            if (startPos < version.length() && version.charAt(startPos++) == '+') {
                startPos = JDBCConnector.unpack(denyAclBuffer, version, startPos, '+');
            }
            accessAcls = new String[acls.size()];
            for (int j = 0; j < accessAcls.length; ++j) {
                accessAcls[j] = (String)acls.get(j);
            }
            if (denyAclBuffer.length() > 0) {
                denyAcls = new String[]{denyAclBuffer.toString()};
            }
        }
        if (accessAcls != null) {
            rd.setACL(accessAcls);
        }
        if (denyAcls != null) {
            rd.setDenyACL(denyAcls);
        }
    }

    public int getMaxDocumentRequest() {
        return 100;
    }

    protected static void addVariable(VariableMap map, String varName, long variable) {
        ArrayList<Long> params = new ArrayList<Long>();
        params.add(new Long(variable));
        map.addVariable(varName, "?", params);
    }

    protected static void addVariable(VariableMap map, String varName, String variable) {
        ArrayList<String> params = new ArrayList<String>();
        params.add(variable);
        map.addVariable(varName, "?", params);
    }

    protected static void addConstant(VariableMap map, String varName, String value) {
        map.addVariable(varName, value, null);
    }

    protected static boolean addIDList(VariableMap map, String varName, String[] documentIdentifiers, boolean[] scanOnly) {
        ArrayList<String> params = new ArrayList<String>();
        StringBuffer sb = new StringBuffer(" (");
        int k = 0;
        for (int i = 0; i < documentIdentifiers.length; ++i) {
            if (scanOnly != null && scanOnly[i]) continue;
            if (k > 0) {
                sb.append(",");
            }
            String documentIdentifier = documentIdentifiers[i];
            sb.append("?");
            params.add(documentIdentifier);
            ++k;
        }
        sb.append(") ");
        map.addVariable(varName, sb.toString(), params);
        return k > 0;
    }

    protected static void substituteQuery(String inputString, VariableMap inputMap, StringBuffer outputQuery, ArrayList outputParams) throws ManifoldCFException {
        int startIndex = 0;
        while (true) {
            int nextIndex;
            if ((nextIndex = inputString.indexOf("$(", startIndex)) == -1) {
                outputQuery.append(inputString.substring(startIndex));
                break;
            }
            int endIndex = inputString.indexOf(")", nextIndex);
            if (endIndex == -1) {
                outputQuery.append(inputString.substring(startIndex));
                break;
            }
            String variableName = inputString.substring(nextIndex + 2, endIndex);
            VariableMapItem item = inputMap.getVariable(variableName);
            if (item == null) {
                throw new ManifoldCFException("No such substitution variable: $(" + variableName + ")");
            }
            outputQuery.append(inputString.substring(startIndex, nextIndex));
            outputQuery.append(item.getValue());
            ArrayList inputParams = item.getParameters();
            if (inputParams != null) {
                int i = 0;
                while (i < inputParams.size()) {
                    Object x = inputParams.get(i++);
                    outputParams.add(x);
                }
            }
            startIndex = endIndex + 1;
        }
    }

    protected static String[] getAcls(DocumentSpecification spec) {
        HashMap<String, String> map = new HashMap<String, String>();
        int i = 0;
        while (i < spec.getChildCount()) {
            SpecificationNode sn;
            if (!(sn = spec.getChild(i++)).getType().equals("access")) continue;
            String token = sn.getAttributeValue("token");
            map.put(token, token);
        }
        String[] rval = new String[map.size()];
        Iterator iter = map.keySet().iterator();
        i = 0;
        while (iter.hasNext()) {
            rval[i++] = (String)iter.next();
        }
        return rval;
    }

    protected static void pack(StringBuffer output, String value, char delimiter) {
        int i = 0;
        while (i < value.length()) {
            char x;
            if ((x = value.charAt(i++)) == '\\' || x == delimiter) {
                output.append('\\');
            }
            output.append(x);
        }
        output.append(delimiter);
    }

    protected static int unpack(StringBuffer sb, String value, int startPosition, char delimiter) {
        while (startPosition < value.length()) {
            char x;
            if ((x = value.charAt(startPosition++)) == '\\') {
                if (startPosition < value.length()) {
                    x = value.charAt(startPosition++);
                }
            } else if (x == delimiter) break;
            sb.append(x);
        }
        return startPosition;
    }

    protected static void packFixedList(StringBuffer output, String[] values, char delimiter) {
        int i = 0;
        while (i < values.length) {
            JDBCConnector.pack(output, values[i++], delimiter);
        }
    }

    protected static int unpackFixedList(String[] output, String value, int startPosition, char delimiter) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < output.length) {
            sb.setLength(0);
            startPosition = JDBCConnector.unpack(sb, value, startPosition, delimiter);
            output[i++] = sb.toString();
        }
        return startPosition;
    }

    protected static void packList(StringBuffer output, ArrayList values, char delimiter) {
        JDBCConnector.pack(output, Integer.toString(values.size()), delimiter);
        int i = 0;
        while (i < values.size()) {
            JDBCConnector.pack(output, values.get(i++).toString(), delimiter);
        }
    }

    protected static void packList(StringBuffer output, String[] values, char delimiter) {
        JDBCConnector.pack(output, Integer.toString(values.length), delimiter);
        int i = 0;
        while (i < values.length) {
            JDBCConnector.pack(output, values[i++], delimiter);
        }
    }

    protected static int unpackList(ArrayList output, String value, int startPosition, char delimiter) {
        StringBuffer sb = new StringBuffer();
        startPosition = JDBCConnector.unpack(sb, value, startPosition, delimiter);
        try {
            int count = Integer.parseInt(sb.toString());
            for (int i = 0; i < count; ++i) {
                sb.setLength(0);
                startPosition = JDBCConnector.unpack(sb, value, startPosition, delimiter);
                output.add(sb.toString());
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        return startPosition;
    }

    protected static String createQueryString(String queryText, ArrayList paramList) {
        StringBuffer sb = new StringBuffer(queryText);
        sb.append("; arguments = (");
        int i = 0;
        while (i < paramList.size()) {
            Object parameter;
            if (i > 0) {
                sb.append(",");
            }
            if ((parameter = paramList.get(i++)) instanceof String) {
                sb.append(JDBCConnector.quoteSQLString((String)parameter));
                continue;
            }
            sb.append(parameter.toString());
        }
        sb.append(")");
        return sb.toString();
    }

    protected static String quoteSQLString(String input) {
        StringBuffer sb = new StringBuffer("'");
        int i = 0;
        while (i < input.length()) {
            char x;
            if ((x = input.charAt(i++)) == '\'') {
                sb.append('\'').append(x);
                continue;
            }
            if (x >= '\u0000' && x < ' ') {
                sb.append(' ');
                continue;
            }
            sb.append(x);
        }
        sb.append("'");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String readAsString(Object o) throws ManifoldCFException {
        if (o instanceof BinaryInput) {
            BinaryInput bi = (BinaryInput)o;
            try {
                String string;
                InputStream is = bi.getStream();
                try {
                    int x;
                    InputStreamReader reader = new InputStreamReader(is, "utf-8");
                    StringBuffer sb = new StringBuffer();
                    while ((x = reader.read()) != -1) {
                        sb.append((char)x);
                    }
                    string = sb.toString();
                }
                catch (Throwable throwable) {
                    try {
                        is.close();
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new ManifoldCFException(e.getMessage(), (Throwable)e);
                    }
                }
                is.close();
                return string;
            }
            finally {
                bi.doneWithStream();
            }
        }
        return o.toString();
    }

    static {
        documentKnownColumns.put(JDBCConstants.idReturnColumnName, "");
        documentKnownColumns.put(JDBCConstants.urlReturnColumnName, "");
        documentKnownColumns.put(JDBCConstants.dataReturnColumnName, "");
    }

    protected static class TableSpec {
        public String idQuery;
        public String versionQuery;
        public String dataQuery;

        public TableSpec(DocumentSpecification ds) {
            int i = 0;
            while (i < ds.getChildCount()) {
                SpecificationNode sn;
                if ((sn = ds.getChild(i++)).getType().equals(JDBCConstants.idQueryNode)) {
                    this.idQuery = sn.getValue();
                    if (this.idQuery != null) continue;
                    this.idQuery = "";
                    continue;
                }
                if (sn.getType().equals(JDBCConstants.versionQueryNode)) {
                    this.versionQuery = sn.getValue();
                    if (this.versionQuery != null) continue;
                    this.versionQuery = "";
                    continue;
                }
                if (!sn.getType().equals(JDBCConstants.dataQueryNode)) continue;
                this.dataQuery = sn.getValue();
                if (this.dataQuery != null) continue;
                this.dataQuery = "";
            }
        }
    }

    protected static class VariableMap {
        protected Map variableMap = new HashMap();

        public void addVariable(String variableName, String value, ArrayList parameters) {
            VariableMapItem e = new VariableMapItem(value, parameters);
            this.variableMap.put(variableName, e);
        }

        public VariableMapItem getVariable(String variableName) {
            return (VariableMapItem)this.variableMap.get(variableName);
        }
    }

    protected static class VariableMapItem {
        protected String value;
        protected ArrayList params;

        public VariableMapItem(String value, ArrayList params) {
            this.value = value;
            this.params = params;
        }

        public String getValue() {
            return this.value;
        }

        public ArrayList getParameters() {
            return this.params;
        }
    }
}

