/*
 * Decompiled with CFR 0.152.
 */
package com.anotherbigidea.flash.readers;

import com.anotherbigidea.flash.SWFActionCodes;
import com.anotherbigidea.flash.interfaces.SWFActions;
import com.anotherbigidea.io.InStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

public class ActionParser
implements SWFActionCodes {
    protected SWFActions actions;
    protected int blockDepth = 0;
    protected String mStringEncoding = "UTF-8";

    public ActionParser(SWFActions sWFActions, int n) {
        this.actions = sWFActions;
        if (n < 6) {
            this.mStringEncoding = "US-ASCII";
        }
    }

    public synchronized void parse(byte[] byArray) throws IOException {
        Vector vector = this.createRecords(byArray);
        this.processRecords(vector);
    }

    public synchronized void parse(InStream inStream) throws IOException {
        Vector vector = this.createRecords(inStream);
        this.processRecords(vector);
    }

    protected void processRecords(Vector vector) throws IOException {
        Enumeration enumeration = vector.elements();
        block96: while (enumeration.hasMoreElements()) {
            ActionRecord actionRecord = (ActionRecord)enumeration.nextElement();
            if (actionRecord.blockDepth < this.blockDepth) {
                --this.blockDepth;
                this.actions.endBlock();
            }
            if (actionRecord.label != null) {
                this.actions.jumpLabel(actionRecord.label);
            }
            int n = actionRecord.code;
            byte[] byArray = actionRecord.data;
            InStream inStream = byArray != null && byArray.length > 0 ? new InStream(byArray) : null;
            switch (n) {
                case 0: {
                    this.actions.end();
                    continue block96;
                }
                case 129: {
                    this.actions.gotoFrame(inStream.readUI16());
                    continue block96;
                }
                case 131: {
                    this.actions.getURL(inStream.readString(this.mStringEncoding), inStream.readString(this.mStringEncoding));
                    continue block96;
                }
                case 4: {
                    this.actions.nextFrame();
                    continue block96;
                }
                case 5: {
                    this.actions.prevFrame();
                    continue block96;
                }
                case 6: {
                    this.actions.play();
                    continue block96;
                }
                case 7: {
                    this.actions.stop();
                    continue block96;
                }
                case 8: {
                    this.actions.toggleQuality();
                    continue block96;
                }
                case 9: {
                    this.actions.stopSounds();
                    continue block96;
                }
                case 138: {
                    this.actions.waitForFrame(inStream.readUI16(), actionRecord.jumpLabel);
                    continue block96;
                }
                case 139: {
                    this.actions.setTarget(inStream.readString(this.mStringEncoding));
                    continue block96;
                }
                case 140: {
                    this.actions.gotoFrame(inStream.readString(this.mStringEncoding));
                    continue block96;
                }
                case 157: {
                    this.actions.ifJump(actionRecord.jumpLabel);
                    continue block96;
                }
                case 153: {
                    this.actions.jump(actionRecord.jumpLabel);
                    continue block96;
                }
                case 141: {
                    this.actions.waitForFrame(actionRecord.jumpLabel);
                    continue block96;
                }
                case 23: {
                    this.actions.pop();
                    continue block96;
                }
                case 150: {
                    this.parsePush(byArray.length, inStream);
                    continue block96;
                }
                case 10: {
                    this.actions.add();
                    continue block96;
                }
                case 11: {
                    this.actions.substract();
                    continue block96;
                }
                case 12: {
                    this.actions.multiply();
                    continue block96;
                }
                case 13: {
                    this.actions.divide();
                    continue block96;
                }
                case 14: {
                    this.actions.equals();
                    continue block96;
                }
                case 15: {
                    this.actions.lessThan();
                    continue block96;
                }
                case 16: {
                    this.actions.and();
                    continue block96;
                }
                case 17: {
                    this.actions.or();
                    continue block96;
                }
                case 18: {
                    this.actions.not();
                    continue block96;
                }
                case 19: {
                    this.actions.stringEquals();
                    continue block96;
                }
                case 20: {
                    this.actions.stringLength();
                    continue block96;
                }
                case 33: {
                    this.actions.concat();
                    continue block96;
                }
                case 21: {
                    this.actions.substring();
                    continue block96;
                }
                case 41: {
                    this.actions.stringLessThan();
                    continue block96;
                }
                case 53: {
                    this.actions.substringMB();
                    continue block96;
                }
                case 49: {
                    this.actions.stringLengthMB();
                    continue block96;
                }
                case 24: {
                    this.actions.toInteger();
                    continue block96;
                }
                case 50: {
                    this.actions.charToAscii();
                    continue block96;
                }
                case 51: {
                    this.actions.asciiToChar();
                    continue block96;
                }
                case 54: {
                    this.actions.charMBToAscii();
                    continue block96;
                }
                case 55: {
                    this.actions.asciiToCharMB();
                    continue block96;
                }
                case 158: {
                    this.actions.call();
                    continue block96;
                }
                case 28: {
                    this.actions.getVariable();
                    continue block96;
                }
                case 29: {
                    this.actions.setVariable();
                    continue block96;
                }
                case 154: {
                    this.parseGetURL2(inStream.readUI8());
                    continue block96;
                }
                case 159: {
                    this.actions.gotoFrame(inStream.readUI8() != 0);
                    continue block96;
                }
                case 32: {
                    this.actions.setTarget();
                    continue block96;
                }
                case 34: {
                    this.actions.getProperty();
                    continue block96;
                }
                case 35: {
                    this.actions.setProperty();
                    continue block96;
                }
                case 36: {
                    this.actions.cloneSprite();
                    continue block96;
                }
                case 37: {
                    this.actions.removeSprite();
                    continue block96;
                }
                case 39: {
                    this.actions.startDrag();
                    continue block96;
                }
                case 40: {
                    this.actions.endDrag();
                    continue block96;
                }
                case 38: {
                    this.actions.trace();
                    continue block96;
                }
                case 52: {
                    this.actions.getTime();
                    continue block96;
                }
                case 48: {
                    this.actions.randomNumber();
                    continue block96;
                }
                case 66: {
                    this.actions.initArray();
                    continue block96;
                }
                case 136: {
                    this.parseLookupTable(inStream);
                    continue block96;
                }
                case 61: {
                    this.actions.callFunction();
                    continue block96;
                }
                case 82: {
                    this.actions.callMethod();
                    continue block96;
                }
                case 155: {
                    this.parseDefineFunction(inStream);
                    continue block96;
                }
                case 60: {
                    this.actions.defineLocalValue();
                    continue block96;
                }
                case 65: {
                    this.actions.defineLocal();
                    continue block96;
                }
                case 58: {
                    this.actions.deleteProperty();
                    continue block96;
                }
                case 59: {
                    this.actions.deleteThreadVars();
                    continue block96;
                }
                case 70: {
                    this.actions.enumerate();
                    continue block96;
                }
                case 73: {
                    this.actions.typedEquals();
                    continue block96;
                }
                case 78: {
                    this.actions.getMember();
                    continue block96;
                }
                case 67: {
                    this.actions.initObject();
                    continue block96;
                }
                case 83: {
                    this.actions.newMethod();
                    continue block96;
                }
                case 64: {
                    this.actions.newObject();
                    continue block96;
                }
                case 79: {
                    this.actions.setMember();
                    continue block96;
                }
                case 69: {
                    this.actions.getTargetPath();
                    continue block96;
                }
                case 148: {
                    this.parseWith(inStream);
                    continue block96;
                }
                case 76: {
                    this.actions.duplicate();
                    continue block96;
                }
                case 62: {
                    this.actions.returnValue();
                    continue block96;
                }
                case 77: {
                    this.actions.swap();
                    continue block96;
                }
                case 135: {
                    this.actions.storeInRegister(inStream.readUI8());
                    continue block96;
                }
                case 63: {
                    this.actions.modulo();
                    continue block96;
                }
                case 68: {
                    this.actions.typeOf();
                    continue block96;
                }
                case 71: {
                    this.actions.typedAdd();
                    continue block96;
                }
                case 72: {
                    this.actions.typedLessThan();
                    continue block96;
                }
                case 74: {
                    this.actions.convertToNumber();
                    continue block96;
                }
                case 75: {
                    this.actions.convertToString();
                    continue block96;
                }
                case 80: {
                    this.actions.increment();
                    continue block96;
                }
                case 81: {
                    this.actions.decrement();
                    continue block96;
                }
                case 96: {
                    this.actions.bitAnd();
                    continue block96;
                }
                case 97: {
                    this.actions.bitOr();
                    continue block96;
                }
                case 98: {
                    this.actions.bitXor();
                    continue block96;
                }
                case 99: {
                    this.actions.shiftLeft();
                    continue block96;
                }
                case 100: {
                    this.actions.shiftRight();
                    continue block96;
                }
                case 101: {
                    this.actions.shiftRightUnsigned();
                    continue block96;
                }
                case 84: {
                    this.actions.instanceOf();
                    continue block96;
                }
                case 85: {
                    this.actions.enumerateObject();
                    continue block96;
                }
                case 103: {
                    this.actions.greaterThan();
                    continue block96;
                }
                case 102: {
                    this.actions.strictEquals();
                    continue block96;
                }
                case 104: {
                    this.actions.stringGreaterThan();
                    continue block96;
                }
            }
            this.actions.unknown(n, byArray);
        }
    }

    protected void parseDefineFunction(InStream inStream) throws IOException {
        int n;
        String string = inStream.readString(this.mStringEncoding);
        int n2 = inStream.readUI16();
        String[] stringArray = new String[n2];
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n] = inStream.readString(this.mStringEncoding);
        }
        n = inStream.readUI16();
        this.actions.startFunction(string, stringArray);
        if (n == 0) {
            this.actions.endBlock();
            return;
        }
        ++this.blockDepth;
    }

    protected void parseWith(InStream inStream) throws IOException {
        int n = inStream.readUI16();
        this.actions.startWith();
        if (n == 0) {
            this.actions.endBlock();
            return;
        }
        ++this.blockDepth;
    }

    protected void parseLookupTable(InStream inStream) throws IOException {
        String[] stringArray = new String[inStream.readUI16()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = inStream.readString(this.mStringEncoding);
        }
        this.actions.lookupTable(stringArray);
    }

    protected void parseGetURL2(int n) throws IOException {
        int n2 = n & 3;
        int n3 = 0;
        switch (n & 0xF0) {
            case 64: {
                n3 = 1;
                break;
            }
            case 128: {
                n3 = 3;
                break;
            }
            case 192: {
                n3 = 4;
                break;
            }
            default: {
                n3 = 0;
            }
        }
        this.actions.getURL(n2, n3);
    }

    protected void parsePush(int n, InStream inStream) throws IOException {
        block11: while (inStream.getBytesRead() < (long)n) {
            int n2 = inStream.readUI8();
            switch (n2) {
                case 0: {
                    this.actions.push(inStream.readString(this.mStringEncoding));
                    continue block11;
                }
                case 1: {
                    this.actions.push(inStream.readFloat());
                    continue block11;
                }
                case 2: {
                    this.actions.pushNull();
                    continue block11;
                }
                case 3: {
                    continue block11;
                }
                case 4: {
                    this.actions.pushRegister(inStream.readUI8());
                    continue block11;
                }
                case 5: {
                    this.actions.push(inStream.readUI8() != 0);
                    continue block11;
                }
                case 6: {
                    this.actions.push(inStream.readDouble());
                    continue block11;
                }
                case 7: {
                    this.actions.push(inStream.readSI32());
                    continue block11;
                }
                case 8: {
                    this.actions.lookup(inStream.readUI8());
                    continue block11;
                }
            }
        }
    }

    protected Vector createRecords(byte[] byArray) throws IOException {
        return this.createRecords(new InStream(byArray));
    }

    protected Vector createRecords(InStream inStream) throws IOException {
        int n;
        Object object;
        int n2;
        Vector<ActionRecord> vector = new Vector<ActionRecord>();
        Vector<ActionRecord> vector2 = new Vector<ActionRecord>();
        Vector<Integer> vector3 = new Vector<Integer>();
        Hashtable<Integer, ActionRecord> hashtable = new Hashtable<Integer, ActionRecord>();
        Stack<int[]> stack = new Stack<int[]>();
        int n3 = 0;
        while (true) {
            int n4;
            int n5;
            int n6 = (int)inStream.getBytesRead();
            n2 = inStream.readUI8();
            int n7 = n2 >= 128 ? inStream.readUI16() : 0;
            object = n7 > 0 ? inStream.read(n7) : null;
            ActionRecord actionRecord = new ActionRecord(n6, n2, (byte[])object);
            vector.addElement(actionRecord);
            hashtable.put(new Integer(n6), actionRecord);
            if (!stack.isEmpty()) {
                actionRecord.blockDepth = n = stack.size();
                n5 = n7 > 0 ? n7 + 3 : 1;
                for (n4 = n - 1; n4 >= 0; --n4) {
                    int[] nArray = (int[])stack.elementAt(n4);
                    int n8 = nArray[0];
                    if ((n8 -= n5) <= 0) {
                        stack.pop();
                        continue;
                    }
                    nArray[0] = n8;
                }
            }
            if (n2 == 0) break;
            if (n2 == 155) {
                InStream inStream2 = new InStream(actionRecord.data);
                inStream2.readString(this.mStringEncoding);
                n5 = inStream2.readUI16();
                for (n4 = 0; n4 < n5; ++n4) {
                    inStream2.readString(this.mStringEncoding);
                }
                n4 = inStream2.readUI16();
                stack.push(new int[]{n4});
                continue;
            }
            if (n2 == 148) {
                InStream inStream3 = new InStream(actionRecord.data);
                n5 = inStream3.readUI16();
                stack.push(new int[]{n5});
                continue;
            }
            if (n2 == 138 || n2 == 141) {
                vector3.addElement(new Integer(vector.size() - 1));
                continue;
            }
            if (n2 != 157 && n2 != 153) continue;
            vector2.addElement(actionRecord);
        }
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            ActionRecord actionRecord = (ActionRecord)enumeration.nextElement();
            int n9 = actionRecord.offset + 5;
            InStream inStream4 = new InStream(actionRecord.data);
            short s = inStream4.readSI16();
            n = n9 + s;
            ActionRecord actionRecord2 = (ActionRecord)hashtable.get(new Integer(n));
            if (actionRecord2 == null) continue;
            if (actionRecord2.label == null) {
                actionRecord2.label = actionRecord.jumpLabel = "label" + n3++;
                continue;
            }
            actionRecord.jumpLabel = actionRecord2.label;
        }
        enumeration = vector3.elements();
        while (enumeration.hasMoreElements()) {
            int n10;
            n2 = (Integer)enumeration.nextElement();
            ActionRecord actionRecord = (ActionRecord)vector.elementAt(n2);
            object = new InStream(actionRecord.data);
            if (actionRecord.code == 138) {
                ((InStream)object).readUI16();
            }
            if ((n = n2 + (n10 = ((InStream)object).readUI8()) + 1) >= vector.size()) continue;
            ActionRecord actionRecord3 = (ActionRecord)vector.elementAt(n);
            if (actionRecord3.label == null) {
                actionRecord3.label = actionRecord.jumpLabel = "label" + n3++;
                continue;
            }
            actionRecord.jumpLabel = actionRecord3.label;
        }
        return vector;
    }

    protected static class ActionRecord {
        public int offset;
        public int code;
        public String label;
        public String jumpLabel;
        public byte[] data;
        public int blockDepth = 0;

        protected ActionRecord(int n, int n2, byte[] byArray) {
            this.offset = n;
            this.code = n2;
            this.data = byArray;
        }
    }
}

