/*
 * Decompiled with CFR 0.152.
 */
package com.anotherbigidea.flash.sound;

import com.anotherbigidea.flash.interfaces.SWFActions;
import com.anotherbigidea.flash.movie.Frame;
import com.anotherbigidea.flash.movie.Movie;
import com.anotherbigidea.flash.movie.Sound;
import com.anotherbigidea.flash.sound.ADPCMEncodeStream;
import com.anotherbigidea.flash.sound.SoundStreamHead;
import com.anotherbigidea.flash.structs.Color;
import com.anotherbigidea.flash.writers.SWFWriter;
import com.anotherbigidea.flash.writers.TagWriter;
import com.anotherbigidea.io.OutStream;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;

public class ADPCMHelper {
    protected AudioInputStream audioIn;
    protected boolean isStereo;
    protected boolean is16Bit;
    protected int sampleRate;
    protected int rate;
    protected int samplesPerFrame;
    protected boolean isSigned;
    protected int sampleCount = 0;
    protected ADPCMEncodeStream leftEncoder;
    protected ADPCMEncodeStream rightEncoder;
    protected ADPCMPacket currentPacket;

    public ADPCMHelper(InputStream inputStream, int n) throws IOException, UnsupportedAudioFileException {
        this.audioIn = AudioSystem.getAudioInputStream(new BufferedInputStream(inputStream));
        AudioFormat audioFormat = this.audioIn.getFormat();
        int n2 = audioFormat.getFrameSize();
        this.isStereo = audioFormat.getChannels() == 2;
        this.is16Bit = audioFormat.getSampleSizeInBits() > 8;
        this.sampleRate = (int)audioFormat.getSampleRate();
        boolean bl = this.isSigned = audioFormat.getEncoding() == AudioFormat.Encoding.PCM_SIGNED;
        this.sampleRate = this.sampleRate >= 44000 ? 44000 : (this.sampleRate >= 22000 ? 22000 : (this.sampleRate >= 11000 ? 11000 : 5500));
        this.rate = 0;
        if (this.sampleRate == 44000) {
            this.rate = 3;
        } else if (this.sampleRate == 22000) {
            this.rate = 2;
        } else if (this.sampleRate == 11000) {
            this.rate = 1;
        }
        this.samplesPerFrame = this.sampleRate / n;
        FramedInputStream framedInputStream = new FramedInputStream(this.audioIn, n2);
        this.leftEncoder = new ADPCMEncodeStream(framedInputStream, this.is16Bit, this.isSigned);
        if (this.isStereo) {
            this.rightEncoder = new ADPCMEncodeStream(framedInputStream, this.is16Bit, this.isSigned);
        }
    }

    public Sound getSoundDefinition() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutStream outStream = new OutStream(byteArrayOutputStream);
        this.sampleCount = 0;
        boolean bl = true;
        Object object = this.readPacket(4096);
        while (object != null) {
            this.sampleCount += ((ADPCMPacket)object).sampleCount + 1;
            this.writePacket((ADPCMPacket)object, outStream, bl);
            bl = false;
            object = this.readPacket(4096);
        }
        outStream.flush();
        object = byteArrayOutputStream.toByteArray();
        return new Sound(1, this.rate, true, this.isStereo, this.sampleCount, (byte[])object);
    }

    public ADPCMPacket readPacket(int n) throws IOException {
        ADPCMPacket aDPCMPacket = new ADPCMPacket();
        aDPCMPacket.initialLeftSample = this.leftEncoder.getFirstPacketSample();
        if (this.leftEncoder.isDone()) {
            return null;
        }
        int n2 = 0;
        if (this.isStereo) {
            aDPCMPacket.initialRightSample = this.rightEncoder.getFirstPacketSample();
        }
        aDPCMPacket.initialLeftIndex = this.leftEncoder.setIndex(aDPCMPacket.initialLeftSample);
        if (this.isStereo) {
            aDPCMPacket.initialRightIndex = this.rightEncoder.setIndex(aDPCMPacket.initialRightSample);
        }
        aDPCMPacket.leftData = new int[n - 1];
        if (this.isStereo) {
            aDPCMPacket.rightData = new int[n - 1];
        }
        for (int i = 0; i < n - 1; ++i) {
            aDPCMPacket.leftData[i] = this.leftEncoder.getDelta();
            if (!this.leftEncoder.isDone()) {
                ++n2;
            }
            if (!this.isStereo) continue;
            aDPCMPacket.rightData[i] = this.rightEncoder.getDelta();
        }
        aDPCMPacket.sampleCount = n2;
        return aDPCMPacket;
    }

    public byte[] getBlockData(boolean bl) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutStream outStream = new OutStream(byteArrayOutputStream);
        this.currentPacket = this.readPacket(this.samplesPerFrame);
        if (this.currentPacket == null) {
            return null;
        }
        this.writePacket(this.currentPacket, outStream, true);
        outStream.flushBits();
        return byteArrayOutputStream.toByteArray();
    }

    public void writePacket(ADPCMPacket aDPCMPacket, OutStream outStream, boolean bl) throws IOException {
        if (aDPCMPacket == null) {
            return;
        }
        int n = aDPCMPacket.initialLeftSample;
        if (bl) {
            outStream.writeUBits(2, 2L);
        }
        outStream.writeUBits(16, n);
        outStream.writeUBits(6, aDPCMPacket.initialLeftIndex);
        if (this.isStereo) {
            n = aDPCMPacket.initialRightSample;
            outStream.writeUBits(16, n);
            outStream.writeUBits(6, aDPCMPacket.initialRightIndex);
        }
        for (int i = 0; i < aDPCMPacket.sampleCount; ++i) {
            outStream.writeUBits(4, aDPCMPacket.leftData[i]);
            if (!this.isStereo) continue;
            outStream.writeUBits(4, aDPCMPacket.rightData[i]);
        }
    }

    public SoundStreamHead getStreamHeader() {
        return new SoundStreamHead(this.rate, true, this.isStereo, 1, this.rate, true, this.isStereo, this.samplesPerFrame);
    }

    public static void main(String[] stringArray) throws Exception {
        FileInputStream fileInputStream = new FileInputStream(stringArray[0]);
        Movie movie = new Movie();
        movie.setFrameRate(30);
        ADPCMHelper aDPCMHelper = new ADPCMHelper(fileInputStream, 30);
        Frame frame = movie.appendFrame();
        Sound sound = aDPCMHelper.getSoundDefinition();
        int n = frame.startSound(sound, 30);
        while (n-- > 0) {
            frame = movie.appendFrame();
        }
        frame.stop();
        ((InputStream)fileInputStream).close();
        movie.write(stringArray[1]);
    }

    public static void main2(String[] stringArray) throws Exception {
        FileInputStream fileInputStream = new FileInputStream(stringArray[0]);
        SWFWriter sWFWriter = new SWFWriter(stringArray[1]);
        TagWriter tagWriter = new TagWriter(sWFWriter);
        tagWriter.header(5, -1L, 200, 200, 12, -1);
        tagWriter.tagSetBackgroundColor(new Color(255, 255, 255));
        ADPCMHelper aDPCMHelper = new ADPCMHelper(fileInputStream, 12);
        SoundStreamHead soundStreamHead = aDPCMHelper.getStreamHeader();
        soundStreamHead.write(tagWriter);
        byte[] byArray = aDPCMHelper.getBlockData(true);
        while (byArray != null) {
            tagWriter.tagSoundStreamBlock(byArray);
            tagWriter.tagShowFrame();
            byArray = aDPCMHelper.getBlockData(false);
        }
        SWFActions sWFActions = tagWriter.tagDoAction();
        sWFActions.start(0);
        sWFActions.stop();
        sWFActions.end();
        sWFActions.done();
        tagWriter.tagShowFrame();
        tagWriter.tagEnd();
        ((InputStream)fileInputStream).close();
    }

    public static class FramedInputStream
    extends InputStream {
        protected InputStream in;
        protected byte[] frameData;
        protected int dataPtr;
        protected int frameSize;
        protected boolean done = false;

        public FramedInputStream(InputStream inputStream, int n) {
            this.in = inputStream;
            this.frameSize = n;
            this.frameData = new byte[n];
            this.dataPtr = n;
        }

        public int read() throws IOException {
            if (this.dataPtr < this.frameData.length) {
                int n;
                if ((n = this.frameData[this.dataPtr++]) < 0) {
                    n += 256;
                }
                return n;
            }
            if (this.done) {
                return -1;
            }
            this.dataPtr = 0;
            int n = 0;
            while (this.dataPtr < this.frameSize && (n = this.in.read(this.frameData, this.dataPtr, this.frameSize - this.dataPtr)) >= 0) {
                this.dataPtr += n;
            }
            if (this.dataPtr == 0) {
                this.done = true;
                return -1;
            }
            while (this.dataPtr < this.frameData.length) {
                this.frameData[this.dataPtr++] = 0;
            }
            this.dataPtr = 0;
            return this.read();
        }
    }

    public class ADPCMPacket {
        public int initialLeftSample = 0;
        public int initialLeftIndex = 0;
        public int initialRightSample = 0;
        public int initialRightIndex = 0;
        public int[] leftData;
        public int[] rightData;
        public int sampleCount;
    }
}

