/*
 * Decompiled with CFR 0.152.
 */
package com.anotherbigidea.flash.sound;

import com.anotherbigidea.flash.movie.Frame;
import com.anotherbigidea.flash.movie.Movie;
import com.anotherbigidea.flash.movie.Sound;
import com.anotherbigidea.flash.sound.MP3Frame;
import com.anotherbigidea.flash.sound.SoundStreamHead;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;

public class MP3Helper {
    public static Sound getSoundDefinition(InputStream inputStream) throws IOException {
        MP3Frame mP3Frame = MP3Frame.readFrame(inputStream);
        int n = mP3Frame.getSamplesPerFrame();
        int n2 = mP3Frame.getSampleRate();
        boolean bl = mP3Frame.isStereo();
        int n3 = 0;
        if (n2 >= 44000) {
            n3 = 3;
        } else if (n2 >= 22000) {
            n3 = 2;
        } else if (n2 >= 11000) {
            n3 = 1;
        }
        int n4 = 0;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while (mP3Frame != null) {
            byteArrayOutputStream.write(0);
            byteArrayOutputStream.write(0);
            while (mP3Frame != null) {
                n4 += mP3Frame.getSamplesPerFrame();
                mP3Frame.write(byteArrayOutputStream);
                mP3Frame = MP3Frame.readFrame(inputStream);
            }
            byteArrayOutputStream.flush();
        }
        inputStream.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        return new Sound(2, n3, true, bl, n4, byArray);
    }

    public static SoundStreamHead streamingBlocks(InputStream inputStream, int n, ArrayList arrayList) throws IOException {
        MP3Frame mP3Frame = MP3Frame.readFrame(inputStream);
        int n2 = mP3Frame.getSamplesPerFrame();
        int n3 = mP3Frame.getSampleRate();
        int n4 = 0;
        int n5 = n3 / n;
        boolean bl = mP3Frame.isStereo();
        int n6 = 0;
        if (n3 >= 44000) {
            n6 = 3;
        } else if (n3 >= 22000) {
            n6 = 2;
        } else if (n3 >= 11000) {
            n6 = 1;
        }
        SoundStreamHead soundStreamHead = new SoundStreamHead(n6, true, bl, 2, n6, true, bl, n5);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while (mP3Frame != null) {
            byteArrayOutputStream.write(0);
            byteArrayOutputStream.write(0);
            byteArrayOutputStream.write(0);
            byteArrayOutputStream.write(0);
            int n7 = 0;
            int n8 = n5 * (arrayList.size() + 1);
            while (mP3Frame != null && n4 + n7 < n8) {
                n7 += mP3Frame.getSamplesPerFrame();
                mP3Frame.write(byteArrayOutputStream);
                mP3Frame = MP3Frame.readFrame(inputStream);
            }
            byteArrayOutputStream.flush();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            byArray[0] = (byte)(n7 & 0xFF);
            byArray[1] = (byte)(n7 >> 8);
            n4 += n7;
            arrayList.add(byArray);
            byteArrayOutputStream.reset();
        }
        inputStream.close();
        double d = (double)n4 / (double)n3;
        int n9 = (int)(d * (double)n);
        System.out.println("Required=" + n9 + " actual=" + arrayList.size());
        while (arrayList.size() < n9) {
            arrayList.add(null);
        }
        return soundStreamHead;
    }

    public static void main(String[] stringArray) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(stringArray[0]);
        ArrayList arrayList = new ArrayList();
        SoundStreamHead soundStreamHead = MP3Helper.streamingBlocks(fileInputStream, 30, arrayList);
        Movie movie = new Movie();
        movie.setFrameRate(30);
        Frame frame = movie.appendFrame();
        frame.setSoundHeader(soundStreamHead);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            byte[] byArray = (byte[])iterator.next();
            frame.setSoundData(byArray);
            frame = movie.appendFrame();
        }
        movie.write(stringArray[1]);
    }
}

