/*
 * Decompiled with CFR 0.152.
 */
package com.anotherbigidea.flash.structs;

import com.anotherbigidea.io.InStream;
import com.anotherbigidea.io.OutStream;
import java.io.IOException;

public class Rect {
    protected int bitSize = -1;
    protected int minX;
    protected int minY;
    protected int maxX;
    protected int maxY;

    public int getMinX() {
        return this.minX;
    }

    public int getMinY() {
        return this.minY;
    }

    public int getMaxX() {
        return this.maxX;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public void setMinX(int n) {
        this.minX = n;
        this.bitSize = -1;
    }

    public void setMinY(int n) {
        this.minY = n;
        this.bitSize = -1;
    }

    public void setMaxX(int n) {
        this.maxX = n;
        this.bitSize = -1;
    }

    public void setMaxY(int n) {
        this.maxY = n;
        this.bitSize = -1;
    }

    public Rect(int n, int n2, int n3, int n4) {
        this.minX = n;
        this.minY = n2;
        this.maxX = n3;
        this.maxY = n4;
    }

    public Rect(InStream inStream) throws IOException {
        inStream.synchBits();
        this.bitSize = (int)inStream.readUBits(5);
        this.minX = inStream.readSBits(this.bitSize);
        this.maxX = inStream.readSBits(this.bitSize);
        this.minY = inStream.readSBits(this.bitSize);
        this.maxY = inStream.readSBits(this.bitSize);
    }

    public Rect() {
        this(0, 0, 11000, 8000);
    }

    protected int getBitSize() {
        if (this.bitSize == -1) {
            int n = OutStream.determineSignedBitSize(this.minX);
            int n2 = OutStream.determineSignedBitSize(this.maxX);
            int n3 = OutStream.determineSignedBitSize(this.minY);
            int n4 = OutStream.determineSignedBitSize(this.maxY);
            this.bitSize = n3;
            if (this.bitSize < n2) {
                this.bitSize = n2;
            }
            if (this.bitSize < n) {
                this.bitSize = n;
            }
            if (this.bitSize < n4) {
                this.bitSize = n4;
            }
        }
        return this.bitSize;
    }

    public long getLength() {
        int n = 5 + this.getBitSize() * 4;
        int n2 = n / 8;
        if (n2 * 8 < n) {
            ++n2;
        }
        return n2;
    }

    public void write(OutStream outStream) throws IOException {
        outStream.flushBits();
        outStream.writeUBits(5, this.getBitSize());
        outStream.writeSBits(this.bitSize, this.minX);
        outStream.writeSBits(this.bitSize, this.maxX);
        outStream.writeSBits(this.bitSize, this.minY);
        outStream.writeSBits(this.bitSize, this.maxY);
        outStream.flushBits();
    }

    public String toString() {
        return "Rect bitsize=" + this.bitSize + " (" + this.minX + "," + this.minY + ")-(" + this.maxX + "," + this.maxY + ")";
    }
}

