/*
 * Decompiled with CFR 0.152.
 */
package com.anotherbigidea.flash.structs;

import com.anotherbigidea.io.InStream;
import com.anotherbigidea.io.OutStream;
import java.io.IOException;

public class SoundInfo {
    protected boolean noMultiplePlay;
    protected boolean stopPlaying;
    protected EnvelopePoint[] envelope;
    protected int inPoint;
    protected int outPoint;
    protected int loopCount;

    public SoundInfo(boolean bl, boolean bl2, EnvelopePoint[] envelopePointArray, int n, int n2, int n3) {
        this.noMultiplePlay = bl;
        this.stopPlaying = bl2;
        this.envelope = envelopePointArray;
        this.inPoint = n;
        this.outPoint = n2;
        this.loopCount = n3;
    }

    public boolean isNoMultiplePlay() {
        return this.noMultiplePlay;
    }

    public boolean isStopPlaying() {
        return this.stopPlaying;
    }

    public EnvelopePoint[] getEnvelope() {
        return this.envelope;
    }

    public int getInPoint() {
        return this.inPoint;
    }

    public int getOutPoint() {
        return this.outPoint;
    }

    public int getLoopCount() {
        return this.loopCount;
    }

    public SoundInfo(InStream inStream) throws IOException {
        int n = inStream.readUI8();
        this.noMultiplePlay = (n & 0x10) != 0;
        this.stopPlaying = (n & 0x20) != 0;
        boolean bl = (n & 8) != 0;
        boolean bl2 = (n & 4) != 0;
        boolean bl3 = (n & 2) != 0;
        boolean bl4 = (n & 1) != 0;
        this.inPoint = bl4 ? (int)inStream.readUI32() : -1;
        this.outPoint = bl3 ? (int)inStream.readUI32() : -1;
        this.loopCount = bl2 ? inStream.readUI16() : 1;
        int n2 = 0;
        if (bl) {
            n2 = inStream.readUI8();
        }
        this.envelope = new EnvelopePoint[n2];
        for (int i = 0; i < n2; ++i) {
            this.envelope[i] = new EnvelopePoint((int)inStream.readUI32(), inStream.readUI16(), inStream.readUI16());
        }
    }

    public void write(OutStream outStream) throws IOException {
        int n = 0;
        if (this.noMultiplePlay) {
            ++n;
        }
        if (this.stopPlaying) {
            n += 2;
        }
        outStream.writeUBits(4, n);
        boolean bl = this.envelope != null && this.envelope.length > 0;
        boolean bl2 = this.loopCount > 1;
        boolean bl3 = this.outPoint >= 0;
        boolean bl4 = this.inPoint >= 0;
        n = 0;
        if (bl) {
            n += 8;
        }
        if (bl2) {
            n += 4;
        }
        if (bl3) {
            n += 2;
        }
        if (bl4) {
            ++n;
        }
        outStream.writeUBits(4, n);
        if (bl4) {
            outStream.writeUI32(this.inPoint);
        }
        if (bl3) {
            outStream.writeUI32(this.outPoint);
        }
        if (bl2) {
            outStream.writeUI16(this.loopCount);
        }
        if (bl) {
            outStream.writeUI8(this.envelope.length);
            for (int i = 0; i < this.envelope.length; ++i) {
                outStream.writeUI32(this.envelope[i].mark44);
                outStream.writeUI16(this.envelope[i].level0);
                outStream.writeUI16(this.envelope[i].level1);
            }
        }
    }

    public String toString() {
        return "SoundInfo: no-multiplay=" + this.noMultiplePlay + " stop=" + this.stopPlaying + " envelope=" + (this.envelope == null ? "none" : "" + this.envelope.length + " points") + " in-point=" + this.inPoint + " out-point=" + this.outPoint + " loop-count=" + this.loopCount;
    }

    public static class EnvelopePoint {
        public int mark44;
        public int level0;
        public int level1;

        public EnvelopePoint(int n, int n2, int n3) {
            this.mark44 = n;
            this.level0 = n2;
            this.level1 = n3;
        }
    }
}

