/*
 * Decompiled with CFR 0.152.
 */
package com.anotherbigidea.flash.writers;

import com.anotherbigidea.flash.interfaces.SWFActions;
import com.anotherbigidea.flash.interfaces.SWFFileSignature;
import com.anotherbigidea.flash.interfaces.SWFShape;
import com.anotherbigidea.flash.interfaces.SWFTagTypes;
import com.anotherbigidea.flash.interfaces.SWFTags;
import com.anotherbigidea.flash.interfaces.SWFText;
import com.anotherbigidea.flash.interfaces.SWFVectors;
import com.anotherbigidea.flash.readers.SWFReader;
import com.anotherbigidea.flash.readers.TagParser;
import com.anotherbigidea.flash.structs.AlphaColor;
import com.anotherbigidea.flash.structs.AlphaTransform;
import com.anotherbigidea.flash.structs.ButtonRecord;
import com.anotherbigidea.flash.structs.ButtonRecord2;
import com.anotherbigidea.flash.structs.Color;
import com.anotherbigidea.flash.structs.ColorTransform;
import com.anotherbigidea.flash.structs.Matrix;
import com.anotherbigidea.flash.structs.Rect;
import com.anotherbigidea.flash.structs.SoundInfo;
import com.anotherbigidea.flash.writers.ActionTextWriter;
import com.anotherbigidea.util.Hex;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Vector;

public class SWFTagDumper
implements SWFTagTypes,
SWFShape,
SWFText,
SWFFileSignature {
    protected PrintWriter writer;
    protected String dashes = "---------------";
    protected boolean dumpHex;
    protected String indent = "";
    protected boolean decompileActions = false;

    public SWFTagDumper(boolean bl, boolean bl2) {
        this(System.out, bl, bl2);
    }

    public SWFTagDumper(OutputStream outputStream, boolean bl, boolean bl2) {
        this.writer = new PrintWriter(outputStream);
        this.dumpHex = bl;
        this.decompileActions = bl2;
    }

    public SWFTagDumper(PrintWriter printWriter, boolean bl, boolean bl2) {
        this.writer = printWriter;
        this.dumpHex = bl;
        this.decompileActions = bl2;
    }

    public void signature(String string) {
        this.println("signature: " + string);
    }

    protected void println(String string) {
        this.writer.println(this.indent + string);
    }

    public void tag(int n, boolean bl, byte[] byArray) throws IOException {
        this.println("Tag " + n + " length=" + byArray.length);
        if (this.dumpHex) {
            Hex.dump(this.writer, byArray, 0L, this.indent + "    ", false);
            this.println(this.dashes);
        }
    }

    public void header(int n, long l, int n2, int n3, int n4, int n5) throws IOException {
        this.println("header: version=" + n + " length=" + l + " width=" + n2 + " height=" + n3 + " rate=" + n4 + " frame-count=" + n5);
    }

    public void tagEnd() throws IOException {
        this.println("end");
        this.println(this.dashes);
    }

    public void tagStartSound(int n, SoundInfo soundInfo) throws IOException {
        this.println("start-sound id=" + n + " " + soundInfo);
    }

    public void tagSoundStreamHead(int n, boolean bl, boolean bl2, int n2, int n3, boolean bl3, boolean bl4, int n4) throws IOException {
        this.printSoundStreamHead("sound-stream-head", n, bl, bl2, n2, n3, bl3, bl4, n4);
    }

    public void tagSoundStreamHead2(int n, boolean bl, boolean bl2, int n2, int n3, boolean bl3, boolean bl4, int n4) throws IOException {
        this.printSoundStreamHead("sound-stream-head-2", n, bl, bl2, n2, n3, bl3, bl4, n4);
    }

    public void printSoundStreamHead(String string, int n, boolean bl, boolean bl2, int n2, int n3, boolean bl3, boolean bl4, int n4) throws IOException {
        String string2 = "5.5";
        if (n == 1) {
            string2 = "11";
        }
        if (n == 2) {
            string2 = "22";
        }
        if (n == 3) {
            string2 = "44";
        }
        String string3 = "5.5";
        if (n3 == 1) {
            string3 = "11";
        }
        if (n3 == 2) {
            string3 = "22";
        }
        if (n3 == 3) {
            string3 = "44";
        }
        String string4 = "RawSamples";
        if (n2 == 1) {
            string4 = "ADPCM";
        }
        if (n2 == 2) {
            string4 = "MP3";
        }
        this.println(string + " play at " + string2 + "kHz stereo=" + bl2 + " 16bit=" + bl + " | Stream at " + string3 + "kHz format=" + string4 + " stereo=" + bl4 + " 16bit=" + bl3 + " Avg-Samples=" + n4);
    }

    public void tagSoundStreamBlock(byte[] byArray) throws IOException {
        this.println("sound-stream-block");
        if (this.dumpHex) {
            Hex.dump(this.writer, byArray, 0L, this.indent + "    ", false);
            this.println(this.dashes);
        }
    }

    public void tagSerialNumber(String string) throws IOException {
        this.println("serial number =" + string);
    }

    public void tagGenerator(byte[] byArray) throws IOException {
        this.println("generator tag");
        if (this.dumpHex) {
            Hex.dump(this.writer, byArray, 0L, this.indent + "    ", false);
            this.println(this.dashes);
        }
    }

    public void tagGeneratorText(byte[] byArray) throws IOException {
        this.println("generator text");
        if (this.dumpHex) {
            Hex.dump(this.writer, byArray, 0L, this.indent + "    ", false);
            this.println(this.dashes);
        }
    }

    public void tagGeneratorFont(byte[] byArray) throws IOException {
        this.println("generator font");
        if (this.dumpHex) {
            Hex.dump(this.writer, byArray, 0L, this.indent + "    ", false);
            this.println(this.dashes);
        }
    }

    public void tagGeneratorCommand(byte[] byArray) throws IOException {
        this.println("generator command");
        if (this.dumpHex) {
            Hex.dump(this.writer, byArray, 0L, this.indent + "    ", false);
            this.println(this.dashes);
        }
    }

    public void tagNameCharacter(byte[] byArray) throws IOException {
        this.println("generator name character");
        if (this.dumpHex) {
            Hex.dump(this.writer, byArray, 0L, this.indent + "    ", false);
            this.println(this.dashes);
        }
    }

    public void tagDefineBits(int n, byte[] byArray) throws IOException {
        this.println("jpeg bits");
        if (this.dumpHex) {
            Hex.dump(this.writer, byArray, 0L, this.indent + "    ", false);
            this.println(this.dashes);
        }
    }

    public void tagJPEGTables(byte[] byArray) throws IOException {
        this.println("jpeg encoding data");
        if (this.dumpHex) {
            Hex.dump(this.writer, byArray, 0L, this.indent + "    ", false);
            this.println(this.dashes);
        }
    }

    public void tagDefineBitsJPEG3(int n, byte[] byArray, byte[] byArray2) throws IOException {
        this.println("jpeg with alpha");
        if (this.dumpHex) {
            Hex.dump(this.writer, byArray, 0L, this.indent + "    ", false);
            this.println("--- Alpha Channel follows ---");
            Hex.dump(this.writer, byArray2, 0L, this.indent + "    ", false);
            this.println(this.dashes);
        }
    }

    public void tagDefineSound(int n, int n2, int n3, boolean bl, boolean bl2, int n4, byte[] byArray) throws IOException {
        String string = "5.5";
        if (n3 == 1) {
            string = "11";
        }
        if (n3 == 2) {
            string = "22";
        }
        if (n3 == 3) {
            string = "44";
        }
        String string2 = "RawSamples";
        if (n2 == 1) {
            string2 = "ADPCM";
        }
        if (n2 == 2) {
            string2 = "MP3";
        }
        this.println("define sound: id=" + n + " format=" + string2 + " freq=" + string + "kHz 16bit=" + bl + " stereo=" + bl2 + " samples=" + n4);
        if (this.dumpHex) {
            Hex.dump(this.writer, byArray, 0L, this.indent + "    ", false);
            this.println(this.dashes);
        }
    }

    public void tagDefineButtonSound(int n, int n2, SoundInfo soundInfo, int n3, SoundInfo soundInfo2, int n4, SoundInfo soundInfo3, int n5, SoundInfo soundInfo4) throws IOException {
        this.println("define button sound: id=" + n);
        this.println("    roll-over sound=" + n2 + " " + soundInfo);
        this.println("    roll-out  sound=" + n3 + " " + soundInfo2);
        this.println("    press     sound=" + n4 + " " + soundInfo3);
        this.println("    release   sound=" + n5 + " " + soundInfo4);
    }

    public void tagShowFrame() throws IOException {
        this.println("---------- frame ----------");
    }

    public SWFActions tagDoAction() throws IOException {
        this.println("actions:");
        ActionTextWriter actionTextWriter = new ActionTextWriter(this.writer);
        actionTextWriter.indent = "    " + this.indent;
        return actionTextWriter;
    }

    public SWFActions tagDoInitAction(int n) throws IOException {
        this.println("init actions for sprite " + n + ":");
        ActionTextWriter actionTextWriter = new ActionTextWriter(this.writer);
        actionTextWriter.indent = "    " + this.indent;
        return actionTextWriter;
    }

    public SWFShape tagDefineShape(int n, Rect rect) throws IOException {
        this.println("shape id=" + n + "   " + rect);
        return this;
    }

    public SWFShape tagDefineShape2(int n, Rect rect) throws IOException {
        this.println("shape2 id=" + n + "   " + rect);
        return this;
    }

    public SWFShape tagDefineShape3(int n, Rect rect) throws IOException {
        this.println("shape3 id=" + n + "   " + rect);
        return this;
    }

    public void tagFreeCharacter(int n) throws IOException {
        this.println("free character id=" + n);
    }

    public void tagPlaceObject(int n, int n2, Matrix matrix, AlphaTransform alphaTransform) throws IOException {
        this.println("place-object id=" + n + " depth=" + n2 + "  " + matrix + "  " + alphaTransform);
    }

    public SWFActions tagPlaceObject2(boolean bl, int n, int n2, int n3, Matrix matrix, AlphaTransform alphaTransform, int n4, String string, int n5) throws IOException {
        this.println("place-object2 move=" + bl + " id=" + n3 + " depth=" + n2 + " clip=" + n + " ratio=" + n4 + " name=" + string + "  " + matrix + "  " + alphaTransform);
        if (n5 != 0) {
            this.println("  clip-actions:");
            ActionTextWriter actionTextWriter = new ActionTextWriter(this.writer);
            actionTextWriter.indent = "    " + this.indent;
            return actionTextWriter;
        }
        return null;
    }

    public void tagRemoveObject(int n, int n2) throws IOException {
        this.println("remove-object id=" + n + " depth=" + n2);
    }

    public void tagRemoveObject2(int n) throws IOException {
        this.println("remove-object2 depth=" + n);
    }

    public void tagSetBackgroundColor(Color color) throws IOException {
        this.println("background-color  " + color);
    }

    public void tagFrameLabel(String string) throws IOException {
        this.println("frame-label " + string);
    }

    public void tagFrameLabel(String string, boolean bl) throws IOException {
        this.println("frame-label " + string + (bl ? " (anchor)" : ""));
    }

    public SWFTagTypes tagDefineSprite(int n) throws IOException {
        this.println("sprite id=" + n);
        SWFTagDumper sWFTagDumper = new SWFTagDumper(this.writer, this.dumpHex, this.decompileActions);
        sWFTagDumper.indent = this.indent + "    ";
        return sWFTagDumper;
    }

    public void tagProtect(byte[] byArray) throws IOException {
        this.println("protect");
    }

    public void tagEnableDebug(byte[] byArray) throws IOException {
        this.println("enable-debug");
    }

    public void tagEnableDebug2(byte[] byArray) throws IOException {
        this.println("enable-debug-2");
    }

    public SWFVectors tagDefineFont(int n, int n2) throws IOException {
        this.println("font id=" + n);
        return this;
    }

    public void tagDefineFontInfo(int n, String string, int n2, int[] nArray) throws IOException {
        this.println("font-info id=" + n + " name=" + string + " flags=" + Integer.toBinaryString(n2) + " codes=" + nArray.length);
    }

    public void tagDefineFontInfo2(int n, String string, int n2, int[] nArray, int n3) throws IOException {
        this.println("font-info2 id=" + n + " name=" + string + " flags=" + Integer.toBinaryString(n2) + " codes=" + nArray.length + " language=" + n3);
    }

    public SWFVectors tagDefineFont2(int n, int n2, String string, int n3, int n4, int n5, int n6, int[] nArray, int[] nArray2, Rect[] rectArray, int[] nArray3, int[] nArray4, int[] nArray5) throws IOException {
        this.println("font2 id=" + n + " flags=" + Integer.toBinaryString(n2) + " name=" + string + " ascent=" + n4 + " descent=" + n5 + " leading=" + n6 + " has-kerns=" + (nArray3 != null));
        return this;
    }

    public void tagDefineTextField(int n, String string, String string2, Rect rect, int n2, AlphaColor alphaColor, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) throws IOException {
        if (string2 != null) {
            string2 = string2.replace('\r', ' ');
            string2 = string2.replace('\n', ' ');
            string2 = string2.replace('\b', ' ');
        }
        this.println("edit-field id=" + n + " name=" + string + " text=" + string2 + " font=" + n4 + " size=" + n5 + " chars=" + n6 + " left=" + n7 + " right=" + n8 + " indent=" + n9 + " spacing=" + n10 + " alignment=" + n3 + " flags=" + Integer.toBinaryString(n2) + " " + alphaColor);
    }

    public SWFText tagDefineText(int n, Rect rect, Matrix matrix) throws IOException {
        this.println("text id=" + n + " " + rect + " " + matrix);
        return this;
    }

    public SWFText tagDefineText2(int n, Rect rect, Matrix matrix) throws IOException {
        this.println("text2 id=" + n + " " + rect + " " + matrix);
        return this;
    }

    public SWFActions tagDefineButton(int n, Vector vector) throws IOException {
        this.println("button id=" + n);
        Object object = vector.elements();
        while (object.hasMoreElements()) {
            ButtonRecord buttonRecord = (ButtonRecord)object.nextElement();
            this.println("  " + buttonRecord);
        }
        this.println("  actions:");
        object = new ActionTextWriter(this.writer);
        ((ActionTextWriter)object).indent = "    " + this.indent;
        return object;
    }

    public void tagButtonCXForm(int n, ColorTransform colorTransform) throws IOException {
        this.println("button-cxform id=" + n + "  " + colorTransform);
    }

    public SWFActions tagDefineButton2(int n, boolean bl, Vector vector) throws IOException {
        this.println("button2 id=" + n + " track-as-menu=" + bl);
        Object object = vector.elements();
        while (object.hasMoreElements()) {
            ButtonRecord2 buttonRecord2 = (ButtonRecord2)object.nextElement();
            this.println("  " + buttonRecord2);
        }
        this.println("  actions:");
        object = new ActionTextWriter(this.writer);
        ((ActionTextWriter)object).indent = "    " + this.indent;
        return object;
    }

    public void tagExport(String[] stringArray, int[] nArray) throws IOException {
        this.println("export");
        for (int i = 0; i < stringArray.length && i < nArray.length; ++i) {
            this.println("  id=" + nArray[i] + " name=" + stringArray[i]);
        }
    }

    public void tagImport(String string, String[] stringArray, int[] nArray) throws IOException {
        this.println("import library-movie=" + string);
        for (int i = 0; i < stringArray.length && i < nArray.length; ++i) {
            this.println("  id=" + nArray[i] + " name=" + stringArray[i]);
        }
    }

    public void tagDefineQuickTimeMovie(int n, String string) throws IOException {
        this.println("quicktime-movie id=" + n + " name=" + string);
    }

    public void tagDefineBitsJPEG2(int n, byte[] byArray) throws IOException {
        this.println("jpeg2 id=" + n);
        if (this.dumpHex) {
            Hex.dump(this.writer, byArray, 0L, this.indent + "    ", false);
            this.println(this.dashes);
        }
    }

    public void tagDefineBitsJPEG2(int n, InputStream inputStream) throws IOException {
        this.println("jpeg2 id=" + n + " (from input stream)");
    }

    public SWFShape tagDefineMorphShape(int n, Rect rect, Rect rect2) throws IOException {
        this.println("morph-shape id=" + n + " start: " + rect + "  end: " + rect2);
        return this;
    }

    public void tagDefineBitsLossless(int n, int n2, int n3, int n4, Color[] colorArray, byte[] byArray) throws IOException {
        this.dumpBitsLossless("bits-lossless", n, n2, n3, n4, colorArray, byArray);
    }

    public void tagDefineBitsLossless2(int n, int n2, int n3, int n4, Color[] colorArray, byte[] byArray) throws IOException {
        this.dumpBitsLossless("bits-lossless2", n, n2, n3, n4, colorArray, byArray);
    }

    public void dumpBitsLossless(String string, int n, int n2, int n3, int n4, Color[] colorArray, byte[] byArray) throws IOException {
        int n5 = 0;
        if (n2 == 3) {
            n5 = 8;
        } else if (n2 == 4) {
            n5 = 16;
        } else if (n2 == 5) {
            n5 = 32;
        }
        this.println(string + " id=" + n + " bits=" + n5 + " width=" + n3 + " height=" + n4);
        if (this.dumpHex) {
            for (int i = 0; i < colorArray.length; ++i) {
                this.println("    " + i + ": " + colorArray[i]);
            }
            Hex.dump(this.writer, byArray, 0L, this.indent + "    ", false);
            this.println(this.dashes);
        }
    }

    public void done() throws IOException {
        this.println("    " + this.dashes);
    }

    public void line(int n, int n2) throws IOException {
        this.println("    line  " + n + "," + n2);
    }

    public void curve(int n, int n2, int n3, int n4) throws IOException {
        this.println("    curve " + n + "," + n2 + " - " + n3 + "," + n4);
    }

    public void move(int n, int n2) throws IOException {
        this.println("    move  " + n + "," + n2);
    }

    public void setFillStyle0(int n) throws IOException {
        this.println("    fill0 = " + n);
    }

    public void setFillStyle1(int n) throws IOException {
        this.println("    fill1 = " + n);
    }

    public void setLineStyle(int n) throws IOException {
        this.println("    line  = " + n);
    }

    public void defineFillStyle(Color color) throws IOException {
        this.println("    fill " + color);
    }

    public void defineFillStyle(Matrix matrix, int[] nArray, Color[] colorArray, boolean bl) throws IOException {
        this.println("    fill radial=" + bl + "  " + matrix);
        for (int i = 0; i < nArray.length && i < colorArray.length; ++i) {
            if (colorArray[i] == null) continue;
            this.println("         ratio=" + nArray[i] + " " + colorArray[i]);
        }
    }

    public void defineFillStyle(int n, Matrix matrix, boolean bl) throws IOException {
        this.println("    fill clipped=" + bl + " image=" + n + " " + matrix);
    }

    public void defineLineStyle(int n, Color color) throws IOException {
        this.println("    line-style width=" + n + "  " + color);
    }

    public void font(int n, int n2) throws IOException {
        this.println("    font id=" + n + " size=" + n2);
    }

    public void color(Color color) throws IOException {
        this.println("    color " + color);
    }

    public void setX(int n) throws IOException {
        this.println("    x = " + n);
    }

    public void setY(int n) throws IOException {
        this.println("    y = " + n);
    }

    public void text(int[] nArray, int[] nArray2) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer.append("(");
        stringBuffer2.append("(");
        for (int i = 0; i < nArray.length && i < nArray2.length; ++i) {
            stringBuffer.append(" ");
            stringBuffer2.append(" ");
            stringBuffer.append(nArray[i]);
            stringBuffer2.append(nArray2[i]);
        }
        stringBuffer.append(" )");
        stringBuffer2.append(" )");
        this.println("    text");
        this.println("        glyph indices = " + stringBuffer);
        this.println("        advances      = " + stringBuffer2);
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws IOException {
        SWFTagDumper sWFTagDumper = new SWFTagDumper(stringArray.length > 1, stringArray.length > 2);
        FileInputStream fileInputStream = new FileInputStream(stringArray[0]);
        TagParser tagParser = new TagParser(sWFTagDumper);
        SWFReader sWFReader = new SWFReader((SWFTags)tagParser, fileInputStream);
        try {
            sWFReader.readFile();
        }
        finally {
            sWFTagDumper.flush();
            fileInputStream.close();
        }
    }
}

