/*
 * Decompiled with CFR 0.152.
 */
package com.anotherbigidea.io;

import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;

public class Byte4ByteDebugStreams
extends OutputStream {
    protected ByteArrayInputStream in;
    protected byte[] bytesIn;
    protected byte[] bytesOut;
    protected int bytePtr = 0;

    public Byte4ByteDebugStreams(String string) throws Exception {
        RandomAccessFile randomAccessFile = new RandomAccessFile(string, "r");
        this.bytesIn = new byte[(int)randomAccessFile.length()];
        this.bytesOut = new byte[(int)randomAccessFile.length()];
        randomAccessFile.readFully(this.bytesIn);
        randomAccessFile.close();
    }

    public Byte4ByteDebugStreams(byte[] byArray) {
        this.bytesIn = byArray;
        this.bytesOut = new byte[byArray.length];
    }

    public InputStream getInputStream() {
        if (this.in != null) {
            return this.in;
        }
        this.in = new ByteArrayInputStream(this.bytesIn);
        return this.in;
    }

    public void setInputBytes(byte[] byArray) {
        this.bytesIn = byArray;
    }

    public void write(int n) throws IOException {
        if (n > 127) {
            n = (n & 0x7F) - 128;
        }
        this.bytesOut[this.bytePtr] = (byte)n;
        if (this.bytesOut[this.bytePtr] != this.bytesIn[this.bytePtr]) {
            IOException iOException = new IOException("Byte mismatch between input and output at byte #" + this.bytePtr + " 0x" + Integer.toHexString(this.bytePtr) + "\nexpected 0x" + Integer.toHexString(this.bytesIn[this.bytePtr]) + " but got 0x" + Integer.toHexString(n));
            iOException.printStackTrace();
            throw iOException;
        }
        ++this.bytePtr;
    }

    public void write(String string) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        fileOutputStream.write(this.bytesOut);
        fileOutputStream.flush();
        fileOutputStream.close();
    }
}

