/*
 * Decompiled with CFR 0.152.
 */
package oss.distributor;

import java.io.IOException;
import java.net.Socket;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.w3c.dom.Element;
import oss.distributor.BackgroundTest;
import oss.distributor.Distributor;
import oss.distributor.Target;

class ConnectServiceTest
implements Runnable {
    Distributor distributor;
    Logger logger;
    int frequency;
    int timeout;
    Thread thread;

    public ConnectServiceTest(Distributor distributor, Element configElement) {
        this.distributor = distributor;
        this.logger = distributor.getLogger();
        this.frequency = 60000;
        try {
            this.frequency = Integer.parseInt(configElement.getAttribute("frequency"));
        }
        catch (NumberFormatException e) {
            this.logger.warning("Invalid frequency, using default:  " + e.getMessage());
        }
        this.logger.config("Test frequency:  " + this.frequency);
        this.timeout = 2000;
        try {
            this.timeout = Integer.parseInt(configElement.getAttribute("timeout"));
        }
        catch (NumberFormatException e) {
            this.logger.warning("Invalid timeout, using default:  " + e.getMessage());
        }
        this.logger.config("Test timeout:  " + this.timeout);
        this.thread = new Thread((Runnable)this, this.getClass().getName());
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            List targets;
            List list = targets = this.distributor.getTargets();
            synchronized (list) {
                Iterator i = targets.iterator();
                while (i.hasNext()) {
                    try {
                        boolean result;
                        ConnectBackgroundTest connectTest;
                        Target target = (Target)i.next();
                        ConnectBackgroundTest connectBackgroundTest = connectTest = new ConnectBackgroundTest(target);
                        synchronized (connectBackgroundTest) {
                            connectTest.startTest();
                            connectTest.wait(this.timeout);
                        }
                        if (connectTest.getResult() == 2) {
                            result = true;
                        } else {
                            result = false;
                            if (connectTest.getResult() == 1) {
                                this.logger.warning("Test timed out");
                            }
                        }
                        if (result && !target.isEnabled()) {
                            this.logger.warning("Enabling: " + target);
                            target.enable();
                            continue;
                        }
                        if (result || !target.isEnabled()) continue;
                        this.logger.warning("Disabling: " + target);
                        target.disable();
                    }
                    catch (InterruptedException e) {
                        this.logger.warning("Service test interrupted");
                    }
                }
            }
            try {
                Thread.sleep(this.frequency);
            }
            catch (InterruptedException e) {
            }
        }
    }

    class ConnectBackgroundTest
    extends BackgroundTest {
        protected ConnectBackgroundTest(Target target) {
            super(target);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void test() {
            try {
                Socket sock = new Socket(this.target.getInetAddress(), this.target.getPort());
                sock.close();
                this.success = true;
                this.finished = true;
                ConnectBackgroundTest connectBackgroundTest = this;
                synchronized (connectBackgroundTest) {
                    this.notify();
                }
            }
            catch (IOException e) {
                ConnectServiceTest.this.logger.warning("Error communicating with server: " + e.getMessage());
                return;
            }
        }
    }
}

