/*
 * Decompiled with CFR 0.152.
 */
package oss.distributor;

import java.nio.channels.SocketChannel;
import oss.distributor.Target;

public class Connection {
    SocketChannel client;
    SocketChannel server;
    Target target;
    boolean terminated;

    public Connection(SocketChannel client, SocketChannel server, Target target) {
        this.client = client;
        this.server = server;
        this.target = target;
        this.terminated = false;
    }

    public SocketChannel getClient() {
        return this.client;
    }

    public SocketChannel getServer() {
        return this.server;
    }

    public Target getTarget() {
        return this.target;
    }

    public void terminate() {
        this.target.getDataMover().closeConnection(this.client, this.server);
        this.terminated = true;
    }

    public boolean isTerminated() {
        if (!this.client.isOpen() && !this.server.isOpen()) {
            this.terminated = true;
        }
        return this.terminated;
    }

    public String toString() {
        return "Connection from " + this.client + " to " + this.server;
    }
}

