/*
 * Decompiled with CFR 0.152.
 */
package oss.distributor;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import oss.distributor.ControllerConnection;
import oss.distributor.Distributor;

class Controller
implements Runnable {
    Distributor distributor;
    Logger logger;
    int port;
    List conns;
    Thread thread;
    ServerSocket controllerServer;

    protected Controller(Distributor distributor, int port) {
        this.distributor = distributor;
        this.logger = distributor.getLogger();
        this.port = port;
        this.conns = new LinkedList();
        this.thread = new Thread((Runnable)this, this.getClass().getName());
        this.thread.start();
    }

    public void run() {
        try {
            this.controllerServer = new ServerSocket();
            this.controllerServer.bind(new InetSocketAddress("127.0.0.1", this.port));
        }
        catch (IOException e) {
            this.logger.warning("Error binding controller socket: " + e.getMessage());
            return;
        }
        while (true) {
            try {
                Socket socket = this.controllerServer.accept();
                this.logger.fine("Control connection from " + socket);
                ControllerConnection conn = new ControllerConnection(socket, this.distributor);
                this.conns.add(conn);
            }
            catch (IOException e) {
                this.logger.warning("Error accepting connection to controller: " + e.getMessage());
                this.shutdown();
                return;
            }
            this.removeDeadConnections();
        }
    }

    private void shutdown() {
        try {
            this.controllerServer.close();
        }
        catch (IOException e) {
            this.logger.warning("Error closing controller socket: " + e.getMessage());
        }
        Iterator i = this.conns.iterator();
        while (i.hasNext()) {
            ControllerConnection c = (ControllerConnection)i.next();
            c.close();
            i.remove();
        }
    }

    private void removeDeadConnections() {
        Iterator i = this.conns.iterator();
        while (i.hasNext()) {
            ControllerConnection c = (ControllerConnection)i.next();
            if (!c.isClosed()) continue;
            this.logger.finest("Removing closed connection " + c);
            i.remove();
        }
    }

    protected String getMemoryStats(String indent) {
        return indent + this.conns.size() + " entries in conns List";
    }
}

