/*
 * Decompiled with CFR 0.152.
 */
package oss.distributor;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import oss.distributor.DistributionAlgorithm;
import oss.distributor.Distributor;
import oss.distributor.Target;

class ControllerConnection
implements Runnable {
    Socket socket;
    Distributor distributor;
    Logger logger;
    BufferedReader in;
    PrintWriter out;
    Thread thread;
    boolean closed = false;

    protected ControllerConnection(Socket socket, Distributor distributor) throws IOException {
        this.socket = socket;
        this.distributor = distributor;
        this.logger = distributor.getLogger();
        this.in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        this.out = new PrintWriter(socket.getOutputStream(), true);
        this.thread = new Thread((Runnable)this, this.getClass().getName());
        this.thread.start();
    }

    public void run() {
        try {
            boolean interactive = false;
            while (!this.closed) {
                String line;
                if (interactive) {
                    this.out.print("distributor> ");
                    this.out.flush();
                }
                if ((line = this.in.readLine()) == null) {
                    this.logger.fine("Control connection " + this.socket + " closed");
                    this.close();
                    return;
                }
                this.logger.finest("Read '" + line + "' from " + this.socket);
                StringTokenizer st = new StringTokenizer(line);
                if (!st.hasMoreTokens()) {
                    interactive = true;
                    continue;
                }
                String command = st.nextToken();
                this.logger.finer("Read '" + command + "' command from " + this.socket);
                if (command.equals("stats")) {
                    this.stats(st);
                    continue;
                }
                if (command.equals("memstats")) {
                    this.memstats(st);
                    continue;
                }
                if (command.equals("conns")) {
                    this.connections(st);
                    continue;
                }
                if (command.equals("threads")) {
                    this.threads(st);
                    continue;
                }
                if (command.equals("add")) {
                    this.addTarget(st);
                    continue;
                }
                if (command.equals("remove")) {
                    this.removeTarget(st);
                    continue;
                }
                if (command.equals("addgroup")) {
                    this.addTargetGroup(st);
                    continue;
                }
                if (command.equals("removegroup")) {
                    this.removeTargetGroup(st);
                    continue;
                }
                if (command.equals("disable")) {
                    this.disableTarget(st);
                    continue;
                }
                if (command.equals("enable")) {
                    this.enableTarget(st);
                    continue;
                }
                if (command.equals("loglevel")) {
                    this.setLogLevel(st);
                    continue;
                }
                if (command.equals("help")) {
                    this.help(st);
                    continue;
                }
                if (command.equals("quit")) {
                    this.close();
                    return;
                }
                this.out.println("Unknown command:  " + command);
                this.out.println("Try 'help' for a list of commands");
            }
        }
        catch (IOException e) {
            this.logger.warning("Error while communicating with controller client: " + e.getMessage());
            this.close();
            return;
        }
    }

    protected void help(StringTokenizer st) {
        this.out.println("Commands:");
        this.out.println("stats");
        this.out.println("memstats");
        this.out.println("conns");
        this.out.println("threads");
        this.out.println("add");
        this.out.println("remove");
        this.out.println("addgroup");
        this.out.println("removegroup");
        this.out.println("disable");
        this.out.println("enable");
        this.out.println("loglevel");
        this.out.println("help");
        this.out.println("quit");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stats(StringTokenizer st) {
        List targetGroups;
        List list = targetGroups = this.distributor.getTargetGroups();
        synchronized (list) {
            int tgCounter = 0;
            Iterator iter = targetGroups.iterator();
            while (iter.hasNext()) {
                List targets;
                this.out.println("Target group " + tgCounter + ":");
                ++tgCounter;
                List list2 = targets = (List)iter.next();
                synchronized (list2) {
                    Iterator targetIter = targets.iterator();
                    while (targetIter.hasNext()) {
                        Target target = (Target)targetIter.next();
                        this.out.println("  " + target);
                        this.out.println(target.getStats("    "));
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void memstats(StringTokenizer st) {
        List targetGroups;
        Iterator iter;
        List distAlgos;
        this.out.println(this.distributor.getController() + ":");
        this.out.println(this.distributor.getController().getMemoryStats(""));
        this.out.println("");
        this.out.println(this.distributor.getTargetSelector() + ":");
        this.out.println(this.distributor.getTargetSelector().getMemoryStats(""));
        this.out.println("");
        List list = distAlgos = this.distributor.getDistributionAlgorithms();
        synchronized (list) {
            iter = distAlgos.iterator();
            while (iter.hasNext()) {
                DistributionAlgorithm algo = (DistributionAlgorithm)iter.next();
                this.out.println(algo);
                this.out.println(algo.getMemoryStats("  "));
            }
        }
        this.out.println("");
        List list2 = targetGroups = this.distributor.getTargetGroups();
        synchronized (list2) {
            int tgCounter = 0;
            iter = targetGroups.iterator();
            while (iter.hasNext()) {
                List targets;
                this.out.println("Target group " + tgCounter + ":");
                ++tgCounter;
                List list3 = targets = (List)iter.next();
                synchronized (list3) {
                    Iterator targetIter = targets.iterator();
                    while (targetIter.hasNext()) {
                        Target target = (Target)targetIter.next();
                        this.out.println("  " + target);
                        this.out.println(target.getMemoryStats("    "));
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connections(StringTokenizer st) {
        List targetGroups;
        List list = targetGroups = this.distributor.getTargetGroups();
        synchronized (list) {
            int tgCounter = 0;
            Iterator iter = targetGroups.iterator();
            while (iter.hasNext()) {
                List targets;
                this.out.println("Target group " + tgCounter + ":");
                ++tgCounter;
                List list2 = targets = (List)iter.next();
                synchronized (list2) {
                    Iterator targetIter = targets.iterator();
                    while (targetIter.hasNext()) {
                        Target target = (Target)targetIter.next();
                        this.out.println("  " + target);
                        this.out.println(target.getConnectionList("    "));
                    }
                }
            }
        }
    }

    protected void threads(StringTokenizer st) {
        Thread[] tarray = new Thread[Thread.activeCount()];
        Thread.enumerate(tarray);
        for (int i = 0; i < tarray.length; ++i) {
            this.out.println(tarray[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addTarget(StringTokenizer st) {
        List targetGroups;
        Target newTarget;
        int tgIndex;
        if (st.countTokens() != 3) {
            this.out.println("Usage: add <target group> <hostname> <port>");
            return;
        }
        try {
            tgIndex = Integer.parseInt(st.nextToken());
            InetAddress addr = InetAddress.getByName(st.nextToken());
            int port = Integer.parseInt(st.nextToken());
            newTarget = new Target(this.distributor, addr, port, this.distributor.getConnectionFailureLimit(), this.distributor.getTerminate(), this.distributor.getHalfClose());
        }
        catch (UnknownHostException e) {
            this.out.println("Host not found:  " + e.getMessage());
            return;
        }
        catch (NumberFormatException e) {
            this.out.println("Target group and port must be integers");
            return;
        }
        List list = targetGroups = this.distributor.getTargetGroups();
        synchronized (list) {
            if (tgIndex < 0 || tgIndex >= targetGroups.size()) {
                this.out.println("Invalid target group");
                return;
            }
            Iterator iter = targetGroups.iterator();
            int tgCounter = 0;
            while (iter.hasNext()) {
                if (tgCounter == tgIndex) {
                    List targets = (List)iter.next();
                    targets.add(newTarget);
                    this.out.println("New target added");
                    break;
                }
                ++tgCounter;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeTarget(StringTokenizer st) {
        int port;
        InetAddress addr;
        int tgIndex;
        if (st.countTokens() != 3) {
            this.out.println("Usage: remove <target group> <hostname> <port>");
            return;
        }
        try {
            tgIndex = Integer.parseInt(st.nextToken());
            addr = InetAddress.getByName(st.nextToken());
            port = Integer.parseInt(st.nextToken());
        }
        catch (UnknownHostException e) {
            this.out.println("Host not found:  " + e.getMessage());
            return;
        }
        catch (NumberFormatException e) {
            this.out.println("Target group and port must be integers");
            return;
        }
        List targetGroups = this.distributor.getTargetGroups();
        List targets = null;
        List list = targetGroups;
        synchronized (list) {
            if (tgIndex < 0 || tgIndex >= targetGroups.size()) {
                this.out.println("Invalid target group");
                return;
            }
            Iterator iter = targetGroups.iterator();
            int tgCounter = 0;
            while (iter.hasNext()) {
                if (tgCounter == tgIndex) {
                    targets = (List)iter.next();
                    break;
                }
                ++tgCounter;
            }
        }
        boolean targetFound = false;
        Target target = null;
        List list2 = targets;
        synchronized (list2) {
            Iterator targetIter = targets.iterator();
            while (targetIter.hasNext()) {
                target = (Target)targetIter.next();
                if (!target.getInetAddress().equals(addr) || target.getPort() != port) continue;
                targetIter.remove();
                targetFound = true;
                break;
            }
        }
        if (targetFound) {
            target.terminateAll();
            this.out.println("Target removed");
        } else {
            this.out.println("No matching target found");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addTargetGroup(StringTokenizer st) {
        List targetGroups;
        int tgIndex;
        if (st.countTokens() != 1) {
            this.out.println("Usage: addgroup <target group>");
            return;
        }
        try {
            tgIndex = Integer.parseInt(st.nextToken());
        }
        catch (NumberFormatException e) {
            this.out.println("Target group must be an integer");
            return;
        }
        List list = targetGroups = this.distributor.getTargetGroups();
        synchronized (list) {
            if (tgIndex < 0 || tgIndex > targetGroups.size()) {
                this.out.println("Invalid target group");
                return;
            }
            targetGroups.add(tgIndex, new LinkedList());
            this.out.println("New target group added at position " + tgIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeTargetGroup(StringTokenizer st) {
        List targets;
        List targetGroups;
        int tgIndex;
        if (st.countTokens() != 1) {
            this.out.println("Usage: removegroup <target group>");
            return;
        }
        try {
            tgIndex = Integer.parseInt(st.nextToken());
        }
        catch (NumberFormatException e) {
            this.out.println("Target group must be an integer");
            return;
        }
        List list = targetGroups = this.distributor.getTargetGroups();
        synchronized (list) {
            if (tgIndex < 0 || tgIndex >= targetGroups.size()) {
                this.out.println("Invalid target group");
                return;
            }
            targets = (List)targetGroups.remove(tgIndex);
        }
        list = targets;
        synchronized (list) {
            Iterator targetIter = targets.iterator();
            while (targetIter.hasNext()) {
                Target target = (Target)targetIter.next();
                target.terminateAll();
            }
        }
        this.out.println("Target group at position " + tgIndex + " removed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disableTarget(StringTokenizer st) {
        int port;
        InetAddress addr;
        int tgIndex;
        if (st.countTokens() != 3) {
            this.out.println("Usage: disable <target group> <hostname> <port>");
            return;
        }
        try {
            tgIndex = Integer.parseInt(st.nextToken());
            addr = InetAddress.getByName(st.nextToken());
            port = Integer.parseInt(st.nextToken());
        }
        catch (UnknownHostException e) {
            this.out.println("Host not found:  " + e.getMessage());
            return;
        }
        catch (NumberFormatException e) {
            this.out.println("Target group and port must be integers");
            return;
        }
        List targetGroups = this.distributor.getTargetGroups();
        List targets = null;
        List list = targetGroups;
        synchronized (list) {
            if (tgIndex < 0 || tgIndex >= targetGroups.size()) {
                this.out.println("Invalid target group");
                return;
            }
            Iterator iter = targetGroups.iterator();
            int tgCounter = 0;
            while (iter.hasNext()) {
                if (tgCounter == tgIndex) {
                    targets = (List)iter.next();
                    break;
                }
                ++tgCounter;
            }
        }
        boolean targetFound = false;
        List list2 = targets;
        synchronized (list2) {
            Iterator targetIter = targets.iterator();
            while (targetIter.hasNext()) {
                Target target = (Target)targetIter.next();
                if (!target.getInetAddress().equals(addr) || target.getPort() != port) continue;
                target.disable();
                targetFound = true;
                this.out.println("Target disabled");
                break;
            }
        }
        if (!targetFound) {
            this.out.println("No matching target found");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enableTarget(StringTokenizer st) {
        int port;
        InetAddress addr;
        int tgIndex;
        if (st.countTokens() != 3) {
            this.out.println("Usage: enable <target group> <hostname> <port>");
            return;
        }
        try {
            tgIndex = Integer.parseInt(st.nextToken());
            addr = InetAddress.getByName(st.nextToken());
            port = Integer.parseInt(st.nextToken());
        }
        catch (UnknownHostException e) {
            this.out.println("Host not found:  " + e.getMessage());
            return;
        }
        catch (NumberFormatException e) {
            this.out.println("Target group and port must be integers");
            return;
        }
        List targetGroups = this.distributor.getTargetGroups();
        List targets = null;
        List list = targetGroups;
        synchronized (list) {
            if (tgIndex < 0 || tgIndex >= targetGroups.size()) {
                this.out.println("Invalid target group");
                return;
            }
            Iterator iter = targetGroups.iterator();
            int tgCounter = 0;
            while (iter.hasNext()) {
                if (tgCounter == tgIndex) {
                    targets = (List)iter.next();
                    break;
                }
                ++tgCounter;
            }
        }
        boolean targetFound = false;
        List list2 = targets;
        synchronized (list2) {
            Iterator targetIter = targets.iterator();
            while (targetIter.hasNext()) {
                Target target = (Target)targetIter.next();
                if (!target.getInetAddress().equals(addr) || target.getPort() != port) continue;
                target.enable();
                targetFound = true;
                this.out.println("Target enabled");
                break;
            }
        }
        if (!targetFound) {
            this.out.println("No matching target found");
        }
    }

    protected void setLogLevel(StringTokenizer st) {
        Level newLevel;
        if (st.countTokens() != 1) {
            this.out.println("Usage: loglevel off|severe|warning|info|config|fine|finer|finest|all");
            return;
        }
        String levelName = st.nextToken();
        try {
            newLevel = Distributor.parseLogLevel(levelName);
        }
        catch (ParseException e) {
            this.out.println("Unrecognized log level");
            return;
        }
        this.logger.setLevel(newLevel);
    }

    protected boolean isClosed() {
        return this.closed;
    }

    protected void close() {
        try {
            this.socket.close();
        }
        catch (IOException e) {
            this.logger.warning("Error closing connection to controller client: " + e.getMessage());
        }
        this.closed = true;
    }

    public String toString() {
        return "ControllerConnection from " + this.socket;
    }
}

