/*
 * Decompiled with CFR 0.152.
 */
package oss.distributor;

import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import oss.distributor.Connection;
import oss.distributor.DistributionAlgorithm;
import oss.distributor.Distributor;
import oss.distributor.Target;

class DataMover
implements Runnable {
    Target target;
    boolean halfClose;
    Selector selector;
    Logger logger;
    List distributionAlgorithms;
    Map clients;
    Map servers;
    List newConnections;
    List channelsToReactivate;
    DelayedMover delayedMover;
    long clientToServerByteCount;
    long serverToClientByteCount;
    Thread thread;
    final int BUFFER_SIZE = 131072;

    protected DataMover(Distributor distributor, Target target, boolean halfClose) {
        this.logger = distributor.getLogger();
        this.distributionAlgorithms = distributor.getDistributionAlgorithms();
        this.target = target;
        this.halfClose = halfClose;
        try {
            this.selector = Selector.open();
        }
        catch (IOException e) {
            this.logger.severe("Error creating selector: " + e.getMessage());
            System.exit(1);
        }
        this.clients = new HashMap();
        this.servers = new HashMap();
        this.newConnections = new LinkedList();
        this.channelsToReactivate = new LinkedList();
        this.delayedMover = new DelayedMover();
        this.clientToServerByteCount = 0L;
        this.serverToClientByteCount = 0L;
        this.thread = new Thread((Runnable)this, this.toString());
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addConnection(Connection conn) {
        List list = this.newConnections;
        synchronized (list) {
            this.newConnections.add(conn);
        }
        this.selector.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processNewConnections() {
        boolean didSomething = false;
        List list = this.newConnections;
        synchronized (list) {
            Iterator iter = this.newConnections.iterator();
            while (iter.hasNext()) {
                Connection conn = (Connection)iter.next();
                iter.remove();
                SocketChannel client = conn.getClient();
                SocketChannel server = conn.getServer();
                try {
                    this.logger.finest("Setting channels to non-blocking mode");
                    client.configureBlocking(false);
                    server.configureBlocking(false);
                    this.clients.put(client, server);
                    this.servers.put(server, client);
                    this.logger.finest("Registering channels with selector");
                    client.register(this.selector, 1);
                    server.register(this.selector, 1);
                }
                catch (IOException e) {
                    this.logger.warning("Error setting channels to non-blocking mode: " + e.getMessage());
                    try {
                        this.logger.fine("Closing channels");
                        client.close();
                        server.close();
                    }
                    catch (IOException ioe) {
                        this.logger.warning("Error closing channels: " + ioe.getMessage());
                    }
                }
                didSomething = true;
            }
        }
        return didSomething;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToReactivateList(SocketChannel channel) {
        List list = this.channelsToReactivate;
        synchronized (list) {
            this.channelsToReactivate.add(channel);
        }
        this.selector.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processReactivateList() {
        boolean didSomething = false;
        List list = this.channelsToReactivate;
        synchronized (list) {
            Iterator iter = this.channelsToReactivate.iterator();
            while (iter.hasNext()) {
                SocketChannel channel = (SocketChannel)iter.next();
                iter.remove();
                SelectionKey key = channel.keyFor(this.selector);
                try {
                    key.interestOps(key.interestOps() | 1);
                }
                catch (CancelledKeyException e) {
                    // empty catch block
                }
                didSomething = true;
            }
        }
        return didSomething;
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        selectFailureOrZeroCount = 0;
        buffer = ByteBuffer.allocateDirect(131072);
        block6: while (true) {
            pncReturn = this.processNewConnections();
            prlReturn = this.processReactivateList();
            if (pncReturn || prlReturn) {
                selectFailureOrZeroCount = 0;
            }
            if (selectFailureOrZeroCount >= 10) {
                this.logger.warning("select appears to be failing repeatedly, pausing");
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                selectFailureOrZeroCount = 0;
            }
            selectReturn = 0;
            try {
                selectReturn = this.selector.select();
                selectFailureOrZeroCount = selectReturn > 0 ? 0 : ++selectFailureOrZeroCount;
            }
            catch (IOException e) {
                this.logger.warning("Error when selecting for ready channel: " + e.getMessage());
                ++selectFailureOrZeroCount;
                continue;
            }
            this.logger.finest("select reports " + selectReturn + " channels ready to read");
            keyIter = this.selector.selectedKeys().iterator();
            while (true) {
                if (keyIter.hasNext()) ** break;
                continue block6;
                key = keyIter.next();
                keyIter.remove();
                src = (SocketChannel)key.channel();
                if (this.clients.containsKey(src)) {
                    clientToServer = true;
                    dst = (SocketChannel)this.clients.get(src);
                } else if (this.servers.containsKey(src)) {
                    clientToServer = false;
                    dst = (SocketChannel)this.servers.get(src);
                } else {
                    key.cancel();
                    continue;
                }
                try {
                    do {
                        readMore = false;
                        buffer.clear();
                        numberOfBytes = src.read(buffer);
                        this.logger.finest("Read " + numberOfBytes + " bytes from " + src);
                        if (numberOfBytes > 0) {
                            if (!this.moveData(buffer, src, (SocketChannel)var9_9, (boolean)var10_10, key)) continue;
                            readMore = true;
                            continue;
                        }
                        if (numberOfBytes != -1) continue;
                        this.handleEOF(key, src, (SocketChannel)var9_9, (boolean)var10_10);
                    } while (readMore);
                    continue;
                }
                catch (IOException e) {
                    this.logger.warning("Error moving data between channels: " + e.getMessage());
                    this.closeConnection(src, (SocketChannel)var9_9, (boolean)var10_10);
                    continue;
                }
                break;
            }
            break;
        }
    }

    private boolean moveData(ByteBuffer buffer, SocketChannel src, SocketChannel dst, boolean clientToServer, SelectionKey sourceKey) throws IOException {
        buffer.flip();
        if (clientToServer) {
            this.clientToServerByteCount += (long)buffer.remaining();
        } else {
            this.serverToClientByteCount += (long)buffer.remaining();
        }
        Iterator iter = this.distributionAlgorithms.iterator();
        ByteBuffer reviewedBuffer = buffer;
        while (iter.hasNext()) {
            DistributionAlgorithm algo = (DistributionAlgorithm)iter.next();
            if (clientToServer) {
                reviewedBuffer = algo.reviewClientToServerData(src, dst, reviewedBuffer);
                continue;
            }
            reviewedBuffer = algo.reviewServerToClientData(src, dst, reviewedBuffer);
        }
        dst.write(reviewedBuffer);
        if (reviewedBuffer.hasRemaining()) {
            this.logger.finer("Delaying " + reviewedBuffer.remaining() + " bytes from " + src + " to " + dst);
            ByteBuffer delayedBuffer = ByteBuffer.allocate(reviewedBuffer.remaining());
            delayedBuffer.put(reviewedBuffer);
            delayedBuffer.flip();
            try {
                sourceKey.interestOps(sourceKey.interestOps() ^ 1);
                this.delayedMover.addToQueue(new DelayedDataInfo(dst, delayedBuffer, src, clientToServer));
            }
            catch (CancelledKeyException e) {
                // empty catch block
            }
            return false;
        }
        return true;
    }

    private void handleEOF(SelectionKey key, SocketChannel src, SocketChannel dst, boolean clientToServer) throws IOException {
        if (this.halfClose) {
            key.cancel();
            Socket srcSocket = src.socket();
            Socket dstSocket = dst.socket();
            if (srcSocket.isOutputShutdown()) {
                this.logger.finer("Closing source socket");
                srcSocket.close();
            } else {
                this.logger.finest("Shutting down source input");
                srcSocket.shutdownInput();
            }
            if (dstSocket.isInputShutdown()) {
                this.logger.finer("Closing destination socket");
                dstSocket.close();
            } else {
                this.logger.finest("Shutting down dest output");
                dstSocket.shutdownOutput();
            }
            if (srcSocket.isClosed() && dstSocket.isClosed()) {
                this.dumpState(src, dst, clientToServer);
            }
        } else {
            this.closeConnection(src, dst, clientToServer);
        }
    }

    private void closeConnection(SocketChannel src, SocketChannel dst, boolean clientToServer) {
        SocketChannel server;
        SocketChannel client;
        if (clientToServer) {
            client = src;
            server = dst;
        } else {
            server = src;
            client = dst;
        }
        this.closeConnection(client, server);
    }

    protected void closeConnection(SocketChannel client, SocketChannel server) {
        try {
            this.logger.fine("Closing channels");
            client.close();
            server.close();
        }
        catch (IOException ioe) {
            this.logger.warning("Error closing channels: " + ioe.getMessage());
        }
        this.dumpState(client, server);
    }

    private void dumpState(SocketChannel src, SocketChannel dst, boolean clientToServer) {
        SocketChannel server;
        SocketChannel client;
        if (clientToServer) {
            client = src;
            server = dst;
        } else {
            server = src;
            client = dst;
        }
        this.dumpState(client, server);
    }

    private void dumpState(SocketChannel client, SocketChannel server) {
        this.clients.remove(client);
        this.servers.remove(server);
        this.delayedMover.dumpDelayedState(client, server);
    }

    public long getClientToServerByteCount() {
        return this.clientToServerByteCount;
    }

    public long getServerToClientByteCount() {
        return this.serverToClientByteCount;
    }

    public String toString() {
        return this.getClass().getName() + " for " + this.target.getInetAddress() + ":" + this.target.getPort();
    }

    protected String getMemoryStats(String indent) {
        String stats = indent + this.clients.size() + " entries in clients Map\n";
        stats = stats + indent + this.servers.size() + " entries in servers Map\n";
        stats = stats + indent + this.newConnections.size() + " entries in newConnections List\n";
        stats = stats + indent + this.channelsToReactivate.size() + " entries in channelsToReactivate List\n";
        stats = stats + indent + this.selector.keys().size() + " entries in selector key Set\n";
        stats = stats + indent + "DelayedMover:\n";
        stats = stats + this.delayedMover.getMemoryStats(indent);
        return stats;
    }

    static /* synthetic */ void access$000(DataMover x0, SocketChannel x1, SocketChannel x2, boolean x3) {
        x0.closeConnection(x1, x2, x3);
    }

    class DelayedDataInfo {
        SocketChannel dst;
        ByteBuffer buffer;
        SocketChannel src;
        boolean clientToServer;

        DelayedDataInfo(SocketChannel dst, ByteBuffer buffer, SocketChannel src, boolean clientToServer) {
            this.dst = dst;
            this.buffer = buffer;
            this.src = src;
            this.clientToServer = clientToServer;
        }

        SocketChannel getDest() {
            return this.dst;
        }

        ByteBuffer getBuffer() {
            return this.buffer;
        }

        SocketChannel getSource() {
            return this.src;
        }

        boolean isClientToServer() {
            return this.clientToServer;
        }
    }

    class DelayedMover
    implements Runnable {
        Selector delayedSelector;
        List queue;
        Map delayedInfo;
        Thread thread;

        DelayedMover() {
            try {
                this.delayedSelector = Selector.open();
            }
            catch (IOException e) {
                DataMover.this.logger.severe("Error creating selector: " + e.getMessage());
                System.exit(1);
            }
            this.queue = new LinkedList();
            this.delayedInfo = new HashMap();
            this.thread = new Thread((Runnable)this, this.toString());
            this.thread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addToQueue(DelayedDataInfo info) {
            List list = this.queue;
            synchronized (list) {
                this.queue.add(info);
            }
            this.delayedSelector.wakeup();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean processQueue() {
            boolean didSomething = false;
            List list = this.queue;
            synchronized (list) {
                Iterator iter = this.queue.iterator();
                while (iter.hasNext()) {
                    DelayedDataInfo info = (DelayedDataInfo)iter.next();
                    iter.remove();
                    SocketChannel dst = info.getDest();
                    Map map = this.delayedInfo;
                    synchronized (map) {
                        this.delayedInfo.put(dst, info);
                    }
                    SelectionKey key = dst.keyFor(this.delayedSelector);
                    if (key == null) {
                        DataMover.this.logger.finest("Registering channel with selector");
                        try {
                            dst.register(this.delayedSelector, 4);
                        }
                        catch (ClosedChannelException e) {}
                    } else {
                        try {
                            key.interestOps(key.interestOps() | 4);
                        }
                        catch (CancelledKeyException e) {
                            // empty catch block
                        }
                    }
                    didSomething = true;
                }
            }
            return didSomething;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public void run() {
            selectFailureOrZeroCount = 0;
            block11: while (true) {
                if (pqReturn = this.processQueue()) {
                    selectFailureOrZeroCount = 0;
                }
                if (selectFailureOrZeroCount >= 10) {
                    DataMover.this.logger.warning("select appears to be failing repeatedly, pausing");
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    selectFailureOrZeroCount = 0;
                }
                try {
                    selectReturn = this.delayedSelector.select();
                    selectFailureOrZeroCount = selectReturn > 0 ? 0 : ++selectFailureOrZeroCount;
                }
                catch (IOException e) {
                    DataMover.this.logger.warning("Error when selecting for ready channel: " + e.getMessage());
                    ++selectFailureOrZeroCount;
                    continue;
                }
                DataMover.this.logger.finest("select reports " + selectReturn + " channels ready to write");
                keyIter = this.delayedSelector.selectedKeys().iterator();
                while (true) {
                    if (keyIter.hasNext()) ** break;
                    continue block11;
                    key = keyIter.next();
                    keyIter.remove();
                    dst = (SocketChannel)key.channel();
                    e = this.delayedInfo;
                    synchronized (e) {
                        info = (DelayedDataInfo)this.delayedInfo.get(dst);
                    }
                    delayedBuffer = info.getBuffer();
                    try {
                        numberOfBytes = dst.write(delayedBuffer);
                        DataMover.this.logger.finest("Wrote " + numberOfBytes + " delayed bytes to " + dst + ", " + delayedBuffer.remaining() + " bytes remain delayed");
                        if (delayedBuffer.hasRemaining()) continue;
                        try {
                            key.interestOps(key.interestOps() ^ 4);
                        }
                        catch (CancelledKeyException e) {
                            // empty catch block
                        }
                        src = info.getSource();
                        this.dumpDelayedState(info.getDest());
                        DataMover.this.addToReactivateList(src);
                        continue;
                    }
                    catch (IOException e) {
                        DataMover.this.logger.warning("Error writing delayed data: " + e.getMessage());
                        DataMover.access$000(DataMover.this, dst, info.getSource(), info.isClientToServer());
                        continue;
                    }
                    break;
                }
                break;
            }
        }

        void dumpDelayedState(SocketChannel client, SocketChannel server) {
            this.dumpDelayedState(client);
            this.dumpDelayedState(server);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void dumpDelayedState(SocketChannel dst) {
            Map map = this.delayedInfo;
            synchronized (map) {
                this.delayedInfo.remove(dst);
            }
        }

        public String toString() {
            return this.getClass().getName() + " for " + DataMover.this.target.getInetAddress() + ":" + DataMover.this.target.getPort();
        }

        protected String getMemoryStats(String indent) {
            String stats = indent + this.queue.size() + " entries in queue List\n";
            stats = indent + this.delayedInfo.size() + " entries in delayedInfo Map\n";
            stats = stats + indent + this.delayedSelector.keys().size() + " entries in delayedSelector key Set";
            return stats;
        }
    }
}

