/*
 * Decompiled with CFR 0.152.
 */
package oss.distributor;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import oss.distributor.Connection;
import oss.distributor.Distributor;
import oss.distributor.Target;
import oss.distributor.TargetSelector;

public abstract class DistributionAlgorithm
implements Runnable {
    Distributor distributor;
    Logger logger;
    int connectionTimeout;
    TargetSelector targetSelector;
    Selector selector;
    protected List newClients;
    Map pendingConnections;
    List completedConnections;
    List failedConnections;
    TimedOutConnectionDetector timedOutDetector;
    Thread thread;
    int selectFailureOrZeroCount = 0;

    public DistributionAlgorithm(Distributor distributor) {
        this.distributor = distributor;
        this.logger = distributor.getLogger();
        this.newClients = new LinkedList();
        this.pendingConnections = new HashMap();
        this.completedConnections = new LinkedList();
        this.failedConnections = new LinkedList();
        try {
            this.selector = Selector.open();
        }
        catch (IOException e) {
            this.logger.severe("Error creating selector: " + e.getMessage());
            System.exit(1);
        }
        this.thread = new Thread((Runnable)this, this.getClass().getName());
    }

    public void finishInitialization() {
        this.connectionTimeout = this.distributor.getConnectionTimeout();
        this.targetSelector = this.distributor.getTargetSelector();
        this.timedOutDetector = new TimedOutConnectionDetector();
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void tryToConnect(SocketChannel client) {
        List list = this.newClients;
        synchronized (list) {
            this.newClients.add(client);
        }
        this.selector.wakeup();
    }

    protected abstract boolean processNewClients();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initiateConnection(SocketChannel client, Target target) {
        try {
            SocketChannel connToServer = SocketChannel.open();
            connToServer.configureBlocking(false);
            connToServer.connect(new InetSocketAddress(target.getInetAddress(), target.getPort()));
            SelectionKey key = connToServer.register(this.selector, 8, client);
            Map map = this.pendingConnections;
            synchronized (map) {
                this.pendingConnections.put(client, new PendingConnectionState(target, System.currentTimeMillis(), key));
            }
        }
        catch (IOException e) {
            this.logger.warning("Error initiating connection to target: " + e.getMessage());
            List list = this.failedConnections;
            synchronized (list) {
                this.failedConnections.add(client);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            boolean pncReturn;
            if (pncReturn = this.processNewClients()) {
                this.selectFailureOrZeroCount = 0;
            }
            if (this.selectFailureOrZeroCount >= 10) {
                this.logger.warning("select appears to be failing repeatedly, pausing");
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                this.selectFailureOrZeroCount = 0;
            }
            int selectReturn = 0;
            try {
                selectReturn = this.selector.select();
                this.selectFailureOrZeroCount = selectReturn > 0 ? 0 : ++this.selectFailureOrZeroCount;
            }
            catch (IOException e) {
                this.logger.warning("Error when selecting for ready channel: " + e.getMessage());
                ++this.selectFailureOrZeroCount;
                continue;
            }
            this.logger.finest("select reports " + selectReturn + " channels ready to connect");
            Iterator<SelectionKey> keyIter = this.selector.selectedKeys().iterator();
            while (keyIter.hasNext()) {
                SelectionKey key = keyIter.next();
                keyIter.remove();
                SocketChannel server = (SocketChannel)key.channel();
                SocketChannel client = (SocketChannel)key.attachment();
                try {
                    server.finishConnect();
                    this.logger.fine("Connection from " + client + " to " + server + " complete");
                    Map e = this.pendingConnections;
                    synchronized (e) {
                        PendingConnectionState connState = (PendingConnectionState)this.pendingConnections.get(client);
                        this.completedConnections.add(new Connection(client, server, connState.getTarget()));
                        this.pendingConnections.remove(client);
                    }
                    key.cancel();
                }
                catch (IOException e) {
                    this.logger.warning("Error finishing connection");
                    key.cancel();
                    try {
                        server.close();
                    }
                    catch (IOException ioe) {
                        this.logger.warning("Error closing channel: " + ioe.getMessage());
                    }
                    Object object = this.pendingConnections;
                    synchronized (object) {
                        this.pendingConnections.remove(client);
                    }
                    object = this.failedConnections;
                    synchronized (object) {
                        this.failedConnections.add(client);
                    }
                }
            }
            this.processCompletedConnections(this.completedConnections);
        }
    }

    public abstract void processCompletedConnections(List var1);

    public abstract void processFailedConnections(List var1);

    public void connectionNotify(Connection conn) {
    }

    public ByteBuffer reviewClientToServerData(SocketChannel client, SocketChannel server, ByteBuffer buffer) {
        return buffer;
    }

    public ByteBuffer reviewServerToClientData(SocketChannel server, SocketChannel client, ByteBuffer buffer) {
        return buffer;
    }

    public String getMemoryStats(String indent) {
        String stats = indent + this.newClients.size() + " entries in newClients List\n";
        stats = stats + indent + this.pendingConnections.size() + " entries in pendingConnections Map\n";
        stats = stats + indent + this.completedConnections.size() + " entries in completedConnections List\n";
        stats = stats + indent + this.failedConnections.size() + " entries in failedConnections List\n";
        stats = stats + indent + this.selector.keys().size() + " entries in selector key Set";
        return stats;
    }

    class TimedOutConnectionDetector
    implements Runnable {
        Thread thread = new Thread((Runnable)this, this.getClass().getName());

        TimedOutConnectionDetector() {
            this.thread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                Map map = DistributionAlgorithm.this.pendingConnections;
                synchronized (map) {
                    Iterator iter = DistributionAlgorithm.this.pendingConnections.entrySet().iterator();
                    while (iter.hasNext()) {
                        Map.Entry pendingEntry = iter.next();
                        SocketChannel client = (SocketChannel)pendingEntry.getKey();
                        PendingConnectionState connState = (PendingConnectionState)pendingEntry.getValue();
                        if (connState.getStartTime() + (long)DistributionAlgorithm.this.connectionTimeout >= System.currentTimeMillis()) continue;
                        DistributionAlgorithm.this.logger.finer("Pending connection from " + client + " to " + connState.getTarget() + " timed out");
                        connState.getServerKey().cancel();
                        iter.remove();
                        List list = DistributionAlgorithm.this.failedConnections;
                        synchronized (list) {
                            DistributionAlgorithm.this.failedConnections.add(client);
                        }
                    }
                }
                DistributionAlgorithm.this.processFailedConnections(DistributionAlgorithm.this.failedConnections);
                try {
                    Thread.sleep(DistributionAlgorithm.this.connectionTimeout / 2);
                }
                catch (InterruptedException e) {
                }
            }
        }
    }

    class PendingConnectionState {
        Target target;
        long startTime;
        SelectionKey serverConnectionKey;

        PendingConnectionState(Target target, long startTime, SelectionKey serverConnectionKey) {
            this.target = target;
            this.startTime = startTime;
            this.serverConnectionKey = serverConnectionKey;
        }

        Target getTarget() {
            return this.target;
        }

        long getStartTime() {
            return this.startTime;
        }

        SelectionKey getServerKey() {
            return this.serverConnectionKey;
        }
    }
}

