/*
 * Decompiled with CFR 0.152.
 */
package oss.distributor;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import oss.distributor.Controller;
import oss.distributor.DistributionAlgorithm;
import oss.distributor.Target;
import oss.distributor.TargetSelector;

public class Distributor {
    InetAddress bindAddress;
    int port;
    boolean terminateOnDisable;
    boolean halfClose;
    int connectionTimeout;
    int connectionFailureLimit;
    List targetGroups;
    List distributionAlgorithms;
    Logger logger;
    Object serviceTest;
    Controller controller;
    TargetSelector targetSelector;

    private static void usage() {
        System.err.println("Usage:  java -jar /path/to/distributor-x.x.jar /path/to/distributor.conf");
        System.exit(1);
    }

    public static void main(String[] args) {
        try {
            System.in.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        Distributor d = new Distributor(args);
        d.balance();
    }

    private Distributor(String[] args) {
        String loggingDefaultsString = new String();
        loggingDefaultsString = loggingDefaultsString + "java.util.logging.FileHandler.formatter = ";
        loggingDefaultsString = loggingDefaultsString + "java.util.logging.SimpleFormatter\n";
        loggingDefaultsString = loggingDefaultsString + "java.util.logging.FileHandler.append = true\n";
        ByteArrayInputStream loggingDefaultsStream = new ByteArrayInputStream(loggingDefaultsString.getBytes());
        try {
            LogManager.getLogManager().readConfiguration(loggingDefaultsStream);
        }
        catch (IOException e) {
            System.err.println("Error setting logging defaults:  " + e.getMessage());
            System.exit(1);
        }
        this.logger = Logger.getLogger(this.getClass().getName());
        this.logger.setLevel(Level.ALL);
        int controlPort = 0;
        if (args.length < 1) {
            Distributor.usage();
        }
        try {
            List<Target> targets;
            Node configNode;
            int i;
            DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document configDoc = db.parse(args[0]);
            Element rootElement = configDoc.getDocumentElement();
            NodeList configChildren = rootElement.getChildNodes();
            for (int i2 = 0; i2 < configChildren.getLength(); ++i2) {
                Node configNode2 = configChildren.item(i2);
                if (!configNode2.getNodeName().equals("log")) continue;
                Element logElement = (Element)configNode2;
                if (logElement.getAttribute("type").equals("console")) {
                    ConsoleHandler ch = new ConsoleHandler();
                    Level consoleLevel = null;
                    try {
                        consoleLevel = Distributor.parseLogLevel(logElement.getAttribute("level"));
                    }
                    catch (ParseException e) {
                        System.err.println("Unknown log level");
                        System.exit(1);
                    }
                    ch.setLevel(consoleLevel);
                    this.logger.addHandler(ch);
                    continue;
                }
                if (!logElement.getAttribute("type").equals("file")) continue;
                FileHandler fh = new FileHandler(logElement.getAttribute("filename"));
                Level fileLevel = null;
                try {
                    fileLevel = Distributor.parseLogLevel(logElement.getAttribute("level"));
                }
                catch (ParseException e) {
                    System.err.println("Unknown log level");
                    System.exit(1);
                }
                fh.setLevel(fileLevel);
                this.logger.addHandler(fh);
            }
            this.bindAddress = null;
            if (rootElement.getAttribute("bindaddr").equals("") || rootElement.getAttribute("bindaddr").equals("0.0.0.0")) {
                this.logger.config("Using wildcard bind address");
            } else {
                this.bindAddress = InetAddress.getByName(rootElement.getAttribute("bindaddr"));
            }
            this.logger.config("Bind address:  " + this.bindAddress);
            if (rootElement.getAttribute("port").equals("")) {
                this.logger.severe("The 'port' attribute is required");
                System.exit(1);
            } else {
                this.port = Integer.parseInt(rootElement.getAttribute("port"));
                this.logger.config("Port:  " + this.port);
            }
            this.terminateOnDisable = false;
            if (rootElement.getAttribute("terminate_on_disable").equals("yes")) {
                this.terminateOnDisable = true;
            }
            this.logger.config("Terminate on disable:  " + this.terminateOnDisable);
            this.halfClose = true;
            if (rootElement.getAttribute("half_close").equals("no")) {
                this.halfClose = false;
            }
            this.logger.config("TCP half close:  " + this.halfClose);
            this.connectionTimeout = 2000;
            if (rootElement.getAttribute("connection_timeout").equals("")) {
                this.logger.warning("Connection timeout not specified, using default");
            } else {
                this.connectionTimeout = Integer.parseInt(rootElement.getAttribute("connection_timeout"));
            }
            this.logger.config("Connection timeout:  " + this.connectionTimeout);
            this.connectionFailureLimit = 5;
            if (rootElement.getAttribute("connection_failure_limit").equals("")) {
                this.logger.warning("Connection failure limit not specified, using default");
            } else {
                this.connectionFailureLimit = Integer.parseInt(rootElement.getAttribute("connection_failure_limit"));
            }
            this.logger.config("Connection failure limit:  " + this.connectionFailureLimit);
            if (rootElement.getAttribute("control_port").equals("")) {
                this.logger.warning("No control port defined, no control server will be started");
            } else {
                controlPort = Integer.parseInt(rootElement.getAttribute("control_port"));
            }
            this.logger.config("Control port:  " + controlPort);
            this.distributionAlgorithms = new ArrayList();
            HashMap<String, String> algoClasses = new HashMap<String, String>();
            for (i = 0; i < configChildren.getLength(); ++i) {
                configNode = configChildren.item(i);
                if (!configNode.getNodeName().equals("algo_mapping")) continue;
                Element mapElement = (Element)configNode;
                String algoName = mapElement.getAttribute("name");
                String algoClass = mapElement.getAttribute("class");
                this.logger.finest("Loaded algo mapping:  " + algoName + " -> " + algoClass);
                algoClasses.put(algoName, algoClass);
            }
            for (i = 0; i < configChildren.getLength(); ++i) {
                configNode = configChildren.item(i);
                if (!configNode.getNodeName().equals("algorithms")) continue;
                Element algosElement = (Element)configNode;
                NodeList algosChildren = algosElement.getChildNodes();
                for (int j = 0; j < algosChildren.getLength(); ++j) {
                    Node algoNode = algosChildren.item(j);
                    if (!algoNode.getNodeName().equals("algorithm")) continue;
                    Element algoElement = (Element)algoNode;
                    String algoName = algoElement.getAttribute("name");
                    this.logger.finer("Constructing " + algoClasses.get(algoName));
                    Object distAlgo = this.constructObjectFromName((String)algoClasses.get(algoName), algoElement);
                    this.distributionAlgorithms.add(distAlgo);
                }
            }
            if (this.distributionAlgorithms.size() > 0) {
                this.logger.config("Distribution algorithms:");
                Iterator iter = this.distributionAlgorithms.iterator();
                while (iter.hasNext()) {
                    this.logger.config(iter.next().toString());
                }
            } else {
                this.logger.severe("At least one distribution algorithm must be specified");
                System.exit(1);
            }
            this.targetGroups = new ArrayList();
            for (int i3 = 0; i3 < configChildren.getLength(); ++i3) {
                configNode = configChildren.item(i3);
                if (!configNode.getNodeName().equals("target_group")) continue;
                targets = new ArrayList();
                Element tgElement = (Element)configNode;
                NodeList tgChildren = tgElement.getChildNodes();
                for (int j = 0; j < tgChildren.getLength(); ++j) {
                    Node tgNode = tgChildren.item(j);
                    if (!tgNode.getNodeName().equals("target")) continue;
                    Element targetElement = (Element)tgNode;
                    targets.add(new Target(this, InetAddress.getByName(targetElement.getAttribute("hostname")), Integer.parseInt(targetElement.getAttribute("port")), this.connectionFailureLimit, this.terminateOnDisable, this.halfClose));
                }
                if (targets.size() <= 0) continue;
                this.targetGroups.add(targets);
            }
            if (this.targetGroups.size() > 0) {
                this.logger.config("Target groups:");
                Iterator tgIter = this.targetGroups.iterator();
                int tgCounter = 0;
                while (tgIter.hasNext()) {
                    this.logger.config("Group " + tgCounter + ":");
                    ++tgCounter;
                    targets = (List)tgIter.next();
                    Iterator targetIter = targets.iterator();
                    while (targetIter.hasNext()) {
                        this.logger.config("  " + targetIter.next());
                    }
                }
            } else {
                this.logger.severe("At least one target group must be specified");
                System.exit(1);
            }
            this.serviceTest = null;
            String serviceType = rootElement.getAttribute("service_type");
            this.logger.config("Service type:  " + serviceType);
            if (serviceType.equals("")) {
                this.logger.warning("No service test specified, none will be used");
            } else if (serviceType.equals("none")) {
                this.logger.config("Configured for no service test");
            } else {
                Element testParameters = null;
                String testClassName = null;
                for (int i4 = 0; i4 < configChildren.getLength(); ++i4) {
                    Element elem;
                    Node node = configChildren.item(i4);
                    if (node.getNodeName().equals("test_parameters")) {
                        elem = (Element)node;
                        if (!elem.getAttribute("service_type").equals(serviceType)) continue;
                        testParameters = elem;
                        continue;
                    }
                    if (!node.getNodeName().equals("type_mapping") || !(elem = (Element)node).getAttribute("service_type").equals(serviceType)) continue;
                    testClassName = elem.getAttribute("class");
                    this.logger.config("Service test class:  " + testClassName);
                }
                if (testParameters == null) {
                    this.logger.severe("Test parameters for service test not found");
                    System.exit(1);
                }
                if (testClassName == null) {
                    this.logger.severe("Service test class name not found");
                    System.exit(1);
                }
                this.logger.finer("Constructing " + testClassName);
                this.serviceTest = this.constructObjectFromName(testClassName, testParameters);
            }
        }
        catch (ParserConfigurationException e) {
            System.err.println("Error reading config file: " + e.getMessage());
            System.exit(1);
        }
        catch (SAXException e) {
            System.err.println("Error reading config file: " + e.getMessage());
            System.exit(1);
        }
        catch (IOException e) {
            System.err.println("Error reading config file: " + e.getMessage());
            System.exit(1);
        }
        catch (NumberFormatException e) {
            System.err.println("Error reading config file: " + e.getMessage());
            System.exit(1);
        }
        if (controlPort != 0) {
            this.controller = new Controller(this, controlPort);
        }
        this.targetSelector = new TargetSelector(this);
        this.targetSelector.finishInitialization();
        Iterator iter = this.distributionAlgorithms.iterator();
        while (iter.hasNext()) {
            DistributionAlgorithm algo = (DistributionAlgorithm)iter.next();
            algo.finishInitialization();
        }
    }

    private Object constructObjectFromName(String className, Element configElement) {
        try {
            Class<?> objClass = Class.forName(className);
            Class[] constructorArgumentClasses = new Class[]{this.getClass(), Class.forName("org.w3c.dom.Element")};
            Constructor<?> classConstructor = objClass.getConstructor(constructorArgumentClasses);
            Object[] constructorArguments = new Object[]{this, configElement};
            Object obj = classConstructor.newInstance(constructorArguments);
            return obj;
        }
        catch (ClassNotFoundException e) {
            this.logger.severe("Class not found:  " + e.getMessage());
            System.exit(1);
        }
        catch (NoSuchMethodException e) {
            this.logger.severe("Constructor in class not found:  " + e.getMessage());
            System.exit(1);
        }
        catch (InstantiationException e) {
            this.logger.severe("Class is abstract:  " + e.getMessage());
            System.exit(1);
        }
        catch (IllegalAccessException e) {
            this.logger.severe("Access to class constructor prohibited:  " + e.getMessage());
            System.exit(1);
        }
        catch (InvocationTargetException e) {
            this.logger.severe("Class constructor threw exception:  " + e.getCause().getMessage());
            System.exit(1);
        }
        return null;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public List getDistributionAlgorithms() {
        return this.distributionAlgorithms;
    }

    public List getTargetGroups() {
        return this.targetGroups;
    }

    public TargetSelector getTargetSelector() {
        return this.targetSelector;
    }

    protected Controller getController() {
        return this.controller;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public int getConnectionFailureLimit() {
        return this.connectionFailureLimit;
    }

    public boolean getTerminate() {
        return this.terminateOnDisable;
    }

    public boolean getHalfClose() {
        return this.halfClose;
    }

    public List getTargets() {
        ArrayList all = new ArrayList();
        Iterator i = this.targetGroups.iterator();
        while (i.hasNext()) {
            List tg = (List)i.next();
            all.addAll(tg);
        }
        return all;
    }

    private void balance() {
        try {
            ServerSocketChannel server = ServerSocketChannel.open();
            server.socket().bind(new InetSocketAddress(this.bindAddress, this.port));
            while (true) {
                SocketChannel client = server.accept();
                this.logger.fine("Accepted connection from " + client);
                this.targetSelector.addNewClient(client);
            }
        }
        catch (IOException e) {
            this.logger.warning("Error with server socket: " + e.getMessage());
            return;
        }
    }

    public static Level parseLogLevel(String levelName) throws ParseException {
        if (levelName.equals("off")) {
            return Level.OFF;
        }
        if (levelName.equals("severe")) {
            return Level.SEVERE;
        }
        if (levelName.equals("warning")) {
            return Level.WARNING;
        }
        if (levelName.equals("info")) {
            return Level.INFO;
        }
        if (levelName.equals("config")) {
            return Level.CONFIG;
        }
        if (levelName.equals("fine")) {
            return Level.FINE;
        }
        if (levelName.equals("finer")) {
            return Level.FINER;
        }
        if (levelName.equals("finest")) {
            return Level.FINEST;
        }
        if (levelName.equals("all")) {
            return Level.ALL;
        }
        throw new ParseException("Unrecognized log level", 0);
    }
}

