/*
 * Decompiled with CFR 0.152.
 */
package oss.distributor;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import oss.distributor.BackgroundTest;
import oss.distributor.Distributor;
import oss.distributor.Target;

class HTTPServiceTest
implements Runnable {
    Distributor distributor;
    Logger logger;
    int frequency;
    int timeout;
    boolean useSSL;
    String path;
    String userAgent;
    protected static final int REQUIREMENT_RESPONSE_CODE = 1;
    protected static final int REQUIREMENT_CONTENT_TYPE = 2;
    protected static final int REQUIREMENT_DOCUMENT_TEXT = 3;
    Map requirements;
    Thread thread;

    public HTTPServiceTest(Distributor distributor, Element configElement) {
        this.distributor = distributor;
        this.logger = distributor.getLogger();
        this.frequency = 60000;
        try {
            this.frequency = Integer.parseInt(configElement.getAttribute("frequency"));
        }
        catch (NumberFormatException e) {
            this.logger.warning("Invalid frequency, using default:  " + e.getMessage());
        }
        this.logger.config("Test frequency:  " + this.frequency);
        this.timeout = 5000;
        try {
            this.timeout = Integer.parseInt(configElement.getAttribute("timeout"));
        }
        catch (NumberFormatException e) {
            this.logger.warning("Invalid timeout, using default:  " + e.getMessage());
        }
        this.logger.config("Test timeout:  " + this.timeout);
        this.useSSL = false;
        if (configElement.getAttribute("use_ssl").equals("yes")) {
            this.useSSL = true;
        }
        this.logger.config("Use SSL:  " + this.useSSL);
        this.userAgent = "Distributor - http://distributor.sourceforge.net/";
        if (!configElement.getAttribute("user_agent").equals("")) {
            this.userAgent = configElement.getAttribute("user_agent");
        }
        this.logger.config("User agent:  " + this.userAgent);
        if (!configElement.getAttribute("ssl_keystore").equals("")) {
            System.setProperty("javax.net.ssl.trustStore", configElement.getAttribute("ssl_keystore"));
        }
        this.logger.config("SSL keystore:  " + System.getProperty("javax.net.ssl.trustStore"));
        this.requirements = new LinkedHashMap();
        NodeList configChildren = configElement.getChildNodes();
        for (int i = 0; i < configChildren.getLength(); ++i) {
            Node configNode = configChildren.item(i);
            if (!configNode.getNodeName().equals("get")) continue;
            Element getElement = (Element)configNode;
            this.path = getElement.getAttribute("path");
            NodeList getChildren = getElement.getChildNodes();
            for (int j = 0; j < getChildren.getLength(); ++j) {
                Node getNode = getChildren.item(j);
                if (getNode.getNodeName().equals("response_code")) {
                    Element responseCodeElement = (Element)getNode;
                    int code = Integer.parseInt(responseCodeElement.getAttribute("value"));
                    this.requirements.put(new Integer(1), new Integer(code));
                    continue;
                }
                if (getNode.getNodeName().equals("content_type")) {
                    Element contentTypeElement = (Element)getNode;
                    String type = contentTypeElement.getAttribute("value");
                    this.requirements.put(new Integer(2), type);
                    continue;
                }
                if (!getNode.getNodeName().equals("document_text")) continue;
                Element documentTextElement = (Element)getNode;
                String requiredText = documentTextElement.getAttribute("value");
                this.requirements.put(new Integer(3), requiredText);
            }
        }
        if (this.path == null) {
            this.logger.severe("A path is required");
            System.exit(1);
        }
        if (this.requirements.size() == 0) {
            this.requirements.put(new Integer(1), new Integer(200));
        }
        this.logger.config("Path:  " + this.path);
        this.logger.config("Requirements:  " + this.requirements);
        this.thread = new Thread((Runnable)this, this.getClass().getName());
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            List targets;
            List list = targets = this.distributor.getTargets();
            synchronized (list) {
                Iterator i = targets.iterator();
                while (i.hasNext()) {
                    try {
                        boolean result;
                        HTTPBackgroundTest httpTest;
                        Target target = (Target)i.next();
                        HTTPBackgroundTest hTTPBackgroundTest = httpTest = new HTTPBackgroundTest(target);
                        synchronized (hTTPBackgroundTest) {
                            httpTest.startTest();
                            httpTest.wait(this.timeout);
                        }
                        if (httpTest.getResult() == 2) {
                            result = true;
                        } else {
                            result = false;
                            if (httpTest.getResult() == 1) {
                                this.logger.warning("Test timed out");
                            }
                        }
                        if (result && !target.isEnabled()) {
                            this.logger.warning("Enabling: " + target);
                            target.enable();
                            continue;
                        }
                        if (result || !target.isEnabled()) continue;
                        this.logger.warning("Disabling: " + target);
                        target.disable();
                    }
                    catch (InterruptedException e) {
                        this.logger.warning("Service test interrupted");
                    }
                }
            }
            try {
                Thread.sleep(this.frequency);
            }
            catch (InterruptedException e) {
            }
        }
    }

    class HTTPBackgroundTest
    extends BackgroundTest {
        protected HTTPBackgroundTest(Target target) {
            super(target);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void test() {
            try {
                String hostname;
                String proto = "http";
                if (HTTPServiceTest.this.useSSL) {
                    proto = "https";
                }
                if ((hostname = this.target.getInetAddress().getHostName()).indexOf(58) != -1) {
                    hostname = "[" + hostname + "]";
                }
                URL serverURL = new URL(proto, hostname, this.target.getPort(), HTTPServiceTest.this.path);
                HTTPServiceTest.this.logger.fine("Server URL is " + serverURL);
                HTTPServiceTest.this.logger.fine("Opening connection to server");
                HttpURLConnection conn = (HttpURLConnection)serverURL.openConnection();
                conn.setRequestProperty("User-Agent", HTTPServiceTest.this.userAgent);
                Iterator i = HTTPServiceTest.this.requirements.entrySet().iterator();
                this.success = true;
                while (i.hasNext() && this.success) {
                    Map.Entry requirementEntry = i.next();
                    int requirement = (Integer)requirementEntry.getKey();
                    switch (requirement) {
                        case 1: {
                            int requiredCode = (Integer)requirementEntry.getValue();
                            HTTPServiceTest.this.logger.finer("Checking for response code: " + requiredCode);
                            if (conn.getResponseCode() == requiredCode) break;
                            HTTPServiceTest.this.logger.warning("Required response code is " + requiredCode + ", got " + conn.getResponseCode());
                            this.success = false;
                            break;
                        }
                        case 2: {
                            String requiredType = (String)requirementEntry.getValue();
                            HTTPServiceTest.this.logger.finer("Checking for content type: " + requiredType);
                            if (conn.getContentType().equals(requiredType)) break;
                            HTTPServiceTest.this.logger.warning("Required content type is " + requiredType + ", got " + conn.getContentType());
                            this.success = false;
                            break;
                        }
                        case 3: {
                            String docLine;
                            String requiredText = (String)requirementEntry.getValue();
                            HTTPServiceTest.this.logger.finer("Checking for document text: " + requiredText);
                            BufferedReader docReader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                            this.success = false;
                            while ((docLine = docReader.readLine()) != null) {
                                if (docLine.indexOf(requiredText) == -1) continue;
                                this.success = true;
                                HTTPServiceTest.this.logger.finer("Required text found");
                            }
                            if (this.success) break;
                            HTTPServiceTest.this.logger.warning("Required text not found");
                        }
                    }
                }
                conn.disconnect();
                if (this.success) {
                    HTTPServiceTest.this.logger.fine("Server met all requirements");
                }
                this.finished = true;
                HTTPBackgroundTest hTTPBackgroundTest = this;
                synchronized (hTTPBackgroundTest) {
                    this.notify();
                }
            }
            catch (MalformedURLException e) {
                HTTPServiceTest.this.logger.warning("Error building URL: " + e.getMessage());
                this.finished = true;
                this.success = true;
                return;
            }
            catch (IOException e) {
                HTTPServiceTest.this.logger.warning("Error communicating with server: " + e.getMessage());
                return;
            }
        }
    }
}

