/*
 * Decompiled with CFR 0.152.
 */
package oss.distributor;

import java.net.InetAddress;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import oss.distributor.Connection;
import oss.distributor.DistributionAlgorithm;
import oss.distributor.Distributor;
import oss.distributor.Target;

class HashDistributionAlgorithm
extends DistributionAlgorithm
implements Runnable {
    int hashTimeout = 1800000;
    Map ipMap;
    Map lastConnectTime;
    IpMapCleaner ipMapCleaner;

    public HashDistributionAlgorithm(Distributor distributor, Element configElement) {
        super(distributor);
        if (configElement.getAttribute("hash_timeout").equals("")) {
            this.logger.warning("No hash timeout specified, using default");
        } else {
            try {
                this.hashTimeout = Integer.parseInt(configElement.getAttribute("hash_timeout"));
            }
            catch (NumberFormatException e) {
                this.logger.warning("Invalid hash timeout, using default:  " + e.getMessage());
            }
        }
        this.logger.config("Hash timeout:  " + this.hashTimeout);
        this.ipMap = new HashMap();
        this.lastConnectTime = new HashMap();
        this.ipMapCleaner = new IpMapCleaner();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean processNewClients() {
        boolean didSomething = false;
        List list = this.newClients;
        synchronized (list) {
            Iterator iter = this.newClients.iterator();
            while (iter.hasNext()) {
                SocketChannel client = (SocketChannel)iter.next();
                iter.remove();
                Target target = (Target)this.ipMap.get(client.socket().getInetAddress());
                if (target != null) {
                    this.logger.finer("Existing mapping for " + client.socket().getInetAddress() + " to " + target);
                    if (target.isEnabled()) {
                        this.initiateConnection(client, target);
                    } else {
                        this.logger.finer("Existing mapping for " + client.socket().getInetAddress() + " points to a disabled target");
                        this.targetSelector.addUnconnectedClient(client);
                    }
                } else {
                    this.logger.finer("No existing mapping for " + client.socket().getInetAddress());
                    this.targetSelector.addUnconnectedClient(client);
                }
                didSomething = true;
            }
        }
        return didSomething;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processCompletedConnections(List completedConnections) {
        List list = completedConnections;
        synchronized (list) {
            Iterator iter = completedConnections.iterator();
            while (iter.hasNext()) {
                Connection conn = (Connection)iter.next();
                iter.remove();
                this.targetSelector.addFinishedClient(conn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processFailedConnections(List failedConnections) {
        List list = failedConnections;
        synchronized (list) {
            Iterator iter = failedConnections.iterator();
            while (iter.hasNext()) {
                SocketChannel client = (SocketChannel)iter.next();
                iter.remove();
                this.targetSelector.addUnconnectedClient(client);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionNotify(Connection conn) {
        Map map = this.ipMap;
        synchronized (map) {
            this.logger.finer("Storing mapping from " + conn.getClient().socket().getInetAddress() + " to " + conn.getTarget());
            this.ipMap.put(conn.getClient().socket().getInetAddress(), conn.getTarget());
        }
        map = this.lastConnectTime;
        synchronized (map) {
            this.lastConnectTime.put(conn.getClient().socket().getInetAddress(), new Long(System.currentTimeMillis()));
        }
    }

    public String getMemoryStats(String indent) {
        String stats = super.getMemoryStats(indent) + "\n";
        stats = stats + indent + this.ipMap.size() + " entries in ipMap Map\n";
        stats = stats + indent + this.lastConnectTime.size() + " entries in lastConnectTime Map";
        return stats;
    }

    class IpMapCleaner
    implements Runnable {
        Thread thread = new Thread((Runnable)this, this.getClass().getName());

        IpMapCleaner() {
            this.thread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            long sleepTime = HashDistributionAlgorithm.this.hashTimeout / 4;
            if (sleepTime > 900000L) {
                sleepTime = 900000L;
            }
            while (true) {
                Map map = HashDistributionAlgorithm.this.lastConnectTime;
                synchronized (map) {
                    Iterator iter = HashDistributionAlgorithm.this.lastConnectTime.entrySet().iterator();
                    while (iter.hasNext()) {
                        Map.Entry timeEntry = iter.next();
                        InetAddress addr = (InetAddress)timeEntry.getKey();
                        long lastConnect = (Long)timeEntry.getValue();
                        if (lastConnect + (long)HashDistributionAlgorithm.this.hashTimeout >= System.currentTimeMillis()) continue;
                        Map map2 = HashDistributionAlgorithm.this.ipMap;
                        synchronized (map2) {
                            HashDistributionAlgorithm.this.ipMap.remove(addr);
                        }
                        HashDistributionAlgorithm.this.lastConnectTime.remove(addr);
                    }
                }
                try {
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException e) {
                }
            }
        }
    }
}

