/*
 * Decompiled with CFR 0.152.
 */
package oss.distributor;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.StartTlsRequest;
import javax.naming.ldap.StartTlsResponse;
import javax.net.ssl.SSLSession;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import oss.distributor.BackgroundTest;
import oss.distributor.Distributor;
import oss.distributor.Target;

class LDAPServiceTest
implements Runnable {
    Distributor distributor;
    Logger logger;
    Hashtable env;
    int frequency;
    int timeout;
    String searchDN;
    Map requiredAttributes;
    String[] requiredAttributeNames;
    int sslType;
    Thread thread;
    protected static final int SSL_NONE = 0;
    protected static final int SSL_LDAPS = 1;
    protected static final int SSL_STARTTLS = 2;

    public LDAPServiceTest(Distributor distributor, Element configElement) {
        this.distributor = distributor;
        this.logger = distributor.getLogger();
        this.env = new Hashtable();
        this.env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        this.frequency = 60000;
        try {
            this.frequency = Integer.parseInt(configElement.getAttribute("frequency"));
        }
        catch (NumberFormatException e) {
            this.logger.warning("Invalid frequency, using default:  " + e.getMessage());
        }
        this.logger.config("Test frequency:  " + this.frequency);
        this.timeout = 5000;
        try {
            this.timeout = Integer.parseInt(configElement.getAttribute("timeout"));
        }
        catch (NumberFormatException e) {
            this.logger.warning("Invalid timeout, using default:  " + e.getMessage());
        }
        this.logger.config("Test timeout:  " + this.timeout);
        this.sslType = configElement.getAttribute("ssl_type").equals("starttls") ? 2 : (configElement.getAttribute("ssl_type").equals("ldaps") ? 1 : 0);
        this.logger.config("SSL type:  " + this.sslType);
        if (!configElement.getAttribute("ssl_keystore").equals("")) {
            System.setProperty("javax.net.ssl.trustStore", configElement.getAttribute("ssl_keystore"));
        }
        this.logger.config("SSL keystore:  " + System.getProperty("javax.net.ssl.trustStore"));
        this.searchDN = null;
        this.requiredAttributes = new LinkedHashMap();
        NodeList configChildren = configElement.getChildNodes();
        for (int i = 0; i < configChildren.getLength(); ++i) {
            Node configNode = configChildren.item(i);
            if (!configNode.getNodeName().equals("query")) continue;
            Element queryElement = (Element)configNode;
            this.searchDN = queryElement.getAttribute("dn");
            NodeList queryChildren = queryElement.getChildNodes();
            for (int j = 0; j < queryChildren.getLength(); ++j) {
                Node queryNode = queryChildren.item(j);
                if (!queryNode.getNodeName().equals("required_attribute")) continue;
                Element reqAttrElement = (Element)queryNode;
                if (reqAttrElement.getAttribute("value").equals("")) {
                    this.requiredAttributes.put(reqAttrElement.getAttribute("name"), null);
                    continue;
                }
                this.requiredAttributes.put(reqAttrElement.getAttribute("name"), reqAttrElement.getAttribute("value"));
            }
        }
        if (this.searchDN == null) {
            this.logger.severe("A search DN is required");
            System.exit(1);
        }
        if (this.requiredAttributes.size() == 0) {
            this.logger.severe("At least one required attribute must be specified");
            System.exit(1);
        }
        this.logger.config("Search DN:  " + this.searchDN);
        this.logger.config("Required attributes:  " + this.requiredAttributes);
        this.requiredAttributeNames = new String[this.requiredAttributes.keySet().size()];
        Iterator i = this.requiredAttributes.keySet().iterator();
        int j = 0;
        while (i.hasNext()) {
            String attrName = (String)i.next();
            this.logger.fine("Adding " + attrName + " to result list");
            this.requiredAttributeNames[j] = attrName;
            ++j;
        }
        this.thread = new Thread((Runnable)this, this.getClass().getName());
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            List targets;
            List list = targets = this.distributor.getTargets();
            synchronized (list) {
                Iterator i = targets.iterator();
                while (i.hasNext()) {
                    try {
                        boolean result;
                        LDAPBackgroundTest ldapTest;
                        Target target = (Target)i.next();
                        LDAPBackgroundTest lDAPBackgroundTest = ldapTest = new LDAPBackgroundTest(target);
                        synchronized (lDAPBackgroundTest) {
                            ldapTest.startTest();
                            ldapTest.wait(this.timeout);
                        }
                        if (ldapTest.getResult() == 2) {
                            result = true;
                        } else {
                            result = false;
                            if (ldapTest.getResult() == 1) {
                                this.logger.warning("Test timed out");
                            }
                        }
                        if (result && !target.isEnabled()) {
                            this.logger.warning("Enabling: " + target);
                            target.enable();
                            continue;
                        }
                        if (result || !target.isEnabled()) continue;
                        this.logger.warning("Disabling: " + target);
                        target.disable();
                    }
                    catch (InterruptedException e) {
                        this.logger.warning("Service test interrupted");
                    }
                }
            }
            try {
                Thread.sleep(this.frequency);
            }
            catch (InterruptedException e) {
            }
        }
    }

    class LDAPBackgroundTest
    extends BackgroundTest {
        protected LDAPBackgroundTest(Target target) {
            super(target);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void test() {
            String hostname = this.target.getInetAddress().getHostName();
            if (hostname.indexOf(58) != -1) {
                hostname = "[" + hostname + "]";
            }
            String serverURL = "ldap://" + hostname + ":" + this.target.getPort() + "/";
            LDAPServiceTest.this.logger.fine("Server URL is " + serverURL);
            LDAPServiceTest.this.env.put("java.naming.provider.url", serverURL);
            if (LDAPServiceTest.this.sslType == 1) {
                LDAPServiceTest.this.logger.finer("Enabling SSL (ldaps)");
                LDAPServiceTest.this.env.put("java.naming.security.protocol", "ssl");
            } else {
                LDAPServiceTest.this.env.remove("java.naming.security.protocol");
            }
            try {
                LDAPServiceTest.this.logger.finest("Creating context");
                InitialLdapContext ctx = new InitialLdapContext(LDAPServiceTest.this.env, null);
                if (LDAPServiceTest.this.sslType == 2) {
                    LDAPServiceTest.this.logger.finer("Starting TLS");
                    StartTlsResponse tls = (StartTlsResponse)ctx.extendedOperation(new StartTlsRequest());
                    SSLSession sess = tls.negotiate();
                }
                LDAPServiceTest.this.logger.finer("Getting attributes from server");
                Attributes returnedAttributes = ctx.getAttributes(LDAPServiceTest.this.searchDN, LDAPServiceTest.this.requiredAttributeNames);
                Iterator i = LDAPServiceTest.this.requiredAttributes.entrySet().iterator();
                this.success = true;
                while (i.hasNext() && this.success) {
                    Map.Entry reqAttr = i.next();
                    String reqAttrKey = (String)reqAttr.getKey();
                    String reqAttrValue = (String)reqAttr.getValue();
                    LDAPServiceTest.this.logger.finer("Checking for attribute: " + reqAttr);
                    Attribute returnedAttr = returnedAttributes.get(reqAttrKey);
                    if (returnedAttr == null) {
                        LDAPServiceTest.this.logger.warning("Required attribute " + reqAttrKey + " not in returned attributes " + returnedAttributes);
                        this.success = false;
                        continue;
                    }
                    if (reqAttrValue == null || returnedAttr.contains(reqAttrValue)) continue;
                    LDAPServiceTest.this.logger.warning("Required attribute value " + reqAttrValue + " not in returned values " + returnedAttr);
                    this.success = false;
                }
                LDAPServiceTest.this.logger.finest("Closing context");
                ctx.close();
                if (this.success) {
                    LDAPServiceTest.this.logger.fine("Server returned all required attributes");
                }
                this.finished = true;
                LDAPBackgroundTest lDAPBackgroundTest = this;
                synchronized (lDAPBackgroundTest) {
                    this.notify();
                }
            }
            catch (NamingException e) {
                LDAPServiceTest.this.logger.warning("Error communicating with LDAP server: " + e.getMessage());
                return;
            }
            catch (IOException e) {
                LDAPServiceTest.this.logger.warning("Error negotiating TLS with LDAP server: " + e.getMessage());
                return;
            }
        }
    }
}

