/*
 * Decompiled with CFR 0.152.
 */
package oss.distributor;

import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import oss.distributor.Connection;
import oss.distributor.DistributionAlgorithm;
import oss.distributor.Distributor;
import oss.distributor.Target;

class RoundRobinDistributionAlgorithm
extends DistributionAlgorithm {
    Map clientStates = new HashMap();
    List nextTargetIndicies = new ArrayList();
    List targetGroups;

    public RoundRobinDistributionAlgorithm(Distributor distributor, Element configElement) {
        super(distributor);
    }

    public void finishInitialization() {
        super.finishInitialization();
        this.targetGroups = this.distributor.getTargetGroups();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean processNewClients() {
        boolean didSomething = false;
        List list = this.newClients;
        synchronized (list) {
            Iterator iter = this.newClients.iterator();
            while (iter.hasNext()) {
                SocketChannel client = (SocketChannel)iter.next();
                iter.remove();
                Map map = this.clientStates;
                synchronized (map) {
                    this.clientStates.put(client, new ClientState());
                }
                this.tryNextTarget(client);
                didSomething = true;
            }
        }
        return didSomething;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryNextTarget(SocketChannel client) {
        Target target;
        ClientState clientState;
        Map map = this.clientStates;
        synchronized (map) {
            clientState = (ClientState)this.clientStates.get(client);
        }
        try {
            target = clientState.getNextTarget();
        }
        catch (NoMoreTargetsException e) {
            this.logger.fine("Tried all targets for " + client + " without success");
            Map map2 = this.clientStates;
            synchronized (map2) {
                this.clientStates.remove(client);
            }
            this.targetSelector.addUnconnectedClient(client);
            return;
        }
        if (target.isEnabled()) {
            this.logger.finer("Initiating connection from " + client + " to " + target);
            this.initiateConnection(client, target);
        } else {
            this.tryNextTarget(client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processCompletedConnections(List completedConnections) {
        List list = completedConnections;
        synchronized (list) {
            Iterator iter = completedConnections.iterator();
            while (iter.hasNext()) {
                Connection conn = (Connection)iter.next();
                iter.remove();
                Map map = this.clientStates;
                synchronized (map) {
                    this.clientStates.remove(conn.getClient());
                }
                this.targetSelector.addFinishedClient(conn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processFailedConnections(List failedConnections) {
        List list = failedConnections;
        synchronized (list) {
            Iterator iter = failedConnections.iterator();
            while (iter.hasNext()) {
                SocketChannel client = (SocketChannel)iter.next();
                iter.remove();
                this.tryNextTarget(client);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNextTargetIndex(int targetGroupIndex) throws NoSuchTargetGroupException {
        int index;
        List list = this.nextTargetIndicies;
        synchronized (list) {
            int nextIndex;
            List targetGroup;
            if (targetGroupIndex > this.nextTargetIndicies.size() - 1) {
                for (int i = this.nextTargetIndicies.size(); i <= targetGroupIndex; ++i) {
                    this.nextTargetIndicies.add(new Integer(0));
                }
            }
            Integer indexInteger = (Integer)this.nextTargetIndicies.get(targetGroupIndex);
            index = indexInteger;
            List list2 = this.targetGroups;
            synchronized (list2) {
                try {
                    targetGroup = (List)this.targetGroups.get(targetGroupIndex);
                }
                catch (IndexOutOfBoundsException e) {
                    throw new NoSuchTargetGroupException();
                }
            }
            list2 = targetGroup;
            synchronized (list2) {
                nextIndex = index < targetGroup.size() - 1 ? index + 1 : 0;
            }
            this.nextTargetIndicies.set(targetGroupIndex, new Integer(nextIndex));
        }
        return index;
    }

    public String getMemoryStats(String indent) {
        String stats = super.getMemoryStats(indent) + "\n";
        stats = stats + indent + this.clientStates.size() + " entries in clientStates Map\n";
        stats = stats + indent + this.nextTargetIndicies.size() + " entries in nextTargetIndicies List";
        return stats;
    }

    class ClientState {
        int currentTargetGroupIndex;
        int nextTargetIndex;
        int lastTargetIndex;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ClientState() {
            block6: {
                this.currentTargetGroupIndex = 0;
                try {
                    List currentTargetGroup;
                    this.nextTargetIndex = RoundRobinDistributionAlgorithm.this.getNextTargetIndex(this.currentTargetGroupIndex);
                    if (this.nextTargetIndex > 0) {
                        this.lastTargetIndex = this.nextTargetIndex - 1;
                        break block6;
                    }
                    List list = RoundRobinDistributionAlgorithm.this.targetGroups;
                    synchronized (list) {
                        currentTargetGroup = (List)RoundRobinDistributionAlgorithm.this.targetGroups.get(this.currentTargetGroupIndex);
                    }
                    this.lastTargetIndex = currentTargetGroup.size() - 1;
                }
                catch (NoSuchTargetGroupException e) {
                    this.nextTargetIndex = 0;
                    this.lastTargetIndex = 0;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Target getNextTarget() throws NoMoreTargetsException {
            Target nextTarget;
            block18: {
                List currentTargetGroup;
                List list = RoundRobinDistributionAlgorithm.this.targetGroups;
                synchronized (list) {
                    try {
                        currentTargetGroup = (List)RoundRobinDistributionAlgorithm.this.targetGroups.get(this.currentTargetGroupIndex);
                    }
                    catch (IndexOutOfBoundsException e) {
                        throw new NoMoreTargetsException();
                    }
                }
                list = currentTargetGroup;
                synchronized (list) {
                    if (this.nextTargetIndex > currentTargetGroup.size() - 1) {
                        this.nextTargetIndex = 0;
                    }
                    if (this.lastTargetIndex > currentTargetGroup.size() - 1) {
                        this.lastTargetIndex = currentTargetGroup.size() - 1;
                    }
                    nextTarget = (Target)currentTargetGroup.get(this.nextTargetIndex);
                }
                if (this.nextTargetIndex == this.lastTargetIndex) {
                    ++this.currentTargetGroupIndex;
                    try {
                        List nextTargetGroup;
                        this.nextTargetIndex = RoundRobinDistributionAlgorithm.this.getNextTargetIndex(this.currentTargetGroupIndex);
                        if (this.nextTargetIndex > 0) {
                            this.lastTargetIndex = this.nextTargetIndex - 1;
                            break block18;
                        }
                        List list2 = RoundRobinDistributionAlgorithm.this.targetGroups;
                        synchronized (list2) {
                            nextTargetGroup = (List)RoundRobinDistributionAlgorithm.this.targetGroups.get(this.currentTargetGroupIndex);
                        }
                        this.lastTargetIndex = nextTargetGroup.size() - 1;
                    }
                    catch (NoSuchTargetGroupException e) {
                        this.nextTargetIndex = 0;
                        this.lastTargetIndex = 0;
                    }
                } else {
                    this.nextTargetIndex = this.nextTargetIndex >= currentTargetGroup.size() - 1 ? 0 : ++this.nextTargetIndex;
                }
            }
            return nextTarget;
        }
    }

    class NoSuchTargetGroupException
    extends Exception {
        NoSuchTargetGroupException() {
        }
    }

    class NoMoreTargetsException
    extends Exception {
        NoMoreTargetsException() {
        }
    }
}

