/*
 * Decompiled with CFR 0.152.
 */
package oss.distributor;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.w3c.dom.Element;
import oss.distributor.BackgroundTest;
import oss.distributor.Distributor;
import oss.distributor.Target;

class ScriptServiceTest
implements Runnable {
    Distributor distributor;
    Logger logger;
    int frequency;
    int timeout;
    String script;
    Thread thread;

    public ScriptServiceTest(Distributor distributor, Element configElement) {
        this.distributor = distributor;
        this.logger = distributor.getLogger();
        this.frequency = 60000;
        try {
            this.frequency = Integer.parseInt(configElement.getAttribute("frequency"));
        }
        catch (NumberFormatException e) {
            this.logger.warning("Invalid frequency, using default:  " + e.getMessage());
        }
        this.logger.config("Test frequency:  " + this.frequency);
        this.timeout = 5000;
        try {
            this.timeout = Integer.parseInt(configElement.getAttribute("timeout"));
        }
        catch (NumberFormatException e) {
            this.logger.warning("Invalid timeout, using default:  " + e.getMessage());
        }
        this.logger.config("Test timeout:  " + this.timeout);
        this.script = configElement.getAttribute("script");
        this.logger.config("Script:  " + this.script);
        if (this.script == null) {
            this.logger.severe("A script is required");
            System.exit(1);
        }
        this.thread = new Thread((Runnable)this, this.getClass().getName());
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            List targets;
            List list = targets = this.distributor.getTargets();
            synchronized (list) {
                Iterator i = targets.iterator();
                while (i.hasNext()) {
                    try {
                        boolean result;
                        ScriptBackgroundTest scriptTest;
                        Target target = (Target)i.next();
                        ScriptBackgroundTest scriptBackgroundTest = scriptTest = new ScriptBackgroundTest(target);
                        synchronized (scriptBackgroundTest) {
                            scriptTest.startTest();
                            scriptTest.wait(this.timeout);
                        }
                        if (scriptTest.getResult() == 2) {
                            result = true;
                        } else {
                            result = false;
                            if (scriptTest.getResult() == 1) {
                                this.logger.warning("Test timed out");
                            }
                        }
                        if (result && !target.isEnabled()) {
                            this.logger.warning("Enabling: " + target);
                            target.enable();
                            continue;
                        }
                        if (result || !target.isEnabled()) continue;
                        this.logger.warning("Disabling: " + target);
                        target.disable();
                    }
                    catch (InterruptedException e) {
                        this.logger.warning("Service test interrupted");
                    }
                }
            }
            try {
                Thread.sleep(this.frequency);
            }
            catch (InterruptedException e) {
            }
        }
    }

    class ScriptBackgroundTest
    extends BackgroundTest {
        protected ScriptBackgroundTest(Target target) {
            super(target);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void test() {
            String server = this.target.getInetAddress().getHostName();
            int port = this.target.getPort();
            try {
                String[] cmdarray = new String[]{ScriptServiceTest.this.script, server, Integer.toString(port)};
                ScriptServiceTest.this.logger.fine("Executing script");
                Process proc = Runtime.getRuntime().exec(cmdarray);
                boolean procDone = false;
                while (!procDone) {
                    try {
                        proc.waitFor();
                        procDone = true;
                    }
                    catch (InterruptedException e) {}
                }
                if (proc.exitValue() == 0) {
                    ScriptServiceTest.this.logger.fine("Script returned zero, server fine");
                    this.success = true;
                } else {
                    ScriptServiceTest.this.logger.warning("Script returned non-zero, server has failed");
                    this.success = false;
                }
                this.finished = true;
                ScriptBackgroundTest scriptBackgroundTest = this;
                synchronized (scriptBackgroundTest) {
                    this.notify();
                }
            }
            catch (IOException e) {
                ScriptServiceTest.this.logger.warning("Error when executing script: " + e.getMessage());
                this.finished = true;
                this.success = true;
                return;
            }
        }
    }
}

