/*
 * Decompiled with CFR 0.152.
 */
package oss.distributor;

import java.net.InetAddress;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import oss.distributor.Connection;
import oss.distributor.DataMover;
import oss.distributor.Distributor;

public class Target
implements Runnable {
    Distributor distributor;
    InetAddress addr;
    int port;
    boolean enabled;
    boolean terminateOnDisable;
    List connections;
    long totalConnectionCount;
    Logger logger;
    DataMover dataMover;
    Thread thread;
    int failureCount;
    int failureCountLimit;

    protected Target(Distributor distributor, InetAddress addr, int port, int failureCountLimit, boolean terminateOnDisable, boolean halfClose) {
        this.distributor = distributor;
        this.addr = addr;
        this.port = port;
        this.failureCountLimit = failureCountLimit;
        this.terminateOnDisable = terminateOnDisable;
        this.connections = new LinkedList();
        this.logger = distributor.getLogger();
        this.dataMover = new DataMover(distributor, this, halfClose);
        this.failureCount = 0;
        this.totalConnectionCount = 0L;
        this.enabled = true;
        this.thread = new Thread((Runnable)this, this.toString());
        this.thread.start();
    }

    public InetAddress getInetAddress() {
        return this.addr;
    }

    public int getPort() {
        return this.port;
    }

    protected DataMover getDataMover() {
        return this.dataMover;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addConnection(Connection conn) {
        List list = this.connections;
        synchronized (list) {
            this.connections.add(conn);
        }
        this.dataMover.addConnection(conn);
        ++this.totalConnectionCount;
    }

    public synchronized void enable() {
        this.enabled = true;
        this.failureCount = 0;
    }

    public synchronized void disable() {
        if (this.enabled) {
            this.enabled = false;
            if (this.terminateOnDisable) {
                this.terminateAll();
            }
        }
    }

    public synchronized boolean isEnabled() {
        return this.enabled;
    }

    public synchronized int incrementFailureCount() {
        ++this.failureCount;
        if (this.failureCount > this.failureCountLimit) {
            this.logger.warning("Target has exceeded failure count threshold");
            this.logger.warning("Disabling:  " + this);
            this.disable();
        }
        return this.failureCount;
    }

    public synchronized void resetFailureCount() {
        this.failureCount = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void terminateAll() {
        List list = this.connections;
        synchronized (list) {
            Iterator iter = this.connections.iterator();
            while (iter.hasNext()) {
                Connection conn = (Connection)iter.next();
                this.logger.fine("Terminating and removing connection " + conn);
                conn.terminate();
                iter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            List list = this.connections;
            synchronized (list) {
                Iterator iter = this.connections.iterator();
                while (iter.hasNext()) {
                    Connection conn = (Connection)iter.next();
                    if (!conn.isTerminated()) continue;
                    this.logger.finer("Removing terminated connection");
                    iter.remove();
                }
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public String toString() {
        return this.getClass().getName() + " for " + this.addr + ":" + this.port;
    }

    protected String getStats(String indent) {
        String stats = this.enabled ? indent + this.connections.size() + " current connections\n" : indent + "DISABLED\n";
        stats = stats + indent + this.totalConnectionCount + " total connections\n";
        stats = stats + indent + this.dataMover.getClientToServerByteCount() + " client to server bytes\n";
        stats = stats + indent + this.dataMover.getServerToClientByteCount() + " server to client bytes";
        return stats;
    }

    protected String getMemoryStats(String indent) {
        String stats = indent + this.connections.size() + " entries in connections List\n";
        stats = stats + indent + "DataMover:\n";
        stats = stats + this.dataMover.getMemoryStats(indent);
        return stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getConnectionList(String indent) {
        String connList;
        List list = this.connections;
        synchronized (list) {
            if (this.connections.size() > 0) {
                connList = new String();
                Iterator iter = this.connections.iterator();
                while (iter.hasNext()) {
                    Connection conn = (Connection)iter.next();
                    connList = connList + indent + conn + "\n";
                }
            } else {
                connList = indent + "No connections";
            }
        }
        return connList;
    }
}

