/*
 * Decompiled with CFR 0.152.
 */
package oss.distributor;

import java.io.IOException;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import oss.distributor.Connection;
import oss.distributor.DistributionAlgorithm;
import oss.distributor.Distributor;

public class TargetSelector
implements Runnable {
    Distributor distributor;
    Logger logger;
    List distributionAlgorithms;
    Map currentAlgorithm;
    List needsDistributing;
    List finishedDistributing;
    Thread thread;

    protected TargetSelector(Distributor distributor) {
        this.distributor = distributor;
        this.currentAlgorithm = new HashMap();
        this.needsDistributing = new LinkedList();
        this.finishedDistributing = new LinkedList();
        this.thread = new Thread((Runnable)this, this.getClass().getName());
    }

    protected void finishInitialization() {
        this.logger = this.distributor.getLogger();
        this.distributionAlgorithms = this.distributor.getDistributionAlgorithms();
        this.thread.start();
    }

    protected void addNewClient(SocketChannel client) {
        try {
            this.logger.finest("Setting client channel to non-blocking mode");
            client.configureBlocking(false);
            this.addUnconnectedClient(client);
        }
        catch (IOException e) {
            this.logger.warning("Error setting channels to non-blocking mode: " + e.getMessage());
            try {
                this.logger.fine("Closing client channel");
                client.close();
            }
            catch (IOException ioe) {
                this.logger.warning("Error closing client channel: " + ioe.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addUnconnectedClient(SocketChannel client) {
        List list = this.needsDistributing;
        synchronized (list) {
            this.needsDistributing.add(client);
        }
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addFinishedClient(Connection conn) {
        List list = this.finishedDistributing;
        synchronized (list) {
            this.finishedDistributing.add(conn);
        }
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            DistributionAlgorithm algo;
            Iterator iter;
            Object object = this;
            synchronized (object) {
                if (this.needsDistributing.size() == 0 && this.finishedDistributing.size() == 0) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
            }
            object = this.needsDistributing;
            synchronized (object) {
                iter = this.needsDistributing.iterator();
                while (iter.hasNext()) {
                    SocketChannel client = (SocketChannel)iter.next();
                    iter.remove();
                    algo = (DistributionAlgorithm)this.currentAlgorithm.get(client);
                    if (algo == null) {
                        algo = (DistributionAlgorithm)this.distributionAlgorithms.get(0);
                    } else {
                        int i = this.distributionAlgorithms.indexOf(algo);
                        if (i < this.distributionAlgorithms.size() - 1) {
                            algo = (DistributionAlgorithm)this.distributionAlgorithms.get(i + 1);
                        } else {
                            this.logger.warning("Unable to find a working target for client " + client);
                            this.currentAlgorithm.remove(client);
                            try {
                                client.close();
                            }
                            catch (IOException e) {}
                            continue;
                        }
                    }
                    this.currentAlgorithm.put(client, algo);
                    this.logger.finer("Asking " + algo + " to try to find a target for " + client);
                    algo.tryToConnect(client);
                }
            }
            object = this.finishedDistributing;
            synchronized (object) {
                iter = this.finishedDistributing.iterator();
                while (iter.hasNext()) {
                    Connection conn = (Connection)iter.next();
                    iter.remove();
                    this.logger.finer("Notifying distribution algorithms of successful connection " + conn);
                    Iterator algoIter = this.distributionAlgorithms.iterator();
                    while (algoIter.hasNext()) {
                        algo = (DistributionAlgorithm)algoIter.next();
                        algo.connectionNotify(conn);
                    }
                    this.currentAlgorithm.remove(conn.getClient());
                    this.logger.finer("Registering connection " + conn + "with target");
                    conn.getTarget().addConnection(conn);
                }
            }
        }
    }

    protected String getMemoryStats(String indent) {
        String stats = indent + this.currentAlgorithm.size() + " entries in currentAlgorithm Map\n";
        stats = stats + indent + this.needsDistributing.size() + " entries in needsDistributing List\n";
        stats = stats + indent + this.finishedDistributing.size() + " entries in finishedDistributing List";
        return stats;
    }
}

