/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.protocol.http;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;
import org.apache.hadoop.conf.Configuration;
import org.apache.nutch.crawl.CrawlDatum;
import org.apache.nutch.metadata.Metadata;
import org.apache.nutch.metadata.SpellCheckedMetadata;
import org.apache.nutch.net.protocols.HttpDateFormat;
import org.apache.nutch.net.protocols.Response;
import org.apache.nutch.protocol.ProtocolException;
import org.apache.nutch.protocol.http.Http;
import org.apache.nutch.protocol.http.api.HttpBase;
import org.apache.nutch.protocol.http.api.HttpException;

public class HttpResponse
implements Response {
    private Configuration conf;
    private HttpBase http;
    private URL url;
    private String orig;
    private String base;
    private byte[] content;
    private int code;
    private Metadata headers = new SpellCheckedMetadata();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse(HttpBase http, URL url, CrawlDatum datum) throws ProtocolException, IOException {
        String portString;
        int port;
        this.http = http;
        this.url = url;
        this.orig = url.toString();
        this.base = url.toString();
        if (!"http".equals(url.getProtocol())) {
            throw new HttpException("Not an HTTP url:" + url);
        }
        if (Http.LOG.isTraceEnabled()) {
            Http.LOG.trace("fetching " + url);
        }
        String path = "".equals(url.getFile()) ? "/" : url.getFile();
        String host = url.getHost();
        if (url.getPort() == -1) {
            port = 80;
            portString = "";
        } else {
            port = url.getPort();
            portString = ":" + port;
        }
        Socket socket = null;
        try {
            socket = new Socket();
            socket.setSoTimeout(http.getTimeout());
            String sockHost = http.useProxy() ? http.getProxyHost() : host;
            int sockPort = http.useProxy() ? http.getProxyPort() : port;
            InetSocketAddress sockAddr = new InetSocketAddress(sockHost, sockPort);
            socket.connect(sockAddr, http.getTimeout());
            this.conf = http.getConf();
            if (sockAddr != null && this.conf.getBoolean("store.ip.address", false)) {
                this.headers.add("_ip_", sockAddr.getAddress().getHostAddress());
            }
            OutputStream req = socket.getOutputStream();
            StringBuffer reqStr = new StringBuffer("GET ");
            if (http.useProxy()) {
                reqStr.append(url.getProtocol() + "://" + host + portString + path);
            } else {
                reqStr.append(path);
            }
            reqStr.append(" HTTP/1.0\r\n");
            reqStr.append("Host: ");
            reqStr.append(host);
            reqStr.append(portString);
            reqStr.append("\r\n");
            reqStr.append("Accept-Encoding: x-gzip, gzip, deflate\r\n");
            String userAgent = http.getUserAgent();
            if (userAgent == null || userAgent.length() == 0) {
                if (Http.LOG.isErrorEnabled()) {
                    Http.LOG.error("User-agent is not set!");
                }
            } else {
                reqStr.append("User-Agent: ");
                reqStr.append(userAgent);
                reqStr.append("\r\n");
            }
            reqStr.append("Accept-Language: ");
            reqStr.append(this.http.getAcceptLanguage());
            reqStr.append("\r\n");
            reqStr.append("Accept: ");
            reqStr.append(this.http.getAccept());
            reqStr.append("\r\n");
            if (datum.getModifiedTime() > 0L) {
                reqStr.append("If-Modified-Since: " + HttpDateFormat.toString((long)datum.getModifiedTime()));
                reqStr.append("\r\n");
            }
            reqStr.append("\r\n");
            byte[] reqBytes = reqStr.toString().getBytes();
            req.write(reqBytes);
            req.flush();
            PushbackInputStream in = new PushbackInputStream(new BufferedInputStream(socket.getInputStream(), 8192), 8192);
            StringBuffer line = new StringBuffer();
            boolean haveSeenNonContinueStatus = false;
            while (!haveSeenNonContinueStatus) {
                this.code = this.parseStatusLine(in, line);
                this.parseHeaders(in, line);
                haveSeenNonContinueStatus = this.code != 100;
            }
            this.readPlainContent(in);
            String contentEncoding = this.getHeader("Content-Encoding");
            if ("gzip".equals(contentEncoding) || "x-gzip".equals(contentEncoding)) {
                this.content = http.processGzipEncoded(this.content, url);
            } else if ("deflate".equals(contentEncoding)) {
                this.content = http.processDeflateEncoded(this.content, url);
            } else if (Http.LOG.isTraceEnabled()) {
                Http.LOG.trace("fetched " + this.content.length + " bytes from " + url);
            }
        }
        finally {
            if (socket != null) {
                socket.close();
            }
        }
    }

    public URL getUrl() {
        return this.url;
    }

    public int getCode() {
        return this.code;
    }

    public String getHeader(String name) {
        return this.headers.get(name);
    }

    public Metadata getHeaders() {
        return this.headers;
    }

    public byte[] getContent() {
        return this.content;
    }

    private void readPlainContent(InputStream in) throws HttpException, IOException {
        int contentLength = Integer.MAX_VALUE;
        String contentLengthString = this.headers.get("Content-Length");
        if (contentLengthString != null) {
            contentLengthString = contentLengthString.trim();
            try {
                if (!contentLengthString.isEmpty()) {
                    contentLength = Integer.parseInt(contentLengthString);
                }
            }
            catch (NumberFormatException e) {
                throw new HttpException("bad content length: " + contentLengthString);
            }
        }
        if (this.http.getMaxContent() >= 0 && contentLength > this.http.getMaxContent()) {
            contentLength = this.http.getMaxContent();
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(8192);
        byte[] bytes = new byte[8192];
        int length = 0;
        int i = in.read(bytes);
        while (i != -1 && length + i <= contentLength) {
            out.write(bytes, 0, i);
            length += i;
            i = in.read(bytes);
        }
        this.content = out.toByteArray();
    }

    private void readChunkedContent(PushbackInputStream in, StringBuffer line) throws HttpException, IOException {
        boolean doneChunks = false;
        int contentBytesRead = 0;
        byte[] bytes = new byte[8192];
        ByteArrayOutputStream out = new ByteArrayOutputStream(8192);
        while (!doneChunks) {
            int len;
            int chunkLen;
            if (Http.LOG.isTraceEnabled()) {
                Http.LOG.trace("Http: starting chunk");
            }
            HttpResponse.readLine(in, line, false);
            int pos = line.indexOf(";");
            String chunkLenStr = pos < 0 ? line.toString() : line.substring(0, pos);
            chunkLenStr = chunkLenStr.trim();
            try {
                chunkLen = Integer.parseInt(chunkLenStr, 16);
            }
            catch (NumberFormatException e) {
                throw new HttpException("bad chunk length: " + line.toString());
            }
            if (chunkLen == 0) {
                doneChunks = true;
                break;
            }
            if (contentBytesRead + chunkLen > this.http.getMaxContent()) {
                chunkLen = this.http.getMaxContent() - contentBytesRead;
            }
            for (int chunkBytesRead = 0; chunkBytesRead < chunkLen; chunkBytesRead += len) {
                int toRead = chunkLen - chunkBytesRead < 8192 ? chunkLen - chunkBytesRead : 8192;
                len = in.read(bytes, 0, toRead);
                if (len == -1) {
                    throw new HttpException("chunk eof after " + contentBytesRead + " bytes in successful chunks" + " and " + chunkBytesRead + " in current chunk");
                }
                out.write(bytes, 0, len);
            }
            HttpResponse.readLine(in, line, false);
        }
        if (!doneChunks) {
            if (contentBytesRead != this.http.getMaxContent()) {
                throw new HttpException("chunk eof: !doneChunk && didn't max out");
            }
            return;
        }
        this.content = out.toByteArray();
        this.parseHeaders(in, line);
    }

    private int parseStatusLine(PushbackInputStream in, StringBuffer line) throws IOException, HttpException {
        int code;
        HttpResponse.readLine(in, line, false);
        int codeStart = line.indexOf(" ");
        int codeEnd = line.indexOf(" ", codeStart + 1);
        if (codeEnd == -1) {
            codeEnd = line.length();
        }
        try {
            code = Integer.parseInt(line.substring(codeStart + 1, codeEnd));
        }
        catch (NumberFormatException e) {
            throw new HttpException("bad status line '" + line + "': " + e.getMessage(), (Throwable)e);
        }
        return code;
    }

    private void processHeaderLine(StringBuffer line) throws IOException, HttpException {
        char c;
        int valueStart;
        int colonIndex = line.indexOf(":");
        if (colonIndex == -1) {
            int i;
            for (i = 0; i < line.length() && Character.isWhitespace(line.charAt(i)); ++i) {
            }
            if (i == line.length()) {
                return;
            }
            throw new HttpException("No colon in header:" + line);
        }
        String key = line.substring(0, colonIndex);
        for (valueStart = colonIndex + 1; valueStart < line.length() && ((c = line.charAt(valueStart)) == ' ' || c == '\t'); ++valueStart) {
        }
        String value = line.substring(valueStart);
        this.headers.set(key, value);
    }

    private void parseHeaders(PushbackInputStream in, StringBuffer line) throws IOException, HttpException {
        while (HttpResponse.readLine(in, line, true) != 0) {
            int pos = line.indexOf("<!DOCTYPE");
            if (pos != -1 || (pos = line.indexOf("<HTML")) != -1 || (pos = line.indexOf("<html")) != -1) {
                in.unread(line.substring(pos).getBytes("UTF-8"));
                line.setLength(pos);
                try {
                    this.processHeaderLine(line);
                }
                catch (Exception e) {
                    Http.LOG.warn("Error: ", (Throwable)e);
                }
                return;
            }
            this.processHeaderLine(line);
        }
    }

    private static int readLine(PushbackInputStream in, StringBuffer line, boolean allowContinuedLine) throws IOException {
        line.setLength(0);
        int c = in.read();
        while (c != -1) {
            block0 : switch (c) {
                case 13: {
                    if (HttpResponse.peek(in) == 10) {
                        in.read();
                    }
                }
                case 10: {
                    if (line.length() > 0 && allowContinuedLine) {
                        switch (HttpResponse.peek(in)) {
                            case 9: 
                            case 32: {
                                in.read();
                                break block0;
                            }
                        }
                    }
                    return line.length();
                }
                default: {
                    line.append((char)c);
                }
            }
            c = in.read();
        }
        throw new EOFException();
    }

    private static int peek(PushbackInputStream in) throws IOException {
        int value = in.read();
        in.unread(value);
        return value;
    }
}

